/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.bridge;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;

/**
 * @author thomas jourdan
 *
 */
public interface Bridge {
  
  /**
   * Start an external process.
   * @param batchJob
   */
  public void execute();

  /**
   * Waits until the external process is finished.
   * @return exit code of the process
   */
  public void waitFor();

  /**
   * Get the image produced by the external process.
   * Use this methode only for FileBridge.
   * @return
   */
  public BufferedImage getImage() throws IOException;

  /**
   * Revieves incrementaly calculated image tiles and draws them on the graphics contect.
   * Use this methode only for StreamBridge.
   */
  public boolean recieve(Graphics graphics);
  
  /**
   * Kills the external process.
   */
  public void destroy();

  /**
   * Deletes temporary files.
   */
  public void cleanUp();

}
