/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import kandid.soup.*;
import kandid.calculation.*;
import kandid.util.*;

/**
 * Class ZoomFrame
 * @author thomas jourdan
 */
public class ZoomFrame extends JFrame {
  private static final long serialVersionUID = 1L;
  OrganismPanel organismPanel;

  /**
   * Constructor ZoomFrame.
   * @param poolController
   */
  public ZoomFrame(PopulationController populationController) {
    try {
      organismPanel = new OrganismPanel(true, 1, 1, populationController.scrollbar, populationController, 0);
      jbInit();
      this.pack();
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }


  /**
   * Method jbInit
   *
   * @throws Exception
   */
  private void jbInit() throws Exception {
    this.addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        this_windowClosing(e);
      }
    });
    this.getContentPane().add(organismPanel, BorderLayout.CENTER);
  }

  /**
   * Method prepare
   *
   * @param chromosome
   * @param calculationName
   */
  public void prepare(PopulationType population, int populationID, Calculation calculation) {
    organismPanel.start(population,
                        populationID,
                        calculation.getFitness());
  }

  /**
   * Method this_windowClosing
   *
   * @param e
   */
  void this_windowClosing(WindowEvent e) {
    organismPanel.stop();
  }
}
