/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * @author thomas jourdan
 *
 */
public class PrimaryTests {

  public static Test suite() {
    TestSuite suite = new TestSuite("Test for Kandid");
    //$JUnit-BEGIN$
    suite.addTest(new TestSuite(kandid.noise.PseudoRandomizerTest.class));
    suite.addTest(new TestSuite(kandid.noise.PerlinNoiseTest.class));
    suite.addTest(new TestSuite(kandid.pond.test.BreederTest.class));
    suite.addTest(new TestSuite(kandid.pond.test.BreederListTest.class));
    suite.addTest(new TestSuite(kandid.util.NetworkHelperTest.class));
    suite.addTest(new TestSuite(kandid.pond.test.BreederRequestThreadTest.class));
    suite.addTest(new TestSuite(kandid.soup.test.FileDiffTest.class));
    suite.addTest(new TestSuite(kandid.soup.test.SoupFactoryTest.class));
    suite.addTest(new TestSuite(kandid.soup.test.ChromosomeStampTest.class));
    suite.addTest(new TestSuite(kandid.util.WeightTest.class));
    suite.addTest(new TestSuite(kandid.util.CentralRandomizerTest.class));
    suite.addTest(new TestSuite(kandid.calculation.vm.scalar.ScalarVMTest.class));
    suite.addTest(new TestSuite(kandid.calculation.vm.vector.VectorVMTest.class));
    suite.addTest(new TestSuite(kandid.calculation.lsys.Lsys0LCalculationTest.class));
    suite.addTest(new TestSuite(kandid.calculation.lsys.LsysILCalculationTest.class));
    suite.addTest(new TestSuite(kandid.calculation.lsys.LsysMashineTest.class));
    suite.addTest(new TestSuite(kandid.calculation.lsys.LsysD0LCalculationTest.class));
    suite.addTest(new TestSuite(kandid.calculation.bridge.FileBridgeTest.class));
    suite.addTest(new TestSuite(kandid.calculation.bridge.StreamBridgeTest.class));
    suite.addTest(new TestSuite(kandid.calculation.bridge.flame.FlameJobTest.class));
    suite.addTest(new TestSuite(kandid.calculation.voronoi.PairListTest.class));
    suite.addTest(new TestSuite(kandid.colorator.GradientColoratorTest.class));
    suite.addTest(new TestSuite(kandid.colorator.LookUpTableColoratorTest.class));
    suite.addTest(new TestSuite(kandid.preference.test.PreferenceTest.class));
    suite.addTest(new TestSuite(kandid.preference.test.PasswordHelperTest.class));
    suite.addTest(new TestSuite(kandid.extensions.ExportStateTest.class));
    suite.addTest(new TestSuite(kandid.extensions.LRUImageCacheTest.class));
    suite.addTest(new TestSuite(kandid.catalog.test.CatalogTypeImplTest.class));
    //$JUnit-END$
    return suite;
  }
}
