/*
 * Copyright (C) 2002 - 2026 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid;

import java.awt.*;
import java.awt.event.*;
import java.io.File;
import javax.swing.*;
import kandid.util.*;

/**
 * Class Kandid
 * @author thomas jourdan
 */
public class Kandid implements WindowListener {
  public static final String localImageFolder = "filebase";
  public static final String incomingImageFolder = "incoming";
  public static  String scratchFolder = "/dev/shm/kandid/scratch";
  public static  String cacheFolder = "/dev/shm/kandid/cache";
  public static final String    release = "1.2.0";
  public static final String    preferencesFileName = "./kandid.preferences";
  
  public static Kandid    kandid;

  private IntroWizard     wizardPanel;
  private static JFrame   frame;
  /**
   * Construct the stand alone application
   */
  public Kandid() throws Exception {
    System.out.println("Kandid, a framework for genetic art. release " + release);
    System.out.println("Copyright (C) 2002 - 2026 Thomas Jourdan");
    System.out.println();   
    System.out.println("This program is free software: you can redistribute it and/or modify");
    System.out.println("it under the terms of the GNU General Public License as published by");
    System.out.println("the Free Software Foundation, either version 3 of the License, or");
    System.out.println("(at your option) any later version.");
    System.out.println();   
    System.out.println("This program is distributed in the hope that it will be useful,");
    System.out.println("but WITHOUT ANY WARRANTY; without even the implied warranty of");
    System.out.println("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
    System.out.println("GNU General Public License for more details.");
    System.out.println();   
    System.out.println("You should have received a copy of the GNU General Public License");
    System.out.println("along with this program.  If not, see <https://www.gnu.org/licenses/>.");      
    System.out.println();
    System.out.println(IlCopyleft.lib_text);
    System.out.println();
    System.out.println(Debug.info());
    
    kandid    = this;
    if(Debug.enabled) assert kandid != null: "kandid is undefined";
    wizardPanel = new IntroWizard();
  }

  /**
   * Get instance of this Kandid stand  alone application.
   *
   * @return
   */
  public static Kandid getInstance() {
    if(Debug.enabled) assert kandid != null: "kandid is undefined";
    return kandid;
  }

  public static JFrame getFrame() {
    if(Debug.enabled) assert frame != null: "frame is undefined";
    return frame;
  }

  /**
   * Initialize the applet.
   */
  public void init() {
    try {
      IconLoader.load();
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
    try {
      jbInit();
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

  /**
   * Create an image icon.
   *
   * @param filename source file name.
   * @param description
   *
   * @return
   */
  public ImageIcon createImageIcon(String filename, String description) {
    String path = "/img/" + filename;
    if (Debug.enabled) System.out.println("new ImageIcon " + path);
   return new ImageIcon(getClass().getResource(path), description);
  }

  /**
   * Component initialization.
   *
   * @throws Exception
   */
  private void jbInit() throws Exception {
    Kandid.frame.setSize(new Dimension(505, 400));
    Kandid.frame.getContentPane().add(wizardPanel, BorderLayout.CENTER);
  }

  /**
   * Entry point.
   *
   * @param args not interpreted
   */
  public static void main(String[] args) {
    if(args.length >= 1 && args[0].equals("-junit")) {
      //junit.swingui.TestRunner.run(PrimaryTests.class);
      junit.textui.TestRunner.run(PrimaryTests.suite());
    }
    else {
      Kandid application;
      try {
        scratchFolder = "./scratch";
        cacheFolder = "./cache";
        File incomingDir = new File(incomingImageFolder);   
        if(!incomingDir.exists()) {
          incomingDir.mkdirs();
        } 
        File filebaseDir = new File(localImageFolder);    
        if(!filebaseDir.exists()) {
          filebaseDir.mkdirs();
        }
        File dir = new File("/tmp");
        if(dir.exists() && dir.canWrite()) {
          scratchFolder = "/tmp/kandid/scratch";
          cacheFolder = "/tmp/kandid/cache";
        }
      } catch (Exception exc) {
        Debug.stackTrace(exc);
      }
      try {
        application = new Kandid();
        frame = new JFrame();
        frame.addWindowListener(application);
        frame.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        frame.setTitle("Kandid, a framework for genetic art.        " + release);
//TODO        frame.getContentPane().add(application., BorderLayout.CENTER);
        application.init();
        frame.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
      } catch (Exception exc) {
        Debug.stackTrace(exc);
      }
    }
  }

  // implements WindowListener
  public void windowOpened(WindowEvent evt) {
  }
  
  public void windowClosing(WindowEvent evt) {
    int co = JOptionPane.showConfirmDialog(frame,
                                          "All populations and images will be closed.\nAre you sure?",
                                          "Kandid",
                                          JOptionPane.YES_NO_OPTION,
                                          JOptionPane.QUESTION_MESSAGE);
    switch(co) {
      case 0:
        System.exit(0);
        break;
      default:
        break;
    }
  }
  
  public void windowClosed(WindowEvent evt) {
  }
  
  public void windowIconified(WindowEvent evt) {
  }
  
  public void windowDeiconified(WindowEvent evt) {
  }
  
  public void windowActivated(WindowEvent evt) {
  }
  
  public void windowDeactivated(WindowEvent evt) {
  }

  //static initializer for setting look & feel
  static {
    try {
      //UIManager.LookAndFeelInfo[] lookAndFeelInfo = UIManager.getInstalledLookAndFeels();
      
      //UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");      
      //UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
      //UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

}
