/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid;

import javax.swing.ImageIcon;

public class EnvironmentEditor extends javax.swing.JDialog {
  private static final long serialVersionUID = 1L;

  private static ImageIcon cancelImageIcon;
  private static ImageIcon acceptImageIcon;

  private Environment environment;
  private boolean valid;
  
  /** Creates new form EnvironmentEditor */
    public EnvironmentEditor(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        getRootPane().setDefaultButton(okButton);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
      inputPanel = new javax.swing.JPanel();
      crossingoverLabel = new javax.swing.JLabel();
      crossingoverTextField = new javax.swing.JTextField();
      mutationLabel = new javax.swing.JLabel();
      mutationTextField = new javax.swing.JTextField();
      scaleLabel = new javax.swing.JLabel();
      scaleTextField = new javax.swing.JTextField();
      controlPanel = new javax.swing.JPanel();
      cancelButton = new javax.swing.JButton();
      okButton = new javax.swing.JButton();
      
      setTitle("Environment Editor");
      setName("EnvironmentEditor");
      addWindowListener(new java.awt.event.WindowAdapter() {
        public void windowClosing(java.awt.event.WindowEvent evt) {
          closeDialog(evt);
        }
      });
      
      inputPanel.setLayout(new java.awt.GridLayout(3, 2));
      
      crossingoverLabel.setText("crossing over rate:   ");
      inputPanel.add(crossingoverLabel);
      
      inputPanel.add(crossingoverTextField);
      
      mutationLabel.setText("mutation rate:   ");
      inputPanel.add(mutationLabel);
      
      inputPanel.add(mutationTextField);
      
      scaleLabel.setText("scale factor:   ");
      inputPanel.add(scaleLabel);
      
      inputPanel.add(scaleTextField);
      
      getContentPane().add(inputPanel, java.awt.BorderLayout.CENTER);
      
      controlPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));
      
      if (acceptImageIcon == null)
        acceptImageIcon = Kandid.getInstance().createImageIcon("accept.png", null);
      okButton.setIcon(acceptImageIcon);
      okButton.setText("Ok");
      okButton.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
          okButtonActionPerformed(evt);
        }
      });
      
      controlPanel.add(okButton);
      
      if (cancelImageIcon == null)
        cancelImageIcon = Kandid.getInstance().createImageIcon("cancel.png", null);
      cancelButton.setIcon(cancelImageIcon);
      cancelButton.setText("Cancel");
      cancelButton.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
          cancelButtonActionPerformed(evt);
        }
      });
      
      controlPanel.add(cancelButton);
      
      getContentPane().add(controlPanel, java.awt.BorderLayout.SOUTH);
      
      pack();
    }//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
      valid = true;
      close();
    }//GEN-LAST:event_okButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
      valid = false;
      close();
    }//GEN-LAST:event_cancelButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
      valid = false;
      close();  
    }//GEN-LAST:event_closeDialog

    private void close() {
        setVisible(false);
        dispose();
    }

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
      new EnvironmentEditor(new javax.swing.JFrame(), true).setVisible(true);
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel inputPanel;
    private javax.swing.JLabel crossingoverLabel;
    private javax.swing.JTextField crossingoverTextField;
    private javax.swing.JLabel mutationLabel;
    private javax.swing.JTextField mutationTextField;
    private javax.swing.JLabel scaleLabel;
    private javax.swing.JTextField scaleTextField;
    private javax.swing.JPanel controlPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton okButton;
    // End of variables declaration//GEN-END:variables

  /**
   * Returns the environment.
   * @return Environment
   */
  public Environment getEnvironment() {
    if (valid) {
      try {
        environment.setMergeRate(Double.parseDouble(crossingoverTextField.getText()));
      } catch (NumberFormatException exc) {
      }
      try {
        environment.setMutationRate(Double.parseDouble(mutationTextField.getText()));
      } catch (NumberFormatException exc) {
      }
      try {
        environment.setScaleFactor(Double.parseDouble(scaleTextField.getText()));
      } catch (NumberFormatException exc) {
      }
    }
    return environment;
  }

  /**
   * Sets the environment.
   * @param environment The environment to set
   */
  public void setEnvironment(Environment environment) {
    this.environment = environment;
    crossingoverTextField.setText("" + environment.getMergeRate());
    mutationTextField.setText("" + environment.getMutationRate());
    scaleTextField.setText("" + environment.getScaleFactor());
  }

}
