/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import kandid.util.*;

/**
 * Class ConsoleFrame
 * @author thomas jourdan
 */
public class ConsoleFrame extends JFrame {
  private static final long serialVersionUID = 1L;
  JPanel       buttonPanel   = new JPanel();
  BorderLayout borderLayout1 = new BorderLayout();
  JScrollPane  scrollPane    = null;
  GridLayout   gridLayout1   = new GridLayout();
  JPanel       jPanel1       = new JPanel();
  JPanel       jPanel2       = new JPanel();
  JButton      clearButton   = new JButton();
  JButton      closeButton   = new JButton();
  FlowLayout   flowLayout1   = new FlowLayout();
  FlowLayout   flowLayout2   = new FlowLayout();
  Console logController;

  /**
   * Constructor ConsoleFrame
   */
  public ConsoleFrame(JScrollPane  scrollPane) {
    this.scrollPane = scrollPane;
    try {
      jbInit();
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

  /**
   * Method jbInit
   *
   * @throws Exception
   */
  private void jbInit() throws Exception {
    this.getContentPane().setLayout(borderLayout1);
    buttonPanel.setLayout(gridLayout1);
    clearButton.setText("clear");
    clearButton.setIcon(IconLoader.papersizeImageIcon);
    clearButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        clearButton_actionPerformed(e);
      }
    });
    closeButton.setText("close");
    closeButton.setIcon(IconLoader.cancelImageIcon);
    closeButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        closeButton_actionPerformed(e);
      }
    });
    jPanel2.setLayout(flowLayout1);
    jPanel1.setLayout(flowLayout2);
    flowLayout2.setAlignment(FlowLayout.LEFT);
    flowLayout1.setAlignment(FlowLayout.RIGHT);
    this.getContentPane().add(buttonPanel, BorderLayout.SOUTH);
    buttonPanel.add(jPanel1, null);
    jPanel1.add(clearButton, null);
    buttonPanel.add(jPanel2, null);
    jPanel2.add(closeButton, null);
    this.getContentPane().add(scrollPane, BorderLayout.CENTER);
  }

  /**
   * Method clearButton_actionPerformed
   *
   * @param e
   */
  void clearButton_actionPerformed(ActionEvent e) {
    Console.clear();
  }

  /**
   * Method closeButton_actionPerformed
   *
   * @param e
   */
  void closeButton_actionPerformed(ActionEvent e) {
    Console.hide();
  }
}

