<?xml version="1.0" encoding="UTF-8"?>
<!--
  Copyright (C) 2002 - 2025 Thomas Jourdan

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:jxb="http://java.sun.com/xml/ns/jaxb"
                version="1.0">

<xsl:output method="text"/>

<xsl:template match="xsd:schema">
<xsl:variable name="chromosomeType" select="descendant::xsd:element[@name='chromosome']/@type"/>
// This file was generated by the setEditor.xsl style sheet. 
// Any modifications to this file will be lost upon recompilation of the style sheet or the source schema. 

package kandid.soup.map;
import javax.xml.bind.JAXBException;
import kandid.soup.*;
public class SetEditorMapping {

  private kandid.tree.editor.CheckBoxCellEditor checkBoxCellEditor = new kandid.tree.editor.CheckBoxCellEditor( new javax.swing.JCheckBox() );
  private kandid.tree.editor.ComboBoxCellEditor comboBoxCellEditor = new kandid.tree.editor.ComboBoxCellEditor( new javax.swing.JComboBox() );
  private kandid.tree.editor.TextCellEditor     textCellEditor     = new kandid.tree.editor.TextCellEditor( new javax.swing.JTextField());
  private javax.swing.JCheckBox checkBoxCellRenderer = new javax.swing.JCheckBox();
  private javax.swing.JComboBox comboBoxCellRenderer = new javax.swing.JComboBox();
  private javax.swing.JLabel    textCellRenderer     = new javax.swing.JLabel();

  public static StringBuffer dump(javax.swing.JTree tree) {
    StringBuffer buffer = new StringBuffer();
    javax.swing.tree.DefaultTreeModel model = (javax.swing.tree.DefaultTreeModel) tree.getModel();
    javax.swing.tree.DefaultMutableTreeNode node = (javax.swing.tree.DefaultMutableTreeNode) model.getRoot();
    dump(model, node, "", buffer);
    return buffer;
  }
  
  private static void dump(javax.swing.tree.DefaultTreeModel model, javax.swing.tree.DefaultMutableTreeNode node, String depth, StringBuffer buffer) {
    int childCount = model.getChildCount(node);
    for (int nx = 0; nx &lt; childCount; ++nx) {
      kandid.tree.user.UserTreeNode childNode = (kandid.tree.user.UserTreeNode) model.getChild(node, nx);
      buffer.append(depth);
      buffer.append(childNode.getUser().getValue());
      buffer.append('\n');
      if (!childNode.isLeaf())
        dump(model, childNode, depth + "  ", buffer);
    }
  }

  <xsl:apply-templates/>
}
</xsl:template>

<xsl:template match="xsd:complexType">
  <xsl:if test="contains(@name, 'Gene')">
    protected void fillEditor(^<xsl:value-of select="@name"/> aGene, kandid.tree.user.UserTreeNode node) throws NoSuchMethodException, JAXBException {
    <!-- fill in members -->
   <!-- call fillEditor for super class -->
    <xsl:for-each select="descendant::xsd:extension">
      <xsl:if test="not(@base = 'geneType')">
        fillEditor((^<xsl:value-of select="@base"/>)aGene, node);
      </xsl:if>
    </xsl:for-each>
    <xsl:if test="descendant::xsd:choice">
      <xsl:for-each select="descendant::xsd:choice">
        <xsl:if test="@minOccurs and @maxOccurs">
          {
          java.util.List list = aGene.get^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each>();
          int length = list.size();
          for(int lx = 0; lx &lt; length; ++lx) {
            Object obj = list.get(lx);
            <xsl:for-each select="descendant::xsd:element">
              if(obj instanceof ^<xsl:value-of select="@type"/>) {
                kandid.tree.user.UserTreeNode child = new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserText(textCellRenderer,textCellEditor,"^<xsl:value-of select="@name"/> "+(lx+1), null, null) );
                node.add( child );
                fillEditor((^<xsl:value-of select="@type"/>)list.get(lx), child);
              }
            </xsl:for-each>
          }
          }
        </xsl:if>
      </xsl:for-each>
    </xsl:if>
    <xsl:if test="not(descendant::xsd:choice)">
      <xsl:for-each select="descendant::xsd:element">
        <xsl:variable name="schemaBaseType" select="@type"/>
        <xsl:if test="not(contains($schemaBaseType, 'Gene'))">
          <!-- members are basic data type -->
          <xsl:variable name="javaReturnType" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:annotation/xsd:appinfo/jxb:javaType/@name"/>
          <xsl:variable name="enumvalues" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:enumeration/@value"/>
          <xsl:if test="$enumvalues">
            <!-- basic data type is an enumeration -->
            {
            ^<xsl:value-of select="$schemaBaseType"/> enumType[] = {
            <xsl:for-each select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:enumeration">
              ^<xsl:value-of select="$schemaBaseType"/>.fromValue("<xsl:value-of select="@value"/>"),
            </xsl:for-each>
            };
            // node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserComboBox(comboBoxCellRenderer, comboBoxCellEditor, enumNames, ""+aGene.get^<xsl:value-of select="@name"/>()) ));
            java.lang.Class[] signature = new java.lang.Class[1];
            signature[0] = ^<xsl:value-of select="$schemaBaseType"/>.class;
            node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserComboBox(comboBoxCellRenderer,
                                                                              comboBoxCellEditor,
                                                                              enumType,
                                                                              aGene.get^<xsl:value-of select="@name"/>(),
                                                                              aGene,
                                                                              aGene.getClass().getMethod("set^<xsl:value-of select="@name"/>", signature)
                                                                              ) ));
            }
          </xsl:if>
          <xsl:if test="not($enumvalues)">
            <xsl:if test="$javaReturnType = 'boolean'">
              <!-- basic data type is boolean -->
              {
              java.lang.Class[] signature = new java.lang.Class[1];
              signature[0] = java.lang.Boolean.class;
              node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserCheckBox(checkBoxCellRenderer,
                                                                                checkBoxCellEditor,
                                                                                "<xsl:value-of select="@name"/> = "+aGene.is^<xsl:value-of select="@name"/>(),
                                                                                aGene.is^<xsl:value-of select="@name"/>(),
                                                                                aGene,
                                                                                aGene.getClass().getMethod("set^<xsl:value-of select="@name"/>", signature)
                                                                                ) ));
              }
            </xsl:if>
            <xsl:if test="$javaReturnType = 'int'">
              <!-- basic data type is int -->
              {
              java.lang.Class[] signature = new java.lang.Class[1];
              signature[0] = java.lang.Integer.class;
              node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserInteger(textCellRenderer,
                                                                               textCellEditor,
                                                                               "<xsl:value-of select="@name"/> = "+aGene.get^<xsl:value-of select="@name"/>(),
                                                                               aGene,
                                                                               aGene.getClass().getMethod("set^<xsl:value-of select="@name"/>", signature)
                                                                               ) ));
              }
            </xsl:if>
            <xsl:if test="$javaReturnType = 'long'">
              <!-- basic data type is int -->
              {
              java.lang.Class[] signature = new java.lang.Class[1];
              signature[0] = java.lang.Long.class;
              node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserLong(textCellRenderer,
                                                                            textCellEditor,
                                                                            "<xsl:value-of select="@name"/> = "+aGene.get^<xsl:value-of select="@name"/>(),
                                                                            aGene,
                                                                            aGene.getClass().getMethod("set^<xsl:value-of select="@name"/>", signature)
                                                                            ) ));
              }
            </xsl:if>
            <xsl:if test="$javaReturnType = 'float'">
              <!-- basic data type is float -->
              // node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserText(textCellRenderer,textCellEditor,"<xsl:value-of select="@name"/> = "+aGene.get^<xsl:value-of select="@name"/>()) ));
              {
              java.lang.Class[] signature = new java.lang.Class[1];
              signature[0] = java.lang.Float.class;
              node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserFloat(textCellRenderer,
                                                                            textCellEditor,
                                                                            "<xsl:value-of select="@name"/> = "+aGene.get^<xsl:value-of select="@name"/>(),
                                                                            aGene,
                                                                            aGene.getClass().getMethod("set^<xsl:value-of select="@name"/>", signature)
                                                                            ) ));
              }
            </xsl:if>
            <xsl:if test="$javaReturnType = 'double'">
              <!-- basic data type is double -->
              // node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserText(textCellRenderer,textCellEditor,"<xsl:value-of select="@name"/> = "+aGene.get^<xsl:value-of select="@name"/>()) ));
              {
              java.lang.Class[] signature = new java.lang.Class[1];
              signature[0] = java.lang.Double.class;
              node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserDouble(textCellRenderer,
                                                                            textCellEditor,
                                                                            "<xsl:value-of select="@name"/> = "+aGene.get^<xsl:value-of select="@name"/>(),
                                                                            aGene,
                                                                            aGene.getClass().getMethod("set^<xsl:value-of select="@name"/>", signature)
                                                                            ) ));
              }
            </xsl:if>
          </xsl:if>
        </xsl:if>
        <xsl:if test="contains($schemaBaseType, 'Gene')">
          <xsl:if test="@minOccurs and @maxOccurs">
            <!-- member is list of children of class class gen -->
            <xsl:call-template name="list">
              <xsl:with-param name="aObject">aGene</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="not(@maxOccurs)">
            <!-- members are children of class class gen -->
            <xsl:variable name="superClass" select="/xsd:schema/xsd:complexType[@name=$schemaBaseType]/xsd:complexContent/xsd:extension/@base"/>
            <xsl:variable name="singleSlot" select="/xsd:schema/xsd:complexType[@name=$schemaBaseType]/xsd:complexContent/*/xsd:sequence/xsd:element/@name"/>
            <xsl:variable name="singleSlotBase" select="/xsd:schema/xsd:complexType[@name=$schemaBaseType]/xsd:complexContent/*/xsd:sequence/xsd:element/@type"/>
            <xsl:variable name="singleSlotType" select="/xsd:schema/xsd:simpleType[@name=$singleSlotBase]/xsd:annotation/xsd:appinfo/jxb:javaType/@name"/>
                //superClass     <xsl:value-of select="$superClass"/>
                //singleSlot     <xsl:value-of select="$singleSlot"/>
                //singleSlotBase <xsl:value-of select="$singleSlotBase"/>
                //singleSlotType <xsl:value-of select="$singleSlotType"/>
                //schemaBaseType <xsl:value-of select="$schemaBaseType"/>
            <xsl:choose>
              <xsl:when test="contains(@type, 'colorGene')">
                {
                kandid.tree.user.UserInteger userText = new kandid.tree.user.UserInteger(textCellRenderer, textCellEditor, "Color", null, null);
                userText.setBackgroundColor(new java.awt.Color(aGene.getColor().getRed(), aGene.getColor().getGreen(), aGene.getColor().getBlue()));
                kandid.tree.user.UserTreeNode child = new kandid.tree.user.UserTreeNode(userText);
                node.add(child);
                fillEditor((^<xsl:value-of select="@type"/>)aGene.get^<xsl:value-of select="@name"/>(), child);
                }
              </xsl:when>
              <xsl:when test="(count($singleSlot) = 1) and contains($superClass, 'geneType')">
                {
                java.lang.Class[] signature = new java.lang.Class[1];
                <xsl:choose>
                  <xsl:when test="$singleSlotType = 'boolean'">
                    signature[0] = java.lang.Boolean.class;
                    node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserCheckBox(checkBoxCellRenderer,
                                                                              checkBoxCellEditor,
                                                                              "<xsl:value-of select="@name"/>",
                                                                              aGene.get^<xsl:value-of select="@name"/>().isValue(),
                                                                              aGene.get^<xsl:value-of select="@name"/>(),
                                                                              aGene.get^<xsl:value-of select="@name"/>().getClass().getMethod("set^<xsl:value-of select="$singleSlot"/>", signature)
                                                                              ) ));
                  </xsl:when>
                  <xsl:when test="$singleSlotType = 'int'">
                    signature[0] = java.lang.Integer.class;
                    node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserInteger(textCellRenderer,
                                                                              textCellEditor,
                                                                              "<xsl:value-of select="@name"/> = " + aGene.get^<xsl:value-of select="@name"/>().get^<xsl:value-of select="$singleSlot"/>(),
                                                                              aGene.get^<xsl:value-of select="@name"/>(),
                                                                              aGene.get^<xsl:value-of select="@name"/>().getClass().getMethod("set^<xsl:value-of select="$singleSlot"/>", signature)
                                                                              ) ));
                  </xsl:when>
                  <xsl:when test="$singleSlotType = 'long'">
                    signature[0] = java.lang.Long.class;
                    node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserLong(textCellRenderer,
                                                                              textCellEditor,
                                                                              "<xsl:value-of select="@name"/> = " + aGene.get^<xsl:value-of select="@name"/>().get^<xsl:value-of select="$singleSlot"/>(),
                                                                              aGene.get^<xsl:value-of select="@name"/>(),
                                                                              aGene.get^<xsl:value-of select="@name"/>().getClass().getMethod("set^<xsl:value-of select="$singleSlot"/>", signature)
                                                                              ) ));
                  </xsl:when>
                  <xsl:when test="$singleSlotType = 'float'">
                    signature[0] = java.lang.Float.class;
                    node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserFloat(textCellRenderer,
                                                                              textCellEditor,
                                                                              "<xsl:value-of select="@name"/> = " + aGene.get^<xsl:value-of select="@name"/>().get^<xsl:value-of select="$singleSlot"/>(),
                                                                              aGene.get^<xsl:value-of select="@name"/>(),
                                                                              aGene.get^<xsl:value-of select="@name"/>().getClass().getMethod("set^<xsl:value-of select="$singleSlot"/>", signature)
                                                                              ) ));
                  </xsl:when>
                  <xsl:when test="$singleSlotType = 'double'">
                    signature[0] = java.lang.Double.class;
                    node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserDouble(textCellRenderer,
                                                                              textCellEditor,
                                                                              "<xsl:value-of select="@name"/> = " + aGene.get^<xsl:value-of select="@name"/>().get^<xsl:value-of select="$singleSlot"/>(),
                                                                              aGene.get^<xsl:value-of select="@name"/>(),
                                                                              aGene.get^<xsl:value-of select="@name"/>().getClass().getMethod("set^<xsl:value-of select="$singleSlot"/>", signature)
                                                                              ) ));
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:if test="$singleSlotType">
                    signature[0] = <xsl:value-of select="$singleSlotType"/>.class;
                    </xsl:if>
                    <xsl:if test="not($singleSlotType)">
                    signature[0] = ^<xsl:value-of select="$singleSlotBase"/>.class;
                    </xsl:if>
                    node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserText(textCellRenderer,
                                                                              textCellEditor,
                                                                              "<xsl:value-of select="@name"/> = " + aGene.get^<xsl:value-of select="@name"/>().get^<xsl:value-of select="$singleSlot"/>(),
                                                                              aGene.get^<xsl:value-of select="@name"/>(),
                                                                              aGene.get^<xsl:value-of select="@name"/>().getClass().getMethod("set^<xsl:value-of select="$singleSlot"/>", signature)
                                                                              ) ));
                  </xsl:otherwise>
                </xsl:choose>
                }
              </xsl:when>
              <xsl:otherwise>
                {
                java.lang.Class[] signature = new java.lang.Class[1];
                signature[0] = ^<xsl:value-of select="$schemaBaseType"/>.class;
                kandid.tree.user.UserTreeNode child  = new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserText(textCellRenderer,
                                                                                                      textCellEditor,
                                                                                                      "^<xsl:value-of select="@name"/>",
                                                                                                      aGene,
                                                                                                      aGene.getClass().getMethod("set^<xsl:value-of select="@name"/>", signature)
                                                                                                      ) );
                node.add( child );
                fillEditor((^<xsl:value-of select="@type"/>)aGene.get^<xsl:value-of select="@name"/>(), child);
                }
              </xsl:otherwise>
            </xsl:choose>
          </xsl:if>
        </xsl:if>
      </xsl:for-each>
    </xsl:if>
}
  </xsl:if>
  
  <xsl:if test="contains(@name, 'Chromosome')">
    public void fillEditor(^<xsl:value-of select="@name"/> aGene, javax.swing.JTree tree) throws NoSuchMethodException, JAXBException {
    javax.swing.tree.DefaultTreeModel model = (javax.swing.tree.DefaultTreeModel) tree.getModel();
    javax.swing.tree.DefaultMutableTreeNode node = (javax.swing.tree.DefaultMutableTreeNode) model.getRoot();
    <!-- call fill editor for super class -->
    <xsl:for-each select="descendant::xsd:extension">
      <xsl:if test="not((@base = 'chromosomeType') or (@base = 'coloratorType'))">
        fillEditor((^<xsl:value-of select="@base"/>)aGene, tree);
      </xsl:if>
    </xsl:for-each>
    <!-- randomize elements -->
    <xsl:if test="descendant::xsd:choice">
      <xsl:for-each select="descendant::xsd:choice">
        <xsl:if test="@minOccurs and @maxOccurs">
          <xsl:call-template name="list">
            <xsl:with-param name="aObject">aGene</xsl:with-param>
          </xsl:call-template>
        </xsl:if>
      </xsl:for-each>
    </xsl:if>
    <xsl:if test="not(descendant::xsd:choice)">
      <xsl:for-each select="descendant::xsd:element">
        <xsl:variable name="schemaBaseType" select="@type"/>
        <xsl:if test="contains($schemaBaseType, 'Gene')">
          <xsl:if test="@minOccurs and @maxOccurs">
            <xsl:call-template name="list">
              <xsl:with-param name="aObject">aGene</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="not(@maxOccurs)">
            <xsl:if test="contains($schemaBaseType, 'Gene')">
              <!-- members are children of class class gene -->
              <xsl:variable name="superClass" select="/xsd:schema/xsd:complexType[@name=$schemaBaseType]/xsd:complexContent/xsd:extension/@base"/>
              <xsl:variable name="singleSlot" select="/xsd:schema/xsd:complexType[@name=$schemaBaseType]/xsd:complexContent/*/xsd:sequence/xsd:element/@name"/>
              <xsl:variable name="singleSlotBase" select="/xsd:schema/xsd:complexType[@name=$schemaBaseType]/xsd:complexContent/*/xsd:sequence/xsd:element/@type"/>
              <xsl:variable name="singleSlotType" select="/xsd:schema/xsd:simpleType[@name=$singleSlotBase]/xsd:annotation/xsd:appinfo/jxb:javaType/@name"/>
              <xsl:choose>
                <xsl:when test="contains(@type, 'colorGene')">
                  {
                  kandid.tree.user.UserInteger userText = new kandid.tree.user.UserInteger(textCellRenderer, textCellEditor, "Color", null, null);
                  userText.setBackgroundColor(new java.awt.Color(aGene.getColor().getRed(), aGene.getColor().getGreen(), aGene.getColor().getBlue()));
                  kandid.tree.user.UserTreeNode child = new kandid.tree.user.UserTreeNode(userText);
                  node.add(child);
                  fillEditor((^<xsl:value-of select="@type"/>)aGene.get^<xsl:value-of select="@name"/>(), child);
                  }
                </xsl:when>
                <xsl:when test="(count($singleSlot) = 1) and contains($superClass, 'geneType') and $singleSlotType">
                  {
                  // <xsl:value-of select="$superClass"/>
                  // <xsl:value-of select="$singleSlot"/>
                  // <xsl:value-of select="$singleSlotType"/>
                  // <xsl:value-of select="$schemaBaseType"/>
                  java.lang.Class[] signature = new java.lang.Class[1];
                  <xsl:choose>
                    <xsl:when test="$singleSlotType = 'boolean'">
                      signature[0] = java.lang.Boolean.class;
                      node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserCheckBox(checkBoxCellRenderer,
                                                                                checkBoxCellEditor,
                                                                                "<xsl:value-of select="@name"/>",
                                                                                aGene.get^<xsl:value-of select="@name"/>().isValue(),
                                                                                aGene.get^<xsl:value-of select="@name"/>(),
                                                                                aGene.get^<xsl:value-of select="@name"/>().getClass().getMethod("set^<xsl:value-of select="$singleSlot"/>", signature)
                                                                                ) ));
                    </xsl:when>
                    <xsl:when test="$singleSlotType = 'int'">
                      signature[0] = java.lang.Integer.class;
                      node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserInteger(textCellRenderer,
                                                                                textCellEditor,
                                                                                "<xsl:value-of select="@name"/> = " + aGene.get^<xsl:value-of select="@name"/>().get^<xsl:value-of select="$singleSlot"/>(),
                                                                                aGene.get^<xsl:value-of select="@name"/>(),
                                                                                aGene.get^<xsl:value-of select="@name"/>().getClass().getMethod("set^<xsl:value-of select="$singleSlot"/>", signature)
                                                                                ) ));
                    </xsl:when>
                    <xsl:when test="$singleSlotType = 'long'">
                      signature[0] = java.lang.Long.class;
                      node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserLong(textCellRenderer,
                                                                                textCellEditor,
                                                                                "<xsl:value-of select="@name"/> = " + aGene.get^<xsl:value-of select="@name"/>().get^<xsl:value-of select="$singleSlot"/>(),
                                                                                aGene.get^<xsl:value-of select="@name"/>(),
                                                                                aGene.get^<xsl:value-of select="@name"/>().getClass().getMethod("set^<xsl:value-of select="$singleSlot"/>", signature)
                                                                                ) ));
                    </xsl:when>
                    <xsl:when test="$singleSlotType = 'float'">
                      signature[0] = java.lang.Float.class;
                      node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserFloat(textCellRenderer,
                                                                                textCellEditor,
                                                                                "<xsl:value-of select="@name"/> = " + aGene.get^<xsl:value-of select="@name"/>().get^<xsl:value-of select="$singleSlot"/>(),
                                                                                aGene.get^<xsl:value-of select="@name"/>(),
                                                                                aGene.get^<xsl:value-of select="@name"/>().getClass().getMethod("set^<xsl:value-of select="$singleSlot"/>", signature)
                                                                                ) ));
                    </xsl:when>
                    <xsl:when test="$singleSlotType = 'double'">
                      signature[0] = java.lang.Double.class;
                      node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserDouble(textCellRenderer,
                                                                                textCellEditor,
                                                                                "<xsl:value-of select="@name"/> = " + aGene.get^<xsl:value-of select="@name"/>().get^<xsl:value-of select="$singleSlot"/>(),
                                                                                aGene.get^<xsl:value-of select="@name"/>(),
                                                                                aGene.get^<xsl:value-of select="@name"/>().getClass().getMethod("set^<xsl:value-of select="$singleSlot"/>", signature)
                                                                                ) ));
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:if test="$singleSlotType">
                      signature[0] = <xsl:value-of select="$singleSlotType"/>.class;
                      </xsl:if>
                      <xsl:if test="not($singleSlotType)">
                      signature[0] = ^<xsl:value-of select="$singleSlotBase"/>.class;
                      </xsl:if>
                      node.add(new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserText(textCellRenderer,
                                                                                textCellEditor,
                                                                                "<xsl:value-of select="@name"/> = " + aGene.get^<xsl:value-of select="@name"/>().get^<xsl:value-of select="$singleSlot"/>(),
                                                                                aGene.get^<xsl:value-of select="@name"/>(),
                                                                                aGene.get^<xsl:value-of select="@name"/>().getClass().getMethod("set^<xsl:value-of select="$singleSlot"/>", signature)
                                                                                ) ));
                    </xsl:otherwise>
                  </xsl:choose>
                  }
                </xsl:when>
                <xsl:otherwise>
                  {
                  java.lang.Class[] signature = new java.lang.Class[1];
                  signature[0] = ^<xsl:value-of select="$schemaBaseType"/>.class;
                  kandid.tree.user.UserTreeNode child  = new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserText(textCellRenderer,
                                                                                                        textCellEditor,
                                                                                                        "^<xsl:value-of select="@name"/>",
                                                                                                        aGene,
                                                                                                        aGene.getClass().getMethod("set^<xsl:value-of select="@name"/>", signature)
                                                                                                        ) );
                  node.add( child );
                  fillEditor((^<xsl:value-of select="@type"/>)aGene.get^<xsl:value-of select="@name"/>(), child);
                  }
                </xsl:otherwise>
              </xsl:choose>
            </xsl:if>
          </xsl:if>
        </xsl:if>
      </xsl:for-each>
    </xsl:if>
    model.nodeStructureChanged(node); 
    }
  </xsl:if>
</xsl:template>

<xsl:template name="list">
  <xsl:param name="aObject">aGene</xsl:param>
  <!-- member is list of children of class class gen -->
  {
  java.util.List list = aGene.get^<xsl:value-of select="@name"/>();
  int length = list.size();
  for(int lx = 0; lx &lt; length; ++lx) {
    kandid.tree.user.UserTreeNode child = new kandid.tree.user.UserTreeNode( new kandid.tree.user.UserText(textCellRenderer,textCellEditor,"^<xsl:value-of select="@name"/> "+(lx+1), null, null) );
    node.add( child );
    fillEditor((^<xsl:value-of select="@type"/>)list.get(lx), child);
  }
  }
</xsl:template>

<xsl:template match="*">
</xsl:template>

</xsl:stylesheet>
