<?xml version="1.0" encoding="UTF-8"?>
<!--
  Copyright (C) 2002 - 2025 Thomas Jourdan

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:jxb="http://java.sun.com/xml/ns/jaxb" xmlns:kandid="http://kandid.sourceforge.net/2003/XMLSchema" version="1.0">

  <xsl:output method="text"/>

  <xsl:variable name="chromosomeType" select="descendant::xsd:element[@name='chromosome']/@type"/>

<xsl:template match="xsd:schema">
  <xsl:variable name="imageType" select="/xsd:schema/xsd:element[@name='image']/@type"/>
// This file was generated by the mutate.xsl style sheet. 
// Any modifications to this file will be lost upon recompilation of the style sheet or the source schema. 

package kandid.soup.map;
import javax.xml.bind.JAXBException;
import kandid.soup.*;
import kandid.soup.genetic.lsys.LsysGenetic;

public class MutateChromosome extends RandomizeChromosome {
  private static ObjectFactory objectFactory = new ObjectFactory();

  private int mutateListLength(kandid.Environment env, int min, int max, int oldLength) {
    if(kandid.util.CentralRandomizer.getDouble(1.0) &lt; env.getMutationRate()) {
      int newLength = (int) Math.ceil(oldLength + (Math.log(oldLength + 1) * kandid.util.CentralRandomizer.getGaussian()));
      if (newLength &lt; min) {
          newLength = min;
      } else if (newLength > max) {
          newLength = max;
      }
      return newLength;
    }
    else {
      return oldLength;
    }
  }

  private void cutList(int cutTo, java.util.List list) {
      int length = list.size();
      while (length > cutTo) {
          --length;
          list.remove(length);
      }
  }
  
  private int scrambleList(kandid.Environment env, java.util.List list) {
    int mutationCounter = 0;
    int length = list.size();
    if(length > 1) {
      if (kandid.util.CentralRandomizer.getDouble(1.0) &lt; env.getMutationRate()) {
        int g1 = kandid.util.CentralRandomizer.getInt(length-1);
        int g2 = kandid.util.CentralRandomizer.getInt(length-1);
        if(g1 != g2) {
          Object temp = list.get(g1);
          list.set(g1, list.get(g2));
          list.set(g2, temp);
          ++mutationCounter;
        }
      }
    }
    return mutationCounter;
  }

  <xsl:apply-templates/>
}
</xsl:template>

<xsl:template match="xsd:complexType">
  <xsl:if test="contains(@name, 'Gene')">
    <xsl:variable name="geneType" select="@name"/>
    <xsl:choose>
      <xsl:when test="@name = 'integerGene'">
      private int mutate(kandid.Environment env, ^<xsl:value-of select="@name"/> aGene, int minInclusive, int maxInclusive, ChromosomeType aChromosome, int depth) {
      </xsl:when>
      <xsl:when test="@name = 'doubleGene'">
      private int mutate(kandid.Environment env, ^<xsl:value-of select="@name"/> aGene, double minInclusive, double maxInclusive, ChromosomeType aChromosome, int depth) {
      </xsl:when>
      <xsl:otherwise>
      private int mutate(kandid.Environment env, ^<xsl:value-of select="@name"/> aGene, ChromosomeType aChromosome, int depth)  throws JAXBException {
      </xsl:otherwise>
    </xsl:choose>
      int mutationCounter = 0;
    <xsl:if test="xsd:annotation/xsd:appinfo/kandid:mutation">
      if(kandid.util.CentralRandomizer.getDouble(1.0) &lt; env.getMutationRate()) {
        // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
        <xsl:value-of select="xsd:annotation/xsd:appinfo/kandid:mutation"/>
        // end section
      }
    </xsl:if>
    <!-- mutate members -->
    <xsl:if test="descendant::xsd:choice">
      <xsl:for-each select="descendant::xsd:choice">
        <xsl:if test="@minOccurs and @maxOccurs">
          <xsl:variable name="variants" select="count(descendant::xsd:element)"/>
          {
          // mutate list for gen <xsl:value-of select="@name"/>
          java.util.List list = aGene.get^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each>();
          // calculate new length of <xsl:value-of select="@name"/> list
          int oldLength = list.size();
          <xsl:if test="@kandid:initialLength">
            int newLength = <xsl:value-of select="@kandid:initialLength"/>;
          </xsl:if>
          <xsl:if test="not(@kandid:initialLength)">
            int newLength = mutateListLength(env, <xsl:value-of select="@minOccurs"/>, <xsl:value-of select="@maxOccurs"/>, oldLength);
          </xsl:if>
          // cut <xsl:value-of select="@name"/> list
          cutList(newLength, list);
          // mutate remaining elements
          java.util.Iterator iter = list.iterator();
          while( iter.hasNext()) {
            Object obj = iter.next();
            <xsl:for-each select="descendant::xsd:element">
              if(obj instanceof ^<xsl:value-of select="$geneType"/>) {
                mutationCounter += mutate(env, (^<xsl:value-of select="$geneType"/>) obj, aChromosome, depth +1);
              }
            </xsl:for-each>
          }
          // append elements to <xsl:value-of select="@name"/> list
          int append = newLength-oldLength;
          while(append > 0) {
            switch(kandid.util.CentralRandomizer.getInt(1, <xsl:value-of select="$variants"/>)) {
            <xsl:for-each select="descendant::xsd:element">
              case <xsl:number format="1" value="position()"/>:
                {
                /* 0 */ // ^<xsl:value-of select="@type"/> newGene = objectFactory.create^<xsl:value-of select="@type"/>();
                // randomize(newGene, aChromosome);
                // list.add(newGene);
                /* 1 */^<xsl:value-of select="$geneType"/> aNew^<xsl:value-of select="@name"/> = objectFactory.create^<xsl:value-of select="$geneType"/>();
                randomize(aNew^<xsl:value-of select="@name"/>, aChromosome, depth +1);
                list.add(aNew^<xsl:value-of select="@name"/>);
                break;
                }
            </xsl:for-each>
            }
            --append;
          }
          }
        </xsl:if>
      </xsl:for-each>
    </xsl:if>
    <xsl:if test="not(descendant::xsd:choice)">
      <!-- call mutation for super class -->
      <xsl:for-each select="descendant::xsd:extension">
        <xsl:if test="not((@base = 'geneType'))">
          // call mutation for super class
          mutationCounter += mutate(env, (^<xsl:value-of select="@base"/>)aGene, aChromosome, depth +1);
        </xsl:if>
      </xsl:for-each>
      <!-- mutate members -->
      // mutate members
      <xsl:for-each select="descendant::xsd:element">
        <xsl:if test="@minOccurs and @maxOccurs">
          <!-- member is list of children of class class gen -->
          <xsl:call-template name="list">
            <xsl:with-param name="aObject">aGene</xsl:with-param>
          </xsl:call-template>
        </xsl:if>
        <xsl:if test="not(@maxOccurs)">
          <!-- members are childs of class class gen -->
          <xsl:variable name="schemaBaseType" select="@type"/>
          <xsl:if test="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:enumeration/@value">
            <!-- basic data type is an enumeration -->
            String enumNames^<xsl:value-of select="@name"/>[] = {
            <xsl:for-each select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:enumeration">
              "<xsl:value-of select="@value"/>",
            </xsl:for-each>
            };
          </xsl:if>
          <xsl:if test="xsd:annotation/xsd:appinfo/kandid:mutation">
            if(kandid.util.CentralRandomizer.getDouble(1.0) &lt; env.getMutationRate()) {
              // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
              <xsl:value-of select="xsd:annotation/xsd:appinfo/kandid:mutation"/>
              // end section
            }
          </xsl:if>
          <xsl:if test="not(xsd:annotation/xsd:appinfo/kandid:mutation)">
            <xsl:if test="contains($schemaBaseType, 'Gene')">
            <!-- members are children of class class gen -->
              <xsl:if test="@kandid:minInclusive and @kandid:maxInclusive">
                mutationCounter += mutate(env, aGene.get^<xsl:value-of select="@name"/>(), <xsl:value-of select="@kandid:minInclusive"/>, <xsl:value-of select="@kandid:maxInclusive"/>, aChromosome, depth +1);
              </xsl:if>
              <xsl:if test="not(@kandid:minInclusive and @kandid:maxInclusive)">
                mutationCounter += mutate(env, aGene.get^<xsl:value-of select="@name"/>(), aChromosome, depth +1);
              </xsl:if>
            </xsl:if>
          </xsl:if>
        </xsl:if>
      </xsl:for-each>
    </xsl:if>
    return mutationCounter;
  }
</xsl:if>

<xsl:if test="contains(@name, 'Chromosome')">
  public int mutate(kandid.Environment env, ^<xsl:value-of select="@name"/> aChromosome) throws JAXBException {
    int mutationCounter = 0;
    
    <!-- call mutation for super class -->
    <xsl:for-each select="descendant::xsd:extension">
      <xsl:if test="not((@base = 'chromosomeType') or (@base = 'coloratorType'))">
        mutationCounter += mutate(env, (^<xsl:value-of select="@base"/>)aChromosome);
      </xsl:if>
    </xsl:for-each>
    <!-- mutate elements -->
    <xsl:for-each select="descendant::xsd:element">
      <xsl:if test="contains(@type, 'Gene')">
        <xsl:if test="@minOccurs and @maxOccurs">
          <!-- member is list of children of class class gen -->
          <xsl:call-template name="list">
            <xsl:with-param name="aObject">aChromosome</xsl:with-param>
          </xsl:call-template>
        </xsl:if>
        <xsl:if test="not(@maxOccurs)">
          <!-- members are childs of class class gen -->
          <xsl:if test="@kandid:minInclusive and @kandid:maxInclusive">
            mutationCounter += mutate(env, aChromosome.get^<xsl:value-of select="@name"/>(), <xsl:value-of select="@kandid:minInclusive"/>, <xsl:value-of select="@kandid:maxInclusive"/>, aChromosome, 1);
          </xsl:if>
          <xsl:if test="not(@kandid:minInclusive and @kandid:maxInclusive)">
            mutationCounter += mutate(env, aChromosome.get^<xsl:value-of select="@name"/>(), aChromosome, 1);
          </xsl:if>
        </xsl:if>
      </xsl:if>
    </xsl:for-each>
    return mutationCounter;
  }
</xsl:if>
</xsl:template>

<xsl:template name="list">
  <xsl:param name="aObject">aGene</xsl:param>
  <!-- member is list of children of class class gen -->
  {
  // mutate list for gen <xsl:value-of select="@name"/>
  java.util.List list = <xsl:value-of select="$aObject"/>.get^<xsl:value-of select="@name"/>();
  // calculate new length of <xsl:value-of select="@name"/> list
  int oldLength = list.size();
  <xsl:if test="@kandid:initialLength">
    int newLength = <xsl:value-of select="@kandid:initialLength"/>;
  </xsl:if>
  <xsl:if test="not(@kandid:initialLength)">
    int newLength = mutateListLength(env, <xsl:value-of select="@minOccurs"/>, <xsl:value-of select="@maxOccurs"/>, oldLength);
  </xsl:if>
  // cut <xsl:value-of select="@name"/> list
  cutList(newLength, list);
  // mutate remaining elements
  java.util.Iterator iter = list.iterator();
  while( iter.hasNext()) {
    mutationCounter += mutate(env, (^<xsl:value-of select="@type"/>) iter.next(), aChromosome, 1);
  }
  // append elements to <xsl:value-of select="@name"/> list
  int append = newLength-oldLength;
  while(append > 0) {
    /* 2 */^<xsl:value-of select="@type"/> newGene = objectFactory.create^<xsl:value-of select="@type"/>();
    randomize(newGene, aChromosome, 0);
    list.add(newGene);
    --append;
  }
  <xsl:if test="@kandid:maxInclusive">
    int length = list.size();
    int ix=0;
    // adjust upper bound for each element
    while(ix &lt; length) {
      ^<xsl:value-of select="@type"/> element = (^<xsl:value-of select="@type"/>)list.get(ix);
      if(element.getValue() > (<xsl:value-of select="@kandid:maxInclusive"/>)) {
        element.setValue(<xsl:value-of select="@kandid:maxInclusive"/>);
        ++mutationCounter;
       }
       ++ix;
     }
  </xsl:if>
  mutationCounter += (newLength > oldLength) ? (newLength-oldLength) : (oldLength-newLength);
  mutationCounter += scrambleList(env, list);
  }
</xsl:template>

<xsl:template match="*">
</xsl:template>

</xsl:stylesheet>
