<?xml version="1.0" encoding="UTF-8"?>
<!--
  Copyright (C) 2002 - 2025 Thomas Jourdan

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:jxb="http://java.sun.com/xml/ns/jaxb"
                xmlns:kandid="http://kandid.sourceforge.net/2003/XMLSchema"
                version="1.0">

<xsl:output method="text"/>

<xsl:template match="xsd:schema">
<xsl:variable name="chromosomeType" select="descendant::xsd:element[@name='chromosome']/@type"/>
// This file was generated by the merge.xsl style sheet. 
// Any modifications to this file will be lost upon recompilation of the style sheet or the source schema. 

package kandid.soup.map;
import javax.xml.bind.JAXBException;
import kandid.soup.*;
public class MergeChromosome extends CloneChromosome {
  private static ObjectFactory objectFactory = new ObjectFactory();
  private static RandomizeChromosome randomizeChromosome = new RandomizeChromosome();
  <xsl:apply-templates/>
}
</xsl:template>

<xsl:template match="xsd:simpleType">
	<xsl:if test="descendant::xsd:annotation/xsd:appinfo/jxb:typesafeEnumClass">
	private ^<xsl:value-of select="@name"/> merge(kandid.Environment env, ^<xsl:value-of select="@name"/> base1, ^<xsl:value-of select="@name"/> base2) {
    return env.isSource1() ? clone(base1) : clone(base2);
	}
	</xsl:if>
</xsl:template>


<xsl:template match="xsd:complexType">
  <xsl:if test="contains(@name, 'Gene')">
    <xsl:variable name="geneType" select="@name"/>
    <xsl:if test="descendant::xsd:choice">
      <xsl:for-each select="descendant::xsd:choice">
        <xsl:if test="@minOccurs and @maxOccurs">
          public ^<xsl:value-of select="$geneType"/> merge(kandid.Environment env,
                                                       ^<xsl:value-of select="$geneType"/> gene1,
                                                       ^<xsl:value-of select="$geneType"/> gene2) throws JAXBException {
            <!-- new instance  -->
            /* 1 */^<xsl:value-of select="$geneType"/> newGene = objectFactory.create^<xsl:value-of select="$geneType"/>();
            <!-- call merge for super class -->
            <xsl:for-each select="descendant::xsd:extension">
              <xsl:if test="not(@base = 'geneType')">
                mergeMembers^<xsl:value-of select="@base"/>(env, newGene, gene1, gene2);
              </xsl:if>
            </xsl:for-each>
            mergeMembers^<xsl:value-of select="$geneType"/>(env, newGene, gene1, gene2);
            return newGene;
          }
          private void mergeMembers^<xsl:value-of select="$geneType"/>(kandid.Environment env,
                                                                   ^<xsl:value-of select="$geneType"/> newGene,
                                                                   ^<xsl:value-of select="$geneType"/> gene1,
                                                                   ^<xsl:value-of select="$geneType"/> gene2) throws JAXBException {
            <xsl:if test="descendant::xsd:element[not(contains(@type, 'Gene'))]">
            </xsl:if>
            <!-- merge members -->
            <xsl:variable name="variants" select="count(descendant::xsd:element)"/>
            {
            // merge list for gen <xsl:value-of select="$geneType"/>
            java.util.List geneList1 = gene1.get^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each>();
            java.util.List geneList2 = gene2.get^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each>();
            java.util.List aGeneList = newGene.get^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each>();
            int length1 = geneList1.size();
            int length2 = geneList2.size();
            int commonLength = length1 &lt; length2 ? length1 : length2;
            int ix=0;
            // merge common part for ^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each> list
            while(ix &lt; commonLength) {
              Object item1 = geneList1.get(ix);
							Object item2 = geneList2.get(ix);
							boolean source1 = env.isSource1();
							if(false) {
							  assert false : "code should never be reached";
							}
              <xsl:for-each select="descendant::xsd:element">
								else if(item1 instanceof ^<xsl:value-of select="$geneType"/>
												&amp;&amp; item2 instanceof ^<xsl:value-of select="$geneType"/>) {
									aGeneList.add(merge(env, (^<xsl:value-of select="$geneType"/>)item1, (^<xsl:value-of select="$geneType"/>)item2));
                }
              </xsl:for-each>
							<xsl:for-each select="descendant::xsd:element">
								else if(source1 &amp;&amp; item1 instanceof ^<xsl:value-of select="$geneType"/>) {
									aGeneList.add(clone((^<xsl:value-of select="$geneType"/>)item1));
								}
							</xsl:for-each>
							<xsl:for-each select="descendant::xsd:element">
								else if(!source1 &amp;&amp; item2 instanceof ^<xsl:value-of select="$geneType"/>) {
									aGeneList.add(clone((^<xsl:value-of select="$geneType"/>)item2));
								}
							</xsl:for-each>
							else {
							  assert false : "code should never be reached";
							}
              ++ix;
            }
            // partial append longer ^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each> list
            if(length2 != length1) {
              if(env.isSource1(length1, length2)) {
                // geneList1 is longer
                int newLength = kandid.util.CentralRandomizer.getInt(length2, length1);
                while(ix &lt; newLength) {
                  Object item1 = geneList1.get(ix);
                  <xsl:for-each select="descendant::xsd:element">
                    if(item1 instanceof ^<xsl:value-of select="$geneType"/>) {
                      aGeneList.add(clone((^<xsl:value-of select="$geneType"/>)item1));
                    }
                  </xsl:for-each>
                  ++ix;
                }
              }
              else {
                // geneList2 is longer
                int newLength = kandid.util.CentralRandomizer.getInt(length1, length2);
                while(ix &lt; newLength) {
                  Object item2 = geneList2.get(ix);
                  <xsl:for-each select="descendant::xsd:element">
                    if(item2 instanceof ^<xsl:value-of select="$geneType"/>) {
                      aGeneList.add(clone((^<xsl:value-of select="$geneType"/>)item2));
                    }
                  </xsl:for-each>
                  ++ix;
                }
              }
            }
            }
          }
          <xsl:for-each select="descendant::xsd:element">
          /*
            public ^<xsl:value-of select="$geneType"/> merge(kandid.Environment env,
                                                         ^<xsl:value-of select="$geneType"/> gene1,
                                                         ^<xsl:value-of select="$geneType"/> gene2) throws JAXBException {
              <!-- new instance  -->
              !! 2 !!^<xsl:value-of select="$geneType"/> newGene = objectFactory.create^<xsl:value-of select="$geneType"/>^<xsl:value-of select="@name"/>();
              <!-- call merge for super class -->
              <xsl:for-each select="descendant::xsd:extension">
                <xsl:if test="not(@base = 'geneType')">
                  mergeMembers^<xsl:value-of select="@base"/>(env, newGene, gene1, gene2);
                </xsl:if>
              </xsl:for-each>
              mergeMembers^<xsl:value-of select="$geneType"/>^<xsl:value-of select="@name"/>(env, newGene, gene1, gene2);
              return newGene;
            }
            private void mergeMembers^<xsl:value-of select="$geneType"/>^<xsl:value-of select="@name"/>(kandid.Environment env,
                                                                     ^<xsl:value-of select="$geneType"/> newGene,
                                                                     ^<xsl:value-of select="$geneType"/> gene1,
                                                                     ^<xsl:value-of select="$geneType"/> gene2) throws JAXBException {
              <xsl:variable name="schemaBaseType" select="@type"/>
              //!! schemaBaseType ^<xsl:value-of select="$schemaBaseType"/>
              <xsl:for-each select="/xsd:schema/xsd:complexType[@name=$schemaBaseType]/xsd:complexContent/*/xsd:sequence/xsd:element">
                <xsl:variable name="singleSlotName" select="@name"/>
                <xsl:variable name="singleSlotType" select="@type"/>
                // schemaBaseType ^<xsl:value-of select="$schemaBaseType"/>
                // singleSlotName ^<xsl:value-of select="$singleSlotName"/>
                // type is ^<xsl:value-of select="$singleSlotType"/>
                newGene.set^<xsl:value-of select="$singleSlotName"/>(merge(env, gene1.get^<xsl:value-of select="$singleSlotName"/>(), gene2.get^<xsl:value-of select="$singleSlotName"/>()));
              </xsl:for-each>
            }
            */
          </xsl:for-each>
        </xsl:if>
      </xsl:for-each>
    </xsl:if>
      
    <xsl:if test="not(descendant::xsd:choice)">
      public ^<xsl:value-of select="@name"/> merge(kandid.Environment env,
                                                   ^<xsl:value-of select="@name"/> gene1,
                                                   ^<xsl:value-of select="@name"/> gene2) throws JAXBException {
        <!-- new instance  -->
        /* 3 */^<xsl:value-of select="@name"/> newGene = objectFactory.create^<xsl:value-of select="@name"/>();
        <!-- call merge for super class -->
        <xsl:for-each select="descendant::xsd:extension">
          <xsl:call-template name="mergeSuper">
            <xsl:with-param name="extensionType"><xsl:value-of select="@base"/></xsl:with-param>
          </xsl:call-template>
        </xsl:for-each>
        // merge members of this class ^<xsl:value-of select="@name"/>
        mergeMembers^<xsl:value-of select="@name"/>(env, newGene, gene1, gene2);
        return newGene;
      }
      private void mergeMembers^<xsl:value-of select="@name"/>(kandid.Environment env,
                                                               ^<xsl:value-of select="@name"/> newGene,
                                                               ^<xsl:value-of select="@name"/> gene1,
                                                               ^<xsl:value-of select="@name"/> gene2) throws JAXBException {
        <xsl:if test="descendant::xsd:element[not(contains(@type, 'Gene'))]">
        </xsl:if>
        <!-- merge members -->
        <xsl:if test="descendant::xsd:choice">
          <xsl:for-each select="descendant::xsd:choice">
            <xsl:if test="@minOccurs and @maxOccurs">
              <xsl:variable name="variants" select="count(descendant::xsd:element)"/>
              {
              // merge list for gen <xsl:value-of select="@name"/>
              java.util.List geneList1 = gene1.get^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each>();
              java.util.List geneList2 = gene2.get^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each>();
              java.util.List aGeneList = newGene.get^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each>();
              int length1 = geneList1.size();
              int length2 = geneList2.size();
              int commonLength = length1 &lt; length2 ? length1 : length2;
              int ix=0;
              // merge common part for ^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each> list
              while(ix &lt; commonLength) {
                Object item1 = geneList1.get(ix);
                <xsl:for-each select="descendant::xsd:element">
                  if(item1 instanceof ^<xsl:value-of select="$geneType"/>) {
                    aGeneList.add(merge(env, (^<xsl:value-of select="$geneType"/>)item1, (^<xsl:value-of select="$geneType"/>)geneList2.get(ix)));
                  }
                </xsl:for-each>
                ++ix;
              }
              // partial append longer ^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each> list
              if(length2 != length1) {
                if(env.isSource1(length1, length2)) {
                  // geneList1 is longer
                  int newLength = kandid.util.CentralRandomizer.getInt(length2, length1);
                  while(ix &lt; newLength) {
                    Object item1 = geneList1.get(ix);
                    <xsl:for-each select="descendant::xsd:element">
                      if(item1 instanceof ^<xsl:value-of select="$geneType"/>) {
                        aGeneList.add(clone((^<xsl:value-of select="$geneType"/>)item1));
                      }
                    </xsl:for-each>
                    ++ix;
                  }
                }
                else {
                  // geneList2 is longer
                  int newLength = kandid.util.CentralRandomizer.getInt(length1, length2);
                  while(ix &lt; newLength) {
                    Object item2 = geneList2.get(ix);
                    <xsl:for-each select="descendant::xsd:element">
                      if(item2 instanceof ^<xsl:value-of select="$geneType"/>) {
                        aGeneList.add(clone((^<xsl:value-of select="$geneType"/>)item2));
                      }
                    </xsl:for-each>
                    ++ix;
                  }
                }
              }
              }
            </xsl:if>
          </xsl:for-each>
        </xsl:if>
        <xsl:if test="not(descendant::xsd:choice)">
          <xsl:for-each select="descendant::xsd:element">
            <xsl:variable name="schemaBaseType" select="@type"/>
            <xsl:if test="not(contains($schemaBaseType, 'Gene'))">
              <!-- members are basic data type -->
              <xsl:variable name="javaReturnType" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:annotation/xsd:appinfo/jxb:javaType/@name"/>
              <xsl:variable name="enumvalues" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:enumeration/@value"/>
              <xsl:if test="$enumvalues">
                <!-- basic data type is an enumeration -->
								//  type is an enumeration of ^<xsl:value-of select="$schemaBaseType"/>
                newGene.set^<xsl:value-of select="@name"/>(merge(env, gene1.get^<xsl:value-of select="@name"/>(), gene2.get^<xsl:value-of select="@name"/>()));
              </xsl:if>
              <xsl:if test="not($enumvalues)">
                <xsl:if test="$javaReturnType = 'boolean'">
                  <!-- basic data type is boolean -->
  								//  type is boolean
                  newGene.set^<xsl:value-of select="@name"/>(env.isSource1() ? gene1.is^<xsl:value-of select="@name"/>() : gene2.is^<xsl:value-of select="@name"/>());
                </xsl:if>
                <xsl:if test="($javaReturnType = 'float') or ($javaReturnType = 'double') or ($javaReturnType = 'int') or ($javaReturnType = 'long')">
                  <!-- basic data type is double, int, long -->
									//  type is <xsl:value-of select="$javaReturnType"/>
                  newGene.set^<xsl:value-of select="@name"/>(env.isSource1() ? gene1.get^<xsl:value-of select="@name"/>() : gene2.get^<xsl:value-of select="@name"/>());
                </xsl:if>
                <xsl:if test="$javaReturnType = 'java.lang.String'">
                  <!-- basic data type is java.lang.String -->
                  //  type is <xsl:value-of select="$javaReturnType"/>
                  newGene.set^<xsl:value-of select="@name"/>(new String(env.isSource1() ? gene1.get^<xsl:value-of select="@name"/>() : gene2.get^<xsl:value-of select="@name"/>()));
                </xsl:if>
              </xsl:if>
            </xsl:if>
            <xsl:if test="contains($schemaBaseType, 'Gene')">
              <xsl:if test="@minOccurs and @maxOccurs">
                <!-- member is list of children of class class gen -->
                <xsl:call-template name="list">
                  <xsl:with-param name="aObject">newGene</xsl:with-param>
                </xsl:call-template>
              </xsl:if>
              <xsl:if test="not(@maxOccurs)">
                <!-- members are children of class class gen -->
                //  type is ^<xsl:value-of select="$schemaBaseType"/>
                newGene.set^<xsl:value-of select="@name"/>(merge(env, gene1.get^<xsl:value-of select="@name"/>(), gene2.get^<xsl:value-of select="@name"/>()));
              </xsl:if>
            </xsl:if>
        </xsl:for-each>
      </xsl:if>
      }
    </xsl:if>
  </xsl:if>
  
  <xsl:if test="contains(@name, 'Chromosome')">
    protected void mergeMembers^<xsl:value-of select="@name"/>(kandid.Environment env,
                                                 ^<xsl:value-of select="@name"/> aChromosome,
                                                 ^<xsl:value-of select="@name"/> gene1,
                                                 ^<xsl:value-of select="@name"/> gene2) throws JAXBException {
      <!-- merge elements -->
      <xsl:for-each select="descendant::xsd:element">
        <xsl:if test="contains(@type, 'Gene')">
          <xsl:if test="@minOccurs and @maxOccurs">
            <!-- member is list of children of class class gen -->
            <xsl:call-template name="list">
              <xsl:with-param name="aObject">aChromosome</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="not(@maxOccurs)">
            <!-- members are children of class class gen -->
            aChromosome.set^<xsl:value-of select="@name"/>(merge(env, (^<xsl:value-of select="@type"/>)gene1.get^<xsl:value-of select="@name"/>(), (^<xsl:value-of select="@type"/>)gene2.get^<xsl:value-of select="@name"/>()));
          </xsl:if>
        </xsl:if>
      </xsl:for-each>
    }

    public ^<xsl:value-of select="@name"/> merge(kandid.Environment env,
                                                 ^<xsl:value-of select="@name"/> gene1,
                                                 ^<xsl:value-of select="@name"/> gene2) throws JAXBException {
      /* 4 */^<xsl:value-of select="@name"/> newGene = objectFactory.create^<xsl:value-of select="@name"/>();
      <!-- call merge for super class -->
      <xsl:for-each select="descendant::xsd:extension">
        <xsl:call-template name="mergeSuper">
          <xsl:with-param name="extensionType"><xsl:value-of select="@base"/></xsl:with-param>
        </xsl:call-template>
      </xsl:for-each>
      <!-- merge elements -->
      // merge members of class ^<xsl:value-of select="@name"/>
      mergeMembers^<xsl:value-of select="@name"/>(env, newGene, gene1, gene2);
      return newGene;
    }
  </xsl:if>
</xsl:template>

  <!-- Calls mergeMembers methods for all super classes. -->
  <xsl:template name="mergeSuper">
    <xsl:param name="extensionType"/>
    <xsl:if test="not(($extensionType = 'chromosomeType') or ($extensionType = 'coloratorType') or ($extensionType = 'geneType'))">
      <xsl:for-each select="/xsd:schema/xsd:complexType[@name=$extensionType]/xsd:complexContent/xsd:extension">
        <xsl:call-template name="mergeSuper">
          <xsl:with-param name="extensionType"><xsl:value-of select="@base"/></xsl:with-param>
        </xsl:call-template>
      </xsl:for-each>
      // merge members of super class ^<xsl:value-of select="$extensionType"/>
      mergeMembers^<xsl:value-of select="$extensionType"/>(env, newGene, gene1, gene2);
    </xsl:if>
  </xsl:template>

  
  <xsl:template name="list">
    <xsl:param name="aObject">aGene</xsl:param>
    <!-- member is list of children of class class gen -->
    // list of type ^<xsl:value-of select="@type"/>
    {
    // merge list for gen <xsl:value-of select="@name"/>
    java.util.List geneList1 = gene1.get^<xsl:value-of select="@name"/>();
    java.util.List geneList2 = gene2.get^<xsl:value-of select="@name"/>();
    java.util.List aGeneList = <xsl:value-of select="$aObject"/>.get^<xsl:value-of select="@name"/>();
    int length1 = geneList1.size();
    int length2 = geneList2.size();
    <xsl:if test="@kandid:mergeLength">
      int newLength = <xsl:value-of select="@kandid:mergeLength"/>;
      int ix=0;
      while(ix &lt; newLength) {
        if(ix &lt; length1 &amp;&amp; ix &lt; length2) { 
          // merge common part for <xsl:value-of select="@name"/> list
          aGeneList.add(merge(env, (^<xsl:value-of select="@type"/>)geneList1.get(ix), (^<xsl:value-of select="@type"/>)geneList2.get(ix)));
        }
        else if(ix &lt; length1 &amp;&amp; ix >= length2) { 
          // partial append longer <xsl:value-of select="@name"/> list
          aGeneList.add(clone((^<xsl:value-of select="@type"/>)geneList1.get(ix)));
        }
        else if(ix >= length1 &amp;&amp; ix &lt; length2) { 
          // partial append longer <xsl:value-of select="@name"/> list
          aGeneList.add(clone((^<xsl:value-of select="@type"/>)geneList2.get(ix)));
        }
        else {
          // generate new elements for <xsl:value-of select="@name"/> list
          /* 5 */^<xsl:value-of select="@type"/> aGene = objectFactory.create^<xsl:value-of select="@type"/>();
          randomizeChromosome.randomize(aGene, aChromosome, 1);
          aGeneList.add(aGene);
        }
        ++ix;
      }
    </xsl:if>
    <xsl:if test="not(@kandid:mergeLength)">
      int commonLength = length1 &lt; length2 ? length1 : length2;
      int ix=0;
      // merge common part for <xsl:value-of select="@name"/> list
      while(ix &lt; commonLength) {
        aGeneList.add(merge(env, (^<xsl:value-of select="@type"/>)geneList1.get(ix), (^<xsl:value-of select="@type"/>)geneList2.get(ix)));
        ++ix;
      }
      // partial append longer <xsl:value-of select="@name"/> list
      if(length2 != length1) {
        if(env.isSource1(length1, length2)) {
          // geneList1 is longer
          int newLength = kandid.util.CentralRandomizer.getInt(length2, length1);
          while(ix &lt; newLength) {
            aGeneList.add(clone((^<xsl:value-of select="@type"/>)geneList1.get(ix)));
            ++ix;
          }
        }
        else {
          // geneList2 is longer
          int newLength = kandid.util.CentralRandomizer.getInt(length1, length2);
          while(ix &lt; newLength) {
            aGeneList.add(clone((^<xsl:value-of select="@type"/>)geneList2.get(ix)));
            ++ix;
          }
        }
      }
    </xsl:if>
    <xsl:if test="@kandid:maxInclusive">
      int length = aGeneList.size();
      ix=0;
      // adjust upper bound for each element
      while(ix &lt; length) {
        ^<xsl:value-of select="@type"/> element = (^<xsl:value-of select="@type"/>)aGeneList.get(ix);
        if(element.getValue() > (<xsl:value-of select="@kandid:maxInclusive"/>))
          element.setValue(<xsl:value-of select="@kandid:maxInclusive"/>);
         ++ix;
       }
    </xsl:if>
    }
  </xsl:template>
  
</xsl:stylesheet>
