/*
 * Decompiled with CFR 0.152.
 */
package kandid.util;

import javax.vecmath.Vector3d;
import kandid.util.TextureRandomizer;

public class PovNoise {
    static final int SINTABSIZE = 1000;
    static final int MAXSIZE = 267;
    static final int NUMBER_OF_WAVES = 10;
    static final int MINX = -10000;
    static final int MINY = -10000;
    static final int MINZ = -10000;
    static final double REALSCALE = 3.0518043793392844E-5;
    boolean initialised;
    static double[] sintab;
    static double[] RTable;
    int[] hashTable = new int[4096];
    double[] frequency = new double[10];
    Vector3d[] Wave_Sources = new Vector3d[10];
    static final int[] crctab;

    static {
        int[] nArray = new int[256];
        nArray[1] = 49345;
        nArray[2] = 49537;
        nArray[3] = 320;
        nArray[4] = 49921;
        nArray[5] = 960;
        nArray[6] = 640;
        nArray[7] = 49729;
        nArray[8] = 50689;
        nArray[9] = 1728;
        nArray[10] = 1920;
        nArray[11] = 51009;
        nArray[12] = 1280;
        nArray[13] = 50625;
        nArray[14] = 50305;
        nArray[15] = 1088;
        nArray[16] = 52225;
        nArray[17] = 3264;
        nArray[18] = 3456;
        nArray[19] = 52545;
        nArray[20] = 3840;
        nArray[21] = 53185;
        nArray[22] = 52865;
        nArray[23] = 3648;
        nArray[24] = 2560;
        nArray[25] = 51905;
        nArray[26] = 52097;
        nArray[27] = 2880;
        nArray[28] = 51457;
        nArray[29] = 2496;
        nArray[30] = 2176;
        nArray[31] = 51265;
        nArray[32] = 55297;
        nArray[33] = 6336;
        nArray[34] = 6528;
        nArray[35] = 55617;
        nArray[36] = 6912;
        nArray[37] = 56257;
        nArray[38] = 55937;
        nArray[39] = 6720;
        nArray[40] = 7680;
        nArray[41] = 57025;
        nArray[42] = 57217;
        nArray[43] = 8000;
        nArray[44] = 56577;
        nArray[45] = 7616;
        nArray[46] = 7296;
        nArray[47] = 56385;
        nArray[48] = 5120;
        nArray[49] = 54465;
        nArray[50] = 54657;
        nArray[51] = 5440;
        nArray[52] = 55041;
        nArray[53] = 6080;
        nArray[54] = 5760;
        nArray[55] = 54849;
        nArray[56] = 53761;
        nArray[57] = 4800;
        nArray[58] = 4992;
        nArray[59] = 54081;
        nArray[60] = 4352;
        nArray[61] = 53697;
        nArray[62] = 53377;
        nArray[63] = 4160;
        nArray[64] = 61441;
        nArray[65] = 12480;
        nArray[66] = 12672;
        nArray[67] = 61761;
        nArray[68] = 13056;
        nArray[69] = 62401;
        nArray[70] = 62081;
        nArray[71] = 12864;
        nArray[72] = 13824;
        nArray[73] = 63169;
        nArray[74] = 63361;
        nArray[75] = 14144;
        nArray[76] = 62721;
        nArray[77] = 13760;
        nArray[78] = 13440;
        nArray[79] = 62529;
        nArray[80] = 15360;
        nArray[81] = 64705;
        nArray[82] = 64897;
        nArray[83] = 15680;
        nArray[84] = 65281;
        nArray[85] = 16320;
        nArray[86] = 16000;
        nArray[87] = 65089;
        nArray[88] = 64001;
        nArray[89] = 15040;
        nArray[90] = 15232;
        nArray[91] = 64321;
        nArray[92] = 14592;
        nArray[93] = 63937;
        nArray[94] = 63617;
        nArray[95] = 14400;
        nArray[96] = 10240;
        nArray[97] = 59585;
        nArray[98] = 59777;
        nArray[99] = 10560;
        nArray[100] = 60161;
        nArray[101] = 11200;
        nArray[102] = 10880;
        nArray[103] = 59969;
        nArray[104] = 60929;
        nArray[105] = 11968;
        nArray[106] = 12160;
        nArray[107] = 61249;
        nArray[108] = 11520;
        nArray[109] = 60865;
        nArray[110] = 60545;
        nArray[111] = 11328;
        nArray[112] = 58369;
        nArray[113] = 9408;
        nArray[114] = 9600;
        nArray[115] = 58689;
        nArray[116] = 9984;
        nArray[117] = 59329;
        nArray[118] = 59009;
        nArray[119] = 9792;
        nArray[120] = 8704;
        nArray[121] = 58049;
        nArray[122] = 58241;
        nArray[123] = 9024;
        nArray[124] = 57601;
        nArray[125] = 8640;
        nArray[126] = 8320;
        nArray[127] = 57409;
        nArray[128] = 40961;
        nArray[129] = 24768;
        nArray[130] = 24960;
        nArray[131] = 41281;
        nArray[132] = 25344;
        nArray[133] = 41921;
        nArray[134] = 41601;
        nArray[135] = 25152;
        nArray[136] = 26112;
        nArray[137] = 42689;
        nArray[138] = 42881;
        nArray[139] = 26432;
        nArray[140] = 42241;
        nArray[141] = 26048;
        nArray[142] = 25728;
        nArray[143] = 42049;
        nArray[144] = 27648;
        nArray[145] = 44225;
        nArray[146] = 44417;
        nArray[147] = 27968;
        nArray[148] = 44801;
        nArray[149] = 28608;
        nArray[150] = 28288;
        nArray[151] = 44609;
        nArray[152] = 43521;
        nArray[153] = 27328;
        nArray[154] = 27520;
        nArray[155] = 43841;
        nArray[156] = 26880;
        nArray[157] = 43457;
        nArray[158] = 43137;
        nArray[159] = 26688;
        nArray[160] = 30720;
        nArray[161] = 47297;
        nArray[162] = 47489;
        nArray[163] = 31040;
        nArray[164] = 47873;
        nArray[165] = 31680;
        nArray[166] = 31360;
        nArray[167] = 47681;
        nArray[168] = 48641;
        nArray[169] = 32448;
        nArray[170] = 32640;
        nArray[171] = 48961;
        nArray[172] = 32000;
        nArray[173] = 48577;
        nArray[174] = 48257;
        nArray[175] = 31808;
        nArray[176] = 46081;
        nArray[177] = 29888;
        nArray[178] = 30080;
        nArray[179] = 46401;
        nArray[180] = 30464;
        nArray[181] = 47041;
        nArray[182] = 46721;
        nArray[183] = 30272;
        nArray[184] = 29184;
        nArray[185] = 45761;
        nArray[186] = 45953;
        nArray[187] = 29504;
        nArray[188] = 45313;
        nArray[189] = 29120;
        nArray[190] = 28800;
        nArray[191] = 45121;
        nArray[192] = 20480;
        nArray[193] = 37057;
        nArray[194] = 37249;
        nArray[195] = 20800;
        nArray[196] = 37633;
        nArray[197] = 21440;
        nArray[198] = 21120;
        nArray[199] = 37441;
        nArray[200] = 38401;
        nArray[201] = 22208;
        nArray[202] = 22400;
        nArray[203] = 38721;
        nArray[204] = 21760;
        nArray[205] = 38337;
        nArray[206] = 38017;
        nArray[207] = 21568;
        nArray[208] = 39937;
        nArray[209] = 23744;
        nArray[210] = 23936;
        nArray[211] = 40257;
        nArray[212] = 24320;
        nArray[213] = 40897;
        nArray[214] = 40577;
        nArray[215] = 24128;
        nArray[216] = 23040;
        nArray[217] = 39617;
        nArray[218] = 39809;
        nArray[219] = 23360;
        nArray[220] = 39169;
        nArray[221] = 22976;
        nArray[222] = 22656;
        nArray[223] = 38977;
        nArray[224] = 34817;
        nArray[225] = 18624;
        nArray[226] = 18816;
        nArray[227] = 35137;
        nArray[228] = 19200;
        nArray[229] = 35777;
        nArray[230] = 35457;
        nArray[231] = 19008;
        nArray[232] = 19968;
        nArray[233] = 36545;
        nArray[234] = 36737;
        nArray[235] = 20288;
        nArray[236] = 36097;
        nArray[237] = 19904;
        nArray[238] = 19584;
        nArray[239] = 35905;
        nArray[240] = 17408;
        nArray[241] = 33985;
        nArray[242] = 34177;
        nArray[243] = 17728;
        nArray[244] = 34561;
        nArray[245] = 18368;
        nArray[246] = 18048;
        nArray[247] = 34369;
        nArray[248] = 33281;
        nArray[249] = 17088;
        nArray[250] = 17280;
        nArray[251] = 33601;
        nArray[252] = 16640;
        nArray[253] = 33217;
        nArray[254] = 32897;
        nArray[255] = 16448;
        crctab = nArray;
    }

    public PovNoise(long seed) {
        int ix = 0;
        while (ix < this.Wave_Sources.length) {
            this.Wave_Sources[ix] = new Vector3d();
            ++ix;
        }
        this.initializeNoise(seed);
    }

    private void initializeNoise(long seed) {
        this.initStaticTables();
        this.initTextureTable(seed);
        TextureRandomizer zVarWave = new TextureRandomizer(seed);
        int i = 0;
        while (i < 10) {
            Vector3d point = this.getDNoise(i, 0.0, 0.0);
            PovNoise.VNormalize(this.Wave_Sources[i], point);
            this.frequency[i] = zVarWave.gleichVerteilt() + 0.01;
            ++i;
        }
    }

    private void initTextureTable(long seed) {
        TextureRandomizer zVarHashTable = new TextureRandomizer(seed);
        int i = 0;
        while (i < 4096) {
            this.hashTable[i] = i;
            ++i;
        }
        i = 4095;
        while (i >= 0) {
            int j = zVarHashTable.wuerfeln() % 4096;
            int temp = this.hashTable[i];
            this.hashTable[i] = this.hashTable[j];
            this.hashTable[j] = temp;
            --i;
        }
    }

    private void initStaticTables() {
        if (!this.initialised) {
            sintab = new double[1000];
            int i = 0;
            while (i < 1000) {
                PovNoise.sintab[i] = Math.sin((double)i / 1000.0 * (Math.PI * 2));
                ++i;
            }
            RTable = new double[267];
            Vector3d rp = new Vector3d();
            int i2 = 0;
            while (i2 < 267) {
                rp.y = rp.z = (double)i2;
                rp.x = rp.z;
                rp = PovNoise.RS(rp);
                PovNoise.RTable[i2] = (double)PovNoise.R(rp) * 3.0518043793392844E-5 - 1.0;
                ++i2;
            }
            this.initialised = true;
        }
    }

    private static Vector3d RS(Vector3d v) {
        v.x *= 0.12345;
        v.y *= 0.12345;
        v.z *= 0.12345;
        return v;
    }

    private static int R(Vector3d v) {
        int[] bits = new int[24];
        long lx = Double.doubleToLongBits(v.x);
        bits[0] = (int)(lx >> 0 & 0xFFL);
        bits[1] = (int)(lx >> 8 & 0xFFL);
        bits[2] = (int)(lx >> 16 & 0xFFL);
        bits[3] = (int)(lx >> 24 & 0xFFL);
        bits[4] = (int)(lx >> 32 & 0xFFL);
        bits[5] = (int)(lx >> 40 & 0xFFL);
        bits[6] = (int)(lx >> 48 & 0xFFL);
        bits[7] = (int)(lx >> 56 & 0xFFL);
        long ly = Double.doubleToLongBits(v.y);
        bits[8] = (int)(ly >> 0 & 0xFFL);
        bits[9] = (int)(ly >> 8 & 0xFFL);
        bits[10] = (int)(ly >> 16 & 0xFFL);
        bits[11] = (int)(ly >> 24 & 0xFFL);
        bits[12] = (int)(ly >> 32 & 0xFFL);
        bits[13] = (int)(ly >> 40 & 0xFFL);
        bits[14] = (int)(ly >> 48 & 0xFFL);
        bits[15] = (int)(ly >> 56 & 0xFFL);
        long lz = Double.doubleToLongBits(v.z);
        bits[16] = (int)(lz >> 0 & 0xFFL);
        bits[17] = (int)(lz >> 8 & 0xFFL);
        bits[18] = (int)(lz >> 16 & 0xFFL);
        bits[19] = (int)(lz >> 24 & 0xFFL);
        bits[20] = (int)(lz >> 32 & 0xFFL);
        bits[21] = (int)(lz >> 40 & 0xFFL);
        bits[22] = (int)(lz >> 48 & 0xFFL);
        bits[23] = (int)(lz >> 56 & 0xFFL);
        return PovNoise.Crc16(bits);
    }

    private static int Crc16(int[] buf) {
        int count = buf.length;
        int crc = 0;
        int ix = 0;
        while (count-- > 0) {
            crc = crc >> 8 ^ crctab[(crc ^ buf[ix]) % crctab.length];
            ++ix;
        }
        return crc;
    }

    private static double cycloidal(double value) {
        if (value >= 0.0) {
            int indx = (int)((value - Math.floor(value)) * 1000.0);
            return sintab[indx];
        }
        int indx = (int)((0.0 - (value + Math.floor(0.0 - value))) * 1000.0);
        return 0.0 - sintab[indx];
    }

    public double getNoise(double x, double y, double z) {
        int ix = (int)(x -= -10000.0);
        int iy = (int)(y -= -10000.0);
        int iz = (int)(z -= -10000.0);
        int jx = ix + 1;
        int jy = iy + 1;
        int jz = iz + 1;
        double sx = PovNoise.SCURVE(x - (double)ix);
        double sy = PovNoise.SCURVE(y - (double)iy);
        double sz = PovNoise.SCURVE(z - (double)iz);
        double tx = 1.0 - sx;
        double ty = 1.0 - sy;
        double tz = 1.0 - sz;
        int m = this.Hash3d(ix, iy, iz) & 0xFF;
        double sum = PovNoise.INCRSUM(m, tx * ty * tz, x - (double)ix, y - (double)iy, z - (double)iz);
        m = this.Hash3d(jx, iy, iz) & 0xFF;
        sum += PovNoise.INCRSUM(m, sx * ty * tz, x - (double)jx, y - (double)iy, z - (double)iz);
        m = this.Hash3d(ix, jy, iz) & 0xFF;
        sum += PovNoise.INCRSUM(m, tx * sy * tz, x - (double)ix, y - (double)jy, z - (double)iz);
        m = this.Hash3d(jx, jy, iz) & 0xFF;
        sum += PovNoise.INCRSUM(m, sx * sy * tz, x - (double)jx, y - (double)jy, z - (double)iz);
        m = this.Hash3d(ix, iy, jz) & 0xFF;
        sum += PovNoise.INCRSUM(m, tx * ty * sz, x - (double)ix, y - (double)iy, z - (double)jz);
        m = this.Hash3d(jx, iy, jz) & 0xFF;
        sum += PovNoise.INCRSUM(m, sx * ty * sz, x - (double)jx, y - (double)iy, z - (double)jz);
        m = this.Hash3d(ix, jy, jz) & 0xFF;
        sum += PovNoise.INCRSUM(m, tx * sy * sz, x - (double)ix, y - (double)jy, z - (double)jz);
        m = this.Hash3d(jx, jy, jz) & 0xFF;
        sum += PovNoise.INCRSUM(m, sx * sy * sz, x - (double)jx, y - (double)jy, z - (double)jz);
        if ((sum += 0.5) < 0.0) {
            sum = 0.0;
        }
        if (sum > 1.0) {
            sum = 1.0;
        }
        return sum;
    }

    public Vector3d getDNoise(double x, double y, double z) {
        Vector3d result = new Vector3d();
        int ix = (int)(x -= -10000.0);
        int iy = (int)(y -= -10000.0);
        int iz = (int)(z -= -10000.0);
        int jx = ix + 1;
        int jy = iy + 1;
        int jz = iz + 1;
        double sx = PovNoise.SCURVE(x - (double)ix);
        double sy = PovNoise.SCURVE(y - (double)iy);
        double sz = PovNoise.SCURVE(z - (double)iz);
        double tx = 1.0 - sx;
        double ty = 1.0 - sy;
        double tz = 1.0 - sz;
        int m = this.Hash3d(ix, iy, iz) & 0xFF;
        double px = x - (double)ix;
        double py = y - (double)iy;
        double pz = z - (double)iz;
        double s = tx * ty * tz;
        result.x = PovNoise.INCRSUM(m, s, px, py, pz);
        result.y = PovNoise.INCRSUM(m + 4, s, px, py, pz);
        result.z = PovNoise.INCRSUM(m + 8, s, px, py, pz);
        m = this.Hash3d(jx, iy, iz) & 0xFF;
        px = x - (double)jx;
        s = sx * ty * tz;
        result.x += PovNoise.INCRSUM(m, s, px, py, pz);
        result.y += PovNoise.INCRSUM(m + 4, s, px, py, pz);
        result.z += PovNoise.INCRSUM(m + 8, s, px, py, pz);
        m = this.Hash3d(jx, jy, iz) & 0xFF;
        py = y - (double)jy;
        s = sx * sy * tz;
        result.x += PovNoise.INCRSUM(m, s, px, py, pz);
        result.y += PovNoise.INCRSUM(m + 4, s, px, py, pz);
        result.z += PovNoise.INCRSUM(m + 8, s, px, py, pz);
        m = this.Hash3d(ix, jy, iz) & 0xFF;
        px = x - (double)ix;
        s = tx * sy * tz;
        result.x += PovNoise.INCRSUM(m, s, px, py, pz);
        result.y += PovNoise.INCRSUM(m + 4, s, px, py, pz);
        result.z += PovNoise.INCRSUM(m + 8, s, px, py, pz);
        m = this.Hash3d(ix, jy, jz) & 0xFF;
        pz = z - (double)jz;
        s = tx * sy * sz;
        result.x += PovNoise.INCRSUM(m, s, px, py, pz);
        result.y += PovNoise.INCRSUM(m + 4, s, px, py, pz);
        result.z += PovNoise.INCRSUM(m + 8, s, px, py, pz);
        m = this.Hash3d(jx, jy, jz) & 0xFF;
        px = x - (double)jx;
        s = sx * sy * sz;
        result.x += PovNoise.INCRSUM(m, s, px, py, pz);
        result.y += PovNoise.INCRSUM(m + 4, s, px, py, pz);
        result.z += PovNoise.INCRSUM(m + 8, s, px, py, pz);
        m = this.Hash3d(jx, iy, jz) & 0xFF;
        py = y - (double)iy;
        s = sx * ty * sz;
        result.x += PovNoise.INCRSUM(m, s, px, py, pz);
        result.y += PovNoise.INCRSUM(m + 4, s, px, py, pz);
        result.z += PovNoise.INCRSUM(m + 8, s, px, py, pz);
        m = this.Hash3d(ix, iy, jz) & 0xFF;
        px = x - (double)ix;
        s = tx * ty * sz;
        result.x += PovNoise.INCRSUM(m, s, px, py, pz);
        result.y += PovNoise.INCRSUM(m + 4, s, px, py, pz);
        result.z += PovNoise.INCRSUM(m + 8, s, px, py, pz);
        return result;
    }

    public double getTurbulence(double x, double y, double z, int octaves) {
        double t = 0.0;
        int i = 0;
        double scale = 1.0;
        while (i < octaves) {
            double value = this.getNoise(x / scale, y / scale, z / scale);
            t += Math.abs(value) * scale;
            ++i;
            scale *= 0.5;
        }
        return t;
    }

    public Vector3d getDTurbulence(double x, double y, double z, int octaves) {
        Vector3d value = new Vector3d();
        Vector3d result = new Vector3d();
        result.x = 0.0;
        result.y = 0.0;
        result.z = 0.0;
        value.z = 0.0;
        value.y = 0.0;
        value.x = 0.0;
        int i = 0;
        double scale = 1.0;
        while (i < octaves) {
            value = this.getDNoise(x / scale, y / scale, z / scale);
            result.x += value.x * scale;
            result.y += value.y * scale;
            result.z += value.z * scale;
            ++i;
            scale *= 0.5;
        }
        return result;
    }

    public Vector3d getWaves(double x, double y, double z, double Frequency, double Bump_Amount, int numberOfWaves) {
        Vector3d point = new Vector3d();
        Vector3d normal = new Vector3d();
        normal.x = 0.0;
        normal.y = 0.0;
        normal.z = 0.0;
        if (numberOfWaves > 10) {
            numberOfWaves = 10;
        }
        int i = 0;
        while (i < numberOfWaves) {
            point.x = x;
            point.y = y;
            point.z = z;
            PovNoise.VSub(point, point, this.Wave_Sources[i]);
            double length = PovNoise.VDot(point, point);
            if (length <= 0.0) {
                length = 1.0;
            }
            length = Math.sqrt(length);
            double index = length * Frequency * this.frequency[i];
            double sinValue = PovNoise.cycloidal(index);
            double scalar = sinValue * Bump_Amount / this.frequency[i];
            PovNoise.VScale(point, point, scalar / length / (double)numberOfWaves);
            PovNoise.VAdd(normal, normal, point);
            ++i;
        }
        PovNoise.VNormalize(normal, normal);
        return normal;
    }

    private static double SCURVE(double a) {
        return a * a * (3.0 - 2.0 * a);
    }

    private int Hash3d(int a, int b, int c) {
        return this.hashTable[this.hashTable[this.hashTable[a & 0xFFF] ^ b & 0xFFF] ^ c & 0xFFF];
    }

    private static double INCRSUM(int m, double s, double x, double y, double z) {
        return s * (RTable[m] * 0.5 + RTable[m + 1] * x + RTable[m + 2] * y + RTable[m + 3] * z);
    }

    private static void VAdd(Vector3d a, Vector3d b, Vector3d c) {
        a.x = b.x + c.x;
        a.y = b.y + c.y;
        a.z = b.z + c.z;
    }

    private static void VSub(Vector3d a, Vector3d b, Vector3d c) {
        a.x = b.x - c.x;
        a.y = b.y - c.y;
        a.z = b.z - c.z;
    }

    private static void VNormalize(Vector3d a, Vector3d b) {
        double VTemp = Math.sqrt(b.x * b.x + b.y * b.y + b.z * b.z);
        a.x = b.x / VTemp;
        a.y = b.y / VTemp;
        a.z = b.z / VTemp;
    }

    private static void VScale(Vector3d a, Vector3d b, double k) {
        a.x = b.x * k;
        a.y = b.y * k;
        a.z = b.z * k;
    }

    private static double VDot(Vector3d b, Vector3d c) {
        return b.x * c.x + b.y * c.y + b.z * c.z;
    }
}

