/*
 * Decompiled with CFR 0.152.
 */
package kandid.util;

import junit.framework.TestCase;
import kandid.util.Base64;

public class Base64Test
extends TestCase {
    public void testEncodeString() {
        this.verifyEncode("", "");
        this.verifyEncode("IA==", " ");
        this.verifyEncode("ICA=", "  ");
        this.verifyEncode("DQo=", "\r\n");
        this.verifyEncode("PD4=", "<>");
        this.verifyEncode("PGFiYz4=", "<abc>");
        this.verifyEncode("PGFiYyBuYW1lPSJ4eXoiLyA+", "<abc name=\"xyz\"/ >");
        String text = "<abc name=\"xyz\">\r\n</abc>";
        String expected = "PGFiYyBuYW1lPSJ4eXoiPg0KPC9hYmM+";
        this.verifyEncode(expected, text);
    }

    private void verifyEncode(String expected, String text) {
        String pattern2 = Base64.encode(text);
        Base64Test.assertEquals((String)expected, (String)pattern2);
    }

    public void testDecodeString() {
        this.verifyBoth("");
        this.verifyBoth(" ");
        this.verifyBoth("\r\n");
        this.verifyBoth("<abc name=\"xyz\">");
        this.verifyBoth("<abc name=\"xyz\" />");
    }

    private void verifyBoth(String expected) {
        String base64data2 = Base64.encode(expected);
        String pattern2 = Base64.decode(base64data2);
        Base64Test.assertEquals((String)expected, (String)pattern2);
    }
}

