/*
 * Decompiled with CFR 0.152.
 */
package kandid.tree.user;

import java.awt.Color;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.tree.TreeCellEditor;
import kandid.tree.user.UserObject;
import kandid.util.Debug;

public abstract class AbstractUserObject
implements UserObject {
    protected Object value;
    protected JComponent renderer;
    protected TreeCellEditor editor;
    protected Color backgroundColor;
    protected Object dataModel;
    protected Method setterMethod;

    protected AbstractUserObject(JComponent renderer, TreeCellEditor editor, Object value, Object dataModel, Method dataSetter) {
        this.renderer = renderer;
        this.editor = editor;
        this.value = value;
        this.dataModel = dataModel;
        this.setterMethod = dataSetter;
        this.backgroundColor = null;
    }

    @Override
    public Object getRenderValue() {
        return this.value;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    protected void sendToModel(Object valueForModel) {
        if (this.dataModel != null && this.setterMethod != null) {
            try {
                Object[] param = new Object[]{valueForModel};
                this.setterMethod.invoke(this.dataModel, param);
            }
            catch (Exception exc) {
                Debug.stackTrace(exc);
            }
        }
    }
}

