/*
 * Decompiled with CFR 0.152.
 */
package kandid.soup.map;

import java.util.List;
import javax.xml.bind.JAXBException;
import kandid.calculation.lca.DirectLcaCalculation;
import kandid.calculation.lca.TotalLcaCalculation;
import kandid.soup.AbstractTutorialShapeGene;
import kandid.soup.AffineIfsChromosome;
import kandid.soup.AffineIfsSymmChromosome;
import kandid.soup.AffineTransformationGene;
import kandid.soup.AlphabetGene;
import kandid.soup.AxiomGene;
import kandid.soup.BooleanGene;
import kandid.soup.ChromosomeType;
import kandid.soup.ColorGene;
import kandid.soup.ColorMapEntryGene;
import kandid.soup.ContextGene;
import kandid.soup.DirectLcaChromosome;
import kandid.soup.DistanceFunctionBase;
import kandid.soup.DistanceFunctionGene;
import kandid.soup.DomainWarpingChladniNoiseChromosome;
import kandid.soup.DomainWarpingChladniWorleyNoiseChromosome;
import kandid.soup.DomainWarpingChladniWorleyPerlinNoiseChromosome;
import kandid.soup.DomainWarpingChromosome;
import kandid.soup.DoubleGene;
import kandid.soup.ExprScalarArgsListGene;
import kandid.soup.ExprScalarConstGene;
import kandid.soup.ExprScalarListGene;
import kandid.soup.ExprScalarOprBase;
import kandid.soup.ExprScalarOprGene;
import kandid.soup.ExprScalarVarBase;
import kandid.soup.ExprScalarVarGene;
import kandid.soup.ExprSdlArgsListGene;
import kandid.soup.ExprSdlConstGene;
import kandid.soup.ExprSdlListGene;
import kandid.soup.ExprSdlOprBase;
import kandid.soup.ExprSdlOprGene;
import kandid.soup.ExprSdlVarBase;
import kandid.soup.ExprSdlVarGene;
import kandid.soup.ExprVectorArgsListGene;
import kandid.soup.ExprVectorConstGene;
import kandid.soup.ExprVectorListGene;
import kandid.soup.ExprVectorOprBase;
import kandid.soup.ExprVectorOprGene;
import kandid.soup.ExprVectorVarBase;
import kandid.soup.ExprVectorVarGene;
import kandid.soup.FlameIfsChromosome;
import kandid.soup.FlameTransformationGene;
import kandid.soup.FractionalGene;
import kandid.soup.GeneType;
import kandid.soup.GradientChromosome;
import kandid.soup.GradientSegmentGene;
import kandid.soup.HsbColorGene;
import kandid.soup.HsbFrequenceChromosome;
import kandid.soup.HsbftGene;
import kandid.soup.IgnoreGene;
import kandid.soup.IntegerGene;
import kandid.soup.KingGene;
import kandid.soup.LcaChromosome;
import kandid.soup.LcaInitialStateBase;
import kandid.soup.LcaInitialStateGene;
import kandid.soup.LcaStateGene;
import kandid.soup.LookUpColorGene;
import kandid.soup.LookUpTableChromosome;
import kandid.soup.Lsys0LChromosome;
import kandid.soup.LsysChromosome;
import kandid.soup.LsysD0LChromosome;
import kandid.soup.LsysILChromosome;
import kandid.soup.LsysProductionGene;
import kandid.soup.Matrix4X3Gene;
import kandid.soup.NormalMapEntryGene;
import kandid.soup.NormalizedGene;
import kandid.soup.NormalizedVector3Gene;
import kandid.soup.ObjectFactory;
import kandid.soup.PovBlackHoleWarpGene;
import kandid.soup.PovBlendGene;
import kandid.soup.PovBlendMapModifierBase;
import kandid.soup.PovColorMapGene;
import kandid.soup.PovFinishGene;
import kandid.soup.PovIsoSurfaceChromosome;
import kandid.soup.PovMapPatternBase;
import kandid.soup.PovNormalGene;
import kandid.soup.PovNormalMapGene;
import kandid.soup.PovPigmentGene;
import kandid.soup.PovReflectionGene;
import kandid.soup.PovRidgedMultifractalGene;
import kandid.soup.PovRotateGene;
import kandid.soup.PovTextureLayerGene;
import kandid.soup.PovThingChromosome;
import kandid.soup.PovThingGene;
import kandid.soup.PovThingNFChromosome;
import kandid.soup.PovTransformMapGene;
import kandid.soup.PovTurbulenceWarpGene;
import kandid.soup.PovWarpGene;
import kandid.soup.PredecessorGene;
import kandid.soup.RandomWalkPointGene;
import kandid.soup.ScalarExprGene;
import kandid.soup.ScalarExpressionChromosome;
import kandid.soup.SdlExpressionGene;
import kandid.soup.SeedGene;
import kandid.soup.SuccessorGene;
import kandid.soup.SymmetricGene;
import kandid.soup.SymmetricIfsChromosome;
import kandid.soup.TotalLcaChromosome;
import kandid.soup.TransparentLookUpTableChromosome;
import kandid.soup.TutorialCircleGene;
import kandid.soup.TutorialShapeChromosome;
import kandid.soup.VectorExprGene;
import kandid.soup.VectorExpressionChromosome;
import kandid.soup.VoronoiChromosome;
import kandid.soup.VoronoiChromosomeBase;
import kandid.soup.VoronoiTransparentChromosome;
import kandid.soup.WarpingLayerGene;
import kandid.soup.WarpingTurbulenceGene;
import kandid.soup.genetic.lsys.LsysGenetic;
import kandid.util.CentralRandomizer;

public class RandomizeChromosome {
    private static ObjectFactory objectFactory = new ObjectFactory();

    protected void randomize(BooleanGene aGene, ChromosomeType aChromosome, double probability, int depth) throws JAXBException {
        aGene.setValue(CentralRandomizer.getBoolean(probability));
    }

    protected void randomize(IntegerGene aGene, int minInclusive, int maxInclusive, ChromosomeType aChromosome, boolean binomialRamdomizer, double binomialProbability, int depth) throws JAXBException {
        if (binomialRamdomizer) {
            aGene.setValue(minInclusive + CentralRandomizer.getBinomial(maxInclusive - minInclusive, binomialProbability));
        } else {
            aGene.setValue(CentralRandomizer.getInt(minInclusive, maxInclusive));
        }
    }

    protected void randomize(SeedGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        aGene.setValue(CentralRandomizer.getLong());
    }

    protected void randomize(DoubleGene aGene, double minInclusive, double maxInclusive, ChromosomeType aChromosome, boolean binomialRamdomizer, double binomialProbability, int depth) throws JAXBException {
        aGene.setValue(CentralRandomizer.getDouble(minInclusive, maxInclusive));
    }

    protected void randomize(NormalizedGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        aGene.setValue(CentralRandomizer.getDouble(0.0, 1.0));
    }

    protected void randomize(FractionalGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        aGene.setValue(CentralRandomizer.getDouble(0.0, 1.0));
    }

    protected void randomize(SymmetricGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        aGene.setValue(CentralRandomizer.getDouble(-1.0, 1.0));
    }

    protected void randomize(RandomWalkPointGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        aGene.setX(CentralRandomizer.getDouble(0.0, 1.0));
        aGene.setY(CentralRandomizer.getDouble(0.0, 1.0));
    }

    protected void randomize(ColorGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        aGene.setRed(Float.valueOf(CentralRandomizer.getFloat(0.0f, 1.0f)));
        aGene.setGreen(Float.valueOf(CentralRandomizer.getFloat(0.0f, 1.0f)));
        aGene.setBlue(Float.valueOf(CentralRandomizer.getFloat(0.0f, 1.0f)));
    }

    protected void randomize(HsbColorGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        aGene.setHue(CentralRandomizer.getDouble(0.0, 1.0));
        aGene.setSaturation(CentralRandomizer.getDouble(0.0, 1.0));
        aGene.setBrightness(CentralRandomizer.getDouble(0.0, 1.0));
    }

    protected void randomize(AffineTransformationGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        SymmetricGene aTa = objectFactory.createSymmetricGene();
        this.randomize(aTa, aChromosome, depth + 1);
        aGene.setTa(aTa);
        SymmetricGene aTb = objectFactory.createSymmetricGene();
        this.randomize(aTb, aChromosome, depth + 1);
        aGene.setTb(aTb);
        SymmetricGene aTc = objectFactory.createSymmetricGene();
        this.randomize(aTc, aChromosome, depth + 1);
        aGene.setTc(aTc);
        SymmetricGene aTd = objectFactory.createSymmetricGene();
        this.randomize(aTd, aChromosome, depth + 1);
        aGene.setTd(aTd);
        SymmetricGene aTe = objectFactory.createSymmetricGene();
        this.randomize(aTe, aChromosome, depth + 1);
        aGene.setTe(aTe);
        SymmetricGene aTf = objectFactory.createSymmetricGene();
        this.randomize(aTf, aChromosome, depth + 1);
        aGene.setTf(aTf);
    }

    protected void randomize(LookUpColorGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        FractionalGene aHue = objectFactory.createFractionalGene();
        this.randomize(aHue, aChromosome, depth + 1);
        aGene.setHue(aHue);
        NormalizedGene aSaturation = objectFactory.createNormalizedGene();
        this.randomize(aSaturation, aChromosome, depth + 1);
        aGene.setSaturation(aSaturation);
        NormalizedGene aBrightness = objectFactory.createNormalizedGene();
        this.randomize(aBrightness, aChromosome, depth + 1);
        aGene.setBrightness(aBrightness);
    }

    public void randomize(TransparentLookUpTableChromosome aChromosome) throws JAXBException {
        List<LookUpColorGene> list = aChromosome.getLutColor();
        list.clear();
        int newLength = CentralRandomizer.getInt(2, 32);
        while (newLength > 0) {
            LookUpColorGene aLutColor = objectFactory.createLookUpColorGene();
            this.randomize(aLutColor, (ChromosomeType)aChromosome, 1);
            list.add(aLutColor);
            --newLength;
        }
    }

    public void randomize(LookUpTableChromosome aChromosome) throws JAXBException {
        List<LookUpColorGene> list = aChromosome.getLutColor();
        list.clear();
        int newLength = CentralRandomizer.getInt(2, 32);
        while (newLength > 0) {
            LookUpColorGene aLutColor = objectFactory.createLookUpColorGene();
            this.randomize(aLutColor, (ChromosomeType)aChromosome, 1);
            list.add(aLutColor);
            --newLength;
        }
    }

    protected void randomize(GradientSegmentGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        FractionalGene aHue = objectFactory.createFractionalGene();
        this.randomize(aHue, aChromosome, depth + 1);
        aGene.setHue(aHue);
        NormalizedGene aSaturation = objectFactory.createNormalizedGene();
        this.randomize(aSaturation, aChromosome, depth + 1);
        aGene.setSaturation(aSaturation);
        NormalizedGene aBrightness = objectFactory.createNormalizedGene();
        this.randomize(aBrightness, aChromosome, depth + 1);
        aGene.setBrightness(aBrightness);
        NormalizedGene aWeight = objectFactory.createNormalizedGene();
        this.randomize(aWeight, aChromosome, depth + 1);
        aGene.setWeight(aWeight);
    }

    public void randomize(GradientChromosome aChromosome) throws JAXBException {
        List<GradientSegmentGene> list = aChromosome.getGradientSegment();
        list.clear();
        int newLength = CentralRandomizer.getInt(2, 10);
        while (newLength > 0) {
            GradientSegmentGene aGradientSegment = objectFactory.createGradientSegmentGene();
            this.randomize(aGradientSegment, (ChromosomeType)aChromosome, 1);
            list.add(aGradientSegment);
            --newLength;
        }
    }

    public void randomize(HsbFrequenceChromosome aChromosome) throws JAXBException {
        DoubleGene aFrequence = objectFactory.createDoubleGene();
        this.randomize(aFrequence, 0.02, 2.0, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setFrequence(aFrequence);
        SymmetricGene aPhaseshift = objectFactory.createSymmetricGene();
        this.randomize(aPhaseshift, (ChromosomeType)aChromosome, 1);
        aChromosome.setPhaseshift(aPhaseshift);
    }

    protected void randomize(DistanceFunctionGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        String[] enumNames = new String[]{"abs(dx,dy)", "abs(dx)", "abs(dy)", "dx", "dy", "euclide(dx,dy)", "product(dx,dy)", "quotient(dx,dy)"};
        aGene.setDistanceFunction(DistanceFunctionBase.fromValue(new String(enumNames[CentralRandomizer.getInt(enumNames.length - 1)])));
        SymmetricGene aWeight = objectFactory.createSymmetricGene();
        this.randomize(aWeight, aChromosome, depth + 1);
        aGene.setWeight(aWeight);
    }

    protected void randomize(KingGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        RandomWalkPointGene aPoint = objectFactory.createRandomWalkPointGene();
        this.randomize(aPoint, aChromosome, depth + 1);
        aGene.setPoint(aPoint);
        ColorGene aColor = objectFactory.createColorGene();
        this.randomize(aColor, aChromosome, depth + 1);
        aGene.setColor(aColor);
        NormalizedGene aWeight = objectFactory.createNormalizedGene();
        this.randomize(aWeight, aChromosome, depth + 1);
        aGene.setWeight(aWeight);
    }

    public void randomize(VoronoiChromosomeBase aChromosome) throws JAXBException {
        List<GeneType> list = aChromosome.getDistance();
        list.clear();
        int newLength = CentralRandomizer.getInt(1, 8);
        while (newLength > 0) {
            DistanceFunctionGene aDistance = objectFactory.createDistanceFunctionGene();
            this.randomize(aDistance, (ChromosomeType)aChromosome, 1);
            list.add(aDistance);
            --newLength;
        }
        list = aChromosome.getKing();
        list.clear();
        newLength = CentralRandomizer.getInt(2, 50);
        while (newLength > 0) {
            KingGene aKing = objectFactory.createKingGene();
            this.randomize(aKing, (ChromosomeType)aChromosome, 1);
            list.add(aKing);
            --newLength;
        }
    }

    public void randomize(VoronoiChromosome aChromosome) throws JAXBException {
        this.randomize((VoronoiChromosomeBase)aChromosome);
        SymmetricGene aYard = objectFactory.createSymmetricGene();
        this.randomize(aYard, (ChromosomeType)aChromosome, 1);
        aChromosome.setYard(aYard);
    }

    public void randomize(VoronoiTransparentChromosome aChromosome) throws JAXBException {
        this.randomize((VoronoiChromosomeBase)aChromosome);
        IntegerGene aPrioritySize = objectFactory.createIntegerGene();
        this.randomize(aPrioritySize, 2, 10, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setPrioritySize(aPrioritySize);
        DoubleGene aPriorityWeight = objectFactory.createDoubleGene();
        this.randomize(aPriorityWeight, 0.5, 2.0, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setPriorityWeight(aPriorityWeight);
    }

    public void randomize(AffineIfsChromosome aChromosome) throws JAXBException {
        SeedGene aSeed = objectFactory.createSeedGene();
        this.randomize(aSeed, (ChromosomeType)aChromosome, 1);
        aChromosome.setSeed(aSeed);
        List<AffineTransformationGene> list = aChromosome.getAffineTransformation();
        list.clear();
        int newLength = CentralRandomizer.getInt(2, 8);
        while (newLength > 0) {
            AffineTransformationGene aAffineTransformation = objectFactory.createAffineTransformationGene();
            this.randomize(aAffineTransformation, (ChromosomeType)aChromosome, 1);
            list.add(aAffineTransformation);
            --newLength;
        }
    }

    public void randomize(AffineIfsSymmChromosome aChromosome) throws JAXBException {
        this.randomize((AffineIfsChromosome)aChromosome);
        IntegerGene aSymmetry = objectFactory.createIntegerGene();
        this.randomize(aSymmetry, 1, 25, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setSymmetry(aSymmetry);
        BooleanGene aDn = objectFactory.createBooleanGene();
        this.randomize(aDn, aChromosome, 0.5, 1);
        aChromosome.setDn(aDn);
    }

    public void randomize(SymmetricIfsChromosome aChromosome) throws JAXBException {
        IntegerGene aSymmetry = objectFactory.createIntegerGene();
        this.randomize(aSymmetry, 3, 11, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setSymmetry(aSymmetry);
        DoubleGene aLambda = objectFactory.createDoubleGene();
        this.randomize(aLambda, -2.5, 2.5, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setLambda(aLambda);
        DoubleGene aAlpha = objectFactory.createDoubleGene();
        this.randomize(aAlpha, -2.5, 10.0, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setAlpha(aAlpha);
        DoubleGene aBeta = objectFactory.createDoubleGene();
        this.randomize(aBeta, -20.0, 0.2, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setBeta(aBeta);
        DoubleGene aGamma = objectFactory.createDoubleGene();
        this.randomize(aGamma, -1.0, 1.0, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setGamma(aGamma);
        DoubleGene aOmega = objectFactory.createDoubleGene();
        this.randomize(aOmega, -1.0, 1.0, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setOmega(aOmega);
    }

    protected void randomize(FlameTransformationGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        this.randomize((AffineTransformationGene)aGene, aChromosome, depth);
        NormalizedGene aWeight = objectFactory.createNormalizedGene();
        this.randomize(aWeight, aChromosome, depth + 1);
        aGene.setWeight(aWeight);
        NormalizedGene aColorindex = objectFactory.createNormalizedGene();
        this.randomize(aColorindex, aChromosome, depth + 1);
        aGene.setColorindex(aColorindex);
        BooleanGene aLinearEnabled = objectFactory.createBooleanGene();
        this.randomize(aLinearEnabled, aChromosome, 0.1, depth + 1);
        aGene.setLinearEnabled(aLinearEnabled);
        NormalizedGene aLinearVariation = objectFactory.createNormalizedGene();
        this.randomize(aLinearVariation, aChromosome, depth + 1);
        aGene.setLinearVariation(aLinearVariation);
        BooleanGene aSinusoidalEnabled = objectFactory.createBooleanGene();
        this.randomize(aSinusoidalEnabled, aChromosome, 0.1, depth + 1);
        aGene.setSinusoidalEnabled(aSinusoidalEnabled);
        NormalizedGene aSinusoidalVariation = objectFactory.createNormalizedGene();
        this.randomize(aSinusoidalVariation, aChromosome, depth + 1);
        aGene.setSinusoidalVariation(aSinusoidalVariation);
        BooleanGene aSphericalEnabled = objectFactory.createBooleanGene();
        this.randomize(aSphericalEnabled, aChromosome, 0.1, depth + 1);
        aGene.setSphericalEnabled(aSphericalEnabled);
        NormalizedGene aSphericalVariation = objectFactory.createNormalizedGene();
        this.randomize(aSphericalVariation, aChromosome, depth + 1);
        aGene.setSphericalVariation(aSphericalVariation);
        BooleanGene aSwirlEnabled = objectFactory.createBooleanGene();
        this.randomize(aSwirlEnabled, aChromosome, 0.1, depth + 1);
        aGene.setSwirlEnabled(aSwirlEnabled);
        NormalizedGene aSwirlVariation = objectFactory.createNormalizedGene();
        this.randomize(aSwirlVariation, aChromosome, depth + 1);
        aGene.setSwirlVariation(aSwirlVariation);
        BooleanGene aHorseshoeEnabled = objectFactory.createBooleanGene();
        this.randomize(aHorseshoeEnabled, aChromosome, 0.1, depth + 1);
        aGene.setHorseshoeEnabled(aHorseshoeEnabled);
        NormalizedGene aHorseshoeVariation = objectFactory.createNormalizedGene();
        this.randomize(aHorseshoeVariation, aChromosome, depth + 1);
        aGene.setHorseshoeVariation(aHorseshoeVariation);
        BooleanGene aPolarEnabled = objectFactory.createBooleanGene();
        this.randomize(aPolarEnabled, aChromosome, 0.1, depth + 1);
        aGene.setPolarEnabled(aPolarEnabled);
        NormalizedGene aPolarVariation = objectFactory.createNormalizedGene();
        this.randomize(aPolarVariation, aChromosome, depth + 1);
        aGene.setPolarVariation(aPolarVariation);
        BooleanGene aFoldedHandkerchiefEnabled = objectFactory.createBooleanGene();
        this.randomize(aFoldedHandkerchiefEnabled, aChromosome, 0.1, depth + 1);
        aGene.setFoldedHandkerchiefEnabled(aFoldedHandkerchiefEnabled);
        NormalizedGene aFoldedHandkerchiefVariation = objectFactory.createNormalizedGene();
        this.randomize(aFoldedHandkerchiefVariation, aChromosome, depth + 1);
        aGene.setFoldedHandkerchiefVariation(aFoldedHandkerchiefVariation);
        BooleanGene aHeartEnabled = objectFactory.createBooleanGene();
        this.randomize(aHeartEnabled, aChromosome, 0.1, depth + 1);
        aGene.setHeartEnabled(aHeartEnabled);
        NormalizedGene aHeartVariation = objectFactory.createNormalizedGene();
        this.randomize(aHeartVariation, aChromosome, depth + 1);
        aGene.setHeartVariation(aHeartVariation);
        BooleanGene aDiscEnabled = objectFactory.createBooleanGene();
        this.randomize(aDiscEnabled, aChromosome, 0.1, depth + 1);
        aGene.setDiscEnabled(aDiscEnabled);
        NormalizedGene aDiscVariation = objectFactory.createNormalizedGene();
        this.randomize(aDiscVariation, aChromosome, depth + 1);
        aGene.setDiscVariation(aDiscVariation);
        BooleanGene aSpiralEnabled = objectFactory.createBooleanGene();
        this.randomize(aSpiralEnabled, aChromosome, 0.1, depth + 1);
        aGene.setSpiralEnabled(aSpiralEnabled);
        NormalizedGene aSpiralVariation = objectFactory.createNormalizedGene();
        this.randomize(aSpiralVariation, aChromosome, depth + 1);
        aGene.setSpiralVariation(aSpiralVariation);
        BooleanGene aHyperbolicEnabled = objectFactory.createBooleanGene();
        this.randomize(aHyperbolicEnabled, aChromosome, 0.1, depth + 1);
        aGene.setHyperbolicEnabled(aHyperbolicEnabled);
        NormalizedGene aHyperbolicVariation = objectFactory.createNormalizedGene();
        this.randomize(aHyperbolicVariation, aChromosome, depth + 1);
        aGene.setHyperbolicVariation(aHyperbolicVariation);
        BooleanGene aDiamondEnabled = objectFactory.createBooleanGene();
        this.randomize(aDiamondEnabled, aChromosome, 0.1, depth + 1);
        aGene.setDiamondEnabled(aDiamondEnabled);
        NormalizedGene aDiamondVariation = objectFactory.createNormalizedGene();
        this.randomize(aDiamondVariation, aChromosome, depth + 1);
        aGene.setDiamondVariation(aDiamondVariation);
        BooleanGene aExEnabled = objectFactory.createBooleanGene();
        this.randomize(aExEnabled, aChromosome, 0.1, depth + 1);
        aGene.setExEnabled(aExEnabled);
        NormalizedGene aExVariation = objectFactory.createNormalizedGene();
        this.randomize(aExVariation, aChromosome, depth + 1);
        aGene.setExVariation(aExVariation);
        BooleanGene aJuliaEnabled = objectFactory.createBooleanGene();
        this.randomize(aJuliaEnabled, aChromosome, 0.1, depth + 1);
        aGene.setJuliaEnabled(aJuliaEnabled);
        NormalizedGene aJuliaVariation = objectFactory.createNormalizedGene();
        this.randomize(aJuliaVariation, aChromosome, depth + 1);
        aGene.setJuliaVariation(aJuliaVariation);
        BooleanGene aBentEnabled = objectFactory.createBooleanGene();
        this.randomize(aBentEnabled, aChromosome, 0.1, depth + 1);
        aGene.setBentEnabled(aBentEnabled);
        NormalizedGene aBentVariation = objectFactory.createNormalizedGene();
        this.randomize(aBentVariation, aChromosome, depth + 1);
        aGene.setBentVariation(aBentVariation);
        BooleanGene aFisheyeEnabled = objectFactory.createBooleanGene();
        this.randomize(aFisheyeEnabled, aChromosome, 0.1, depth + 1);
        aGene.setFisheyeEnabled(aFisheyeEnabled);
        NormalizedGene aFisheyeVariation = objectFactory.createNormalizedGene();
        this.randomize(aFisheyeVariation, aChromosome, depth + 1);
        aGene.setFisheyeVariation(aFisheyeVariation);
        BooleanGene aPopcornEnabled = objectFactory.createBooleanGene();
        this.randomize(aPopcornEnabled, aChromosome, 0.1, depth + 1);
        aGene.setPopcornEnabled(aPopcornEnabled);
        NormalizedGene aPopcornVariation = objectFactory.createNormalizedGene();
        this.randomize(aPopcornVariation, aChromosome, depth + 1);
        aGene.setPopcornVariation(aPopcornVariation);
    }

    public void randomize(FlameIfsChromosome aChromosome) throws JAXBException {
        List<FlameTransformationGene> list = aChromosome.getFlameTransformation();
        list.clear();
        int newLength = CentralRandomizer.getInt(2, 8);
        while (newLength > 0) {
            FlameTransformationGene aFlameTransformation = objectFactory.createFlameTransformationGene();
            this.randomize(aFlameTransformation, (ChromosomeType)aChromosome, 1);
            list.add(aFlameTransformation);
            --newLength;
        }
        IntegerGene aPalette = objectFactory.createIntegerGene();
        this.randomize(aPalette, 0, 89, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setPalette(aPalette);
        DoubleGene aHue = objectFactory.createDoubleGene();
        this.randomize(aHue, -0.5, 0.5, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setHue(aHue);
        DoubleGene aBrightness = objectFactory.createDoubleGene();
        this.randomize(aBrightness, 0.0, 5.0, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setBrightness(aBrightness);
        DoubleGene aGamma = objectFactory.createDoubleGene();
        this.randomize(aGamma, 1.0, 5.0, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setGamma(aGamma);
        DoubleGene aVibrancy = objectFactory.createDoubleGene();
        this.randomize(aVibrancy, 0.0, 1.0, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setVibrancy(aVibrancy);
        DoubleGene aZoom = objectFactory.createDoubleGene();
        this.randomize(aZoom, -4.0, 4.0, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setZoom(aZoom);
        DoubleGene aFilter = objectFactory.createDoubleGene();
        this.randomize(aFilter, 0.0, 4.0, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setFilter(aFilter);
    }

    protected void randomize(LcaInitialStateGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        String[] enumNames = new String[]{"uniform random", "random ramp", "single point", "two points", "three points", "two points with single gap"};
        aGene.setFillMode(LcaInitialStateBase.fromValue(new String(enumNames[CentralRandomizer.getInt(enumNames.length - 1)])));
        SeedGene aStateSeed = objectFactory.createSeedGene();
        this.randomize(aStateSeed, aChromosome, depth + 1);
        aGene.setStateSeed(aStateSeed);
    }

    protected void randomize(LcaStateGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int maxStates = 0;
        if (aChromosome instanceof DirectLcaChromosome) {
            maxStates = ((DirectLcaChromosome)aChromosome).getMaxStates().getValue();
        } else if (aChromosome instanceof TotalLcaChromosome) {
            maxStates = ((TotalLcaChromosome)aChromosome).getMaxStates().getValue();
        }
        aGene.setValue(CentralRandomizer.getInt(0, maxStates - 1));
    }

    public void randomize(LcaChromosome aChromosome) throws JAXBException {
        LcaInitialStateGene aLcaInitialState = objectFactory.createLcaInitialStateGene();
        this.randomize(aLcaInitialState, (ChromosomeType)aChromosome, 1);
        aChromosome.setLcaInitialState(aLcaInitialState);
        IntegerGene aWidth = objectFactory.createIntegerGene();
        this.randomize(aWidth, 16, 512, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setWidth(aWidth);
    }

    public void randomize(TotalLcaChromosome aChromosome) throws JAXBException {
        this.randomize((LcaChromosome)aChromosome);
        IntegerGene aMaxStates = objectFactory.createIntegerGene();
        this.randomize(aMaxStates, 2, 30, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setMaxStates(aMaxStates);
        IntegerGene aLeftNeighbors = objectFactory.createIntegerGene();
        this.randomize(aLeftNeighbors, 0, 9, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setLeftNeighbors(aLeftNeighbors);
        IntegerGene aRightNeighbors = objectFactory.createIntegerGene();
        this.randomize(aRightNeighbors, 0, 9, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setRightNeighbors(aRightNeighbors);
        List<GeneType> list = aChromosome.getColor();
        list.clear();
        int newLength = aChromosome.getMaxStates().getValue();
        while (newLength > 0) {
            ColorGene aColor = objectFactory.createColorGene();
            this.randomize(aColor, (ChromosomeType)aChromosome, 1);
            list.add(aColor);
            --newLength;
        }
        list = aChromosome.getRule();
        list.clear();
        newLength = TotalLcaCalculation.numberofRules(aChromosome.getMaxStates().getValue(), aChromosome.getLeftNeighbors().getValue(), aChromosome.getRightNeighbors().getValue());
        while (newLength > 0) {
            LcaStateGene aRule = objectFactory.createLcaStateGene();
            this.randomize(aRule, (ChromosomeType)aChromosome, 1);
            list.add(aRule);
            --newLength;
        }
    }

    public void randomize(DirectLcaChromosome aChromosome) throws JAXBException {
        this.randomize((LcaChromosome)aChromosome);
        IntegerGene aMaxStates = objectFactory.createIntegerGene();
        this.randomize(aMaxStates, 2, 6, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setMaxStates(aMaxStates);
        IntegerGene aLeftNeighbors = objectFactory.createIntegerGene();
        this.randomize(aLeftNeighbors, 0, 2, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setLeftNeighbors(aLeftNeighbors);
        IntegerGene aRightNeighbors = objectFactory.createIntegerGene();
        this.randomize(aRightNeighbors, 0, 2, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setRightNeighbors(aRightNeighbors);
        List<GeneType> list = aChromosome.getColor();
        list.clear();
        int newLength = aChromosome.getMaxStates().getValue();
        while (newLength > 0) {
            ColorGene aColor = objectFactory.createColorGene();
            this.randomize(aColor, (ChromosomeType)aChromosome, 1);
            list.add(aColor);
            --newLength;
        }
        list = aChromosome.getRule();
        list.clear();
        newLength = DirectLcaCalculation.numberofRules(aChromosome.getMaxStates().getValue(), aChromosome.getLeftNeighbors().getValue(), aChromosome.getRightNeighbors().getValue());
        while (newLength > 0) {
            LcaStateGene aRule = objectFactory.createLcaStateGene();
            this.randomize(aRule, (ChromosomeType)aChromosome, 1);
            list.add(aRule);
            --newLength;
        }
    }

    protected void randomize(ExprScalarOprGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        String[] enumNames = new String[]{"ifPositive", "add", "mult", "sub", "div", "noise", "turbulence", "snoise", "sturbulence", "pow", "sqrt", "tan", "sin", "cos", "atanq", "atan", "log", "mix", "mixx", "step", "puls", "clamp", "max", "min", "abs", "smoothstep", "boxstep", "mod", "floor", "ceil", "gamma", "gain", "bias", "euclide", "absolute"};
        aGene.setScalarOpr(ExprScalarOprBase.fromValue(new String(enumNames[CentralRandomizer.getInt(enumNames.length - 1)])));
    }

    protected void randomize(ExprScalarVarGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        String[] enumNames = new String[]{"x", "xi", "y", "yi", "r", "ri", "t", "ti", "xp2", "yp2", "xp3", "yp3", "xcos", "ycos", "xsinh", "ysinh"};
        aGene.setScalarVar(ExprScalarVarBase.fromValue(new String(enumNames[CentralRandomizer.getInt(enumNames.length - 1)])));
    }

    protected void randomize(ExprScalarConstGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        DoubleGene aScalarConst = objectFactory.createDoubleGene();
        this.randomize(aScalarConst, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setScalarConst(aScalarConst);
    }

    protected void randomize(ExprScalarArgsListGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        List<GeneType> list = aGene.getVarOrConstOrScalarExpression();
        list.clear();
        int len = CentralRandomizer.getInt(2, 5);
        while (len > 0) {
            switch (CentralRandomizer.getInt(1, 3)) {
                case 1: {
                    ExprScalarVarGene aNewVar = objectFactory.createExprScalarVarGene();
                    this.randomize(aNewVar, aChromosome, depth + 1);
                    list.add(aNewVar);
                    --len;
                    break;
                }
                case 2: {
                    ExprScalarConstGene aNewConst = objectFactory.createExprScalarConstGene();
                    this.randomize(aNewConst, aChromosome, depth + 1);
                    list.add(aNewConst);
                    --len;
                    break;
                }
                case 3: {
                    if (!(CentralRandomizer.getDouble(0.0, 0.15) < 1.0 / (double)depth)) break;
                    ScalarExprGene aNewScalarExpression = objectFactory.createScalarExprGene();
                    this.randomize(aNewScalarExpression, aChromosome, depth + 1);
                    list.add(aNewScalarExpression);
                    --len;
                }
            }
        }
    }

    protected void randomize(ExprScalarListGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        ExprScalarOprGene aOpr = objectFactory.createExprScalarOprGene();
        this.randomize(aOpr, aChromosome, depth + 1);
        aGene.setOpr(aOpr);
        ExprScalarArgsListGene aArgs = objectFactory.createExprScalarArgsListGene();
        this.randomize(aArgs, aChromosome, depth + 1);
        aGene.setArgs(aArgs);
    }

    protected void randomize(ScalarExprGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        ExprScalarListGene aList = objectFactory.createExprScalarListGene();
        this.randomize(aList, aChromosome, depth + 1);
        aGene.setList(aList);
    }

    public void randomize(ScalarExpressionChromosome aChromosome) throws JAXBException {
        ScalarExprGene aScalarExpression = objectFactory.createScalarExprGene();
        this.randomize(aScalarExpression, (ChromosomeType)aChromosome, 1);
        aChromosome.setScalarExpression(aScalarExpression);
        SeedGene aNoiseSeed = objectFactory.createSeedGene();
        this.randomize(aNoiseSeed, (ChromosomeType)aChromosome, 1);
        aChromosome.setNoiseSeed(aNoiseSeed);
        SymmetricGene aXScale = objectFactory.createSymmetricGene();
        this.randomize(aXScale, (ChromosomeType)aChromosome, 1);
        aChromosome.setXScale(aXScale);
        SymmetricGene aYScale = objectFactory.createSymmetricGene();
        this.randomize(aYScale, (ChromosomeType)aChromosome, 1);
        aChromosome.setYScale(aYScale);
    }

    protected void randomize(ExprVectorOprGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        String[] enumNames = new String[]{"add", "sub", "mult", "mod", "cross", "sincos", "atan", "maxvalue", "minvalue", "maxvector", "minvector", "maxmix", "invmix", "step", "noise", "turbulence", "waves"};
        aGene.setVectorOpr(ExprVectorOprBase.fromValue(new String(enumNames[CentralRandomizer.getInt(enumNames.length - 1)])));
    }

    protected void randomize(ExprVectorVarGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        String[] enumNames = new String[]{"xyr", "xym", "xyt", "cmpow", "cmsinh", "cmim", "cmre"};
        aGene.setVectorVar(ExprVectorVarBase.fromValue(new String(enumNames[CentralRandomizer.getInt(enumNames.length - 1)])));
    }

    protected void randomize(ExprVectorConstGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        DoubleGene aCx = objectFactory.createDoubleGene();
        this.randomize(aCx, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setCx(aCx);
        DoubleGene aCy = objectFactory.createDoubleGene();
        this.randomize(aCy, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setCy(aCy);
        DoubleGene aCz = objectFactory.createDoubleGene();
        this.randomize(aCz, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setCz(aCz);
    }

    protected void randomize(ExprVectorArgsListGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        List<GeneType> list = aGene.getVarOrConstOrVectorExpression();
        list.clear();
        int len = CentralRandomizer.getInt(2, 2);
        while (len > 0) {
            switch (CentralRandomizer.getInt(1, 3)) {
                case 1: {
                    ExprVectorVarGene aNewVar = objectFactory.createExprVectorVarGene();
                    this.randomize(aNewVar, aChromosome, depth + 1);
                    list.add(aNewVar);
                    --len;
                    break;
                }
                case 2: {
                    ExprVectorConstGene aNewConst = objectFactory.createExprVectorConstGene();
                    this.randomize(aNewConst, aChromosome, depth + 1);
                    list.add(aNewConst);
                    --len;
                    break;
                }
                case 3: {
                    if (!(CentralRandomizer.getDouble(0.0, 0.15) < 1.0 / (double)depth)) break;
                    VectorExprGene aNewVectorExpression = objectFactory.createVectorExprGene();
                    this.randomize(aNewVectorExpression, aChromosome, depth + 1);
                    list.add(aNewVectorExpression);
                    --len;
                }
            }
        }
    }

    protected void randomize(ExprVectorListGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        ExprVectorOprGene aOpr = objectFactory.createExprVectorOprGene();
        this.randomize(aOpr, aChromosome, depth + 1);
        aGene.setOpr(aOpr);
        ExprVectorArgsListGene aArgs = objectFactory.createExprVectorArgsListGene();
        this.randomize(aArgs, aChromosome, depth + 1);
        aGene.setArgs(aArgs);
    }

    protected void randomize(VectorExprGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        ExprVectorListGene aList = objectFactory.createExprVectorListGene();
        this.randomize(aList, aChromosome, depth + 1);
        aGene.setList(aList);
    }

    public void randomize(VectorExpressionChromosome aChromosome) throws JAXBException {
        VectorExprGene aVectorExpression = objectFactory.createVectorExprGene();
        this.randomize(aVectorExpression, (ChromosomeType)aChromosome, 1);
        aChromosome.setVectorExpression(aVectorExpression);
        SeedGene aNoiseSeed = objectFactory.createSeedGene();
        this.randomize(aNoiseSeed, (ChromosomeType)aChromosome, 1);
        aChromosome.setNoiseSeed(aNoiseSeed);
        SymmetricGene aXScale = objectFactory.createSymmetricGene();
        this.randomize(aXScale, (ChromosomeType)aChromosome, 1);
        aChromosome.setXScale(aXScale);
        SymmetricGene aYScale = objectFactory.createSymmetricGene();
        this.randomize(aYScale, (ChromosomeType)aChromosome, 1);
        aChromosome.setYScale(aYScale);
    }

    protected void randomize(AlphabetGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        aGene.setValue(LsysGenetic.randomizeAlphabet((LsysChromosome)aChromosome));
    }

    protected void randomize(AxiomGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        aGene.setValue(LsysGenetic.randomizeAxiom((LsysChromosome)aChromosome));
    }

    protected void randomize(IgnoreGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        aGene.setValue(LsysGenetic.randomizeIgnore((LsysChromosome)aChromosome));
    }

    protected void randomize(PredecessorGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        aGene.setValue(LsysGenetic.randomizePredecessor((LsysChromosome)aChromosome));
    }

    protected void randomize(ContextGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        aGene.setValue(LsysGenetic.randomizeContext((LsysChromosome)aChromosome));
    }

    protected void randomize(SuccessorGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        aGene.setValue(LsysGenetic.randomizeSuccessor((LsysChromosome)aChromosome));
    }

    protected void randomize(LsysProductionGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        PredecessorGene aPredecessor = objectFactory.createPredecessorGene();
        this.randomize(aPredecessor, aChromosome, depth + 1);
        aGene.setPredecessor(aPredecessor);
        SuccessorGene aSuccessor = objectFactory.createSuccessorGene();
        this.randomize(aSuccessor, aChromosome, depth + 1);
        aGene.setSuccessor(aSuccessor);
        ContextGene aLeftContext = objectFactory.createContextGene();
        this.randomize(aLeftContext, aChromosome, depth + 1);
        aGene.setLeftContext(aLeftContext);
        ContextGene aRightContext = objectFactory.createContextGene();
        this.randomize(aRightContext, aChromosome, depth + 1);
        aGene.setRightContext(aRightContext);
    }

    public void randomize(LsysChromosome aChromosome) throws JAXBException {
        AlphabetGene aAlphabet = objectFactory.createAlphabetGene();
        this.randomize(aAlphabet, (ChromosomeType)aChromosome, 1);
        aChromosome.setAlphabet(aAlphabet);
        AxiomGene aAxiom = objectFactory.createAxiomGene();
        this.randomize(aAxiom, (ChromosomeType)aChromosome, 1);
        aChromosome.setAxiom(aAxiom);
        List<LsysProductionGene> list = aChromosome.getProduction();
        list.clear();
        int newLength = LsysGenetic.getNumberOfProductions(aChromosome);
        while (newLength > 0) {
            LsysProductionGene aProduction = objectFactory.createLsysProductionGene();
            this.randomize(aProduction, (ChromosomeType)aChromosome, 1);
            list.add(aProduction);
            --newLength;
        }
        IntegerGene aDirections = objectFactory.createIntegerGene();
        this.randomize(aDirections, 1, 36, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setDirections(aDirections);
        IntegerGene aBaseIndex = objectFactory.createIntegerGene();
        this.randomize(aBaseIndex, 0, 256, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setBaseIndex(aBaseIndex);
    }

    public void randomize(LsysD0LChromosome aChromosome) throws JAXBException {
        this.randomize((LsysChromosome)aChromosome);
        IntegerGene aDepth = objectFactory.createIntegerGene();
        this.randomize(aDepth, 1, 12, (ChromosomeType)aChromosome, true, 0.4, 1);
        aChromosome.setDepth(aDepth);
    }

    public void randomize(Lsys0LChromosome aChromosome) throws JAXBException {
        this.randomize((LsysChromosome)aChromosome);
        IntegerGene aDepth = objectFactory.createIntegerGene();
        this.randomize(aDepth, 1, 12, (ChromosomeType)aChromosome, true, 0.4, 1);
        aChromosome.setDepth(aDepth);
        IntegerGene aJitter = objectFactory.createIntegerGene();
        this.randomize(aJitter, 0, 100, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setJitter(aJitter);
        SeedGene aNoiseSeed = objectFactory.createSeedGene();
        this.randomize(aNoiseSeed, (ChromosomeType)aChromosome, 1);
        aChromosome.setNoiseSeed(aNoiseSeed);
    }

    public void randomize(LsysILChromosome aChromosome) throws JAXBException {
        this.randomize((LsysChromosome)aChromosome);
        IgnoreGene aIgnore = objectFactory.createIgnoreGene();
        this.randomize(aIgnore, (ChromosomeType)aChromosome, 1);
        aChromosome.setIgnore(aIgnore);
        IntegerGene aDepth = objectFactory.createIntegerGene();
        this.randomize(aDepth, 1, 12, (ChromosomeType)aChromosome, true, 0.4, 1);
        aChromosome.setDepth(aDepth);
        IntegerGene aJitter = objectFactory.createIntegerGene();
        this.randomize(aJitter, 0, 100, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setJitter(aJitter);
        SeedGene aNoiseSeed = objectFactory.createSeedGene();
        this.randomize(aNoiseSeed, (ChromosomeType)aChromosome, 1);
        aChromosome.setNoiseSeed(aNoiseSeed);
    }

    protected void randomize(NormalizedVector3Gene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        NormalizedGene aX = objectFactory.createNormalizedGene();
        this.randomize(aX, aChromosome, depth + 1);
        aGene.setX(aX);
        NormalizedGene aY = objectFactory.createNormalizedGene();
        this.randomize(aY, aChromosome, depth + 1);
        aGene.setY(aY);
        NormalizedGene aZ = objectFactory.createNormalizedGene();
        this.randomize(aZ, aChromosome, depth + 1);
        aGene.setZ(aZ);
    }

    protected void randomize(Matrix4X3Gene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        DoubleGene aVal00 = objectFactory.createDoubleGene();
        this.randomize(aVal00, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setVal00(aVal00);
        DoubleGene aVal01 = objectFactory.createDoubleGene();
        this.randomize(aVal01, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setVal01(aVal01);
        DoubleGene aVal02 = objectFactory.createDoubleGene();
        this.randomize(aVal02, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setVal02(aVal02);
        DoubleGene aVal10 = objectFactory.createDoubleGene();
        this.randomize(aVal10, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setVal10(aVal10);
        DoubleGene aVal11 = objectFactory.createDoubleGene();
        this.randomize(aVal11, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setVal11(aVal11);
        DoubleGene aVal12 = objectFactory.createDoubleGene();
        this.randomize(aVal12, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setVal12(aVal12);
        DoubleGene aVal20 = objectFactory.createDoubleGene();
        this.randomize(aVal20, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setVal20(aVal20);
        DoubleGene aVal21 = objectFactory.createDoubleGene();
        this.randomize(aVal21, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setVal21(aVal21);
        DoubleGene aVal22 = objectFactory.createDoubleGene();
        this.randomize(aVal22, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setVal22(aVal22);
        DoubleGene aVal30 = objectFactory.createDoubleGene();
        this.randomize(aVal30, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setVal30(aVal30);
        DoubleGene aVal31 = objectFactory.createDoubleGene();
        this.randomize(aVal31, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setVal31(aVal31);
        DoubleGene aVal32 = objectFactory.createDoubleGene();
        this.randomize(aVal32, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setVal32(aVal32);
    }

    protected void randomize(PovTurbulenceWarpGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        NormalizedVector3Gene aTurbulenceVector = objectFactory.createNormalizedVector3Gene();
        this.randomize(aTurbulenceVector, aChromosome, depth + 1);
        aGene.setTurbulenceVector(aTurbulenceVector);
        IntegerGene aOctaves = objectFactory.createIntegerGene();
        this.randomize(aOctaves, 1, 6, aChromosome, false, 0.0, depth + 1);
        aGene.setOctaves(aOctaves);
        DoubleGene aOmega = objectFactory.createDoubleGene();
        this.randomize(aOmega, 0.01, 0.99, aChromosome, false, 0.0, depth + 1);
        aGene.setOmega(aOmega);
        DoubleGene aLambda = objectFactory.createDoubleGene();
        this.randomize(aLambda, 1.0, 2.5, aChromosome, false, 0.0, depth + 1);
        aGene.setLambda(aLambda);
    }

    protected void randomize(PovBlackHoleWarpGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        NormalizedVector3Gene aLocation = objectFactory.createNormalizedVector3Gene();
        this.randomize(aLocation, aChromosome, depth + 1);
        aGene.setLocation(aLocation);
        NormalizedGene aRadius = objectFactory.createNormalizedGene();
        this.randomize(aRadius, aChromosome, depth + 1);
        aGene.setRadius(aRadius);
        DoubleGene aFalloff = objectFactory.createDoubleGene();
        this.randomize(aFalloff, 0.1, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setFalloff(aFalloff);
        NormalizedGene aStrength = objectFactory.createNormalizedGene();
        this.randomize(aStrength, aChromosome, depth + 1);
        aGene.setStrength(aStrength);
        BooleanGene aInvers = objectFactory.createBooleanGene();
        this.randomize(aInvers, aChromosome, 0.5, depth + 1);
        aGene.setInvers(aInvers);
    }

    protected void randomize(HsbftGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        this.randomize((HsbColorGene)aGene, aChromosome, depth);
        NormalizedGene aFilter = objectFactory.createNormalizedGene();
        this.randomize(aFilter, aChromosome, depth + 1);
        aGene.setFilter(aFilter);
        NormalizedGene aTransmit = objectFactory.createNormalizedGene();
        this.randomize(aTransmit, aChromosome, depth + 1);
        aGene.setTransmit(aTransmit);
    }

    protected void randomize(ColorMapEntryGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        NormalizedGene aWeight = objectFactory.createNormalizedGene();
        this.randomize(aWeight, aChromosome, depth + 1);
        aGene.setWeight(aWeight);
        HsbftGene aHsbft = objectFactory.createHsbftGene();
        this.randomize(aHsbft, aChromosome, depth + 1);
        aGene.setHsbft(aHsbft);
    }

    protected void randomize(PovColorMapGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        String[] enumNames = new String[]{"boxed", "bozo", "bumps", "cells", "cylindrical", "dents", "granite", "leopard", "marble", "onion", "planar", "radial", "ripples", "spherical", "spotted", "waves", "wood", "wrinkles"};
        aGene.setMapPattern(PovMapPatternBase.fromValue(new String(enumNames[CentralRandomizer.getInt(enumNames.length - 1)])));
        List<ColorMapEntryGene> list = aGene.getColor();
        list.clear();
        int newLength = 2 + CentralRandomizer.getBinomial(254, 0.01);
        while (newLength > 0) {
            ColorMapEntryGene aColor = objectFactory.createColorMapEntryGene();
            this.randomize(aColor, aChromosome, 1);
            list.add(aColor);
            --newLength;
        }
    }

    protected void randomize(PovTransformMapGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        Matrix4X3Gene aMatrix = objectFactory.createMatrix4X3Gene();
        this.randomize(aMatrix, aChromosome, depth + 1);
        aGene.setMatrix(aMatrix);
        BooleanGene aInvers = objectFactory.createBooleanGene();
        this.randomize(aInvers, aChromosome, 0.5, depth + 1);
        aGene.setInvers(aInvers);
    }

    protected void randomize(PovWarpGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        PovTurbulenceWarpGene aTurbulence = objectFactory.createPovTurbulenceWarpGene();
        this.randomize(aTurbulence, aChromosome, depth + 1);
        aGene.setTurbulence(aTurbulence);
        List<PovBlackHoleWarpGene> list = aGene.getBlackHole();
        list.clear();
        int newLength = 0 + CentralRandomizer.getBinomial(10, 0.2);
        while (newLength > 0) {
            PovBlackHoleWarpGene aBlackHole = objectFactory.createPovBlackHoleWarpGene();
            this.randomize(aBlackHole, aChromosome, 1);
            list.add(aBlackHole);
            --newLength;
        }
    }

    protected void randomize(PovBlendGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        String[] enumNames = new String[]{"ramp_wave", "triangle_wave", "sine_wave", "scallop_wave", "cubic_wave", "poly_wave"};
        aGene.setBlendMapModifier(PovBlendMapModifierBase.fromValue(new String(enumNames[CentralRandomizer.getInt(enumNames.length - 1)])));
        DoubleGene aBlendMapFrequency = objectFactory.createDoubleGene();
        this.randomize(aBlendMapFrequency, 0.1, 10.0, aChromosome, false, 0.0, depth + 1);
        aGene.setBlendMapFrequency(aBlendMapFrequency);
        DoubleGene aBlendMapPhase = objectFactory.createDoubleGene();
        this.randomize(aBlendMapPhase, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setBlendMapPhase(aBlendMapPhase);
    }

    protected void randomize(PovPigmentGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        PovColorMapGene aColorMap = objectFactory.createPovColorMapGene();
        this.randomize(aColorMap, aChromosome, depth + 1);
        aGene.setColorMap(aColorMap);
        PovWarpGene aWarp = objectFactory.createPovWarpGene();
        this.randomize(aWarp, aChromosome, depth + 1);
        aGene.setWarp(aWarp);
        PovTransformMapGene aTransform = objectFactory.createPovTransformMapGene();
        this.randomize(aTransform, aChromosome, depth + 1);
        aGene.setTransform(aTransform);
        PovBlendGene aBlend = objectFactory.createPovBlendGene();
        this.randomize(aBlend, aChromosome, depth + 1);
        aGene.setBlend(aBlend);
    }

    protected void randomize(NormalMapEntryGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        NormalizedGene aWeight = objectFactory.createNormalizedGene();
        this.randomize(aWeight, aChromosome, depth + 1);
        aGene.setWeight(aWeight);
        String[] enumNames = new String[]{"boxed", "bozo", "bumps", "cells", "cylindrical", "dents", "granite", "leopard", "marble", "onion", "planar", "radial", "ripples", "spherical", "spotted", "waves", "wood", "wrinkles"};
        aGene.setMapPattern(PovMapPatternBase.fromValue(new String(enumNames[CentralRandomizer.getInt(enumNames.length - 1)])));
        DoubleGene aDepth = objectFactory.createDoubleGene();
        this.randomize(aDepth, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setDepth(aDepth);
        DoubleGene aBumpSize = objectFactory.createDoubleGene();
        this.randomize(aBumpSize, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setBumpSize(aBumpSize);
        PovWarpGene aWarp = objectFactory.createPovWarpGene();
        this.randomize(aWarp, aChromosome, depth + 1);
        aGene.setWarp(aWarp);
        PovTransformMapGene aTransform = objectFactory.createPovTransformMapGene();
        this.randomize(aTransform, aChromosome, depth + 1);
        aGene.setTransform(aTransform);
    }

    protected void randomize(PovNormalMapGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        BooleanGene aAverage = objectFactory.createBooleanGene();
        this.randomize(aAverage, aChromosome, 0.25, depth + 1);
        aGene.setAverage(aAverage);
        String[] enumNames = new String[]{"boxed", "bozo", "bumps", "cells", "cylindrical", "dents", "granite", "leopard", "marble", "onion", "planar", "radial", "ripples", "spherical", "spotted", "waves", "wood", "wrinkles"};
        aGene.setMapPattern(PovMapPatternBase.fromValue(new String(enumNames[CentralRandomizer.getInt(enumNames.length - 1)])));
        List<NormalMapEntryGene> list = aGene.getNormal();
        list.clear();
        int newLength = 2 + CentralRandomizer.getBinomial(254, 0.001);
        while (newLength > 0) {
            NormalMapEntryGene aNormal = objectFactory.createNormalMapEntryGene();
            this.randomize(aNormal, aChromosome, 1);
            list.add(aNormal);
            --newLength;
        }
    }

    protected void randomize(PovNormalGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        PovNormalMapGene aNormalMap = objectFactory.createPovNormalMapGene();
        this.randomize(aNormalMap, aChromosome, depth + 1);
        aGene.setNormalMap(aNormalMap);
        PovWarpGene aWarp = objectFactory.createPovWarpGene();
        this.randomize(aWarp, aChromosome, depth + 1);
        aGene.setWarp(aWarp);
        PovTransformMapGene aTransform = objectFactory.createPovTransformMapGene();
        this.randomize(aTransform, aChromosome, depth + 1);
        aGene.setTransform(aTransform);
        PovBlendGene aBlend = objectFactory.createPovBlendGene();
        this.randomize(aBlend, aChromosome, depth + 1);
        aGene.setBlend(aBlend);
    }

    protected void randomize(PovReflectionGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        HsbftGene aColor = objectFactory.createHsbftGene();
        this.randomize(aColor, aChromosome, depth + 1);
        aGene.setColor(aColor);
        BooleanGene aMetallic = objectFactory.createBooleanGene();
        this.randomize(aMetallic, aChromosome, 0.5, depth + 1);
        aGene.setMetallic(aMetallic);
    }

    protected void randomize(PovFinishGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        DoubleGene aAmbient = objectFactory.createDoubleGene();
        this.randomize(aAmbient, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setAmbient(aAmbient);
        DoubleGene aDiffuse = objectFactory.createDoubleGene();
        this.randomize(aDiffuse, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setDiffuse(aDiffuse);
        DoubleGene aSpecular = objectFactory.createDoubleGene();
        this.randomize(aSpecular, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setSpecular(aSpecular);
        DoubleGene aRoughness = objectFactory.createDoubleGene();
        this.randomize(aRoughness, 0.001, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setRoughness(aRoughness);
        BooleanGene aMetallic = objectFactory.createBooleanGene();
        this.randomize(aMetallic, aChromosome, 0.5, depth + 1);
        aGene.setMetallic(aMetallic);
        PovReflectionGene aReflection = objectFactory.createPovReflectionGene();
        this.randomize(aReflection, aChromosome, depth + 1);
        aGene.setReflection(aReflection);
    }

    protected void randomize(PovTextureLayerGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        PovPigmentGene aPigment = objectFactory.createPovPigmentGene();
        this.randomize(aPigment, aChromosome, depth + 1);
        aGene.setPigment(aPigment);
    }

    protected void randomize(PovThingGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
    }

    public void randomize(PovThingChromosome aChromosome) throws JAXBException {
        PovThingGene aThing = objectFactory.createPovThingGene();
        this.randomize(aThing, (ChromosomeType)aChromosome, 1);
        aChromosome.setThing(aThing);
        List<PovTextureLayerGene> list = aChromosome.getTextureLayer();
        list.clear();
        int newLength = 2 + CentralRandomizer.getBinomial(18, 0.1);
        while (newLength > 0) {
            PovTextureLayerGene aTextureLayer = objectFactory.createPovTextureLayerGene();
            this.randomize(aTextureLayer, (ChromosomeType)aChromosome, 1);
            list.add(aTextureLayer);
            --newLength;
        }
    }

    public void randomize(PovThingNFChromosome aChromosome) throws JAXBException {
        this.randomize((PovThingChromosome)aChromosome);
        PovNormalGene aNormal = objectFactory.createPovNormalGene();
        this.randomize(aNormal, (ChromosomeType)aChromosome, 1);
        aChromosome.setNormal(aNormal);
        PovFinishGene aFinish = objectFactory.createPovFinishGene();
        this.randomize(aFinish, (ChromosomeType)aChromosome, 1);
        aChromosome.setFinish(aFinish);
    }

    protected void randomize(ExprSdlOprGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        String[] enumNames = new String[]{"add", "mult", "sub", "div", "max", "min", "mod", "noise", "snoise", "atanq", "pow", "sqrt", "pow", "abs", "acos", "acosh", "asin", "asinh", "atan", "atanh", "ceil", "cos", "cosh", "degrees", "exp", "floor", "ln", "log", "radians", "sin", "sinh", "sqrt", "tan", "tanh"};
        aGene.setSdlOpr(ExprSdlOprBase.fromValue(new String(enumNames[CentralRandomizer.getInt(enumNames.length - 1)])));
    }

    protected void randomize(ExprSdlVarGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        String[] enumNames = new String[]{"x", "y", "z"};
        aGene.setSdlVar(ExprSdlVarBase.fromValue(new String(enumNames[CentralRandomizer.getInt(enumNames.length - 1)])));
    }

    protected void randomize(ExprSdlConstGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        DoubleGene aSdlConst = objectFactory.createDoubleGene();
        this.randomize(aSdlConst, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setSdlConst(aSdlConst);
    }

    protected void randomize(ExprSdlArgsListGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        List<GeneType> list = aGene.getVarOrConstOrSdlExpression();
        list.clear();
        int len = CentralRandomizer.getInt(2, 5);
        while (len > 0) {
            switch (CentralRandomizer.getInt(1, 3)) {
                case 1: {
                    ExprSdlVarGene aNewVar = objectFactory.createExprSdlVarGene();
                    this.randomize(aNewVar, aChromosome, depth + 1);
                    list.add(aNewVar);
                    --len;
                    break;
                }
                case 2: {
                    ExprSdlConstGene aNewConst = objectFactory.createExprSdlConstGene();
                    this.randomize(aNewConst, aChromosome, depth + 1);
                    list.add(aNewConst);
                    --len;
                    break;
                }
                case 3: {
                    if (!(CentralRandomizer.getDouble(0.0, 0.15) < 1.0 / (double)depth)) break;
                    SdlExpressionGene aNewSdlExpression = objectFactory.createSdlExpressionGene();
                    this.randomize(aNewSdlExpression, aChromosome, depth + 1);
                    list.add(aNewSdlExpression);
                    --len;
                }
            }
        }
    }

    protected void randomize(ExprSdlListGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        ExprSdlOprGene aOpr = objectFactory.createExprSdlOprGene();
        this.randomize(aOpr, aChromosome, depth + 1);
        aGene.setOpr(aOpr);
        ExprSdlArgsListGene aArgs = objectFactory.createExprSdlArgsListGene();
        this.randomize(aArgs, aChromosome, depth + 1);
        aGene.setArgs(aArgs);
    }

    protected void randomize(SdlExpressionGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        ExprSdlListGene aList = objectFactory.createExprSdlListGene();
        this.randomize(aList, aChromosome, depth + 1);
        aGene.setList(aList);
    }

    protected void randomize(PovRotateGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        DoubleGene aRx = objectFactory.createDoubleGene();
        this.randomize(aRx, -180.0, 180.0, aChromosome, false, 0.0, depth + 1);
        aGene.setRx(aRx);
        DoubleGene aRy = objectFactory.createDoubleGene();
        this.randomize(aRy, -180.0, 180.0, aChromosome, false, 0.0, depth + 1);
        aGene.setRy(aRy);
        DoubleGene aRz = objectFactory.createDoubleGene();
        this.randomize(aRz, -180.0, 180.0, aChromosome, false, 0.0, depth + 1);
        aGene.setRz(aRz);
    }

    protected void randomize(PovRidgedMultifractalGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        ExprSdlListGene aFx = objectFactory.createExprSdlListGene();
        this.randomize(aFx, aChromosome, depth + 1);
        aGene.setFx(aFx);
        ExprSdlListGene aFy = objectFactory.createExprSdlListGene();
        this.randomize(aFy, aChromosome, depth + 1);
        aGene.setFy(aFy);
        ExprSdlListGene aFz = objectFactory.createExprSdlListGene();
        this.randomize(aFz, aChromosome, depth + 1);
        aGene.setFz(aFz);
        DoubleGene aH = objectFactory.createDoubleGene();
        this.randomize(aH, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setH(aH);
        DoubleGene aLacunarity = objectFactory.createDoubleGene();
        this.randomize(aLacunarity, 1.0, 100.0, aChromosome, false, 0.0, depth + 1);
        aGene.setLacunarity(aLacunarity);
        IntegerGene aOctaves = objectFactory.createIntegerGene();
        this.randomize(aOctaves, 1, 6, aChromosome, false, 0.0, depth + 1);
        aGene.setOctaves(aOctaves);
        DoubleGene aOffset = objectFactory.createDoubleGene();
        this.randomize(aOffset, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setOffset(aOffset);
        DoubleGene aGain = objectFactory.createDoubleGene();
        this.randomize(aGain, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
        aGene.setGain(aGain);
    }

    public void randomize(PovIsoSurfaceChromosome aChromosome) throws JAXBException {
        this.randomize((PovThingNFChromosome)aChromosome);
        PovRidgedMultifractalGene aRidgedMultifractal = objectFactory.createPovRidgedMultifractalGene();
        this.randomize(aRidgedMultifractal, (ChromosomeType)aChromosome, 1);
        aChromosome.setRidgedMultifractal(aRidgedMultifractal);
        NormalizedGene aThreshold = objectFactory.createNormalizedGene();
        this.randomize(aThreshold, (ChromosomeType)aChromosome, 1);
        aChromosome.setThreshold(aThreshold);
        PovRotateGene aRotate = objectFactory.createPovRotateGene();
        this.randomize(aRotate, (ChromosomeType)aChromosome, 1);
        aChromosome.setRotate(aRotate);
    }

    protected void randomize(AbstractTutorialShapeGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        ColorGene aColor = objectFactory.createColorGene();
        this.randomize(aColor, aChromosome, depth + 1);
        aGene.setColor(aColor);
        NormalizedGene aTransparency = objectFactory.createNormalizedGene();
        this.randomize(aTransparency, aChromosome, depth + 1);
        aGene.setTransparency(aTransparency);
        SymmetricGene aX = objectFactory.createSymmetricGene();
        this.randomize(aX, aChromosome, depth + 1);
        aGene.setX(aX);
        SymmetricGene aY = objectFactory.createSymmetricGene();
        this.randomize(aY, aChromosome, depth + 1);
        aGene.setY(aY);
    }

    protected void randomize(TutorialCircleGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        this.randomize((AbstractTutorialShapeGene)aGene, aChromosome, depth);
        NormalizedGene aRadius = objectFactory.createNormalizedGene();
        this.randomize(aRadius, aChromosome, depth + 1);
        aGene.setRadius(aRadius);
    }

    public void randomize(TutorialShapeChromosome aChromosome) throws JAXBException {
        List<TutorialCircleGene> list = aChromosome.getAllShapes();
        list.clear();
        int newLength = CentralRandomizer.getInt(2, 100);
        while (newLength > 0) {
            TutorialCircleGene aAllShapes = objectFactory.createTutorialCircleGene();
            this.randomize(aAllShapes, (ChromosomeType)aChromosome, 1);
            list.add(aAllShapes);
            --newLength;
        }
        ColorGene aColor = objectFactory.createColorGene();
        this.randomize(aColor, (ChromosomeType)aChromosome, 1);
        aChromosome.setColor(aColor);
    }

    protected void randomize(WarpingTurbulenceGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        SymmetricGene aTimeCoord = objectFactory.createSymmetricGene();
        this.randomize(aTimeCoord, aChromosome, depth + 1);
        aGene.setTimeCoord(aTimeCoord);
        DoubleGene aOctaves = objectFactory.createDoubleGene();
        this.randomize(aOctaves, 0.0, 7.0, aChromosome, false, 0.0, depth + 1);
        aGene.setOctaves(aOctaves);
        DoubleGene aAmpscale = objectFactory.createDoubleGene();
        this.randomize(aAmpscale, 0.2, 0.8, aChromosome, false, 0.0, depth + 1);
        aGene.setAmpscale(aAmpscale);
        DoubleGene aFreqscale = objectFactory.createDoubleGene();
        this.randomize(aFreqscale, 1.0, 4.0, aChromosome, false, 0.0, depth + 1);
        aGene.setFreqscale(aFreqscale);
        SymmetricGene aScaleOut = objectFactory.createSymmetricGene();
        this.randomize(aScaleOut, aChromosome, depth + 1);
        aGene.setScaleOut(aScaleOut);
        SymmetricGene aScaleXin = objectFactory.createSymmetricGene();
        this.randomize(aScaleXin, aChromosome, depth + 1);
        aGene.setScaleXin(aScaleXin);
        SymmetricGene aScaleYin = objectFactory.createSymmetricGene();
        this.randomize(aScaleYin, aChromosome, depth + 1);
        aGene.setScaleYin(aScaleYin);
        NormalizedGene aSource1 = objectFactory.createNormalizedGene();
        this.randomize(aSource1, aChromosome, depth + 1);
        aGene.setSource1(aSource1);
        NormalizedGene aSource2 = objectFactory.createNormalizedGene();
        this.randomize(aSource2, aChromosome, depth + 1);
        aGene.setSource2(aSource2);
        NormalizedGene aSource3 = objectFactory.createNormalizedGene();
        this.randomize(aSource3, aChromosome, depth + 1);
        aGene.setSource3(aSource3);
        NormalizedGene aSource4 = objectFactory.createNormalizedGene();
        this.randomize(aSource4, aChromosome, depth + 1);
        aGene.setSource4(aSource4);
        SeedGene aSeed1 = objectFactory.createSeedGene();
        this.randomize(aSeed1, aChromosome, depth + 1);
        aGene.setSeed1(aSeed1);
        SeedGene aSeed2 = objectFactory.createSeedGene();
        this.randomize(aSeed2, aChromosome, depth + 1);
        aGene.setSeed2(aSeed2);
        SeedGene aSeed3 = objectFactory.createSeedGene();
        this.randomize(aSeed3, aChromosome, depth + 1);
        aGene.setSeed3(aSeed3);
        SeedGene aSeed4 = objectFactory.createSeedGene();
        this.randomize(aSeed4, aChromosome, depth + 1);
        aGene.setSeed4(aSeed4);
    }

    protected void randomize(WarpingLayerGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        List<WarpingTurbulenceGene> list = aGene.getTerm();
        list.clear();
        int newLength = CentralRandomizer.getInt(1, 2);
        while (newLength > 0) {
            WarpingTurbulenceGene aTerm = objectFactory.createWarpingTurbulenceGene();
            this.randomize(aTerm, aChromosome, 1);
            list.add(aTerm);
            --newLength;
        }
    }

    public void randomize(DomainWarpingChromosome aChromosome) throws JAXBException {
        DoubleGene aMainscale = objectFactory.createDoubleGene();
        this.randomize(aMainscale, 0.1, 10.0, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setMainscale(aMainscale);
        DoubleGene aGradientgain = objectFactory.createDoubleGene();
        this.randomize(aGradientgain, 0.001, 0.999, (ChromosomeType)aChromosome, false, 0.0, 1);
        aChromosome.setGradientgain(aGradientgain);
        List<WarpingLayerGene> list = aChromosome.getWarpingLayer();
        list.clear();
        int newLength = CentralRandomizer.getInt(1, 5);
        while (newLength > 0) {
            WarpingLayerGene aWarpingLayer = objectFactory.createWarpingLayerGene();
            this.randomize(aWarpingLayer, (ChromosomeType)aChromosome, 1);
            list.add(aWarpingLayer);
            --newLength;
        }
    }

    public void randomize(DomainWarpingChladniNoiseChromosome aChromosome) throws JAXBException {
        this.randomize((DomainWarpingChromosome)aChromosome);
    }

    public void randomize(DomainWarpingChladniWorleyNoiseChromosome aChromosome) throws JAXBException {
        this.randomize((DomainWarpingChromosome)aChromosome);
    }

    public void randomize(DomainWarpingChladniWorleyPerlinNoiseChromosome aChromosome) throws JAXBException {
        this.randomize((DomainWarpingChromosome)aChromosome);
    }
}

