/*
 * Decompiled with CFR 0.152.
 */
package kandid.soup.map;

import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import kandid.Environment;
import kandid.calculation.lca.DirectLcaCalculation;
import kandid.calculation.lca.TotalLcaCalculation;
import kandid.colorator.ColorF32;
import kandid.soup.AbstractTutorialShapeGene;
import kandid.soup.AffineIfsChromosome;
import kandid.soup.AffineIfsSymmChromosome;
import kandid.soup.AffineTransformationGene;
import kandid.soup.AlphabetGene;
import kandid.soup.AxiomGene;
import kandid.soup.BooleanGene;
import kandid.soup.ChromosomeType;
import kandid.soup.ColorGene;
import kandid.soup.ColorMapEntryGene;
import kandid.soup.ContextGene;
import kandid.soup.DirectLcaChromosome;
import kandid.soup.DistanceFunctionBase;
import kandid.soup.DistanceFunctionGene;
import kandid.soup.DomainWarpingChladniNoiseChromosome;
import kandid.soup.DomainWarpingChladniWorleyNoiseChromosome;
import kandid.soup.DomainWarpingChladniWorleyPerlinNoiseChromosome;
import kandid.soup.DomainWarpingChromosome;
import kandid.soup.DoubleGene;
import kandid.soup.ExprScalarArgsListGene;
import kandid.soup.ExprScalarConstGene;
import kandid.soup.ExprScalarListGene;
import kandid.soup.ExprScalarOprBase;
import kandid.soup.ExprScalarOprGene;
import kandid.soup.ExprScalarVarBase;
import kandid.soup.ExprScalarVarGene;
import kandid.soup.ExprSdlArgsListGene;
import kandid.soup.ExprSdlConstGene;
import kandid.soup.ExprSdlListGene;
import kandid.soup.ExprSdlOprBase;
import kandid.soup.ExprSdlOprGene;
import kandid.soup.ExprSdlVarBase;
import kandid.soup.ExprSdlVarGene;
import kandid.soup.ExprVectorArgsListGene;
import kandid.soup.ExprVectorConstGene;
import kandid.soup.ExprVectorListGene;
import kandid.soup.ExprVectorOprBase;
import kandid.soup.ExprVectorOprGene;
import kandid.soup.ExprVectorVarBase;
import kandid.soup.ExprVectorVarGene;
import kandid.soup.FlameIfsChromosome;
import kandid.soup.FlameTransformationGene;
import kandid.soup.FractionalGene;
import kandid.soup.GeneType;
import kandid.soup.GradientChromosome;
import kandid.soup.GradientSegmentGene;
import kandid.soup.HsbColorGene;
import kandid.soup.HsbFrequenceChromosome;
import kandid.soup.HsbftGene;
import kandid.soup.IgnoreGene;
import kandid.soup.IntegerGene;
import kandid.soup.KingGene;
import kandid.soup.LcaChromosome;
import kandid.soup.LcaInitialStateBase;
import kandid.soup.LcaInitialStateGene;
import kandid.soup.LcaStateGene;
import kandid.soup.LookUpColorGene;
import kandid.soup.LookUpTableChromosome;
import kandid.soup.Lsys0LChromosome;
import kandid.soup.LsysChromosome;
import kandid.soup.LsysD0LChromosome;
import kandid.soup.LsysILChromosome;
import kandid.soup.LsysProductionGene;
import kandid.soup.Matrix4X3Gene;
import kandid.soup.NormalMapEntryGene;
import kandid.soup.NormalizedGene;
import kandid.soup.NormalizedVector3Gene;
import kandid.soup.ObjectFactory;
import kandid.soup.PovBlackHoleWarpGene;
import kandid.soup.PovBlendGene;
import kandid.soup.PovBlendMapModifierBase;
import kandid.soup.PovColorMapGene;
import kandid.soup.PovFinishGene;
import kandid.soup.PovIsoSurfaceChromosome;
import kandid.soup.PovMapPatternBase;
import kandid.soup.PovNormalGene;
import kandid.soup.PovNormalMapGene;
import kandid.soup.PovPigmentGene;
import kandid.soup.PovReflectionGene;
import kandid.soup.PovRidgedMultifractalGene;
import kandid.soup.PovRotateGene;
import kandid.soup.PovTextureLayerGene;
import kandid.soup.PovThingChromosome;
import kandid.soup.PovThingGene;
import kandid.soup.PovThingNFChromosome;
import kandid.soup.PovTransformMapGene;
import kandid.soup.PovTurbulenceWarpGene;
import kandid.soup.PovWarpGene;
import kandid.soup.PredecessorGene;
import kandid.soup.RandomWalkPointGene;
import kandid.soup.ScalarExprGene;
import kandid.soup.ScalarExpressionChromosome;
import kandid.soup.SdlExpressionGene;
import kandid.soup.SeedGene;
import kandid.soup.SuccessorGene;
import kandid.soup.SymmetricGene;
import kandid.soup.SymmetricIfsChromosome;
import kandid.soup.TotalLcaChromosome;
import kandid.soup.TransparentLookUpTableChromosome;
import kandid.soup.TutorialCircleGene;
import kandid.soup.TutorialShapeChromosome;
import kandid.soup.VectorExprGene;
import kandid.soup.VectorExpressionChromosome;
import kandid.soup.VoronoiChromosome;
import kandid.soup.VoronoiChromosomeBase;
import kandid.soup.VoronoiTransparentChromosome;
import kandid.soup.WarpingLayerGene;
import kandid.soup.WarpingTurbulenceGene;
import kandid.soup.genetic.lsys.LsysGenetic;
import kandid.soup.map.RandomizeChromosome;
import kandid.util.CentralRandomizer;

public class MutateChromosome
extends RandomizeChromosome {
    private static ObjectFactory objectFactory = new ObjectFactory();

    private int mutateListLength(Environment env, int min, int max, int oldLength) {
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            int newLength = (int)Math.ceil((double)oldLength + Math.log(oldLength + 1) * CentralRandomizer.getGaussian());
            if (newLength < min) {
                newLength = min;
            } else if (newLength > max) {
                newLength = max;
            }
            return newLength;
        }
        return oldLength;
    }

    private void cutList(int cutTo, List list) {
        int length = list.size();
        while (length > cutTo) {
            list.remove(--length);
        }
    }

    private int scrambleList(Environment env, List list) {
        int g2;
        int g1;
        int mutationCounter = 0;
        int length = list.size();
        if (length > 1 && CentralRandomizer.getDouble(1.0) < env.getMutationRate() && (g1 = CentralRandomizer.getInt(length - 1)) != (g2 = CentralRandomizer.getInt(length - 1))) {
            Object temp = list.get(g1);
            list.set(g1, list.get(g2));
            list.set(g2, temp);
            ++mutationCounter;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, BooleanGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            boolean oldValue = aGene.isValue();
            boolean newValue = CentralRandomizer.getBoolean();
            aGene.setValue(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, IntegerGene aGene, int minInclusive, int maxInclusive, ChromosomeType aChromosome, int depth) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            if (CentralRandomizer.getBoolean()) {
                int value = aGene.getValue();
                if (value > minInclusive) {
                    aGene.setValue(aGene.getValue() - 1);
                    ++mutationCounter;
                }
            } else {
                int value = aGene.getValue();
                if (value < maxInclusive) {
                    aGene.setValue(aGene.getValue() + 1);
                    ++mutationCounter;
                }
            }
        }
        return mutationCounter;
    }

    private int mutate(Environment env, SeedGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            long oldValue = aGene.getValue();
            long newValue = CentralRandomizer.getLong();
            aGene.setValue(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, DoubleGene aGene, double minInclusive, double maxInclusive, ChromosomeType aChromosome, int depth) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            double oldValue = aGene.getValue();
            double newValue = oldValue + env.getScaleFactor() * CentralRandomizer.getGaussian();
            if (newValue < minInclusive) {
                newValue = minInclusive;
            } else if (newValue > maxInclusive) {
                newValue = maxInclusive;
            }
            aGene.setValue(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, NormalizedGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            double oldValue = aGene.getValue();
            double newValue = oldValue + env.getScaleFactor() * CentralRandomizer.getGaussian();
            if (newValue < 0.0) {
                newValue = 0.0;
            } else if (newValue > 1.0) {
                newValue = 1.0;
            }
            aGene.setValue(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, FractionalGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            double oldValue = aGene.getValue();
            double newValue = oldValue + env.getScaleFactor() * CentralRandomizer.getGaussian();
            while (newValue < 0.0) {
                newValue += 1.0;
            }
            while (newValue > 1.0) {
                newValue -= 1.0;
            }
            aGene.setValue(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, SymmetricGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            double oldValue = aGene.getValue();
            double newValue = oldValue + env.getScaleFactor() * CentralRandomizer.getGaussian();
            if (newValue < -1.0) {
                newValue = -1.0;
            } else if (newValue > 1.0) {
                newValue = 1.0;
            }
            aGene.setValue(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, RandomWalkPointGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            double radius = CentralRandomizer.getDouble(env.getScaleFactor());
            double angle = CentralRandomizer.getDouble(-Math.PI, Math.PI);
            aGene.setX(aGene.getX() + radius * Math.cos(angle));
            aGene.setY(aGene.getY() + radius * Math.sin(angle));
            ++mutationCounter;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, ColorGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            ColorF32 rgb = new ColorF32(aGene.getRed().floatValue(), aGene.getGreen().floatValue(), aGene.getBlue().floatValue());
            ColorF32 hsb = new ColorF32();
            ColorF32 old = new ColorF32();
            ColorF32.rgb2hsb(rgb, hsb);
            ColorF32.copy(rgb, old);
            double scale = env.getScaleFactor();
            hsb.r += (float)(scale * CentralRandomizer.getGaussian());
            while ((double)hsb.r < 0.0) {
                hsb.r = (float)((double)hsb.r + 1.0);
            }
            while ((double)hsb.r > 1.0) {
                hsb.r = (float)((double)hsb.r - 1.0);
            }
            hsb.g += (float)(scale * CentralRandomizer.getGaussian());
            if ((double)hsb.g < 0.0) {
                hsb.g = 0.0f;
            } else if ((double)hsb.g > 1.0) {
                hsb.g = 1.0f;
            }
            hsb.b += (float)(scale * CentralRandomizer.getGaussian());
            if ((double)hsb.b < 0.0) {
                hsb.b = 0.0f;
            } else if ((double)hsb.b > 1.0) {
                hsb.b = 1.0f;
            }
            ColorF32.hsb2rgb(hsb, rgb);
            aGene.setRed(Float.valueOf(rgb.r));
            aGene.setGreen(Float.valueOf(rgb.g));
            aGene.setBlue(Float.valueOf(rgb.b));
            mutationCounter += old.r != rgb.r || old.g != rgb.g || old.b != rgb.b ? 1 : 0;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, HsbColorGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            double scale = env.getScaleFactor();
            double hue = aGene.getHue() + scale * CentralRandomizer.getGaussian();
            while (hue < 0.0) {
                hue += 1.0;
            }
            while (hue > 1.0) {
                hue -= 1.0;
            }
            double saturation = aGene.getSaturation() + scale * CentralRandomizer.getGaussian();
            if (saturation < 0.0) {
                saturation = 0.0;
            } else if (saturation > 1.0) {
                saturation = 1.0;
            }
            double brightness = aGene.getBrightness() + scale * CentralRandomizer.getGaussian();
            if (brightness < 0.0) {
                brightness = 0.0;
            } else if (brightness > 1.0) {
                brightness = 1.0;
            }
            aGene.setHue(hue);
            aGene.setSaturation(saturation);
            aGene.setBrightness(brightness);
            ++mutationCounter;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, AffineTransformationGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getTa(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getTb(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getTc(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getTd(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getTe(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getTf(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, LookUpColorGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getHue(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSaturation(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getBrightness(), aChromosome, depth + 1);
    }

    public int mutate(Environment env, TransparentLookUpTableChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        List<LookUpColorGene> list = aChromosome.getLutColor();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 2, 32, oldLength);
        this.cutList(newLength, list);
        Iterator<LookUpColorGene> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), (ChromosomeType)aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            LookUpColorGene newGene = objectFactory.createLookUpColorGene();
            this.randomize(newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        return mutationCounter += this.scrambleList(env, list);
    }

    public int mutate(Environment env, LookUpTableChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        List<LookUpColorGene> list = aChromosome.getLutColor();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 2, 32, oldLength);
        this.cutList(newLength, list);
        Iterator<LookUpColorGene> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), (ChromosomeType)aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            LookUpColorGene newGene = objectFactory.createLookUpColorGene();
            this.randomize(newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        return mutationCounter += this.scrambleList(env, list);
    }

    private int mutate(Environment env, GradientSegmentGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getHue(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSaturation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getBrightness(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getWeight(), aChromosome, depth + 1);
    }

    public int mutate(Environment env, GradientChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        List<GradientSegmentGene> list = aChromosome.getGradientSegment();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 2, 10, oldLength);
        this.cutList(newLength, list);
        Iterator<GradientSegmentGene> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), (ChromosomeType)aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            GradientSegmentGene newGene = objectFactory.createGradientSegmentGene();
            this.randomize(newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        return mutationCounter += this.scrambleList(env, list);
    }

    public int mutate(Environment env, HsbFrequenceChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aChromosome.getFrequence(), 0.02, 2.0, (ChromosomeType)aChromosome, 1);
        return mutationCounter += this.mutate(env, aChromosome.getPhaseshift(), (ChromosomeType)aChromosome, 1);
    }

    private int mutate(Environment env, DistanceFunctionGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        String[] enumNamesDistanceFunction = new String[]{"abs(dx,dy)", "abs(dx)", "abs(dy)", "dx", "dy", "euclide(dx,dy)", "product(dx,dy)", "quotient(dx,dy)"};
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            DistanceFunctionBase oldValue = aGene.getDistanceFunction();
            DistanceFunctionBase newValue = DistanceFunctionBase.fromValue(enumNamesDistanceFunction[CentralRandomizer.getInt(enumNamesDistanceFunction.length - 1)]);
            aGene.setDistanceFunction(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter += this.mutate(env, aGene.getWeight(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, KingGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getPoint(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getColor(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getWeight(), aChromosome, depth + 1);
    }

    public int mutate(Environment env, VoronoiChromosomeBase aChromosome) throws JAXBException {
        GeneType newGene;
        int mutationCounter = 0;
        List<GeneType> list = aChromosome.getDistance();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 1, 8, oldLength);
        this.cutList(newLength, list);
        Iterator<GeneType> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), (ChromosomeType)aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            newGene = objectFactory.createDistanceFunctionGene();
            this.randomize((DistanceFunctionGene)newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        mutationCounter += this.scrambleList(env, list);
        list = aChromosome.getKing();
        oldLength = list.size();
        newLength = this.mutateListLength(env, 2, 50, oldLength);
        this.cutList(newLength, list);
        iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, (KingGene)iter.next(), (ChromosomeType)aChromosome, 1);
        }
        append = newLength - oldLength;
        while (append > 0) {
            newGene = objectFactory.createKingGene();
            this.randomize((KingGene)newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        return mutationCounter += this.scrambleList(env, list);
    }

    public int mutate(Environment env, VoronoiChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, (VoronoiChromosomeBase)aChromosome);
        return mutationCounter += this.mutate(env, aChromosome.getYard(), (ChromosomeType)aChromosome, 1);
    }

    public int mutate(Environment env, VoronoiTransparentChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, (VoronoiChromosomeBase)aChromosome);
        mutationCounter += this.mutate(env, aChromosome.getPrioritySize(), 2, 10, (ChromosomeType)aChromosome, 1);
        return mutationCounter += this.mutate(env, aChromosome.getPriorityWeight(), 0.5, 2.0, (ChromosomeType)aChromosome, 1);
    }

    public int mutate(Environment env, AffineIfsChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aChromosome.getSeed(), (ChromosomeType)aChromosome, 1);
        List<AffineTransformationGene> list = aChromosome.getAffineTransformation();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 2, 8, oldLength);
        this.cutList(newLength, list);
        Iterator<AffineTransformationGene> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), (ChromosomeType)aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            AffineTransformationGene newGene = objectFactory.createAffineTransformationGene();
            this.randomize(newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        return mutationCounter += this.scrambleList(env, list);
    }

    public int mutate(Environment env, AffineIfsSymmChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, (AffineIfsChromosome)aChromosome);
        mutationCounter += this.mutate(env, aChromosome.getSymmetry(), 1, 25, (ChromosomeType)aChromosome, 1);
        return mutationCounter += this.mutate(env, aChromosome.getDn(), (ChromosomeType)aChromosome, 1);
    }

    public int mutate(Environment env, SymmetricIfsChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aChromosome.getSymmetry(), 3, 11, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getLambda(), -2.5, 2.5, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getAlpha(), -2.5, 10.0, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getBeta(), -20.0, 0.2, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getGamma(), -1.0, 1.0, (ChromosomeType)aChromosome, 1);
        return mutationCounter += this.mutate(env, aChromosome.getOmega(), -1.0, 1.0, (ChromosomeType)aChromosome, 1);
    }

    private int mutate(Environment env, FlameTransformationGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, (AffineTransformationGene)aGene, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getWeight(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getColorindex(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getLinearEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getLinearVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSinusoidalEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSinusoidalVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSphericalEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSphericalVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSwirlEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSwirlVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getHorseshoeEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getHorseshoeVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getPolarEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getPolarVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getFoldedHandkerchiefEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getFoldedHandkerchiefVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getHeartEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getHeartVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getDiscEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getDiscVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSpiralEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSpiralVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getHyperbolicEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getHyperbolicVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getDiamondEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getDiamondVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getExEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getExVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getJuliaEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getJuliaVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getBentEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getBentVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getFisheyeEnabled(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getFisheyeVariation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getPopcornEnabled(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getPopcornVariation(), aChromosome, depth + 1);
    }

    public int mutate(Environment env, FlameIfsChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        List<FlameTransformationGene> list = aChromosome.getFlameTransformation();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 2, 8, oldLength);
        this.cutList(newLength, list);
        Iterator<FlameTransformationGene> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), (ChromosomeType)aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            FlameTransformationGene newGene = objectFactory.createFlameTransformationGene();
            this.randomize(newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        mutationCounter += this.scrambleList(env, list);
        mutationCounter += this.mutate(env, aChromosome.getPalette(), 0, 89, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getHue(), -0.5, 0.5, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getBrightness(), 0.0, 5.0, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getGamma(), 1.0, 5.0, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getVibrancy(), 0.0, 1.0, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getZoom(), -4.0, 4.0, (ChromosomeType)aChromosome, 1);
        return mutationCounter += this.mutate(env, aChromosome.getFilter(), 0.0, 4.0, (ChromosomeType)aChromosome, 1);
    }

    private int mutate(Environment env, LcaInitialStateGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        String[] enumNamesFillMode = new String[]{"uniform random", "random ramp", "single point", "two points", "three points", "two points with single gap"};
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            LcaInitialStateBase oldValue = aGene.getFillMode();
            LcaInitialStateBase newValue = LcaInitialStateBase.fromValue(enumNamesFillMode[CentralRandomizer.getInt(enumNamesFillMode.length - 1)]);
            aGene.setFillMode(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter += this.mutate(env, aGene.getStateSeed(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, LcaStateGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            double test = CentralRandomizer.getGaussian();
            if (CentralRandomizer.getBoolean()) {
                int value = aGene.getValue();
                if (value > 0) {
                    aGene.setValue(aGene.getValue() - 1);
                    ++mutationCounter;
                }
            } else {
                int value = aGene.getValue();
                int maxStates = 0;
                if (aChromosome instanceof DirectLcaChromosome) {
                    maxStates = ((DirectLcaChromosome)aChromosome).getMaxStates().getValue();
                } else if (aChromosome instanceof TotalLcaChromosome) {
                    maxStates = ((TotalLcaChromosome)aChromosome).getMaxStates().getValue();
                }
                if (value < maxStates - 1) {
                    aGene.setValue(aGene.getValue() + 1);
                    ++mutationCounter;
                }
            }
        }
        return mutationCounter;
    }

    public int mutate(Environment env, LcaChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aChromosome.getLcaInitialState(), (ChromosomeType)aChromosome, 1);
        return mutationCounter += this.mutate(env, aChromosome.getWidth(), 16, 512, (ChromosomeType)aChromosome, 1);
    }

    public int mutate(Environment env, TotalLcaChromosome aChromosome) throws JAXBException {
        GeneType newGene;
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, (LcaChromosome)aChromosome);
        mutationCounter += this.mutate(env, aChromosome.getMaxStates(), 2, 30, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getLeftNeighbors(), 0, 9, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getRightNeighbors(), 0, 9, (ChromosomeType)aChromosome, 1);
        List<GeneType> list = aChromosome.getColor();
        int oldLength = list.size();
        int newLength = aChromosome.getMaxStates().getValue();
        this.cutList(newLength, list);
        Iterator<GeneType> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), (ChromosomeType)aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            newGene = objectFactory.createColorGene();
            this.randomize((ColorGene)newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        mutationCounter += this.scrambleList(env, list);
        list = aChromosome.getRule();
        oldLength = list.size();
        newLength = TotalLcaCalculation.numberofRules(aChromosome.getMaxStates().getValue(), aChromosome.getLeftNeighbors().getValue(), aChromosome.getRightNeighbors().getValue());
        this.cutList(newLength, list);
        iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, (LcaStateGene)iter.next(), (ChromosomeType)aChromosome, 1);
        }
        append = newLength - oldLength;
        while (append > 0) {
            newGene = objectFactory.createLcaStateGene();
            this.randomize((LcaStateGene)newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        int length = list.size();
        int ix = 0;
        while (ix < length) {
            LcaStateGene element = (LcaStateGene)list.get(ix);
            if (element.getValue() > aChromosome.getMaxStates().getValue() - 1) {
                element.setValue(aChromosome.getMaxStates().getValue() - 1);
                ++mutationCounter;
            }
            ++ix;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        return mutationCounter += this.scrambleList(env, list);
    }

    public int mutate(Environment env, DirectLcaChromosome aChromosome) throws JAXBException {
        GeneType newGene;
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, (LcaChromosome)aChromosome);
        mutationCounter += this.mutate(env, aChromosome.getMaxStates(), 2, 6, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getLeftNeighbors(), 0, 2, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getRightNeighbors(), 0, 2, (ChromosomeType)aChromosome, 1);
        List<GeneType> list = aChromosome.getColor();
        int oldLength = list.size();
        int newLength = aChromosome.getMaxStates().getValue();
        this.cutList(newLength, list);
        Iterator<GeneType> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), (ChromosomeType)aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            newGene = objectFactory.createColorGene();
            this.randomize((ColorGene)newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        mutationCounter += this.scrambleList(env, list);
        list = aChromosome.getRule();
        oldLength = list.size();
        newLength = DirectLcaCalculation.numberofRules(aChromosome.getMaxStates().getValue(), aChromosome.getLeftNeighbors().getValue(), aChromosome.getRightNeighbors().getValue());
        this.cutList(newLength, list);
        iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, (LcaStateGene)iter.next(), (ChromosomeType)aChromosome, 1);
        }
        append = newLength - oldLength;
        while (append > 0) {
            newGene = objectFactory.createLcaStateGene();
            this.randomize((LcaStateGene)newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        int length = list.size();
        int ix = 0;
        while (ix < length) {
            LcaStateGene element = (LcaStateGene)list.get(ix);
            if (element.getValue() > aChromosome.getMaxStates().getValue() - 1) {
                element.setValue(aChromosome.getMaxStates().getValue() - 1);
                ++mutationCounter;
            }
            ++ix;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        return mutationCounter += this.scrambleList(env, list);
    }

    private int mutate(Environment env, ExprScalarOprGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        String[] enumNamesScalarOpr = new String[]{"ifPositive", "add", "mult", "sub", "div", "noise", "turbulence", "snoise", "sturbulence", "pow", "sqrt", "tan", "sin", "cos", "atanq", "atan", "log", "mix", "mixx", "step", "puls", "clamp", "max", "min", "abs", "smoothstep", "boxstep", "mod", "floor", "ceil", "gamma", "gain", "bias", "euclide", "absolute"};
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            ExprScalarOprBase oldValue = aGene.getScalarOpr();
            ExprScalarOprBase newValue = ExprScalarOprBase.fromValue(enumNamesScalarOpr[CentralRandomizer.getInt(enumNamesScalarOpr.length - 1)]);
            aGene.setScalarOpr(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, ExprScalarVarGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        String[] enumNamesScalarVar = new String[]{"x", "xi", "y", "yi", "r", "ri", "t", "ti", "xp2", "yp2", "xp3", "yp3", "xcos", "ycos", "xsinh", "ysinh"};
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            ExprScalarVarBase oldValue = aGene.getScalarVar();
            ExprScalarVarBase newValue = ExprScalarVarBase.fromValue(enumNamesScalarVar[CentralRandomizer.getInt(enumNamesScalarVar.length - 1)]);
            aGene.setScalarVar(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, ExprScalarConstGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        return mutationCounter += this.mutate(env, aGene.getScalarConst(), -1.0, 1.0, aChromosome, depth + 1);
    }

    private int mutate(Environment env, ExprScalarArgsListGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        List<GeneType> list = aGene.getVarOrConstOrScalarExpression();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 2, 5, oldLength);
        this.cutList(newLength, list);
        for (GeneType obj : list) {
            if (obj instanceof ExprScalarArgsListGene) {
                mutationCounter += this.mutate(env, (ExprScalarArgsListGene)obj, aChromosome, depth + 1);
            }
            if (obj instanceof ExprScalarArgsListGene) {
                mutationCounter += this.mutate(env, (ExprScalarArgsListGene)obj, aChromosome, depth + 1);
            }
            if (!(obj instanceof ExprScalarArgsListGene)) continue;
            mutationCounter += this.mutate(env, (ExprScalarArgsListGene)obj, aChromosome, depth + 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            switch (CentralRandomizer.getInt(1, 3)) {
                case 1: {
                    ExprScalarArgsListGene aNewVar = objectFactory.createExprScalarArgsListGene();
                    this.randomize(aNewVar, aChromosome, depth + 1);
                    list.add(aNewVar);
                    break;
                }
                case 2: {
                    ExprScalarArgsListGene aNewConst = objectFactory.createExprScalarArgsListGene();
                    this.randomize(aNewConst, aChromosome, depth + 1);
                    list.add(aNewConst);
                    break;
                }
                case 3: {
                    ExprScalarArgsListGene aNewScalarExpression = objectFactory.createExprScalarArgsListGene();
                    this.randomize(aNewScalarExpression, aChromosome, depth + 1);
                    list.add(aNewScalarExpression);
                }
            }
            --append;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, ExprScalarListGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getOpr(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getArgs(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, ScalarExprGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        return mutationCounter += this.mutate(env, aGene.getList(), aChromosome, depth + 1);
    }

    public int mutate(Environment env, ScalarExpressionChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aChromosome.getScalarExpression(), (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getNoiseSeed(), (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getXScale(), (ChromosomeType)aChromosome, 1);
        return mutationCounter += this.mutate(env, aChromosome.getYScale(), (ChromosomeType)aChromosome, 1);
    }

    private int mutate(Environment env, ExprVectorOprGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        String[] enumNamesVectorOpr = new String[]{"add", "sub", "mult", "mod", "cross", "sincos", "atan", "maxvalue", "minvalue", "maxvector", "minvector", "maxmix", "invmix", "step", "noise", "turbulence", "waves"};
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            ExprVectorOprBase oldValue = aGene.getVectorOpr();
            ExprVectorOprBase newValue = ExprVectorOprBase.fromValue(enumNamesVectorOpr[CentralRandomizer.getInt(enumNamesVectorOpr.length - 1)]);
            aGene.setVectorOpr(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, ExprVectorVarGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        String[] enumNamesVectorVar = new String[]{"xyr", "xym", "xyt", "cmpow", "cmsinh", "cmim", "cmre"};
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            ExprVectorVarBase oldValue = aGene.getVectorVar();
            ExprVectorVarBase newValue = ExprVectorVarBase.fromValue(enumNamesVectorVar[CentralRandomizer.getInt(enumNamesVectorVar.length - 1)]);
            aGene.setVectorVar(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, ExprVectorConstGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getCx(), -1.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getCy(), -1.0, 1.0, aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getCz(), -1.0, 1.0, aChromosome, depth + 1);
    }

    private int mutate(Environment env, ExprVectorArgsListGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        List<GeneType> list = aGene.getVarOrConstOrVectorExpression();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 2, 2, oldLength);
        this.cutList(newLength, list);
        for (GeneType obj : list) {
            if (obj instanceof ExprVectorArgsListGene) {
                mutationCounter += this.mutate(env, (ExprVectorArgsListGene)obj, aChromosome, depth + 1);
            }
            if (obj instanceof ExprVectorArgsListGene) {
                mutationCounter += this.mutate(env, (ExprVectorArgsListGene)obj, aChromosome, depth + 1);
            }
            if (!(obj instanceof ExprVectorArgsListGene)) continue;
            mutationCounter += this.mutate(env, (ExprVectorArgsListGene)obj, aChromosome, depth + 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            switch (CentralRandomizer.getInt(1, 3)) {
                case 1: {
                    ExprVectorArgsListGene aNewVar = objectFactory.createExprVectorArgsListGene();
                    this.randomize(aNewVar, aChromosome, depth + 1);
                    list.add(aNewVar);
                    break;
                }
                case 2: {
                    ExprVectorArgsListGene aNewConst = objectFactory.createExprVectorArgsListGene();
                    this.randomize(aNewConst, aChromosome, depth + 1);
                    list.add(aNewConst);
                    break;
                }
                case 3: {
                    ExprVectorArgsListGene aNewVectorExpression = objectFactory.createExprVectorArgsListGene();
                    this.randomize(aNewVectorExpression, aChromosome, depth + 1);
                    list.add(aNewVectorExpression);
                }
            }
            --append;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, ExprVectorListGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getOpr(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getArgs(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, VectorExprGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        return mutationCounter += this.mutate(env, aGene.getList(), aChromosome, depth + 1);
    }

    public int mutate(Environment env, VectorExpressionChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aChromosome.getVectorExpression(), (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getNoiseSeed(), (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getXScale(), (ChromosomeType)aChromosome, 1);
        return mutationCounter += this.mutate(env, aChromosome.getYScale(), (ChromosomeType)aChromosome, 1);
    }

    private int mutate(Environment env, AlphabetGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            String oldValue = new String(aGene.getValue());
            LsysGenetic.mutateAlphabet(aGene, (LsysChromosome)aChromosome);
            if (!aGene.getValue().equals(oldValue)) {
                ++mutationCounter;
            }
        }
        return mutationCounter;
    }

    private int mutate(Environment env, AxiomGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            String oldValue = new String(aGene.getValue());
            LsysGenetic.mutateAxiom(aGene, (LsysChromosome)aChromosome);
            if (!aGene.getValue().equals(oldValue)) {
                ++mutationCounter;
            }
        }
        return mutationCounter;
    }

    private int mutate(Environment env, IgnoreGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            String oldValue = new String(aGene.getValue());
            LsysGenetic.mutateIgnore(aGene, (LsysChromosome)aChromosome);
            if (!aGene.getValue().equals(oldValue)) {
                ++mutationCounter;
            }
        }
        return mutationCounter;
    }

    private int mutate(Environment env, PredecessorGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            String oldValue = new String(aGene.getValue());
            LsysGenetic.mutatePredecessor(aGene, (LsysChromosome)aChromosome);
            if (!aGene.getValue().equals(oldValue)) {
                ++mutationCounter;
            }
        }
        return mutationCounter;
    }

    private int mutate(Environment env, ContextGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            String oldValue = new String(aGene.getValue());
            LsysGenetic.mutateContext(aGene, (LsysChromosome)aChromosome);
            if (!aGene.getValue().equals(oldValue)) {
                ++mutationCounter;
            }
        }
        return mutationCounter;
    }

    private int mutate(Environment env, SuccessorGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            String oldValue = new String(aGene.getValue());
            LsysGenetic.mutateSuccessor(aGene, (LsysChromosome)aChromosome);
            if (!aGene.getValue().equals(oldValue)) {
                ++mutationCounter;
            }
        }
        return mutationCounter;
    }

    private int mutate(Environment env, LsysProductionGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getPredecessor(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSuccessor(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getLeftContext(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getRightContext(), aChromosome, depth + 1);
    }

    public int mutate(Environment env, LsysChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aChromosome.getAlphabet(), (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getAxiom(), (ChromosomeType)aChromosome, 1);
        List<LsysProductionGene> list = aChromosome.getProduction();
        int oldLength = list.size();
        int newLength = LsysGenetic.getNumberOfProductions(aChromosome);
        this.cutList(newLength, list);
        Iterator<LsysProductionGene> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), (ChromosomeType)aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            LsysProductionGene newGene = objectFactory.createLsysProductionGene();
            this.randomize(newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        mutationCounter += this.scrambleList(env, list);
        mutationCounter += this.mutate(env, aChromosome.getDirections(), 1, 36, (ChromosomeType)aChromosome, 1);
        return mutationCounter += this.mutate(env, aChromosome.getBaseIndex(), 0, 256, (ChromosomeType)aChromosome, 1);
    }

    public int mutate(Environment env, LsysD0LChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, (LsysChromosome)aChromosome);
        return mutationCounter += this.mutate(env, aChromosome.getDepth(), 1, 12, (ChromosomeType)aChromosome, 1);
    }

    public int mutate(Environment env, Lsys0LChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, (LsysChromosome)aChromosome);
        mutationCounter += this.mutate(env, aChromosome.getDepth(), 1, 12, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getJitter(), 0, 100, (ChromosomeType)aChromosome, 1);
        return mutationCounter += this.mutate(env, aChromosome.getNoiseSeed(), (ChromosomeType)aChromosome, 1);
    }

    public int mutate(Environment env, LsysILChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, (LsysChromosome)aChromosome);
        mutationCounter += this.mutate(env, aChromosome.getIgnore(), (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getDepth(), 1, 12, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getJitter(), 0, 100, (ChromosomeType)aChromosome, 1);
        return mutationCounter += this.mutate(env, aChromosome.getNoiseSeed(), (ChromosomeType)aChromosome, 1);
    }

    private int mutate(Environment env, NormalizedVector3Gene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getX(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getY(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getZ(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, Matrix4X3Gene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getVal00(), -1.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getVal01(), -1.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getVal02(), -1.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getVal10(), -1.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getVal11(), -1.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getVal12(), -1.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getVal20(), -1.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getVal21(), -1.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getVal22(), -1.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getVal30(), -1.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getVal31(), -1.0, 1.0, aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getVal32(), -1.0, 1.0, aChromosome, depth + 1);
    }

    private int mutate(Environment env, PovTurbulenceWarpGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getTurbulenceVector(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getOctaves(), 1, 6, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getOmega(), 0.01, 0.99, aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getLambda(), 1.0, 2.5, aChromosome, depth + 1);
    }

    private int mutate(Environment env, PovBlackHoleWarpGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getLocation(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getRadius(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getFalloff(), 0.1, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getStrength(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getInvers(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, HsbftGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, (HsbColorGene)aGene, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getFilter(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getTransmit(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, ColorMapEntryGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getWeight(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getHsbft(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, PovColorMapGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        String[] enumNamesMapPattern = new String[]{"boxed", "bozo", "bumps", "cells", "cylindrical", "dents", "granite", "leopard", "marble", "onion", "planar", "radial", "ripples", "spherical", "spotted", "waves", "wood", "wrinkles"};
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            PovMapPatternBase oldValue = aGene.getMapPattern();
            PovMapPatternBase newValue = PovMapPatternBase.fromValue(enumNamesMapPattern[CentralRandomizer.getInt(enumNamesMapPattern.length - 1)]);
            aGene.setMapPattern(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        List<ColorMapEntryGene> list = aGene.getColor();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 2, 256, oldLength);
        this.cutList(newLength, list);
        Iterator<ColorMapEntryGene> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            ColorMapEntryGene newGene = objectFactory.createColorMapEntryGene();
            this.randomize(newGene, aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        return mutationCounter += this.scrambleList(env, list);
    }

    private int mutate(Environment env, PovTransformMapGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getMatrix(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getInvers(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, PovWarpGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getTurbulence(), aChromosome, depth + 1);
        List<PovBlackHoleWarpGene> list = aGene.getBlackHole();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 0, 10, oldLength);
        this.cutList(newLength, list);
        Iterator<PovBlackHoleWarpGene> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            PovBlackHoleWarpGene newGene = objectFactory.createPovBlackHoleWarpGene();
            this.randomize(newGene, aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        return mutationCounter += this.scrambleList(env, list);
    }

    private int mutate(Environment env, PovBlendGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        String[] enumNamesBlendMapModifier = new String[]{"ramp_wave", "triangle_wave", "sine_wave", "scallop_wave", "cubic_wave", "poly_wave"};
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            PovBlendMapModifierBase oldValue = aGene.getBlendMapModifier();
            PovBlendMapModifierBase newValue = PovBlendMapModifierBase.fromValue(enumNamesBlendMapModifier[CentralRandomizer.getInt(enumNamesBlendMapModifier.length - 1)]);
            aGene.setBlendMapModifier(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        mutationCounter += this.mutate(env, aGene.getBlendMapFrequency(), 0.1, 10.0, aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getBlendMapPhase(), 0.0, 1.0, aChromosome, depth + 1);
    }

    private int mutate(Environment env, PovPigmentGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getColorMap(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getWarp(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getTransform(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getBlend(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, NormalMapEntryGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getWeight(), aChromosome, depth + 1);
        String[] enumNamesMapPattern = new String[]{"boxed", "bozo", "bumps", "cells", "cylindrical", "dents", "granite", "leopard", "marble", "onion", "planar", "radial", "ripples", "spherical", "spotted", "waves", "wood", "wrinkles"};
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            PovMapPatternBase oldValue = aGene.getMapPattern();
            PovMapPatternBase newValue = PovMapPatternBase.fromValue(enumNamesMapPattern[CentralRandomizer.getInt(enumNamesMapPattern.length - 1)]);
            aGene.setMapPattern(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        mutationCounter += this.mutate(env, aGene.getDepth(), 0.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getBumpSize(), 0.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getWarp(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getTransform(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, PovNormalMapGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getAverage(), aChromosome, depth + 1);
        String[] enumNamesMapPattern = new String[]{"boxed", "bozo", "bumps", "cells", "cylindrical", "dents", "granite", "leopard", "marble", "onion", "planar", "radial", "ripples", "spherical", "spotted", "waves", "wood", "wrinkles"};
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            PovMapPatternBase oldValue = aGene.getMapPattern();
            PovMapPatternBase newValue = PovMapPatternBase.fromValue(enumNamesMapPattern[CentralRandomizer.getInt(enumNamesMapPattern.length - 1)]);
            aGene.setMapPattern(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        List<NormalMapEntryGene> list = aGene.getNormal();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 2, 256, oldLength);
        this.cutList(newLength, list);
        Iterator<NormalMapEntryGene> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            NormalMapEntryGene newGene = objectFactory.createNormalMapEntryGene();
            this.randomize(newGene, aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        return mutationCounter += this.scrambleList(env, list);
    }

    private int mutate(Environment env, PovNormalGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getNormalMap(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getWarp(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getTransform(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getBlend(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, PovReflectionGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getColor(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getMetallic(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, PovFinishGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getAmbient(), 0.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getDiffuse(), 0.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSpecular(), 0.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getRoughness(), 0.001, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getMetallic(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getReflection(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, PovTextureLayerGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        return mutationCounter += this.mutate(env, aGene.getPigment(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, PovThingGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        return mutationCounter;
    }

    public int mutate(Environment env, PovThingChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aChromosome.getThing(), (ChromosomeType)aChromosome, 1);
        List<PovTextureLayerGene> list = aChromosome.getTextureLayer();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 2, 20, oldLength);
        this.cutList(newLength, list);
        Iterator<PovTextureLayerGene> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), (ChromosomeType)aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            PovTextureLayerGene newGene = objectFactory.createPovTextureLayerGene();
            this.randomize(newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        return mutationCounter += this.scrambleList(env, list);
    }

    public int mutate(Environment env, PovThingNFChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, (PovThingChromosome)aChromosome);
        mutationCounter += this.mutate(env, aChromosome.getNormal(), (ChromosomeType)aChromosome, 1);
        return mutationCounter += this.mutate(env, aChromosome.getFinish(), (ChromosomeType)aChromosome, 1);
    }

    private int mutate(Environment env, ExprSdlOprGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        String[] enumNamesSdlOpr = new String[]{"add", "mult", "sub", "div", "max", "min", "mod", "noise", "snoise", "atanq", "pow", "sqrt", "pow", "abs", "acos", "acosh", "asin", "asinh", "atan", "atanh", "ceil", "cos", "cosh", "degrees", "exp", "floor", "ln", "log", "radians", "sin", "sinh", "sqrt", "tan", "tanh"};
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            ExprSdlOprBase oldValue = aGene.getSdlOpr();
            ExprSdlOprBase newValue = ExprSdlOprBase.fromValue(enumNamesSdlOpr[CentralRandomizer.getInt(enumNamesSdlOpr.length - 1)]);
            aGene.setSdlOpr(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, ExprSdlVarGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        String[] enumNamesSdlVar = new String[]{"x", "y", "z"};
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            ExprSdlVarBase oldValue = aGene.getSdlVar();
            ExprSdlVarBase newValue = ExprSdlVarBase.fromValue(enumNamesSdlVar[CentralRandomizer.getInt(enumNamesSdlVar.length - 1)]);
            aGene.setSdlVar(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, ExprSdlConstGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        return mutationCounter += this.mutate(env, aGene.getSdlConst(), -1.0, 1.0, aChromosome, depth + 1);
    }

    private int mutate(Environment env, ExprSdlArgsListGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        List<GeneType> list = aGene.getVarOrConstOrSdlExpression();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 2, 5, oldLength);
        this.cutList(newLength, list);
        for (GeneType obj : list) {
            if (obj instanceof ExprSdlArgsListGene) {
                mutationCounter += this.mutate(env, (ExprSdlArgsListGene)obj, aChromosome, depth + 1);
            }
            if (obj instanceof ExprSdlArgsListGene) {
                mutationCounter += this.mutate(env, (ExprSdlArgsListGene)obj, aChromosome, depth + 1);
            }
            if (!(obj instanceof ExprSdlArgsListGene)) continue;
            mutationCounter += this.mutate(env, (ExprSdlArgsListGene)obj, aChromosome, depth + 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            switch (CentralRandomizer.getInt(1, 3)) {
                case 1: {
                    ExprSdlArgsListGene aNewVar = objectFactory.createExprSdlArgsListGene();
                    this.randomize(aNewVar, aChromosome, depth + 1);
                    list.add(aNewVar);
                    break;
                }
                case 2: {
                    ExprSdlArgsListGene aNewConst = objectFactory.createExprSdlArgsListGene();
                    this.randomize(aNewConst, aChromosome, depth + 1);
                    list.add(aNewConst);
                    break;
                }
                case 3: {
                    ExprSdlArgsListGene aNewSdlExpression = objectFactory.createExprSdlArgsListGene();
                    this.randomize(aNewSdlExpression, aChromosome, depth + 1);
                    list.add(aNewSdlExpression);
                }
            }
            --append;
        }
        return mutationCounter;
    }

    private int mutate(Environment env, ExprSdlListGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getOpr(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getArgs(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, SdlExpressionGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        return mutationCounter += this.mutate(env, aGene.getList(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, PovRotateGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getRx(), -180.0, 180.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getRy(), -180.0, 180.0, aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getRz(), -180.0, 180.0, aChromosome, depth + 1);
    }

    private int mutate(Environment env, PovRidgedMultifractalGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getFx(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getFy(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getFz(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getH(), 0.0, 1.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getLacunarity(), 1.0, 100.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getOctaves(), 1, 6, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getOffset(), 0.0, 1.0, aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getGain(), 0.0, 1.0, aChromosome, depth + 1);
    }

    public int mutate(Environment env, PovIsoSurfaceChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, (PovThingNFChromosome)aChromosome);
        mutationCounter += this.mutate(env, aChromosome.getRidgedMultifractal(), (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getThreshold(), (ChromosomeType)aChromosome, 1);
        return mutationCounter += this.mutate(env, aChromosome.getRotate(), (ChromosomeType)aChromosome, 1);
    }

    private int mutate(Environment env, AbstractTutorialShapeGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getColor(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getTransparency(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getX(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getY(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, TutorialCircleGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, (AbstractTutorialShapeGene)aGene, aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getRadius(), aChromosome, depth + 1);
    }

    public int mutate(Environment env, TutorialShapeChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        List<TutorialCircleGene> list = aChromosome.getAllShapes();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 2, 100, oldLength);
        this.cutList(newLength, list);
        Iterator<TutorialCircleGene> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), (ChromosomeType)aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            TutorialCircleGene newGene = objectFactory.createTutorialCircleGene();
            this.randomize(newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        mutationCounter += this.scrambleList(env, list);
        return mutationCounter += this.mutate(env, aChromosome.getColor(), (ChromosomeType)aChromosome, 1);
    }

    private int mutate(Environment env, WarpingTurbulenceGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aGene.getTimeCoord(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getOctaves(), 0.0, 7.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getAmpscale(), 0.2, 0.8, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getFreqscale(), 1.0, 4.0, aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getScaleOut(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getScaleXin(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getScaleYin(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSource1(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSource2(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSource3(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSource4(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSeed1(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSeed2(), aChromosome, depth + 1);
        mutationCounter += this.mutate(env, aGene.getSeed3(), aChromosome, depth + 1);
        return mutationCounter += this.mutate(env, aGene.getSeed4(), aChromosome, depth + 1);
    }

    private int mutate(Environment env, WarpingLayerGene aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
        int mutationCounter = 0;
        List<WarpingTurbulenceGene> list = aGene.getTerm();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 1, 2, oldLength);
        this.cutList(newLength, list);
        Iterator<WarpingTurbulenceGene> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            WarpingTurbulenceGene newGene = objectFactory.createWarpingTurbulenceGene();
            this.randomize(newGene, aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        return mutationCounter += this.scrambleList(env, list);
    }

    public int mutate(Environment env, DomainWarpingChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        mutationCounter += this.mutate(env, aChromosome.getMainscale(), 0.1, 10.0, (ChromosomeType)aChromosome, 1);
        mutationCounter += this.mutate(env, aChromosome.getGradientgain(), 0.001, 0.999, (ChromosomeType)aChromosome, 1);
        List<WarpingLayerGene> list = aChromosome.getWarpingLayer();
        int oldLength = list.size();
        int newLength = this.mutateListLength(env, 1, 5, oldLength);
        this.cutList(newLength, list);
        Iterator<WarpingLayerGene> iter = list.iterator();
        while (iter.hasNext()) {
            mutationCounter += this.mutate(env, iter.next(), (ChromosomeType)aChromosome, 1);
        }
        int append = newLength - oldLength;
        while (append > 0) {
            WarpingLayerGene newGene = objectFactory.createWarpingLayerGene();
            this.randomize(newGene, (ChromosomeType)aChromosome, 0);
            list.add(newGene);
            --append;
        }
        mutationCounter += newLength > oldLength ? newLength - oldLength : oldLength - newLength;
        return mutationCounter += this.scrambleList(env, list);
    }

    public int mutate(Environment env, DomainWarpingChladniNoiseChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        return mutationCounter += this.mutate(env, (DomainWarpingChromosome)aChromosome);
    }

    public int mutate(Environment env, DomainWarpingChladniWorleyNoiseChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        return mutationCounter += this.mutate(env, (DomainWarpingChromosome)aChromosome);
    }

    public int mutate(Environment env, DomainWarpingChladniWorleyPerlinNoiseChromosome aChromosome) throws JAXBException {
        int mutationCounter = 0;
        return mutationCounter += this.mutate(env, (DomainWarpingChromosome)aChromosome);
    }
}

