/*
 * Decompiled with CFR 0.152.
 */
package kandid.soup.genetic.vectorvm;

import java.util.Collections;
import java.util.List;
import kandid.Environment;
import kandid.soup.ExprVectorConstGene;
import kandid.soup.ExprVectorListGene;
import kandid.soup.ExprVectorOprBase;
import kandid.soup.ExprVectorVarBase;
import kandid.soup.ExprVectorVarGene;
import kandid.soup.GeneType;
import kandid.soup.SeedGene;
import kandid.soup.SymmetricGene;
import kandid.soup.VectorExprGene;
import kandid.soup.VectorExpressionChromosome;
import kandid.util.CentralRandomizer;

public class Mutator {
    public static int mutate(Environment env, VectorExpressionChromosome aChromosome) {
        int mutationCounter = 0;
        mutationCounter += Mutator.mutate(env, aChromosome.getNoiseSeed());
        mutationCounter += Mutator.mutate(env, aChromosome.getXScale());
        mutationCounter += Mutator.mutate(env, aChromosome.getYScale());
        return mutationCounter += Mutator.mutate(env, aChromosome.getVectorExpression(), 1);
    }

    private static int mutate(Environment env, VectorExprGene scalarExpression, int depth) {
        int mutationCounter = 0;
        ExprVectorListGene expr_list = scalarExpression.getList();
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            ExprVectorOprBase old_opr = expr_list.getOpr().getVectorOpr();
            ExprVectorOprBase[] possible_oprs = ExprVectorOprBase.values();
            ExprVectorOprBase new_opr = possible_oprs[CentralRandomizer.getInt(possible_oprs.length - 1)];
            expr_list.getOpr().setVectorOpr(new_opr);
            mutationCounter += old_opr != new_opr ? 1 : 0;
        }
        List<GeneType> vce1_list = expr_list.getArgs().getVarOrConstOrVectorExpression();
        int length1 = vce1_list.size();
        int ci = 0;
        while (ci < length1) {
            GeneType vce1 = vce1_list.get(ci);
            if (vce1 instanceof ExprVectorVarGene) {
                mutationCounter += Mutator.mutate_var_gene(env, (ExprVectorVarGene)vce1);
            } else if (vce1 instanceof ExprVectorConstGene) {
                mutationCounter += Mutator.mutate_const_gene(env, (ExprVectorConstGene)vce1);
            } else if (vce1 instanceof VectorExprGene) {
                mutationCounter += Mutator.mutate(env, (VectorExprGene)vce1, depth + 1);
            } else assert (false) : "no strategy for mutating " + vce1.getClass().getName();
            ++ci;
        }
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            Collections.shuffle(vce1_list);
            ++mutationCounter;
        }
        return mutationCounter;
    }

    private static int mutate_const_gene(Environment env, ExprVectorConstGene const_gene) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            double old_const = const_gene.getCx().getValue();
            double new_const = old_const + env.getScaleFactor() * CentralRandomizer.getGaussian();
            if (new_const < -1.0) {
                new_const = -1.0;
            } else if (new_const > 1.0) {
                new_const = 1.0;
            }
            const_gene.getCx().setValue(new_const);
            mutationCounter += old_const != new_const ? 1 : 0;
            old_const = const_gene.getCy().getValue();
            new_const = old_const + env.getScaleFactor() * CentralRandomizer.getGaussian();
            if (new_const < -1.0) {
                new_const = -1.0;
            } else if (new_const > 1.0) {
                new_const = 1.0;
            }
            const_gene.getCy().setValue(new_const);
            mutationCounter += old_const != new_const ? 1 : 0;
            old_const = const_gene.getCz().getValue();
            new_const = old_const + env.getScaleFactor() * CentralRandomizer.getGaussian();
            if (new_const < -1.0) {
                new_const = -1.0;
            } else if (new_const > 1.0) {
                new_const = 1.0;
            }
            const_gene.getCz().setValue(new_const);
            mutationCounter += old_const != new_const ? 1 : 0;
        }
        return mutationCounter;
    }

    private static int mutate_var_gene(Environment env, ExprVectorVarGene var_gene) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            ExprVectorVarBase old_var = var_gene.getVectorVar();
            ExprVectorVarBase[] possible_vars = ExprVectorVarBase.values();
            ExprVectorVarBase new_var = possible_vars[CentralRandomizer.getInt(possible_vars.length - 1)];
            var_gene.setVectorVar(new_var);
            mutationCounter += old_var != new_var ? 1 : 0;
        }
        return mutationCounter;
    }

    private static int mutate(Environment env, SeedGene aGene) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            long old_seed = aGene.getValue();
            long new_seed = CentralRandomizer.getLong();
            aGene.setValue(new_seed);
            mutationCounter += old_seed != new_seed ? 1 : 0;
        }
        return mutationCounter;
    }

    private static int mutate(Environment env, SymmetricGene aGene) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            double oldValue = aGene.getValue();
            double newValue = oldValue + env.getScaleFactor() * CentralRandomizer.getGaussian();
            if (newValue < -1.0) {
                newValue = -1.0;
            } else if (newValue > 1.0) {
                newValue = 1.0;
            }
            aGene.setValue(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }
}

