/*
 * Decompiled with CFR 0.152.
 */
package kandid.soup.genetic.scalarvm;

import java.util.List;
import kandid.soup.DoubleGene;
import kandid.soup.ExprScalarArgsListGene;
import kandid.soup.ExprScalarConstGene;
import kandid.soup.ExprScalarListGene;
import kandid.soup.ExprScalarOprBase;
import kandid.soup.ExprScalarOprGene;
import kandid.soup.ExprScalarVarBase;
import kandid.soup.ExprScalarVarGene;
import kandid.soup.GeneType;
import kandid.soup.ObjectFactory;
import kandid.soup.ScalarExprGene;
import kandid.soup.ScalarExpressionChromosome;
import kandid.soup.SeedGene;
import kandid.soup.SymmetricGene;
import kandid.util.CentralRandomizer;

public class Randomizer {
    private static ObjectFactory objectFactory = new ObjectFactory();

    public static ScalarExpressionChromosome create() {
        ScalarExpressionChromosome chromosome = objectFactory.createScalarExpressionChromosome();
        ScalarExprGene new_scalarExpression = objectFactory.createScalarExprGene();
        Randomizer.randomize(new_scalarExpression, 1);
        chromosome.setScalarExpression(new_scalarExpression);
        SeedGene new_noiseSeed = objectFactory.createSeedGene();
        new_noiseSeed.setValue(CentralRandomizer.getLong());
        chromosome.setNoiseSeed(new_noiseSeed);
        SymmetricGene new_x_scale = objectFactory.createSymmetricGene();
        new_x_scale.setValue(CentralRandomizer.getDouble(-1.0, 1.0));
        chromosome.setXScale(new_x_scale);
        SymmetricGene new_y_scale = objectFactory.createSymmetricGene();
        new_y_scale.setValue(CentralRandomizer.getDouble(-1.0, 1.0));
        chromosome.setYScale(new_y_scale);
        return chromosome;
    }

    static void randomize(ScalarExprGene aScalarExpression, int depth) {
        ExprScalarListGene new_list = objectFactory.createExprScalarListGene();
        aScalarExpression.setList(new_list);
        new_list.setOpr(Randomizer.randomize_opr());
        new_list.setArgs(Randomizer.randomize_argslist(depth + 1));
    }

    private static ExprScalarArgsListGene randomize_argslist(int depth) {
        ExprScalarArgsListGene new_argslist = objectFactory.createExprScalarArgsListGene();
        List<GeneType> vce1_list = new_argslist.getVarOrConstOrScalarExpression();
        int len = CentralRandomizer.getInt(2, 5);
        while (len > 0) {
            switch (CentralRandomizer.getInt(1, 3)) {
                case 1: {
                    vce1_list.add(Randomizer.randomize_var());
                    --len;
                    break;
                }
                case 2: {
                    vce1_list.add(Randomizer.randomize_const());
                    --len;
                    break;
                }
                case 3: {
                    if (!(CentralRandomizer.getDouble(0.0, 0.15) < 1.0 / (double)depth)) break;
                    ScalarExprGene new_scalar_expression = objectFactory.createScalarExprGene();
                    Randomizer.randomize(new_scalar_expression, depth + 1);
                    vce1_list.add(new_scalar_expression);
                    --len;
                }
            }
        }
        return new_argslist;
    }

    static ExprScalarConstGene randomize_const() {
        ExprScalarConstGene new_const = objectFactory.createExprScalarConstGene();
        DoubleGene new_double = objectFactory.createDoubleGene();
        new_double.setValue(CentralRandomizer.getDouble(-1.0, 1.0));
        new_const.setScalarConst(new_double);
        return new_const;
    }

    static ExprScalarVarGene randomize_var() {
        ExprScalarVarBase[] possible_vars = ExprScalarVarBase.values();
        ExprScalarVarBase new_var = possible_vars[CentralRandomizer.getInt(possible_vars.length - 1)];
        ExprScalarVarGene new_var_gene = objectFactory.createExprScalarVarGene();
        new_var_gene.setScalarVar(new_var);
        return new_var_gene;
    }

    private static ExprScalarOprGene randomize_opr() {
        ExprScalarOprGene new_opr_gene = objectFactory.createExprScalarOprGene();
        ExprScalarOprBase[] possible_oprs = ExprScalarOprBase.values();
        ExprScalarOprBase new_opr = possible_oprs[CentralRandomizer.getInt(possible_oprs.length - 1)];
        new_opr_gene.setScalarOpr(new_opr);
        return new_opr_gene;
    }
}

