/*
 * Decompiled with CFR 0.152.
 */
package kandid.preference.ui;

import java.awt.Frame;
import java.io.File;
import kandid.Kandid;
import kandid.preference.GenomeDBType;
import kandid.preference.HttpProxyType;
import kandid.preference.OutgoingMailType;
import kandid.preference.PreferenceType;
import kandid.preference.UserType;
import kandid.preference.ui.UiPreference;
import kandid.preference.util.PasswordHelper;
import kandid.preference.util.PreferenceModel;
import kandid.util.Debug;

public class IlPreference {
    private static IlPreference preferenceController = null;
    private UiPreference uiPreference;
    private PreferenceModel preferenceModel;

    public void initialize() {
        this.uiPreference = new UiPreference(this);
        this.preferenceModel = PreferenceModel.getInstance();
        File filebaseDir = new File("filebase");
        this.uiPreference.getFilebaseTextField().setText(filebaseDir.getAbsolutePath());
        File incommingDir = new File("incoming");
        this.uiPreference.getIncommingTextField().setText(incommingDir.getAbsolutePath());
        File scratchDir = new File(Kandid.scratchFolder);
        this.uiPreference.getScratchTextField().setText(scratchDir.getAbsolutePath());
        File cacheDir = new File(Kandid.cacheFolder);
        this.uiPreference.getCacheTextField().setText(cacheDir.getAbsolutePath());
    }

    public void apply() {
        this.save();
    }

    public void ok() {
        this.save();
        this.uiPreference.setVisible(false);
        this.uiPreference.dispose();
    }

    public void cancel() {
        this.uiPreference.setVisible(false);
        this.uiPreference.dispose();
    }

    public void mapFromEditor() {
        PreferenceType preference = this.preferenceModel.getPreference();
        try {
            UserType user = this.preferenceModel.getObjectFactory().createUserType();
            user.setNickname(this.uiPreference.getNicknameTextField().getText());
            user.setEmail(this.uiPreference.getMailTextField().getText());
            preference.setUser(user);
            OutgoingMailType outgoingMail = this.preferenceModel.getObjectFactory().createOutgoingMailType();
            outgoingMail.setSmptHost(this.uiPreference.getSmtpTextField().getText());
            preference.setOutgoingMail(outgoingMail);
            HttpProxyType httpProxy = this.preferenceModel.getObjectFactory().createHttpProxyType();
            httpProxy.setEnabled(this.uiPreference.getEnableProxyCheckBox().isSelected());
            httpProxy.setHost(this.uiPreference.getProxyHostTextField().getText());
            try {
                httpProxy.setPort(Integer.parseInt(this.uiPreference.getProxyPortTextField().getText()));
            }
            catch (NumberFormatException nfexc) {
                httpProxy.setPort(80);
            }
            httpProxy.setNonProxyHosts(this.uiPreference.getNonProxyHostsTextField().getText());
            httpProxy.setUsername(this.uiPreference.getUsernameTextField().getText());
            char[] password = this.uiPreference.getJPasswordField().getPassword();
            httpProxy.setPassword(PasswordHelper.deconstruct(new String(password)));
            preference.setHttpProxy(httpProxy);
            GenomeDBType genomeDB = this.preferenceModel.getObjectFactory().createGenomeDBType();
            genomeDB.setURL(this.uiPreference.getWebDbUrlTextField().getText());
            try {
                genomeDB.setTimeout(Integer.parseInt(this.uiPreference.getTimeoutTextField().getText()));
            }
            catch (NumberFormatException nfexc) {
                genomeDB.setTimeout(50000);
            }
            try {
                genomeDB.setInstallationId(Integer.parseInt(this.uiPreference.getInstallIdTextField().getText()));
            }
            catch (NumberFormatException nfexc) {
                genomeDB.setInstallationId(0);
            }
            preference.setGenomeDB(genomeDB);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
    }

    public void mapToEditor() {
        try {
            GenomeDBType genomeDB;
            HttpProxyType httpProxy;
            OutgoingMailType outgoingMail;
            PreferenceType preference = this.preferenceModel.getPreference();
            UserType user = preference.getUser();
            if (user != null) {
                this.uiPreference.getNicknameTextField().setText(user.getNickname());
                this.uiPreference.getMailTextField().setText(user.getEmail());
            }
            if ((outgoingMail = preference.getOutgoingMail()) != null) {
                this.uiPreference.getSmtpTextField().setText(outgoingMail.getSmptHost());
            }
            if ((httpProxy = preference.getHttpProxy()) != null) {
                this.uiPreference.getEnableProxyCheckBox().setSelected(httpProxy.isEnabled());
                this.uiPreference.getProxyHostTextField().setText(httpProxy.getHost());
                this.uiPreference.getProxyPortTextField().setText("" + httpProxy.getPort());
                this.uiPreference.getNonProxyHostsTextField().setText(httpProxy.getNonProxyHosts());
                this.uiPreference.getUsernameTextField().setText(httpProxy.getUsername());
                this.uiPreference.getJPasswordField().setText(PasswordHelper.construct(httpProxy.getPassword()));
            }
            if ((genomeDB = preference.getGenomeDB()) != null) {
                this.uiPreference.getWebDbUrlTextField().setText(genomeDB.getURL());
                this.uiPreference.getWebDbUrlTextField().setCaretPosition(0);
                this.uiPreference.getTimeoutTextField().setText("" + genomeDB.getTimeout());
                this.uiPreference.getInstallIdTextField().setText("" + genomeDB.getInstallationId());
            }
            this.enableProxy();
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
    }

    public static IlPreference showInstance(int tab, Frame parent) {
        preferenceController = IlPreference.getInstance();
        preferenceController.mapToEditor();
        IlPreference.preferenceController.uiPreference.pack();
        IlPreference.preferenceController.uiPreference.setLocationRelativeTo(parent);
        try {
            IlPreference.preferenceController.uiPreference.getJTabbedPane().setSelectedIndex(tab);
        }
        catch (IndexOutOfBoundsException exc) {
            Debug.stackTrace(exc);
        }
        IlPreference.preferenceController.uiPreference.setVisible(true);
        return preferenceController;
    }

    public static IlPreference getInstance() {
        if (preferenceController == null) {
            preferenceController = new IlPreference();
            preferenceController.initialize();
        }
        return preferenceController;
    }

    private void save() {
        this.mapFromEditor();
        this.preferenceModel.marshalToFile();
    }

    public void ensureLoadGenomeDBCompleted() {
        if (!this.preferenceModel.checkLoadGenomeDBCompleted()) {
            IlPreference.showInstance(1, null);
        }
    }

    public void ensureExportGenomeDBCompleted() {
        if (!this.preferenceModel.checkExportGenomeDBCompleted()) {
            IlPreference.showInstance(0, null);
        }
    }

    public void ensureOutgoingMailCompleted() {
        if (!this.preferenceModel.checkOutgoingMailCompleted()) {
            IlPreference.showInstance(3, null);
        }
    }

    public void enableProxy() {
        boolean enabled = this.uiPreference.getEnableProxyCheckBox().isSelected();
        this.uiPreference.getProxyHostTextField().setEnabled(enabled);
        this.uiPreference.getProxyPortTextField().setEnabled(enabled);
        this.uiPreference.getNonProxyHostsTextField().setEnabled(enabled);
        this.uiPreference.getUsernameTextField().setEnabled(enabled);
        this.uiPreference.getJPasswordField().setEnabled(enabled);
    }

    public static void main(String[] args) {
        IlPreference.showInstance(0, null);
    }
}

