/*
 * Decompiled with CFR 0.152.
 */
package kandid.pond.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import kandid.Kandid;
import kandid.pond.ui.IlPool;
import kandid.util.Debug;

public class UiPool
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel poolContentPane = null;
    private JPanel typePanel = null;
    private JPanel navigationPanel = null;
    private JPanel loadPanel = null;
    private JButton firstButton = null;
    private JButton leftButton = null;
    private JButton rightButton = null;
    private JButton lastButton = null;
    private JButton loadButton = null;
    private JScrollPane typeScrollPane = null;
    private JTree typeTree = null;
    private JPanel poolPanel = null;
    private JPanel selectionPanel = null;
    private JRadioButton bothRadioButton = null;
    private JRadioButton loadedRadioButton = null;
    private JRadioButton ownRadioButton = null;
    private JLabel jLabel = null;
    private ButtonGroup viewGroup = new ButtonGroup();
    private IlPool ilPool;
    private JPanel viewPanel = null;
    private JButton configureButton = null;
    private static ImageIcon firstImageIcon;
    private static ImageIcon leftImageIcon;
    private static ImageIcon rightImageIcon;
    private static ImageIcon lastImageIcon;
    private static ImageIcon loadImageIcon;
    private static ImageIcon configureImageIcon;

    public UiPool() {
        try {
            if (firstImageIcon == null) {
                firstImageIcon = Kandid.getInstance().createImageIcon("first.png", null);
            }
            if (leftImageIcon == null) {
                leftImageIcon = Kandid.getInstance().createImageIcon("left.png", null);
            }
            if (rightImageIcon == null) {
                rightImageIcon = Kandid.getInstance().createImageIcon("right.png", null);
            }
            if (lastImageIcon == null) {
                lastImageIcon = Kandid.getInstance().createImageIcon("last.png", null);
            }
            if (loadImageIcon == null) {
                loadImageIcon = Kandid.getInstance().createImageIcon("readdb.png", null);
            }
            if (configureImageIcon == null) {
                configureImageIcon = Kandid.getInstance().createImageIcon("preferences.png", null);
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        this.initialize();
        this.viewGroup.add(this.bothRadioButton);
        this.viewGroup.add(this.loadedRadioButton);
        this.viewGroup.add(this.ownRadioButton);
    }

    public UiPool(IlPool pool) {
        this();
        this.ilPool = pool;
    }

    private void initialize() {
        this.setContentPane(this.getPoolContentPane());
        this.setTitle("Image Pool");
    }

    protected JPanel getPoolContentPane() {
        if (this.poolContentPane == null) {
            this.poolContentPane = new JPanel();
            this.poolContentPane.setLayout(new BoxLayout(this.poolContentPane, 1));
            this.poolContentPane.setPreferredSize(new Dimension(450, 675));
            this.poolContentPane.add((Component)this.getPoolPanel(), null);
        }
        return this.poolContentPane;
    }

    private JPanel getTypePanel() {
        if (this.typePanel == null) {
            this.typePanel = new JPanel();
            this.typePanel.setLayout(new BoxLayout(this.typePanel, 0));
            this.typePanel.add((Component)this.getTypeScrollPane(), null);
            this.typePanel.add((Component)this.getViewPanel(), null);
        }
        return this.typePanel;
    }

    private JPanel getNavigationPanel() {
        if (this.navigationPanel == null) {
            this.navigationPanel = new JPanel();
            this.navigationPanel.add((Component)this.getFirstButton(), null);
            this.navigationPanel.add((Component)this.getLeftButton(), null);
            this.navigationPanel.add((Component)this.getRightButton(), null);
            this.navigationPanel.add((Component)this.getLastButton(), null);
        }
        return this.navigationPanel;
    }

    private JPanel getLoadPanel() {
        if (this.loadPanel == null) {
            this.loadPanel = new JPanel();
            this.loadPanel.setLayout(new FlowLayout());
            this.loadPanel.setBorder(BorderFactory.createTitledBorder(null, "WEB Database", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.loadPanel.add((Component)this.getLoadButton(), null);
            this.loadPanel.add((Component)this.getConfigureButton(), null);
        }
        return this.loadPanel;
    }

    protected JButton getFirstButton() {
        if (this.firstButton == null) {
            this.firstButton = new JButton();
            this.firstButton.setIcon(firstImageIcon);
            this.firstButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UiPool.this.ilPool.goTop();
                }
            });
        }
        return this.firstButton;
    }

    protected JButton getLeftButton() {
        if (this.leftButton == null) {
            this.leftButton = new JButton();
            this.leftButton.setIcon(leftImageIcon);
            this.leftButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UiPool.this.ilPool.goBackward();
                }
            });
        }
        return this.leftButton;
    }

    protected JButton getRightButton() {
        if (this.rightButton == null) {
            this.rightButton = new JButton();
            this.rightButton.setIcon(rightImageIcon);
            this.rightButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UiPool.this.ilPool.goForward();
                }
            });
        }
        return this.rightButton;
    }

    protected JButton getLastButton() {
        if (this.lastButton == null) {
            this.lastButton = new JButton();
            this.lastButton.setIcon(lastImageIcon);
            this.lastButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UiPool.this.ilPool.goBottom();
                }
            });
        }
        return this.lastButton;
    }

    protected JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setIcon(loadImageIcon);
            this.loadButton.setText("Load");
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UiPool.this.ilPool.load();
                }
            });
        }
        return this.loadButton;
    }

    private JScrollPane getTypeScrollPane() {
        if (this.typeScrollPane == null) {
            this.typeScrollPane = new JScrollPane();
            this.typeScrollPane.setViewportView(this.getTypeTree());
            this.typeScrollPane.setPreferredSize(new Dimension(82, 504));
        }
        return this.typeScrollPane;
    }

    protected JTree getTypeTree() {
        if (this.typeTree == null) {
            this.typeTree = new JTree();
            this.typeTree.setRootVisible(true);
            this.typeTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    UiPool.this.ilPool.nodeSelected(e);
                }
            });
        }
        return this.typeTree;
    }

    protected JPanel getPoolPanel() {
        if (this.poolPanel == null) {
            this.poolPanel = new JPanel();
            this.poolPanel.setLayout(new BoxLayout(this.poolPanel, 1));
            this.poolPanel.setBorder(BorderFactory.createTitledBorder(null, "Local Image Pool", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.poolPanel.add((Component)this.getTypePanel(), null);
            this.poolPanel.add((Component)this.getNavigationPanel(), null);
            this.poolPanel.add((Component)this.getSelectionPanel(), null);
        }
        return this.poolPanel;
    }

    private JPanel getSelectionPanel() {
        if (this.selectionPanel == null) {
            this.jLabel = new JLabel();
            FlowLayout flowLayout4 = new FlowLayout();
            this.selectionPanel = new JPanel();
            this.selectionPanel.setLayout(flowLayout4);
            flowLayout4.setVgap(0);
        }
        return this.selectionPanel;
    }

    protected JRadioButton getBothRadioButton() {
        if (this.bothRadioButton == null) {
            this.bothRadioButton = new JRadioButton();
            this.bothRadioButton.setSelected(true);
            this.bothRadioButton.setText("both");
            this.bothRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UiPool.this.ilPool.activateView();
                }
            });
        }
        return this.bothRadioButton;
    }

    protected JRadioButton getLoadedRadioButton() {
        if (this.loadedRadioButton == null) {
            this.loadedRadioButton = new JRadioButton();
            this.loadedRadioButton.setText("loaded");
            this.loadedRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UiPool.this.ilPool.activateView();
                }
            });
        }
        return this.loadedRadioButton;
    }

    protected JRadioButton getOwnRadioButton() {
        if (this.ownRadioButton == null) {
            this.ownRadioButton = new JRadioButton();
            this.ownRadioButton.setText("own");
            this.ownRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UiPool.this.ilPool.activateView();
                }
            });
        }
        return this.ownRadioButton;
    }

    protected JPanel getViewPanel() {
        if (this.viewPanel == null) {
            GridLayout gridLayout1 = new GridLayout();
            this.viewPanel = new JPanel();
            this.viewPanel.setLayout(gridLayout1);
            gridLayout1.setRows(5);
            gridLayout1.setColumns(2);
            gridLayout1.setHgap(1);
            gridLayout1.setVgap(1);
            this.viewPanel.setPreferredSize(new Dimension(203, 505));
            this.viewPanel.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        }
        return this.viewPanel;
    }

    private JButton getConfigureButton() {
        if (this.configureButton == null) {
            this.configureButton = new JButton();
            this.configureButton.setIcon(configureImageIcon);
            this.configureButton.setText("Configure");
            this.configureButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UiPool.this.ilPool.showPreference();
                }
            });
        }
        return this.configureButton;
    }
}

