/*
 * Decompiled with CFR 0.152.
 */
package kandid.pond.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import kandid.IconLoader;
import kandid.pond.ui.IlLoadWizzard;
import kandid.pond.ui.IlPool;

public class UiLoadWizzard
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel cardPanel = null;
    private JPanel navigationPanel = null;
    private JButton cancelButton = null;
    private JButton nextButton = null;
    private JPanel card1Panel = null;
    private JPanel card2Panel = null;
    private JLabel selectionLabel = null;
    private JRadioButton sameColorRadioButton = null;
    private JRadioButton sameCalculationRadioButton = null;
    private JPanel licensePanel = null;
    private JPanel agreePanel = null;
    private JRadioButton notAgreeRadioButton = null;
    private JRadioButton agreeRadioButton = null;
    private JScrollPane jScrollPane = null;
    private JEditorPane jEditorPane = null;
    private ButtonGroup acceptGroup = new ButtonGroup();
    private ButtonGroup selectionGroup = new ButtonGroup();
    private IlLoadWizzard ilWizzard;

    public UiLoadWizzard() {
        this.initialize();
        this.acceptGroup.add(this.notAgreeRadioButton);
        this.acceptGroup.add(this.agreeRadioButton);
        this.selectionGroup.add(this.sameColorRadioButton);
        this.selectionGroup.add(this.sameCalculationRadioButton);
    }

    public UiLoadWizzard(IlLoadWizzard wizzard) {
        this();
        this.ilWizzard = wizzard;
    }

    private void initialize() {
        this.setTitle("Creative Commons");
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                IlPool.getInstance().finalizeLoad(true);
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.jContentPane, 1));
            this.jContentPane.add((Component)this.getCardPanel(), null);
            this.jContentPane.add((Component)this.getNavigationPanel(), null);
        }
        return this.jContentPane;
    }

    protected JPanel getCardPanel() {
        if (this.cardPanel == null) {
            this.cardPanel = new JPanel();
            this.cardPanel.setLayout(new CardLayout());
            this.cardPanel.setName("cardPanel");
            this.cardPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.cardPanel.add((Component)this.getCard1Panel(), this.getCard1Panel().getName());
            this.cardPanel.add((Component)this.getCard2Panel(), this.getCard2Panel().getName());
        }
        return this.cardPanel;
    }

    private JPanel getNavigationPanel() {
        if (this.navigationPanel == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            this.navigationPanel = new JPanel();
            this.navigationPanel.setLayout(flowLayout1);
            this.navigationPanel.setName("navigationPanel");
            flowLayout1.setAlignment(2);
            this.navigationPanel.add((Component)this.getNextButton(), null);
            this.navigationPanel.add((Component)this.getCancelButton(), null);
        }
        return this.navigationPanel;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setIcon(IconLoader.cancelImageIcon);
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UiLoadWizzard.this.ilWizzard.cancel();
                }
            });
        }
        return this.cancelButton;
    }

    protected JButton getNextButton() {
        if (this.nextButton == null) {
            this.nextButton = new JButton();
            this.nextButton.setIcon(IconLoader.readdbImageIcon);
            this.nextButton.setText("Load");
            this.nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UiLoadWizzard.this.ilWizzard.next();
                }
            });
        }
        return this.nextButton;
    }

    private JPanel getCard1Panel() {
        if (this.card1Panel == null) {
            this.selectionLabel = new JLabel();
            this.card1Panel = new JPanel();
            this.card1Panel.setLayout(new BoxLayout(this.card1Panel, 1));
            this.card1Panel.setName("card1Panel");
            this.selectionLabel.setText("Update your genome pool with public vailable genomes.");
            this.card1Panel.add((Component)this.selectionLabel, null);
            this.card1Panel.add((Component)this.getSameColorRadioButton(), null);
            this.card1Panel.add((Component)this.getSameCalculationRadioButton(), null);
        }
        return this.card1Panel;
    }

    private JPanel getCard2Panel() {
        if (this.card2Panel == null) {
            this.card2Panel = new JPanel();
            this.card2Panel.setLayout(new BoxLayout(this.card2Panel, 1));
            this.card2Panel.setName("card2Panel");
            this.card2Panel.add((Component)this.getLicensePanel(), null);
            this.card2Panel.add((Component)this.getAgreePanel(), null);
        }
        return this.card2Panel;
    }

    protected JRadioButton getSameColorRadioButton() {
        if (this.sameColorRadioButton == null) {
            this.sameColorRadioButton = new JRadioButton();
            this.sameColorRadioButton.setText("Update your genome pool with public vailable genomes.");
        }
        return this.sameColorRadioButton;
    }

    protected JRadioButton getSameCalculationRadioButton() {
        if (this.sameCalculationRadioButton == null) {
            this.sameCalculationRadioButton = new JRadioButton();
            this.sameCalculationRadioButton.setText("All %s calculations.");
        }
        return this.sameCalculationRadioButton;
    }

    private JPanel getLicensePanel() {
        if (this.licensePanel == null) {
            this.licensePanel = new JPanel();
            this.licensePanel.setAlignmentX(0.0f);
            this.licensePanel.add((Component)this.getJScrollPane(), null);
        }
        return this.licensePanel;
    }

    private JPanel getAgreePanel() {
        if (this.agreePanel == null) {
            this.agreePanel = new JPanel();
            this.agreePanel.setLayout(new BoxLayout(this.agreePanel, 1));
            this.agreePanel.add((Component)this.getAgreeRadioButton(), null);
            this.agreePanel.add((Component)this.getNotAgreeRadioButton(), null);
        }
        return this.agreePanel;
    }

    protected JRadioButton getNotAgreeRadioButton() {
        if (this.notAgreeRadioButton == null) {
            this.notAgreeRadioButton = new JRadioButton();
            this.notAgreeRadioButton.setText("I do not accept the terms in the license agreements");
            this.notAgreeRadioButton.setSelected(true);
            this.notAgreeRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    UiLoadWizzard.this.ilWizzard.acceptState();
                }
            });
        }
        return this.notAgreeRadioButton;
    }

    protected JRadioButton getAgreeRadioButton() {
        if (this.agreeRadioButton == null) {
            this.agreeRadioButton = new JRadioButton();
            this.agreeRadioButton.setText("I accept the terms in the license agreements");
            this.agreeRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    UiLoadWizzard.this.ilWizzard.acceptState();
                }
            });
        }
        return this.agreeRadioButton;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJEditorPane());
            this.jScrollPane.setVerticalScrollBarPolicy(22);
            this.jScrollPane.setPreferredSize(new Dimension(450, 350));
        }
        return this.jScrollPane;
    }

    private JEditorPane getJEditorPane() {
        if (this.jEditorPane == null) {
            this.jEditorPane = new JEditorPane();
            this.jEditorPane.setText("All downloaded images are under a\nCreative Commons License\nAttribution-NonCommercial-ShareAlike 2.0\n\nYou are free:\n    * to copy, distribute, display, and perform the work\n    * to make derivative works\n\nUnder the following conditions:\n\n    Attribution. You must give the original author credit.\n\n    Noncommercial. You may not use this work for commercial purposes.\n\n    Share Alike. If you alter, transform, or build upon this work, you may\n      distribute the resulting work only under a license identical to this one.\n\n   * For any reuse or distribution, you must make clear to others the\n      license terms of this work.\n   * Any of these conditions can be waived if you get permission from\n      the copyright holder.\n\nYour fair use and other rights are in no way affected by the above.");
            this.jEditorPane.setEditable(false);
        }
        return this.jEditorPane;
    }
}

