/*
 * Decompiled with CFR 0.152.
 */
package kandid.noise;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import javax.imageio.ImageIO;
import kandid.noise.AbstractNoise;
import kandid.util.Util;

public class ImageNoise
extends AbstractNoise {
    static int[][] argbArray = null;
    static File[] in_files = null;
    static int[] in_width;
    static int[] in_height;
    int where;

    public ImageNoise(long seed) {
        this.initializeNoise(seed);
    }

    @Override
    public void initializeNoise(long seed) {
        try {
            if (in_files == null && (in_files = ImageNoise.listFiles(new File("./incoming/contrast/"))).length > 0) {
                argbArray = new int[in_files.length][];
                in_width = new int[in_files.length];
                in_height = new int[in_files.length];
                int in = 0;
                while (in < in_files.length) {
                    BufferedImage in_image = ImageIO.read(in_files[(int)(Math.abs(seed) % (long)in_files.length)]);
                    ImageNoise.in_width[in] = in_image.getWidth();
                    ImageNoise.in_height[in] = in_image.getHeight();
                    if (in_width[in] > 0 && in_height[in] > 0) {
                        ImageNoise.argbArray[in] = new int[4 * in_width[in] * in_height[in]];
                        Raster raster = in_image.getData();
                        raster.getPixels(0, 0, in_width[in], in_height[in], argbArray[in]);
                    }
                    ++in;
                }
                this.where = (int)(Math.abs(seed) % (long)in_files.length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            argbArray = null;
        }
    }

    private static File[] listFiles(File directory) {
        Object[] entries = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File entry, String name) {
                return true;
            }
        });
        Arrays.sort(entries);
        return entries;
    }

    private double noiseImage(double x, double y) {
        if (argbArray == null) {
            return 0.0;
        }
        int ix = (int)(Util.repeat_seamless(x) * (double)in_width[this.where]) % in_width[this.where];
        int iy = (int)(Util.repeat_seamless(y) * (double)in_height[this.where]) % in_height[this.where];
        int index = 4 * (iy * in_width[this.where] + ix);
        double gray = 0.3 * (double)argbArray[this.where][index] + 0.59 * (double)argbArray[this.where][index + 1] + 0.11 * (double)argbArray[this.where][index + 2];
        return gray / 256.0;
    }

    @Override
    public double unoise(double x, double y, double z) {
        double dist = this.noiseImage(x, y);
        return dist;
    }

    @Override
    public double snoise(double x, double y, double z) {
        double dist = this.noiseImage(x, y);
        return 2.0 * dist - 1.0;
    }
}

