/*
 * Decompiled with CFR 0.152.
 */
package kandid.noise;

import kandid.noise.AbstractNoise;

public class ChladniNoise
extends AbstractNoise {
    int n;
    int m;

    public ChladniNoise(long seed) {
        this.initializeNoise(seed);
    }

    @Override
    public void initializeNoise(long seed) {
        this.n = 1 + (int)(seed % 7L);
        this.m = 1 + Long.hashCode(seed) % 7;
    }

    private double noiseChladni(double x, double y) {
        return Math.cos((double)this.n * Math.PI * x) * Math.cos((double)this.m * Math.PI * y) + Math.cos((double)this.m * Math.PI * x) * Math.cos((double)this.n * Math.PI * y);
    }

    @Override
    public double unoise(double x, double y, double z) {
        double dist = this.noiseChladni(x, y);
        return 0.5 * dist;
    }

    @Override
    public double snoise(double x, double y, double z) {
        double dist = this.noiseChladni(x, y);
        return dist - 1.0;
    }
}

