/*
 * Decompiled with CFR 0.152.
 */
package kandid.noise;

import kandid.noise.AbstractNoise;
import kandid.noise.PseudoRandomizer;

public class CellNoise
extends AbstractNoise {
    static final int CMAX = 128;
    int clen = 1;
    double[] cx;
    double[] cy;

    public CellNoise(long seed) {
        this.initializeNoise(seed);
    }

    @Override
    public void initializeNoise(long seed) {
        this.clen = 2 + (int)(seed % 126L);
        PseudoRandomizer rnd = new PseudoRandomizer(seed);
        this.cx = new double[128];
        this.cy = new double[128];
        int ci = 0;
        while (ci < 128) {
            this.cx[ci] = 4.0 * rnd.uniform() - 2.0;
            this.cy[ci] = 4.0 * rnd.uniform() - 2.0;
            ++ci;
        }
    }

    private double noiseF1(double x, double y) {
        double dist = Double.MAX_VALUE;
        int ci = 0;
        while (ci < 128) {
            double dx = this.cx[ci] - x;
            double dy = this.cy[ci] - y;
            double d = dx * dx + dy * dy;
            if (d < dist) {
                dist = d;
            }
            ++ci;
        }
        return Math.sqrt(dist);
    }

    @Override
    public double unoise(double x, double y, double z) {
        double dist = this.noiseF1(x, y);
        return 0.5 * dist;
    }

    @Override
    public double snoise(double x, double y, double z) {
        double dist = this.noiseF1(x, y);
        return dist - 1.0;
    }
}

