/*
 * Decompiled with CFR 0.152.
 */
package kandid.input;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class GrayImage {
    private int width;
    private int height;
    double[][] bufImg;

    public void load(File fin) {
        try {
            BufferedImage iin = ImageIO.read(fin);
            this.height = iin.getHeight();
            this.width = iin.getWidth();
            this.bufImg = new double[this.height][];
            int iy = 0;
            while (iy < this.height) {
                this.bufImg[iy] = new double[this.width];
                int ix = 0;
                while (ix < this.width) {
                    int rgb8 = iin.getRGB(ix, iy);
                    int r = rgb8 >> 16 & 0xFF;
                    int g = rgb8 >> 8 & 0xFF;
                    int b = rgb8 & 0xFF;
                    this.bufImg[iy][ix] = (0.3 * (double)r + 0.59 * (double)g + 0.11 * (double)b) / 256.0;
                    ++ix;
                }
                ++iy;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double at(double x, double y) {
        int iy;
        int ix = (int)(Math.abs(x) % 1.0 * (double)this.width);
        if (ix >= this.width) {
            ix = this.width - 1;
        }
        if ((iy = (int)(Math.abs(y) % 1.0 * (double)this.height)) >= this.height) {
            iy = this.height - 1;
        }
        return this.bufImg[iy][ix];
    }
}

