/*
 * Decompiled with CFR 0.152.
 */
package kandid.extensions;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import kandid.Console;
import kandid.Kandid;
import kandid.calculation.Calculation;
import kandid.calculation.bridge.PixelBridgeCalculation;
import kandid.calculation.bridge.povray.PovTextureCalculation;
import kandid.colorator.Colorator;
import kandid.colorator.ColoratorFactory;
import kandid.extensions.BitmapFileEngine;
import kandid.extensions.ExportState;
import kandid.pond.BreederType;
import kandid.pond.util.BreederSearchThread;
import kandid.preference.PreferenceType;
import kandid.preference.ui.IlPreference;
import kandid.preference.util.PreferenceModel;
import kandid.soup.ChromosomeType;
import kandid.soup.ColoratorType;
import kandid.soup.EntityType;
import kandid.soup.ImageType;
import kandid.soup.PopulationType;
import kandid.soup.util.SoupFactory;
import kandid.util.Debug;
import kandid.util.NetworkHelper;

public class ExportWizard
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int charColumns = 50;
    private static ImageIcon exportImageIcon;
    private static ImageIcon rewindImageIcon;
    private static ImageIcon papersizeImageIcon;
    private static ImageIcon insertDbImageIcon;
    private static ImageIcon pfmImageIcon;
    private static ImageIcon jpegImageIcon;
    private static ImageIcon pngImageIcon;
    private static Dimension buttonDimension;
    private String title;
    private String typeName;
    private ImageType image;
    private ChromosomeType chromosome;
    private String calculationName;
    private Colorator colorator;
    private ExportState exportState;
    private int wizPos;
    private BreederSearchThread breederRequestThread;
    private JPanel controlPanel;
    private JButton okButton;
    private JButton rewindButton;
    private JPanel choicePanel;
    private JPanel card1Panel;
    private JPanel headline1Panel;
    private JLabel step1Label;
    private JLabel text1Label;
    private JPanel step1Panel;
    private JButton insertDbButton;
    private JButton pngButton;
    private JButton jpegButton;
    private JButton pfmButton;
    private JLabel insertDbLabel;
    private JLabel pngLabel;
    private JLabel jpegLabel;
    private JLabel pfmLabel;
    private JPanel card2Panel;
    private JPanel headline2Panel;
    private JLabel step2Label;
    private JLabel text2Label;
    private JPanel step2Panel;
    private JButton size512x512Button;
    private JButton size1024x1024Button;
    private JButton freesizeButton;
    private JTextField xSizeTextField2;
    private JTextField ySizeTextField;
    private JLabel yLabel;
    private JLabel xLabel;
    private JButton size200x200Button;
    private JPanel card3Panel;
    private JPanel headline3Panel;
    private JLabel step3Label;
    private JLabel text3Label;
    private JPanel step3Panel;
    private JPanel card5Panel;
    private JPanel headline5Panel;
    private JLabel step5Label;
    private JLabel text5Label;
    private JPanel step5Panel;
    private JTextField outputNameTextField;
    private JTextField outputPathTextField;
    private JCheckBox acceptCheckBox;
    private JTextField authorTextField;
    private JLabel exportNameLabel;
    private JLabel exportPathLabel;

    static {
        buttonDimension = new Dimension(140, 30);
    }

    public ExportWizard(PopulationType population, int nx, Calculation calculation, String title) {
        this.title = title;
        SoupFactory soupFactory = SoupFactory.getSoupFactory();
        this.chromosome = soupFactory.getChromosome(population, nx);
        this.image = soupFactory.getImage(population, nx);
        this.typeName = SoupFactory.getTypeName(population);
        this.calculationName = calculation.getClass().getName();
        ColoratorType coloratorType = soupFactory.getColorator(population, nx);
        String coloratorName = soupFactory.getColoratorName(population, nx);
        this.colorator = ColoratorFactory.createColoratorWorker(coloratorName, coloratorType);
        this.exportState = new ExportState();
        Dimension prefDim = calculation.getPreferredSize();
        if (prefDim != null) {
            this.exportState.xDim = prefDim.width;
            this.exportState.yDim = prefDim.height;
        }
        this.exportState.setFullname(title);
        try {
            this.initComponents();
            this.jpegButton.setEnabled(!(calculation instanceof PovTextureCalculation));
            this.pfmButton.setEnabled(!(calculation instanceof PixelBridgeCalculation));
            this.wizPos = 1;
            this.manageCard(0);
            this.xSizeTextField2.setText("" + this.exportState.xDim);
            this.ySizeTextField.setText("" + this.exportState.yDim);
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    private void initComponents() {
        this.controlPanel = new JPanel();
        this.okButton = new JButton();
        this.rewindButton = new JButton();
        this.choicePanel = new JPanel();
        this.card1Panel = new JPanel();
        this.headline1Panel = new JPanel();
        this.step1Label = new JLabel();
        this.text1Label = new JLabel();
        this.step1Panel = new JPanel();
        this.insertDbButton = new JButton();
        this.pngButton = new JButton();
        this.jpegButton = new JButton();
        this.pfmButton = new JButton();
        this.insertDbLabel = new JLabel();
        this.pngLabel = new JLabel();
        this.jpegLabel = new JLabel();
        this.pfmLabel = new JLabel();
        this.card2Panel = new JPanel();
        this.headline2Panel = new JPanel();
        this.step2Label = new JLabel();
        this.text2Label = new JLabel();
        this.step2Panel = new JPanel();
        this.size512x512Button = new JButton();
        this.size1024x1024Button = new JButton();
        this.freesizeButton = new JButton();
        this.xSizeTextField2 = new JTextField();
        this.ySizeTextField = new JTextField();
        this.yLabel = new JLabel();
        this.xLabel = new JLabel();
        this.exportNameLabel = new JLabel();
        this.exportPathLabel = new JLabel();
        this.size200x200Button = new JButton();
        this.card3Panel = new JPanel();
        this.headline3Panel = new JPanel();
        this.step3Label = new JLabel();
        this.text3Label = new JLabel();
        this.step3Panel = new JPanel();
        this.card5Panel = new JPanel();
        this.headline5Panel = new JPanel();
        this.step5Label = new JLabel();
        this.text5Label = new JLabel();
        this.step5Panel = new JPanel();
        this.outputNameTextField = new JTextField();
        this.outputPathTextField = new JTextField();
        this.acceptCheckBox = new JCheckBox();
        this.authorTextField = new JTextField();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExportWizard.this.exitForm(evt);
            }
        });
        this.controlPanel.setLayout(new FlowLayout(2));
        if (exportImageIcon == null) {
            exportImageIcon = Kandid.getInstance().createImageIcon("export.png", null);
        }
        this.okButton.setIcon(exportImageIcon);
        this.okButton.setText("Export image");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.okButtonActionPerformed(evt);
            }
        });
        this.controlPanel.add(this.okButton);
        if (rewindImageIcon == null) {
            rewindImageIcon = Kandid.getInstance().createImageIcon("rewind.png", null);
        }
        this.rewindButton.setIcon(rewindImageIcon);
        this.rewindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.backButtonActionPerformed(evt);
            }
        });
        this.controlPanel.add(this.rewindButton);
        this.getContentPane().add((Component)this.controlPanel, "South");
        this.choicePanel.setLayout(new CardLayout());
        this.card1Panel.setLayout(new BorderLayout());
        this.headline1Panel.setLayout(new GridLayout(2, 1));
        this.step1Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Step 1</b></html>");
        this.headline1Panel.add(this.step1Label);
        this.text1Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Select output format.</b></html>");
        this.headline1Panel.add(this.text1Label);
        this.card1Panel.add((Component)this.headline1Panel, "North");
        this.step1Panel.setLayout(new GridBagLayout());
        if (pngImageIcon == null) {
            pngImageIcon = Kandid.getInstance().createImageIcon("ping.png", null);
        }
        this.pngButton.setIcon(pngImageIcon);
        this.pngButton.setText("PNG");
        this.pngButton.setPreferredSize(buttonDimension);
        this.pngButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.pngButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints1.anchor = 17;
        this.step1Panel.add((Component)this.pngButton, gridBagConstraints1);
        if (jpegImageIcon == null) {
            jpegImageIcon = Kandid.getInstance().createImageIcon("jpeg.png", null);
        }
        this.jpegButton.setIcon(jpegImageIcon);
        this.jpegButton.setText("JPEG");
        this.jpegButton.setPreferredSize(buttonDimension);
        this.jpegButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.jpegButton20ActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints1.anchor = 17;
        this.step1Panel.add((Component)this.jpegButton, gridBagConstraints1);
        if (pfmImageIcon == null) {
            pfmImageIcon = Kandid.getInstance().createImageIcon("pfm.png", null);
        }
        this.pfmButton.setIcon(pfmImageIcon);
        this.pfmButton.setText("PFM");
        this.pfmButton.setPreferredSize(buttonDimension);
        this.pfmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.pfmButtonActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints1.anchor = 17;
        this.step1Panel.add((Component)this.pfmButton, gridBagConstraints1);
        if (insertDbImageIcon == null) {
            insertDbImageIcon = Kandid.getInstance().createImageIcon("insertdb.png", null);
        }
        this.insertDbButton.setIcon(insertDbImageIcon);
        this.insertDbButton.setText("Publish");
        String author = this.image.getAuthor();
        this.insertDbButton.setEnabled(author == null || author.length() == 0);
        this.insertDbButton.setPreferredSize(buttonDimension);
        this.insertDbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.insertDbButtonActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints1.anchor = 17;
        this.pngLabel.setText("Bitmap: Export Portable Network Graphics");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 17;
        this.step1Panel.add((Component)this.pngLabel, gridBagConstraints1);
        this.jpegLabel.setText("Bitmap: Export Compressed JPEG Format");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        this.step1Panel.add((Component)this.jpegLabel, gridBagConstraints1);
        this.pfmLabel.setText("Bitmap: Export Portable FloatMap Image Format");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.anchor = 17;
        this.step1Panel.add((Component)this.pfmLabel, gridBagConstraints1);
        this.insertDbLabel.setText("Publish in WEB database");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.anchor = 17;
        this.card1Panel.add((Component)this.step1Panel, "Center");
        this.choicePanel.add((Component)this.card1Panel, "jPanel8");
        this.card2Panel.setLayout(new BorderLayout());
        this.headline2Panel.setLayout(new GridLayout(2, 1));
        this.step2Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Step 2</b></html>");
        this.headline2Panel.add(this.step2Label);
        this.text2Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Select image size.</b></html>");
        this.headline2Panel.add(this.text2Label);
        this.card2Panel.add((Component)this.headline2Panel, "North");
        this.step2Panel.setLayout(new GridBagLayout());
        if (papersizeImageIcon == null) {
            papersizeImageIcon = Kandid.getInstance().createImageIcon("papersize.png", null);
        }
        this.size200x200Button.setIcon(papersizeImageIcon);
        this.size200x200Button.setText("200 x 200");
        this.size200x200Button.setPreferredSize(buttonDimension);
        this.size200x200Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.size200x200ButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints2.anchor = 17;
        this.step2Panel.add((Component)this.size200x200Button, gridBagConstraints2);
        if (papersizeImageIcon == null) {
            papersizeImageIcon = Kandid.getInstance().createImageIcon("papersize.png", null);
        }
        this.size512x512Button.setIcon(papersizeImageIcon);
        this.size512x512Button.setText("512 x 512");
        this.size512x512Button.setPreferredSize(buttonDimension);
        this.size512x512Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.size512x512ButtonActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints2.anchor = 17;
        this.step2Panel.add((Component)this.size512x512Button, gridBagConstraints2);
        if (papersizeImageIcon == null) {
            papersizeImageIcon = Kandid.getInstance().createImageIcon("papersize.png", null);
        }
        this.size1024x1024Button.setIcon(papersizeImageIcon);
        this.size1024x1024Button.setText("1024 x 1024");
        this.size1024x1024Button.setPreferredSize(buttonDimension);
        this.size1024x1024Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.size1024x1024ButtonActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints2.anchor = 17;
        this.step2Panel.add((Component)this.size1024x1024Button, gridBagConstraints2);
        if (papersizeImageIcon == null) {
            papersizeImageIcon = Kandid.getInstance().createImageIcon("papersize.png", null);
        }
        this.freesizeButton.setIcon(papersizeImageIcon);
        this.freesizeButton.setText("free size");
        this.freesizeButton.setPreferredSize(buttonDimension);
        this.freesizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.freesizeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints2.anchor = 17;
        this.step2Panel.add((Component)this.freesizeButton, gridBagConstraints2);
        this.yLabel.setText("x  ");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 3;
        this.step2Panel.add((Component)this.yLabel, gridBagConstraints2);
        this.xSizeTextField2.setColumns(5);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
        this.step2Panel.add((Component)this.xSizeTextField2, gridBagConstraints2);
        this.xLabel.setText("y  ");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 3;
        this.step2Panel.add((Component)this.xLabel, gridBagConstraints2);
        this.ySizeTextField.setColumns(5);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        this.step2Panel.add((Component)this.ySizeTextField, gridBagConstraints2);
        this.card2Panel.add((Component)this.step2Panel, "Center");
        this.choicePanel.add((Component)this.card2Panel, "jPanel9");
        this.card3Panel.setLayout(new BorderLayout());
        this.headline3Panel.setLayout(new GridLayout(2, 1));
        this.step3Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Step 3</b></html>");
        this.headline3Panel.add(this.step3Label);
        this.text3Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Automaticaly generated filename.</b></html>");
        this.headline3Panel.add(this.text3Label);
        this.card3Panel.add((Component)this.headline3Panel, "North");
        this.step3Panel.setLayout(new GridBagLayout());
        this.exportNameLabel.setText("Name of exported image:");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints3.anchor = 17;
        this.step3Panel.add((Component)this.exportNameLabel, gridBagConstraints3);
        this.outputNameTextField.setColumns(50);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints3.anchor = 17;
        this.step3Panel.add((Component)this.outputNameTextField, gridBagConstraints3);
        this.exportPathLabel.setText("Folder for exported image:");
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints3.anchor = 17;
        this.step3Panel.add((Component)this.exportPathLabel, gridBagConstraints3);
        this.outputPathTextField.setColumns(50);
        this.outputPathTextField.setEditable(false);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints3.anchor = 17;
        this.step3Panel.add((Component)this.outputPathTextField, gridBagConstraints3);
        this.card3Panel.add((Component)this.step3Panel, "Center");
        this.choicePanel.add((Component)this.card3Panel, "jPanel");
        this.card5Panel.setLayout(new BorderLayout());
        this.headline5Panel.setLayout(new GridLayout(2, 1));
        this.step5Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Step 2</b></html>");
        this.headline5Panel.add(this.step5Label);
        this.text5Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Publish to Kandid WEB database.</html>");
        this.headline5Panel.add(this.text5Label);
        this.card5Panel.add((Component)this.headline5Panel, "North");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        this.step5Panel.setLayout(gridbag);
        JEditorPane editorPane = new JEditorPane();
        editorPane.setText("Publishing this work to Kandid WEB database, will give all users the\nfollowing rights:\n\nCreative Commons License\nAttribution-NonCommercial-ShareAlike 2.0\n\nAll users are free:\n    * to copy, distribute, display, and perform the work\n    * to make derivative works\n\nUnder the following conditions:\n\n    Attribution. Users must give the original author credit.\n\n    Noncommercial. Users may not use this work for commercial purposes.\n\n    Share Alike. If a users alters, transforms, or builds upon this work, he\n      may distribute the resulting work only under a license identical to\n      this one.\n\n   * For any reuse or distribution, the user must make clear to others the\n      license terms of this work.\n   * Any of these conditions can be waived if the user gets permission\n      from the copyright holder.\n\nYour fair use and other rights are in no way affected by the above.");
        editorPane.setEditable(false);
        editorPane.setCaretPosition(0);
        JScrollPane editorScrollPane = new JScrollPane(editorPane);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setPreferredSize(new Dimension(450, 180));
        gridbag.setConstraints(editorScrollPane, c);
        this.step5Panel.add(editorScrollPane);
        JLabel l1 = new JLabel(" ");
        gridbag.setConstraints(l1, c);
        this.step5Panel.add(l1);
        this.acceptCheckBox.setText("<html>I accept publishing this work under:<br>Creative Commons<br>Attribution-NonCommercial-ShareAlike&nbsp;2.0  Licence.</html>");
        this.acceptCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.acceptCheckBoxActionPerformed(evt);
            }
        });
        this.acceptCheckBox.setVerticalTextPosition(1);
        gridbag.setConstraints(this.acceptCheckBox, c);
        this.step5Panel.add(this.acceptCheckBox);
        JLabel l2 = new JLabel(" ");
        gridbag.setConstraints(l2, c);
        this.step5Panel.add(l2);
        JLabel l3 = new JLabel("Author:");
        gridbag.setConstraints(l3, c);
        this.step5Panel.add(l3);
        this.authorTextField.setColumns(50);
        gridbag.setConstraints(this.authorTextField, c);
        this.step5Panel.add(this.authorTextField);
        this.card5Panel.add((Component)this.step5Panel, "Center");
        this.choicePanel.add((Component)this.card5Panel, "insertDbPanel");
        this.getContentPane().add((Component)this.choicePanel, "Center");
        this.pack();
    }

    protected void acceptCheckBoxActionPerformed(ActionEvent evt) {
        this.okButton.setEnabled(this.acceptCheckBox.isSelected());
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        if (this.wizPos >= 1) {
            --this.wizPos;
            ((CardLayout)this.choicePanel.getLayout()).previous(this.choicePanel);
        }
        this.manageCard(-1);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.wizPos >= 3) {
            this.exportState.setFullname(this.outputNameTextField.getText());
            SoupFactory soupFactory = SoupFactory.getSoupFactory();
            EntityType entity = soupFactory.createEntity(this.typeName, this.image);
            switch (this.exportState.exportType) {
                case 3: {
                    new BitmapFileEngine(this.chromosome, this.calculationName, this.colorator, this.exportState).start((evt.getModifiers() & 1) == 1);
                    break;
                }
            }
            new File(this.exportState.getPath("filebase")).mkdirs();
            soupFactory.marshalToFile(entity, this.exportState.getPath("filebase") + this.exportState.getFilename() + ".kimg");
            this.closeWizard();
        }
    }

    private void jpegButton20ActionPerformed(ActionEvent evt) {
        this.exportState.exportType = 3;
        this.exportState.fileExtension = "jpg";
        this.manageCard(1);
    }

    private void pngButtonActionPerformed(ActionEvent evt) {
        this.exportState.exportType = 3;
        this.exportState.fileExtension = "png";
        this.manageCard(1);
    }

    private void pfmButtonActionPerformed(ActionEvent evt) {
        this.exportState.exportType = 3;
        this.exportState.fileExtension = "pfm";
        this.manageCard(1);
    }

    private void insertDbButtonActionPerformed(ActionEvent evt) {
        try {
            IlPreference.getInstance().ensureExportGenomeDBCompleted();
            PreferenceType preferences = PreferenceModel.getInstance().getPreference();
            NetworkHelper.setHTTPProxy();
            this.exportState.exportType = 6;
            this.exportState.setFullname(this.title);
            this.outputNameTextField.setText(this.exportState.getFullname());
            this.okButton.setText("Add to WEB database");
            String author = this.image.getAuthor();
            if (author != null && author.length() > 0) {
                this.authorTextField.setText(author);
                this.authorTextField.setEditable(false);
            } else {
                String nickname = preferences.getUser().getNickname();
                String email = preferences.getUser().getEmail();
                Object configuredAutor = "";
                configuredAutor = nickname != null && nickname.length() > 0 ? (String)configuredAutor + nickname : (String)configuredAutor + "anonymous";
                if (email != null && email.length() > 0) {
                    configuredAutor = (String)configuredAutor + " " + email;
                }
                this.authorTextField.setText((String)configuredAutor);
            }
            this.manageCard(4);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
            Console.append(exc.getMessage());
        }
    }

    public void signalBreederSearchReady() {
        BreederType breederType;
        if (this.breederRequestThread != null && (breederType = this.breederRequestThread.getBreederType()) != null) {
            this.exportState.to = NetworkHelper.getUsableEmail(breederType.getEmail());
            this.manageCard(3);
        }
    }

    private void freesizeButtonActionPerformed(ActionEvent evt) {
        String errmsg;
        try {
            this.exportState.xDim = Integer.parseInt(this.xSizeTextField2.getText());
        }
        catch (NumberFormatException exc) {
            errmsg = "Please enter a number greater 0 for x.";
            JOptionPane.showMessageDialog(null, errmsg, "Number format error", 0);
        }
        try {
            this.exportState.yDim = Integer.parseInt(this.ySizeTextField.getText());
        }
        catch (NumberFormatException exc) {
            errmsg = "Please enter a number greater 0 for y.";
            JOptionPane.showMessageDialog(null, errmsg, "Number format error", 0);
        }
        this.exportState.setFullname(this.title + "_x" + this.exportState.xDim + "_y" + this.exportState.yDim);
        this.outputNameTextField.setText(this.exportState.getFullname());
        this.outputPathTextField.setText(this.exportState.getAbsolutPath("filebase"));
        this.manageCard(1);
    }

    private void size1024x1024ButtonActionPerformed(ActionEvent evt) {
        this.exportState.xDim = 1024;
        this.exportState.yDim = 1024;
        this.exportState.setFullname(this.title + "_x" + this.exportState.xDim + "_y" + this.exportState.yDim);
        this.outputNameTextField.setText(this.exportState.getFullname());
        this.outputPathTextField.setText(this.exportState.getAbsolutPath("filebase"));
        this.manageCard(1);
    }

    private void size512x512ButtonActionPerformed(ActionEvent evt) {
        this.exportState.xDim = 512;
        this.exportState.yDim = 512;
        this.exportState.setFullname(this.title + "_x" + this.exportState.xDim + "_y" + this.exportState.yDim);
        this.outputNameTextField.setText(this.exportState.getFullname());
        this.outputPathTextField.setText(this.exportState.getAbsolutPath("filebase"));
        this.manageCard(1);
    }

    private void size200x200ButtonActionPerformed(ActionEvent evt) {
        this.exportState.xDim = 200;
        this.exportState.yDim = 200;
        this.exportState.setFullname(this.title + "_x" + this.exportState.xDim + "_y" + this.exportState.yDim);
        this.outputNameTextField.setText(this.exportState.getFullname());
        this.outputPathTextField.setText(this.exportState.getAbsolutPath("filebase"));
        this.manageCard(1);
    }

    private void exitForm(WindowEvent evt) {
        this.closeWizard();
    }

    private void manageCard(int forward) {
        if (forward > 0) {
            int fc = forward;
            while (fc > 0 && this.wizPos < 5) {
                ((CardLayout)this.choicePanel.getLayout()).next(this.choicePanel);
                ++this.wizPos;
                --fc;
            }
        } else if (forward < 0) {
            ((CardLayout)this.choicePanel.getLayout()).first(this.choicePanel);
            this.wizPos = 1;
        }
        if (this.wizPos <= 1) {
            this.okButton.setText("Export image");
        }
        this.okButton.setEnabled(this.wizPos >= 3 && this.wizPos != 5);
        this.rewindButton.setEnabled(this.wizPos > 1);
        this.outputNameTextField.setEnabled(this.exportState.exportType != 6);
    }

    void closeWizard() {
        this.wizPos = 1;
        this.setVisible(false);
        this.dispose();
    }
}

