/*
 * Decompiled with CFR 0.152.
 */
package kandid.extensions;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import kandid.Console;
import kandid.Gateway;
import kandid.calculation.Calculation;
import kandid.calculation.Deviation;
import kandid.calculation.PixelCalculation;
import kandid.calculation.bridge.PixelBridgeCalculation;
import kandid.colorator.Colorator;
import kandid.extensions.BitmapEngine;
import kandid.extensions.ExportState;
import kandid.soup.ChromosomeType;

public class BitmapFileEngine
extends BitmapEngine {
    public BitmapFileEngine(ChromosomeType chromosome, String calculationName, Colorator colorator, ExportState exportState) {
        super(chromosome, calculationName, colorator, exportState);
    }

    @Override
    protected void generateOutput(Gateway gw, Deviation dev, String timestamp) throws IOException {
        block19: {
            String formatName;
            File imageOutFile;
            block20: {
                Calculation calc = gw.getCalculation();
                if (calc instanceof PixelBridgeCalculation) break block19;
                if (dev == null) {
                    imageOutFile = new File(this.exportState.getPath("filebase") + this.exportState.getFullname());
                } else if (timestamp == null) {
                    imageOutFile = new File(this.exportState.getPath("filebase") + "kandid_" + String.format("%06d", dev.frame) + "_" + this.exportState.getFullname());
                } else {
                    File imageOutPath = new File(this.exportState.getPath("filebase") + timestamp);
                    imageOutPath.mkdirs();
                    imageOutFile = new File(String.valueOf(imageOutPath) + "/kandid_" + String.format("%06d", dev.frame) + "_" + this.exportState.getFullname());
                }
                formatName = this.exportState.fileExtension.toLowerCase();
                if (!(calc instanceof PixelCalculation) || !formatName.equals("png") && !formatName.equals("pfm") && !formatName.equals("jpg")) break block20;
                switch (formatName) {
                    case "png": {
                        ((PixelCalculation)calc).writeRGB_PNG16(this.exportState, imageOutFile);
                        break;
                    }
                    case "pfm": {
                        ((PixelCalculation)calc).writeRGB_PFM(this.exportState, imageOutFile);
                        break;
                    }
                    case "jpg": {
                        ((PixelCalculation)calc).writeRGB_JPG(imageOutFile);
                    }
                }
                Console.append(this.exportState.getAbsolutPath("filebase") + "/" + this.exportState.getFullname() + " is ready");
                break block19;
            }
            if (formatName.equals("pfm")) {
                formatName = "png";
                Console.append("Portable float map PFM is not supported for calculation based on vector graphics, yet. Will use " + formatName.toUpperCase() + " format instead.");
                File patched_imageOutFile = new File(this.exportState.getPath("filebase") + this.exportState.getFilename() + "." + formatName);
                ImageIO.write((RenderedImage)((BufferedImage)gw.getImage()), formatName, patched_imageOutFile);
                Console.append(patched_imageOutFile.toString() + " is ready");
            } else {
                ImageIO.write((RenderedImage)((BufferedImage)gw.getImage()), formatName, imageOutFile);
                Console.append(this.exportState.getAbsolutPath("filebase") + "/" + this.exportState.getFullname() + " is ready");
            }
        }
    }
}

