/*
 * Decompiled with CFR 0.152.
 */
package kandid.extensions;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kandid.Console;
import kandid.Gateway;
import kandid.calculation.Calculation;
import kandid.calculation.Deviation;
import kandid.colorator.Colorator;
import kandid.extensions.ExportEngine;
import kandid.extensions.ExportState;
import kandid.soup.ChromosomeType;
import kandid.util.Debug;

public abstract class BitmapEngine
extends ExportEngine
implements Runnable {
    boolean with_deviations;
    int frames = 500;
    static final int AP = Runtime.getRuntime().availableProcessors();
    static final int FRAME_QUEUE_LEN = 2 * AP;
    static final int FRAME_QUEUE_CONSUMERS = AP + AP / 2;

    public BitmapEngine(ChromosomeType chromosome, String calculationName, Colorator colorator, ExportState exportState) {
        super(chromosome, calculationName, colorator, exportState);
    }

    protected abstract void generateOutput(Gateway var1, Deviation var2, String var3) throws IOException;

    public void start(boolean with_deviations) {
        this.with_deviations = with_deviations;
        if (this.engine == null) {
            this.engine = new Thread((Runnable)this, "engine");
            this.engine.start();
        }
    }

    public void stop() {
        this.engine = null;
    }

    @Override
    public void run() {
        new File(this.exportState.getPath("filebase")).mkdirs();
        if (this.with_deviations) {
            this.run_parallel();
        } else {
            this.run_single();
        }
    }

    private void run_single() {
        Thread me = Thread.currentThread();
        me.setPriority(1);
        Gateway gw = new Gateway();
        try {
            long startTime = System.currentTimeMillis();
            this.calculate_image(gw);
            while (!gw.getReady() && me == this.engine) {
                gw.calculate(null, false, this.exportState.getPath("filebase") + this.exportState.getFilename());
            }
            this.generateOutput(gw, null, "");
        }
        catch (Throwable exc) {
            Console.append("error while single image exporting ");
            Console.append(exc.toString());
            Debug.stackTrace(exc);
        }
    }

    private void run_parallel() {
        LinkedBlockingQueue<Deviation> frame_queue = new LinkedBlockingQueue<Deviation>(FRAME_QUEUE_LEN);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-S");
        StringBuffer stringBuffer = new StringBuffer();
        simpleDateFormat.format(new Date(), stringBuffer, new FieldPosition(0));
        String timestamp = stringBuffer.toString();
        TaskProducer tp = new TaskProducer(frame_queue);
        new Thread((Runnable)tp, "TaskProducer").start();
        int tcon = 0;
        while (tcon < FRAME_QUEUE_CONSUMERS) {
            TaskCalculator tc = new TaskCalculator(timestamp, frame_queue);
            new Thread((Runnable)tc, "TaskCalculator-" + tcon).start();
            ++tcon;
        }
    }

    private void calculate_image(Gateway gw) {
        Console.append("exporting " + this.exportState.getAbsolutPath("filebase") + this.exportState.getFullname());
        Calculation calculation = gw.createCalculation(this.calculationName);
        gw.setChromosome(this.chromosome, calculation, this.colorator);
        gw.activateBitmapCanvas(new Dimension(this.exportState.xDim, this.exportState.yDim));
        gw.getCalculation().setImageFormat(this.exportState.fileExtension);
    }

    private class TaskCalculator
    implements Runnable {
        private final String timestamp;
        private final BlockingQueue<Deviation> frame_queue;

        public TaskCalculator(String timestamp, BlockingQueue<Deviation> frame_queue) {
            this.timestamp = timestamp;
            this.frame_queue = frame_queue;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Deviation dev = this.frame_queue.take();
                    if (!dev.stop) {
                        Gateway gw = new Gateway();
                        BitmapEngine.this.calculate_image(gw);
                        while (!gw.getReady()) {
                            gw.calculate(dev, false, BitmapEngine.this.exportState.getPath("filebase") + BitmapEngine.this.exportState.getFilename());
                        }
                        BitmapEngine.this.generateOutput(gw, dev, this.timestamp);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable exc) {
                exc.printStackTrace();
                Console.append("error while exporting deviation " + BitmapEngine.this.exportState.getFilename());
                Console.append(exc.toString());
                Debug.stackTrace(exc);
            }
        }
    }

    private class TaskProducer
    implements Runnable {
        private final BlockingQueue<Deviation> frame_queue;

        public TaskProducer(BlockingQueue<Deviation> frame_queue) {
            this.frame_queue = frame_queue;
        }

        @Override
        public void run() {
            int frm = 0;
            while (frm < BitmapEngine.this.frames) {
                try {
                    switch (BitmapEngine.this.calculationName) {
                        case "kandid.calculation.vm.scalar.ScalarExpressionCalculation": {
                            this.frame_queue.put(new kandid.calculation.vm.scalar.Deviation(frm, BitmapEngine.this.frames, false));
                            break;
                        }
                        case "kandid.calculation.domainwarping.DomainWarpingCalculation": {
                            this.frame_queue.put(new kandid.calculation.domainwarping.Deviation(frm, BitmapEngine.this.frames, false));
                        }
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++frm;
            }
            frm = 0;
            while (frm < FRAME_QUEUE_CONSUMERS) {
                try {
                    Deviation dev = new Deviation(0, true);
                    this.frame_queue.put(dev);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++frm;
            }
        }
    }
}

