/*
 * Decompiled with CFR 0.152.
 */
package kandid.colorator;

import java.awt.Color;
import kandid.colorator.ColorF32;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;
import kandid.soup.ColorGene;

public class RGBColorator
implements Colorator {
    @Override
    public void getColor(double redValue, double greenValue, double blueValue, ColorF32 cout) {
        assert (cout != null);
        cout.r = redValue >= 1.0 ? 1.0f : (redValue < 0.0 ? 0.0f : (float)redValue);
        cout.g = greenValue >= 1.0 ? 1.0f : (greenValue < 0.0 ? 0.0f : (float)greenValue);
        cout.b = blueValue >= 1.0 ? 1.0f : (blueValue < 0.0 ? 0.0f : (float)blueValue);
    }

    @Override
    public void getColor(double value, ColorF32 cout) {
        assert (cout != null);
        float gray = value > 1.0 ? 1.0f : (value < 0.0 ? 0.0f : (float)value);
        cout.r = gray;
        cout.g = gray;
        cout.b = gray;
    }

    @Override
    public void getColor(ColorGene colorGene, ColorF32 cout) {
        this.getColor(colorGene.getRed().floatValue(), colorGene.getGreen().floatValue(), colorGene.getBlue().floatValue(), cout);
    }

    @Override
    public void getColor(Color color, ColorF32 cout) {
        this.getColor((double)color.getRed() / 256.0, (double)color.getGreen() / 256.0, (double)color.getBlue() / 256.0, cout);
    }

    @Override
    public String getShortName() {
        return "RGB";
    }

    @Override
    public void setColorTable(ChromosomeType colorTable) {
    }

    @Override
    public void getDiscretColor(int index, ColorF32 cout) {
        assert (cout != null);
        cout.r = 0.0f;
        cout.g = 0.0f;
        cout.b = 0.0f;
    }

    @Override
    public int getNumberOfDiscretColors() {
        return 0;
    }
}

