/*
 * Decompiled with CFR 0.152.
 */
package kandid.colorator;

import java.awt.Color;
import kandid.colorator.ColorF32;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;
import kandid.soup.ColorGene;
import kandid.soup.LookUpColorGene;
import kandid.soup.LookUpTableChromosome;
import kandid.soup.TransparentLookUpTableChromosome;

public class LookUpTableColorator
implements Colorator {
    private LookUpColorGene[] hsbSegment;
    private ColorF32[] rgbSegment;

    @Override
    public void getColor(double value, ColorF32 cout) {
        assert (cout != null);
        int ix = (int)((double)this.rgbSegment.length * value);
        if (ix >= this.rgbSegment.length) {
            ix = this.rgbSegment.length - 1;
        } else if (ix < 0) {
            ix = 0;
        }
        ColorF32.copy(this.rgbSegment[ix], cout);
    }

    @Override
    public void getColor(double redValue, double greenValue, double blueValue, ColorF32 cout) {
        this.getNearestColor((float)redValue, (float)greenValue, (float)blueValue, cout);
    }

    @Override
    public void getColor(ColorGene colorGene, ColorF32 cout) {
        this.getNearestColor(colorGene.getRed().floatValue(), colorGene.getGreen().floatValue(), colorGene.getBlue().floatValue(), cout);
    }

    @Override
    public void getColor(Color color, ColorF32 cout) {
        this.getNearestColor(color.getRed() / 256, color.getGreen() / 256, color.getBlue() / 256, cout);
    }

    private void getNearestColor(float red, float green, float blue, ColorF32 cout) {
        assert (cout != null);
        ColorF32 rgb = new ColorF32(red, green, blue);
        ColorF32 hsb = new ColorF32();
        ColorF32.rgb2hsb(rgb, hsb);
        int lx = 0;
        int nearestIndex = 0;
        double minDistance = Double.MAX_VALUE;
        while (lx < this.hsbSegment.length) {
            double dist = LookUpTableColorator.hsbDistance(this.hsbSegment[lx], hsb);
            if (dist < minDistance) {
                minDistance = dist;
                nearestIndex = lx;
            }
            ++lx;
        }
        LookUpColorGene nearestColorSegment = this.hsbSegment[nearestIndex];
        hsb.r = (float)nearestColorSegment.getHue().getValue().doubleValue();
        hsb.g = (float)nearestColorSegment.getSaturation().getValue().doubleValue();
        hsb.b = (float)nearestColorSegment.getBrightness().getValue().doubleValue();
        ColorF32.hsb2rgb(hsb, cout);
    }

    private static double hsbDistance(LookUpColorGene colorSegment, ColorF32 hsb) {
        double diffHue = LookUpTableColorator.diffHue(colorSegment.getHue().getValue(), hsb.r);
        double diffSaturation = colorSegment.getSaturation().getValue() - (double)hsb.g;
        double diffBrightness = colorSegment.getBrightness().getValue() - (double)hsb.b;
        return diffHue * diffHue + diffSaturation * diffSaturation + diffBrightness * diffBrightness;
    }

    public static double diffHue(double hue1, double hue2) {
        hue1 -= Math.floor(hue1);
        hue2 -= Math.floor(hue2);
        double diff1 = Math.abs(hue1 - hue2);
        double diff2 = Double.MAX_VALUE;
        if (hue1 < hue2) {
            diff2 = Math.abs(1.0 + hue1 - hue2);
        }
        if (hue2 < hue1) {
            diff2 = Math.abs(hue1 - (1.0 + hue2));
        }
        return diff1 < diff2 ? diff1 : diff2;
    }

    public static boolean isMinDiffCW(double hue1, double hue2) {
        hue1 -= Math.floor(hue1);
        boolean isCW1 = (hue2 -= Math.floor(hue2)) - hue1 > 0.0;
        double diff1 = Math.abs(hue1 - hue2);
        boolean isCW2 = false;
        double diff2 = Double.MAX_VALUE;
        if (hue1 < hue2) {
            diff2 = Math.abs(1.0 + hue1 - hue2);
        }
        if (hue2 < hue1) {
            diff2 = Math.abs(hue1 - (1.0 + hue2));
            isCW2 = true;
        }
        return diff1 < diff2 ? isCW1 : isCW2;
    }

    @Override
    public String getShortName() {
        return "LUT";
    }

    @Override
    public void setColorTable(ChromosomeType colorTable) {
        int size = 0;
        if (colorTable instanceof LookUpTableChromosome) {
            size = ((LookUpTableChromosome)colorTable).getLutColor().size();
        } else if (colorTable instanceof TransparentLookUpTableChromosome) {
            size = ((TransparentLookUpTableChromosome)colorTable).getLutColor().size();
        }
        assert (size >= 2) : "too less entries in color table";
        this.hsbSegment = new LookUpColorGene[size];
        this.rgbSegment = new ColorF32[size];
        if (colorTable instanceof LookUpTableChromosome) {
            ((LookUpTableChromosome)colorTable).getLutColor().toArray(this.hsbSegment);
        } else if (colorTable instanceof TransparentLookUpTableChromosome) {
            ((TransparentLookUpTableChromosome)colorTable).getLutColor().toArray(this.hsbSegment);
        }
        int ix = 0;
        while (ix < this.rgbSegment.length) {
            this.rgbSegment[ix] = new ColorF32();
            ColorF32 hsb = new ColorF32((float)this.hsbSegment[ix].getHue().getValue().doubleValue(), (float)this.hsbSegment[ix].getSaturation().getValue().doubleValue(), (float)this.hsbSegment[ix].getBrightness().getValue().doubleValue());
            ColorF32.hsb2rgb(hsb, this.rgbSegment[ix]);
            ++ix;
        }
    }

    @Override
    public void getDiscretColor(int index, ColorF32 cout) {
        assert (cout != null);
        if (index >= this.rgbSegment.length) {
            index = this.rgbSegment.length - 1;
        } else if (index < 0) {
            index = 0;
        }
        ColorF32.copy(this.rgbSegment[index], cout);
    }

    @Override
    public int getNumberOfDiscretColors() {
        return this.rgbSegment.length;
    }
}

