/*
 * Decompiled with CFR 0.152.
 */
package kandid.colorator;

import java.awt.Color;
import kandid.colorator.ColorF32;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;
import kandid.soup.ColorGene;
import kandid.soup.HsbFrequenceChromosome;

public class HsbFrequenceColorator
implements Colorator {
    private double phaseshift;
    private double frequence;

    @Override
    public void getColor(double hue, double saturation, double brightness, ColorF32 cout) {
        assert (cout != null);
        if (saturation < 0.0) {
            saturation = 0.0;
        } else if (saturation > 1.0) {
            saturation = 1.0;
        }
        if (brightness < 0.0) {
            brightness = 0.0;
        } else if (brightness > 1.0) {
            brightness = 1.0;
        }
        ColorF32 hsb = new ColorF32((float)(this.frequence * hue + this.phaseshift), (float)saturation, (float)brightness);
        ColorF32.hsb2rgb(hsb, cout);
    }

    @Override
    public void getColor(double brightness, ColorF32 cout) {
        assert (cout != null);
        float gray = brightness > 1.0 ? 1.0f : (brightness < 0.0 ? 0.0f : (float)brightness);
        cout.r = gray;
        cout.g = gray;
        cout.b = gray;
    }

    @Override
    public void getColor(ColorGene colorGene, ColorF32 cout) {
        assert (cout != null);
        cout.r = 0.0f;
        cout.g = 0.0f;
        cout.b = 0.0f;
    }

    @Override
    public void getColor(Color color, ColorF32 cout) {
        assert (cout != null);
        cout.r = 0.0f;
        cout.g = 0.0f;
        cout.b = 0.0f;
    }

    @Override
    public String getShortName() {
        return "HSBF";
    }

    @Override
    public void setColorTable(ChromosomeType colorTable) {
        this.frequence = ((HsbFrequenceChromosome)colorTable).getFrequence().getValue();
        this.phaseshift = ((HsbFrequenceChromosome)colorTable).getPhaseshift().getValue();
    }

    @Override
    public void getDiscretColor(int index, ColorF32 cout) {
        assert (cout != null);
        cout.r = 0.0f;
        cout.g = 0.0f;
        cout.b = 0.0f;
    }

    @Override
    public int getNumberOfDiscretColors() {
        return 0;
    }
}

