/*
 * Decompiled with CFR 0.152.
 */
package kandid.colorator;

import kandid.colorator.Colorator;
import kandid.soup.ColoratorType;
import kandid.util.Debug;

public class ColoratorFactory {
    public static boolean isSimpleColorator(String coloratorName) {
        return coloratorName.endsWith(".BlackWhiteColorator") || coloratorName.endsWith(".GrayColorator") || coloratorName.endsWith(".RGBColorator");
    }

    public static Colorator createColoratorWorker(String coloratorName, ColoratorType coloratorType) {
        try {
            Class<?> cc = Class.forName(coloratorName);
            Colorator colorator = (Colorator)cc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!ColoratorFactory.isSimpleColorator(coloratorName)) {
                if (coloratorName.equals("kandid.colorator.LookUpTableColorator")) {
                    colorator.setColorTable(coloratorType.getLookUpTable());
                } else if (coloratorName.equals("kandid.colorator.TransparentLookUpTableColorator")) {
                    colorator.setColorTable(coloratorType.getTransparentLookUpTable());
                } else if (coloratorName.equals("kandid.colorator.GradientColorator")) {
                    colorator.setColorTable(coloratorType.getGradient());
                } else if (coloratorName.equals("kandid.colorator.HsbFrequenceColorator")) {
                    colorator.setColorTable(coloratorType.getHsbFrequence());
                }
            }
            return colorator;
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
            return null;
        }
    }

    public static String getShortName(String coloratorName) {
        try {
            Class<?> cc = Class.forName(coloratorName);
            Colorator colorator = (Colorator)cc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return colorator.getShortName();
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
            return "";
        }
    }
}

