/*
 * Decompiled with CFR 0.152.
 */
package kandid.colorator;

import junit.framework.Assert;
import junit.framework.TestCase;
import kandid.colorator.ColorF32;

public class ColorF32Test
extends TestCase {
    public void testHsb() {
        ColorF32 color_in = new ColorF32(0.0f, 0.0f, 0.0f);
        ColorF32 expected_hsb = new ColorF32(0.0f, 0.0f, 0.0f);
        this.convert(ColorF32.black, expected_hsb, color_in);
        ColorF32 expected_hsb2 = new ColorF32(0.0f, 0.0f, 1.0f);
        ColorF32 color_in2 = new ColorF32(1.0f, 1.0f, 1.0f);
        this.convert(ColorF32.white, expected_hsb2, color_in2);
        ColorF32 expected = new ColorF32(1.0f, 0.0f, 0.0f);
        expected_hsb = new ColorF32(0.0f, 1.0f, 1.0f);
        ColorF32 color_in3 = new ColorF32(1.0f, 0.0f, 0.0f);
        this.convert(expected, expected_hsb, color_in3);
        expected = new ColorF32(0.0f, 0.5f, 0.7f);
        expected_hsb = new ColorF32(0.54761904f, 1.0f, 0.7f);
        color_in3 = new ColorF32(0.0f, 0.5f, 0.7f);
        this.convert(expected, expected_hsb, color_in3);
        expected = new ColorF32(0.1f, 0.2f, 0.3f);
        expected_hsb = new ColorF32(0.5833333f, 0.6666667f, 0.3f);
        color_in3 = new ColorF32(0.1f, 0.2f, 0.3f);
        this.convert(expected, expected_hsb, color_in3);
        expected = new ColorF32(0.2f, 0.3f, 0.1f);
        expected_hsb = new ColorF32(0.0f, 0.0f, 0.3f);
        color_in3 = new ColorF32(0.2f, 0.3f, 0.1f);
        this.convert(expected, expected_hsb, color_in3);
    }

    private void convert(ColorF32 expectedRGB, ColorF32 expectedHSB, ColorF32 color_in) {
        ColorF32 color_out = new ColorF32(0.0f, 0.0f, 0.0f);
        ColorF32 hsb = new ColorF32();
        ColorF32.rgb2hsb(color_in, hsb);
        System.out.println("rgb " + String.valueOf(expectedRGB) + " hsb " + String.valueOf(hsb));
        if (expectedHSB != null) {
            Assert.assertEquals((float)expectedHSB.r, (float)hsb.r, (float)0.5000001f);
            Assert.assertEquals((float)expectedHSB.g, (float)hsb.g, (float)0.5000001f);
            Assert.assertEquals((float)expectedHSB.b, (float)hsb.b, (float)0.5000001f);
        }
        ColorF32.hsb2rgb(hsb, color_out);
        Assert.assertEquals((float)expectedRGB.r, (float)color_out.r, (float)0.5000001f);
        Assert.assertEquals((float)expectedRGB.g, (float)color_out.g, (float)0.5000001f);
        Assert.assertEquals((float)expectedRGB.b, (float)color_out.b, (float)0.5000001f);
    }
}

