/*
 * Decompiled with CFR 0.152.
 */
package kandid.colorator;

import java.util.Objects;

public class ColorF32 {
    public float r;
    public float g;
    public float b;
    public static final ColorF32 black = new ColorF32(0.0f, 0.0f, 0.0f);
    public static final ColorF32 white = new ColorF32(1.0f, 1.0f, 1.0f);

    public ColorF32() {
        this.r = 0.0f;
        this.g = 0.0f;
        this.b = 0.0f;
    }

    public ColorF32(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b));
    }

    public boolean equals(Object other) {
        if (other instanceof ColorF32) {
            ColorF32 c = (ColorF32)other;
            return c.r == this.r && c.g == this.g && c.b == this.b;
        }
        return false;
    }

    public static void copy(ColorF32 src, ColorF32 dst) {
        assert (src != null);
        assert (dst != null);
        dst.r = src.r;
        dst.g = src.g;
        dst.b = src.b;
    }

    private static float clamp(float v) {
        if (v < 0.0f) {
            return 0.0f;
        }
        if (v > 1.0f) {
            return 1.0f;
        }
        return v;
    }

    private static int clamp_u8(float v) {
        if (v < 0.0f) {
            return 0;
        }
        if (v > 1.0f) {
            return 255;
        }
        return (int)(v * 255.0f);
    }

    private static float max_float(float v1, float v2) {
        return v1 < v2 ? v2 : v1;
    }

    private static float min_float(float v1, float v2) {
        return v1 < v2 ? v1 : v2;
    }

    public static void rgb2hsb(ColorF32 src, ColorF32 dst) {
        assert (src != null);
        assert (dst != null);
        float r = ColorF32.clamp(src.r);
        float g = ColorF32.clamp(src.g);
        float b = ColorF32.clamp(src.b);
        float max = ColorF32.max_float(r, ColorF32.max_float(g, b));
        float min = ColorF32.min_float(r, ColorF32.min_float(g, b));
        float delta = max - min;
        dst.b = max;
        if (delta == 0.0f) {
            dst.r = 0.0f;
            dst.g = 0.0f;
            return;
        }
        dst.g = delta / max;
        dst.r = r == max ? (g - b) / delta / 6.0f : (g == max ? (2.0f + (b - r) / delta) / 6.0f : (4.0f + (r - g) / delta) / 6.0f);
        if (dst.r < 0.0f) {
            dst.r += 1.0f;
        }
    }

    public static void hsb2rgb(ColorF32 src, ColorF32 dst) {
        assert (src != null);
        assert (dst != null);
        if (src.g <= 0.0f) {
            dst.r = src.b;
            dst.g = src.b;
            dst.b = src.b;
        } else {
            float h = (src.r - (float)Math.floor(src.r)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = src.b * (1.0f - src.g);
            float q = src.b * (1.0f - src.g * f);
            float t = src.b * (1.0f - src.g * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    dst.r = src.b;
                    dst.g = t;
                    dst.b = p;
                    break;
                }
                case 1: {
                    dst.r = q;
                    dst.g = src.b;
                    dst.b = p;
                    break;
                }
                case 2: {
                    dst.r = p;
                    dst.g = src.b;
                    dst.b = t;
                    break;
                }
                case 3: {
                    dst.r = p;
                    dst.g = q;
                    dst.b = src.b;
                    break;
                }
                case 4: {
                    dst.r = t;
                    dst.g = p;
                    dst.b = src.b;
                    break;
                }
                default: {
                    dst.r = src.b;
                    dst.g = p;
                    dst.b = q;
                }
            }
        }
    }

    public static int toRGB8(ColorF32 src) {
        int r = ColorF32.clamp_u8(src.r);
        int g = ColorF32.clamp_u8(src.g);
        int b = ColorF32.clamp_u8(src.b);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public String toString() {
        return "ColorF32 [r=" + this.r + ", g=" + this.g + ", b=" + this.b + "]";
    }
}

