/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.voronoi;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import kandid.calculation.Deviation;
import kandid.calculation.voronoi.Pair;
import kandid.calculation.voronoi.PairList;
import kandid.calculation.voronoi.VoronoiCalculationBase;
import kandid.colorator.ColorF32;
import kandid.soup.KingGene;
import kandid.soup.VoronoiTransparentChromosome;

public class VoronoiTransparentCalculation
extends VoronoiCalculationBase
implements Cloneable {
    protected double[] kingRed;
    protected double[] kingGreen;
    protected double[] kingBlue;
    protected int prioritySize;
    protected double priorityWeight;

    @Override
    public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
        this.depth = 6;
        this.xwMin = 0.0;
        this.xwMax = 1.0;
        this.ywMin = 0.0;
        this.ywMax = 1.0;
        super.activateCanvas(viewComponent, canvasSize, zoomMode);
        VoronoiTransparentChromosome voronoiTransparentChromosome = (VoronoiTransparentChromosome)this.chromosome;
        this.prioritySize = voronoiTransparentChromosome.getPrioritySize().getValue();
        this.priorityWeight = voronoiTransparentChromosome.getPriorityWeight().getValue();
        List<KingGene> kingList = voronoiTransparentChromosome.getKing();
        this.numberOfKings = kingList.size();
        this.kingRed = new double[this.numberOfKings];
        this.kingGreen = new double[this.numberOfKings];
        this.kingBlue = new double[this.numberOfKings];
        int kx = 0;
        while (kx < this.numberOfKings) {
            KingGene kingGene = kingList.get(kx);
            this.kingRed[kx] = kingGene.getColor().getRed().floatValue();
            this.kingGreen[kx] = kingGene.getColor().getGreen().floatValue();
            this.kingBlue[kx] = kingGene.getColor().getBlue().floatValue();
            ++kx;
        }
    }

    @Override
    public void calculate(Deviation dev, boolean paintOnScreen, String doExport) {
        ColorF32 colorF32 = new ColorF32();
        if (this.enterDepth()) {
            while (this.more) {
                PairList nearest = new PairList(this.prioritySize);
                int kx = this.numberOfKings;
                while (kx > 0) {
                    double dist = this.kw[--kx] * this.distance(kx);
                    nearest.insert(new Pair(dist, kx));
                }
                double sumRed = 0.0;
                double sumGreen = 0.0;
                double sumBlue = 0.0;
                double factor = 1.0;
                double divisor = 0.0;
                int px = this.prioritySize - 1;
                while (px >= 0) {
                    int nk = nearest.getKing(px);
                    if (nk < 0) break;
                    sumRed += factor * this.kingRed[nk];
                    sumGreen += factor * this.kingGreen[nk];
                    sumBlue += factor * this.kingBlue[nk];
                    divisor += factor;
                    factor *= this.priorityWeight;
                    --px;
                }
                colorF32.r = (float)(sumRed / divisor);
                colorF32.g = (float)(sumGreen / divisor);
                colorF32.b = (float)(sumBlue / divisor);
                this.setPixel(colorF32);
                this.nextLocation();
            }
        }
    }

    @Override
    public boolean hasWhiteBackground() {
        return false;
    }
}

