/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.voronoi;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import kandid.calculation.Deviation;
import kandid.calculation.voronoi.VoronoiCalculationBase;
import kandid.colorator.ColorF32;
import kandid.soup.KingGene;
import kandid.soup.VoronoiChromosome;

public class VoronoiCalculation
extends VoronoiCalculationBase
implements Cloneable {
    protected ColorF32[] intPalette;
    protected double yard;

    @Override
    public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
        super.activateCanvas(viewComponent, canvasSize, zoomMode);
        VoronoiChromosome voronoiChromosome = (VoronoiChromosome)this.chromosome;
        this.yard = voronoiChromosome.getYard().getValue();
        List<KingGene> kingList = voronoiChromosome.getKing();
        this.numberOfKings = kingList.size();
        this.intPalette = new ColorF32[this.numberOfKings];
        int kx = 0;
        while (kx < this.numberOfKings) {
            KingGene kingGene = kingList.get(kx);
            this.intPalette[kx] = new ColorF32();
            this.colorator.getColor(kingGene.getColor(), this.intPalette[kx]);
            ++kx;
        }
    }

    @Override
    public void calculate(Deviation dev, boolean paintOnScreen, String doExport) {
        if (this.enterDepth()) {
            while (this.more) {
                double nearestDistance = Double.MAX_VALUE;
                int nearestKing = 0;
                int kx = this.numberOfKings;
                while (kx > 0) {
                    double dist = this.kw[--kx] * this.distance(kx);
                    if (this.yard > 0.0) {
                        dist = dist < this.yard ? 0.0 : (dist -= this.yard);
                    }
                    if (!(dist < nearestDistance)) continue;
                    nearestDistance = dist;
                    nearestKing = kx;
                }
                this.setPixel(this.intPalette[nearestKing]);
                this.nextLocation();
            }
        }
    }

    @Override
    public boolean hasWhiteBackground() {
        return false;
    }
}

