/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.voronoi;

import kandid.calculation.voronoi.Pair;

public class PairList {
    private int size;
    private Pair[] pairlist;
    private int entries;

    public PairList(int size) {
        this.size = size;
        this.pairlist = new Pair[size];
        this.entries = 0;
    }

    public void insert(Pair pair) {
        int ix = 0;
        while (ix < this.entries && ix < this.size) {
            if (pair.distance < this.pairlist[ix].distance) {
                int mx = this.size - 1;
                while (mx > ix) {
                    this.pairlist[mx] = this.pairlist[mx - 1];
                    --mx;
                }
                break;
            }
            ++ix;
        }
        if (ix < this.size) {
            this.pairlist[ix] = pair;
            ++this.entries;
        }
    }

    public int getKing(int priority) {
        return this.pairlist[priority] == null ? -1 : this.pairlist[priority].king;
    }
}

