/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.vm.vector;

import java.util.List;
import java.util.Random;
import javax.vecmath.Vector3d;
import kandid.soup.ExprVectorArgsListGene;
import kandid.soup.ExprVectorConstGene;
import kandid.soup.ExprVectorListGene;
import kandid.soup.ExprVectorOprBase;
import kandid.soup.ExprVectorOprGene;
import kandid.soup.ExprVectorVarBase;
import kandid.soup.ExprVectorVarGene;
import kandid.soup.GeneType;
import kandid.soup.VectorExprGene;
import kandid.util.Complex;
import kandid.util.PovNoise;

public class VectorVM {
    private static final int maxTapeLen = 16384;
    protected int[] codeTape;
    protected int[] iOper;
    protected double[] xOper;
    protected double[] yOper;
    protected double[] zOper;
    protected int tapeLength;
    protected double[] xStack = new double[128];
    protected double[] yStack = new double[128];
    protected double[] zStack = new double[128];
    protected PovNoise povNoise;
    protected double[] aList = new double[6];
    protected Random aListRandomAccess = new Random();
    protected static final int oprStop = 0;
    protected static final int oprPop = 1;
    protected static final int oprPushConst = 2;
    protected static final int oprPushAccu = 3;
    protected static final int oprPushXYT = 4;
    protected static final int oprPushXYR = 5;
    protected static final int oprPushXYM = 6;
    protected static final int oprPushCMPOW = 7;
    protected static final int oprPushCMSINH = 8;
    protected static final int oprPushCMIM = 9;
    protected static final int oprPushCMRE = 10;
    protected static final int oprIf = 11;
    protected static final int oprJmp = 12;
    protected static final int oprAdd = 13;
    protected static final int oprSub = 14;
    protected static final int oprMult = 15;
    protected static final int oprMod = 16;
    protected static final int oprCross = 17;
    protected static final int oprSincos = 18;
    protected static final int oprAtan = 19;
    protected static final int oprMaxvalue = 20;
    protected static final int oprMinvalue = 21;
    protected static final int oprMaxvector = 22;
    protected static final int oprMinvector = 23;
    protected static final int oprMaxmix = 24;
    protected static final int oprInvmix = 25;
    protected static final int oprStep = 26;
    protected static final int oprNoise = 27;
    protected static final int oprTurbulence = 28;
    protected static final int oprWaves = 29;

    public VectorVM(long seed) {
        this.povNoise = new PovNoise(seed);
    }

    public void compile(VectorExprGene vectorExprGene) {
        this.codeTape = new int[16384];
        this.iOper = new int[16384];
        this.xOper = new double[16384];
        this.yOper = new double[16384];
        this.zOper = new double[16384];
        this.tapeLength = 0;
        this.compile0(vectorExprGene);
        this.codeTape[this.tapeLength] = 0;
        ++this.tapeLength;
    }

    private void compile0(VectorExprGene vectorExprGene) {
        ExprVectorListGene exprListGene = vectorExprGene.getList();
        ExprVectorOprGene opr = exprListGene.getOpr();
        ExprVectorArgsListGene args = exprListGene.getArgs();
        List<GeneType> argsList = args.getVarOrConstOrVectorExpression();
        int argsLen = argsList.size();
        assert (argsLen > 0) : "argument list to short " + argsLen;
        if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.ADD)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 13;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.SUB)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 14;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.MULT)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 15;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.MOD)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 16;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.CROSS)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 17;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.SINCOS)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 18;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.ATAN)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 19;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.MAXVALUE)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 20;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.MINVALUE)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 21;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.MAXVECTOR)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 22;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.MINVECTOR)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 23;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.MAXMIX)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 24;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.INVMIX)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 25;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.STEP)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 26;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.NOISE)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 27;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.TURBULENCE)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 28;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getVectorOpr().equals((Object)ExprVectorOprBase.WAVES)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 29;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else assert (false) : "invalid operator " + String.valueOf((Object)opr.getVectorOpr());
    }

    private void compileElement(GeneType obj) {
        if (obj instanceof ExprVectorVarGene) {
            ExprVectorVarGene var = (ExprVectorVarGene)obj;
            if (var.getVectorVar().equals((Object)ExprVectorVarBase.XYT)) {
                this.codeTape[this.tapeLength++] = 4;
            } else if (var.getVectorVar().equals((Object)ExprVectorVarBase.XYR)) {
                this.codeTape[this.tapeLength++] = 5;
            } else if (var.getVectorVar().equals((Object)ExprVectorVarBase.XYM)) {
                this.codeTape[this.tapeLength++] = 6;
            } else if (var.getVectorVar().equals((Object)ExprVectorVarBase.CMPOW)) {
                this.codeTape[this.tapeLength++] = 7;
            } else if (var.getVectorVar().equals((Object)ExprVectorVarBase.CMSINH)) {
                this.codeTape[this.tapeLength++] = 8;
            } else if (var.getVectorVar().equals((Object)ExprVectorVarBase.CMIM)) {
                this.codeTape[this.tapeLength++] = 9;
            } else if (var.getVectorVar().equals((Object)ExprVectorVarBase.CMRE)) {
                this.codeTape[this.tapeLength++] = 10;
            } else assert (false) : "invalid var compiling vector expression" + String.valueOf((Object)var.getVectorVar());
        } else if (obj instanceof ExprVectorConstGene) {
            ExprVectorConstGene aConst = (ExprVectorConstGene)obj;
            this.codeTape[this.tapeLength] = 2;
            this.xOper[this.tapeLength] = aConst.getCx().getValue();
            this.yOper[this.tapeLength] = aConst.getCy().getValue();
            this.zOper[this.tapeLength] = aConst.getCz().getValue();
            ++this.tapeLength;
        } else if (obj instanceof VectorExprGene) {
            VectorExprGene vectorExpressionArg = (VectorExprGene)obj;
            this.compile0(vectorExpressionArg);
            this.codeTape[this.tapeLength++] = 3;
        } else assert (false) : "invalid object compiling vector expression" + obj.getClass().getName();
    }

    public void execute(double x, double y, double t, double xscale, double yscale, Vector3d result) {
        double r = Math.sqrt((x *= Math.exp(xscale)) * x + (y *= Math.exp(yscale)) * y);
        double m = Math.abs(x) + Math.abs(y);
        Complex cm = new Complex(x, y);
        Complex cm_pow2 = Complex.multiply(cm, cm);
        Complex cm_pow3 = Complex.multiply(cm, cm_pow2);
        Complex cm_cos = Complex.cos(cm);
        Complex cm_sinh = Complex.sinh(cm);
        double xAccu = 0.0;
        double yAccu = 0.0;
        double zAccu = 0.0;
        int tos = 0;
        int ip = 0;
        int argLength = 0;
        while (ip < this.tapeLength) {
            switch (this.codeTape[ip]) {
                case 0: {
                    result.x = xAccu;
                    result.y = yAccu;
                    result.z = zAccu;
                    return;
                }
                case 1: {
                    xAccu = this.xStack[--tos];
                    yAccu = this.yStack[tos];
                    zAccu = this.zStack[tos];
                    break;
                }
                case 2: {
                    this.xStack[tos] = this.xOper[ip];
                    this.yStack[tos] = this.yOper[ip];
                    this.zStack[tos] = this.zOper[ip];
                    ++tos;
                    break;
                }
                case 3: {
                    this.xStack[tos] = xAccu;
                    this.yStack[tos] = yAccu;
                    this.zStack[tos] = zAccu;
                    ++tos;
                    break;
                }
                case 4: {
                    this.xStack[tos] = x;
                    this.yStack[tos] = y;
                    this.zStack[tos] = t;
                    ++tos;
                    break;
                }
                case 5: {
                    this.xStack[tos] = x;
                    this.yStack[tos] = y;
                    this.zStack[tos] = r;
                    ++tos;
                    break;
                }
                case 6: {
                    this.xStack[tos] = x;
                    this.yStack[tos] = y;
                    this.zStack[tos] = m;
                    ++tos;
                    break;
                }
                case 7: {
                    this.xStack[tos] = cm_pow3.re;
                    this.yStack[tos] = cm_pow3.im;
                    this.zStack[tos] = cm_sinh.re;
                    ++tos;
                    break;
                }
                case 8: {
                    this.xStack[tos] = cm_sinh.re;
                    this.yStack[tos] = cm_sinh.im;
                    this.zStack[tos] = cm_cos.im;
                    ++tos;
                    break;
                }
                case 9: {
                    this.xStack[tos] = cm_pow2.im;
                    this.yStack[tos] = cm_cos.im;
                    this.zStack[tos] = cm_sinh.im;
                    ++tos;
                    break;
                }
                case 10: {
                    this.xStack[tos] = cm_pow2.re;
                    this.yStack[tos] = cm_cos.re;
                    this.zStack[tos] = cm_sinh.re;
                    ++tos;
                    break;
                }
                case 12: {
                    ip = this.iOper[ip] - 1;
                    break;
                }
                case 13: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'add' should be 2.";
                    xAccu = this.xStack[tos - 1] + this.xStack[tos - 2];
                    yAccu = this.yStack[tos - 1] + this.yStack[tos - 2];
                    zAccu = this.zStack[tos - 1] + this.zStack[tos - 2];
                    tos -= 2;
                    break;
                }
                case 14: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'sub' should be 2.";
                    xAccu = this.xStack[tos - 1] - this.xStack[tos - 2];
                    yAccu = this.yStack[tos - 1] - this.yStack[tos - 2];
                    zAccu = this.zStack[tos - 1] - this.zStack[tos - 2];
                    tos -= 2;
                    break;
                }
                case 15: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'mult' should be 2.";
                    xAccu = this.xStack[tos - 1] * this.xStack[tos - 2];
                    yAccu = this.yStack[tos - 1] * this.yStack[tos - 2];
                    zAccu = this.zStack[tos - 1] * this.zStack[tos - 2];
                    tos -= 2;
                    break;
                }
                case 16: {
                    long n;
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'mod' should be 2.";
                    if (Math.abs(this.xStack[tos - 2]) > 1.0E-10) {
                        n = (long)(this.xStack[tos - 1] / this.xStack[tos - 2]);
                        xAccu = this.xStack[tos - 1] - (double)n * this.xStack[tos - 2];
                        if (xAccu < 0.0) {
                            xAccu += this.xStack[tos - 2];
                        }
                    } else {
                        xAccu = 0.0;
                    }
                    if (Math.abs(this.yStack[tos - 2]) > 1.0E-10) {
                        n = (long)(this.yStack[tos - 1] / this.yStack[tos - 2]);
                        yAccu = this.yStack[tos - 1] - (double)n * this.yStack[tos - 2];
                        if (yAccu < 0.0) {
                            yAccu += this.yStack[tos - 2];
                        }
                    } else {
                        yAccu = 0.0;
                    }
                    if (Math.abs(this.zStack[tos - 2]) > 1.0E-10) {
                        n = (long)(this.zStack[tos - 1] / this.zStack[tos - 2]);
                        zAccu = this.zStack[tos - 1] - (double)n * this.zStack[tos - 2];
                        if (zAccu < 0.0) {
                            zAccu += this.zStack[tos - 2];
                        }
                        zAccu = this.zStack[tos - 1];
                    } else {
                        zAccu = 0.0;
                    }
                    tos -= 2;
                    break;
                }
                case 17: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'cross' should be 2.";
                    xAccu = this.yStack[tos - 1] * this.zStack[tos - 2] - this.zStack[tos - 1] * this.yStack[tos - 2];
                    yAccu = this.zStack[tos - 1] * this.xStack[tos - 2] - this.xStack[tos - 1] * this.zStack[tos - 2];
                    zAccu = this.xStack[tos - 1] * this.yStack[tos - 2] - this.yStack[tos - 1] * this.xStack[tos - 2];
                    tos -= 2;
                    break;
                }
                case 18: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'sincos' should be 2.";
                    xAccu = Math.sin(Math.PI * this.xStack[tos - 1]) + Math.cos(Math.PI * this.xStack[tos - 2]);
                    yAccu = Math.sin(Math.PI * this.yStack[tos - 1]) + Math.cos(Math.PI * this.yStack[tos - 2]);
                    zAccu = Math.sin(Math.PI * this.zStack[tos - 1]) + Math.cos(Math.PI * this.zStack[tos - 2]);
                    tos -= 2;
                    break;
                }
                case 19: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'atan' should be 2.";
                    xAccu = Math.atan2(this.xStack[tos - 1], this.xStack[tos - 2]) / Math.PI;
                    yAccu = Math.atan2(this.yStack[tos - 1], this.yStack[tos - 2]) / Math.PI;
                    zAccu = Math.atan2(this.zStack[tos - 1], this.zStack[tos - 2]) / Math.PI;
                    tos -= 2;
                    break;
                }
                case 20: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'maxvalue' should be 2.";
                    xAccu = this.xStack[tos - 1] > this.xStack[tos - 2] ? this.xStack[tos - 1] : this.xStack[tos - 2];
                    yAccu = this.yStack[tos - 1] > this.yStack[tos - 2] ? this.yStack[tos - 1] : this.yStack[tos - 2];
                    zAccu = this.zStack[tos - 1] > this.zStack[tos - 2] ? this.zStack[tos - 1] : this.zStack[tos - 2];
                    tos -= 2;
                    break;
                }
                case 21: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'minvalue' should be 2.";
                    xAccu = this.xStack[tos - 1] < this.xStack[tos - 2] ? this.xStack[tos - 1] : this.xStack[tos - 2];
                    yAccu = this.yStack[tos - 1] < this.yStack[tos - 2] ? this.yStack[tos - 1] : this.yStack[tos - 2];
                    zAccu = this.zStack[tos - 1] < this.zStack[tos - 2] ? this.zStack[tos - 1] : this.zStack[tos - 2];
                    tos -= 2;
                    break;
                }
                case 22: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'maxvector' should be 2.";
                    if (this.xStack[tos - 1] * this.xStack[tos - 1] + this.yStack[tos - 1] * this.yStack[tos - 1] + this.zStack[tos - 1] * this.zStack[tos - 1] > this.xStack[tos - 2] * this.xStack[tos - 2] + this.yStack[tos - 2] * this.yStack[tos - 2] + this.zStack[tos - 2] * this.zStack[tos - 2]) {
                        xAccu = this.xStack[tos - 1];
                        yAccu = this.yStack[tos - 1];
                        zAccu = this.zStack[tos - 1];
                    } else {
                        xAccu = this.xStack[tos - 2];
                        yAccu = this.yStack[tos - 2];
                        zAccu = this.zStack[tos - 2];
                    }
                    tos -= 2;
                    break;
                }
                case 23: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'minvector' should be 2.";
                    if (this.xStack[tos - 1] * this.xStack[tos - 1] + this.yStack[tos - 1] * this.yStack[tos - 1] + this.zStack[tos - 1] * this.zStack[tos - 1] < this.xStack[tos - 2] * this.xStack[tos - 2] + this.yStack[tos - 2] * this.yStack[tos - 2] + this.zStack[tos - 2] * this.zStack[tos - 2]) {
                        xAccu = this.xStack[tos - 1];
                        yAccu = this.yStack[tos - 1];
                        zAccu = this.zStack[tos - 1];
                    } else {
                        xAccu = this.xStack[tos - 2];
                        yAccu = this.yStack[tos - 2];
                        zAccu = this.zStack[tos - 2];
                    }
                    tos -= 2;
                    break;
                }
                case 24: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'maxmix' should be 2.";
                    double l1 = this.xStack[tos - 1] * this.xStack[tos - 1] + this.yStack[tos - 1] * this.yStack[tos - 1] + this.zStack[tos - 1] * this.zStack[tos - 1];
                    double l2 = this.xStack[tos - 2] * this.xStack[tos - 2] + this.yStack[tos - 2] * this.yStack[tos - 2] + this.zStack[tos - 2] * this.zStack[tos - 2];
                    double h = l1 / (l1 + l2);
                    xAccu = h * this.xStack[tos - 1] + (1.0 - h) * this.xStack[tos - 2];
                    yAccu = h * this.yStack[tos - 1] + (1.0 - h) * this.yStack[tos - 2];
                    zAccu = h * this.zStack[tos - 1] + (1.0 - h) * this.zStack[tos - 2];
                    tos -= 2;
                    break;
                }
                case 25: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'invmix' should be 2.";
                    double l1 = this.xStack[tos - 1] * this.xStack[tos - 1] + this.yStack[tos - 1] * this.yStack[tos - 1] + this.zStack[tos - 1] * this.zStack[tos - 1];
                    double l2 = this.xStack[tos - 2] * this.xStack[tos - 2] + this.yStack[tos - 2] * this.yStack[tos - 2] + this.zStack[tos - 2] * this.zStack[tos - 2];
                    double h = l1 / (l1 + l2);
                    xAccu = (1.0 - h) * this.xStack[tos - 1] + h * this.xStack[tos - 2];
                    yAccu = (1.0 - h) * this.yStack[tos - 1] + h * this.yStack[tos - 2];
                    zAccu = (1.0 - h) * this.zStack[tos - 1] + h * this.zStack[tos - 2];
                    tos -= 2;
                    break;
                }
                case 26: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'step' should be 2.";
                    xAccu = this.xStack[tos - 1] > this.xStack[tos - 2] ? 1.0 : -1.0;
                    yAccu = this.yStack[tos - 1] > this.yStack[tos - 2] ? 1.0 : -1.0;
                    zAccu = this.zStack[tos - 1] > this.zStack[tos - 2] ? 1.0 : -1.0;
                    tos -= 2;
                    break;
                }
                case 27: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'noise' should be 2.";
                    Vector3d vr = this.povNoise.getDNoise(this.xStack[tos - 2] * this.xStack[tos - 1], this.yStack[tos - 2] * this.yStack[tos - 1], this.zStack[tos - 2] * this.zStack[tos - 1]);
                    xAccu = vr.x;
                    yAccu = vr.y;
                    zAccu = vr.z;
                    tos -= 2;
                    break;
                }
                case 28: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'turbulence' should be 2.";
                    int octaves = (int)Math.log(1.0 + 1.0 / (Math.abs(this.xStack[tos - 2]) + 1.0E-10) + 1.0 / (Math.abs(this.yStack[tos - 2]) + 1.0E-10) + 1.0 / (Math.abs(this.zStack[tos - 2]) + 1.0E-10) + 1.0 / (Math.abs(this.xStack[tos - 1]) + 1.0E-10) + 1.0 / (Math.abs(this.yStack[tos - 1]) + 1.0E-10) + 1.0 / (Math.abs(this.zStack[tos - 1]) + 1.0E-10));
                    octaves = octaves > 7 ? 8 : octaves + 1;
                    Vector3d vr = this.povNoise.getDTurbulence(this.xStack[tos - 2] * this.xStack[tos - 1], this.yStack[tos - 2] * this.yStack[tos - 1], this.zStack[tos - 2] * this.zStack[tos - 1], octaves);
                    xAccu = vr.x;
                    yAccu = vr.y;
                    zAccu = vr.z;
                    tos -= 2;
                    break;
                }
                case 29: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'waves' should be 2.";
                    int numberOfWaves = (int)Math.log(1.0 + 1.0 / (Math.abs(this.xStack[tos - 2]) + 1.0E-10) + 1.0 / (Math.abs(this.yStack[tos - 2]) + 1.0E-10) + 1.0 / (Math.abs(this.zStack[tos - 2]) + 1.0E-10) + 1.0 / (Math.abs(this.xStack[tos - 1]) + 1.0E-10) + 1.0 / (Math.abs(this.yStack[tos - 1]) + 1.0E-10) + 1.0 / Math.abs(this.zStack[tos - 1] + 1.0E-10));
                    Vector3d vr = this.povNoise.getWaves(this.xStack[tos - 2] * this.xStack[tos - 1], this.xStack[tos - 2] * this.yStack[tos - 1], this.xStack[tos - 2] * this.zStack[tos - 1], this.yStack[tos - 2], this.zStack[tos - 2], numberOfWaves);
                    xAccu = vr.x;
                    yAccu = vr.y;
                    zAccu = vr.z;
                    tos -= 2;
                    break;
                }
                default: {
                    assert (false) : "invalid code " + this.codeTape[ip] + " on tape position " + ip;
                    break;
                }
            }
            ++ip;
        }
        result.x = xAccu;
        result.y = yAccu;
        result.z = zAccu;
    }

    public String toString() {
        StringBuffer asm = new StringBuffer();
        int ip = 0;
        while (ip < this.tapeLength) {
            asm.append(ip + "\t");
            switch (this.codeTape[ip]) {
                case 0: {
                    asm.append("stop");
                    break;
                }
                case 1: {
                    asm.append("pop");
                    break;
                }
                case 2: {
                    asm.append("pushConst\t");
                    asm.append(this.xOper[ip]);
                    asm.append('\t');
                    asm.append(this.yOper[ip]);
                    asm.append('\t');
                    asm.append(this.zOper[ip]);
                    break;
                }
                case 3: {
                    asm.append("pushAccu");
                    break;
                }
                case 4: {
                    asm.append("pushXYT");
                    break;
                }
                case 5: {
                    asm.append("pushXYR");
                    break;
                }
                case 6: {
                    asm.append("pushXYM");
                    break;
                }
                case 7: {
                    asm.append("pushCMPOW");
                    break;
                }
                case 8: {
                    asm.append("pushCMSINH");
                    break;
                }
                case 9: {
                    asm.append("pushCMIM");
                    break;
                }
                case 10: {
                    asm.append("pushCMRE");
                    break;
                }
                case 13: {
                    asm.append("add\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 14: {
                    asm.append("sub\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 15: {
                    asm.append("mult\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 16: {
                    asm.append("mod\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 17: {
                    asm.append("cross\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 18: {
                    asm.append("sincos\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 19: {
                    asm.append("atan\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 20: {
                    asm.append("maxvalue\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 21: {
                    asm.append("minvalue\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 22: {
                    asm.append("maxvector\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 23: {
                    asm.append("minvector\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 24: {
                    asm.append("maxmix\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 25: {
                    asm.append("invmix\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 26: {
                    asm.append("step\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 27: {
                    asm.append("noise\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 28: {
                    asm.append("turbulence\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 29: {
                    asm.append("waves\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                default: {
                    asm.append("invalid code\t");
                    asm.append(this.iOper[ip]);
                    assert (false) : "invalid code " + this.codeTape[ip] + " on tape position " + ip;
                    break;
                }
            }
            asm.append('\n');
            ++ip;
        }
        return asm.toString();
    }
}

