/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.vm.vector;

import java.awt.Component;
import java.awt.Dimension;
import javax.vecmath.Vector3d;
import kandid.calculation.Deviation;
import kandid.calculation.RefinementCalculation;
import kandid.calculation.vm.vector.VectorVM;
import kandid.colorator.ColorF32;
import kandid.soup.ChromosomeType;
import kandid.soup.VectorExprGene;
import kandid.soup.VectorExpressionChromosome;

public class VectorExpressionCalculation
extends RefinementCalculation {
    private ScanResults scanResults;
    private VectorVM vectorVM;
    private double xscale = 1.0;
    private double yscale = 1.0;

    @Override
    public boolean reject(ChromosomeType chromosome) {
        this.depth = 6;
        this.xwMin = -1.0;
        this.xwMax = 1.0;
        this.ywMin = -1.0;
        this.ywMax = 1.0;
        this.chromosome = chromosome;
        VectorExpressionChromosome vectorExpressionChromosome = (VectorExpressionChromosome)chromosome;
        VectorExprGene vectorExprGene = vectorExpressionChromosome.getVectorExpression();
        this.vectorVM = new VectorVM(vectorExpressionChromosome.getNoiseSeed().getValue());
        this.xscale = vectorExpressionChromosome.getXScale().getValue();
        this.yscale = vectorExpressionChromosome.getYScale().getValue();
        try {
            this.vectorVM.compile(vectorExprGene);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        this.scanResults = new ScanResults(vectorExpressionChromosome);
        return this.scanResults.isNaN || this.scanResults.range <= 1.000001E-4;
    }

    @Override
    public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
        this.depth = 6;
        this.xwMin = -1.1;
        this.xwMax = 1.1;
        this.ywMin = -1.1;
        this.ywMax = 1.1;
        super.activateCanvas(viewComponent, canvasSize, zoomMode);
        VectorExpressionChromosome vectorExpressionChromosome = (VectorExpressionChromosome)this.chromosome;
        VectorExprGene vectorExprGene = vectorExpressionChromosome.getVectorExpression();
        this.vectorVM = new VectorVM(vectorExpressionChromosome.getNoiseSeed().getValue());
        this.vectorVM.compile(vectorExprGene);
        this.scanResults = new ScanResults((VectorExpressionChromosome)this.chromosome);
    }

    @Override
    public void calculate(Deviation dev, boolean paintOnScreen, String doExport) {
        if (this.enterDepth()) {
            Vector3d vectorValue = new Vector3d();
            ColorF32 cout = new ColorF32();
            while (this.more) {
                this.vectorVM.execute(this.xw, this.yw, 1.0E-10, this.xscale, this.yscale, vectorValue);
                this.colorator.getColor((vectorValue.x - this.scanResults.min) / this.scanResults.range, (vectorValue.y - this.scanResults.min) / this.scanResults.range, (vectorValue.z - this.scanResults.min) / this.scanResults.range, cout);
                this.setPixel(cout);
                this.nextLocation();
            }
        }
    }

    @Override
    public boolean hasWhiteBackground() {
        return false;
    }

    private class ScanResults {
        boolean isNaN = false;
        double min;
        double range = 1.0E-4;

        public ScanResults(VectorExpressionChromosome vectorExpressionChromosome) {
            double max;
            Vector3d vectorValue = new Vector3d();
            Vector3d maxValue = new Vector3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            Vector3d minValue = new Vector3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            long nan = Double.doubleToLongBits(Double.NaN);
            VectorExpressionCalculation.this.vectorVM.execute(0.0, 0.0, 1.0E-10, VectorExpressionCalculation.this.xscale, VectorExpressionCalculation.this.yscale, vectorValue);
            if (nan == Double.doubleToLongBits(vectorValue.x)) {
                this.isNaN = true;
            } else {
                maxValue.x = minValue.x = vectorValue.x;
            }
            if (nan == Double.doubleToLongBits(vectorValue.y)) {
                this.isNaN = true;
            } else {
                maxValue.y = minValue.y = vectorValue.y;
            }
            if (nan == Double.doubleToLongBits(vectorValue.z)) {
                this.isNaN = true;
            } else {
                maxValue.z = minValue.z = vectorValue.z;
            }
            double xt = VectorExpressionCalculation.this.xwMin;
            while (xt < VectorExpressionCalculation.this.xwMax + 1.0E-10) {
                double yt = VectorExpressionCalculation.this.ywMin;
                while (yt < VectorExpressionCalculation.this.ywMax + 1.0E-10) {
                    VectorExpressionCalculation.this.vectorVM.execute(xt, yt, 1.0E-10, VectorExpressionCalculation.this.xscale, VectorExpressionCalculation.this.yscale, vectorValue);
                    if (nan == Double.doubleToLongBits(vectorValue.x)) {
                        this.isNaN = true;
                    } else {
                        if (vectorValue.x < minValue.x) {
                            minValue.x = vectorValue.x;
                        }
                        if (vectorValue.x > maxValue.x) {
                            maxValue.x = vectorValue.x;
                        }
                    }
                    if (nan == Double.doubleToLongBits(vectorValue.y)) {
                        this.isNaN = true;
                    } else {
                        if (vectorValue.y < minValue.y) {
                            minValue.y = vectorValue.y;
                        }
                        if (vectorValue.y > maxValue.y) {
                            maxValue.y = vectorValue.y;
                        }
                    }
                    if (nan == Double.doubleToLongBits(vectorValue.z)) {
                        this.isNaN = true;
                    } else {
                        if (vectorValue.z < minValue.z) {
                            minValue.z = vectorValue.z;
                        }
                        if (vectorValue.z > maxValue.z) {
                            maxValue.z = vectorValue.z;
                        }
                    }
                    yt += 0.1;
                }
                xt += 0.1;
            }
            this.min = minValue.x;
            if (minValue.y < this.min) {
                this.min = minValue.y;
            }
            if (minValue.z < this.min) {
                this.min = minValue.z;
            }
            if (maxValue.y > (max = maxValue.x)) {
                max = maxValue.y;
            }
            if (maxValue.z > max) {
                max = maxValue.z;
            }
            this.range = max - this.min;
            if (this.range < 1.0E-4) {
                this.range = 1.0E-4;
            }
        }
    }
}

