/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.vm.scalar;

import java.util.List;
import kandid.soup.ExprScalarArgsListGene;
import kandid.soup.ExprScalarConstGene;
import kandid.soup.ExprScalarListGene;
import kandid.soup.ExprScalarOprBase;
import kandid.soup.ExprScalarOprGene;
import kandid.soup.ExprScalarVarBase;
import kandid.soup.ExprScalarVarGene;
import kandid.soup.GeneType;
import kandid.soup.ScalarExprGene;
import kandid.util.Complex;
import kandid.util.PovNoise;
import kandid.util.Util;

public class ScalarVM {
    private static final int maxTapeLen = 16384;
    protected int[] codeTape;
    protected int[] iOper;
    protected double[] dOper;
    protected int tapeLength;
    protected double[] dStack = new double[1024];
    protected PovNoise povNoise;
    public static final double epsilon = 1.0E-10;
    protected static final int oprStop = 0;
    protected static final int oprPop = 1;
    protected static final int oprPushConst = 2;
    protected static final int oprPushAccu = 3;
    protected static final int oprPushX = 4;
    protected static final int oprPushY = 5;
    protected static final int oprPushXI = 6;
    protected static final int oprPushYI = 7;
    protected static final int oprPushR = 8;
    protected static final int oprPushRI = 9;
    protected static final int oprPushT = 10;
    protected static final int oprPushTI = 11;
    protected static final int oprPushXp2 = 12;
    protected static final int oprPushYp2 = 13;
    protected static final int oprPushXp3 = 14;
    protected static final int oprPushYp3 = 15;
    protected static final int oprPushXcos = 16;
    protected static final int oprPushYcos = 17;
    protected static final int oprPushXsinh = 18;
    protected static final int oprPushYsinh = 19;
    protected static final int oprIf = 20;
    protected static final int oprJmp = 21;
    protected static final int oprAdd = 22;
    protected static final int oprMult = 23;
    protected static final int oprSub = 24;
    protected static final int oprDiv = 25;
    protected static final int oprNoise = 26;
    protected static final int oprTurbulence = 27;
    protected static final int oprSnoise = 28;
    protected static final int oprSturbulence = 29;
    protected static final int oprPow = 30;
    protected static final int oprSqrt = 31;
    protected static final int oprTan = 32;
    protected static final int oprSin = 33;
    protected static final int oprCos = 34;
    protected static final int oprAtanq = 35;
    protected static final int oprAtan = 36;
    protected static final int oprLog = 37;
    protected static final int oprMix = 38;
    protected static final int oprMixx = 39;
    protected static final int oprStep = 40;
    protected static final int oprPuls = 41;
    protected static final int oprClamp = 42;
    protected static final int oprMax = 43;
    protected static final int oprMin = 44;
    protected static final int oprAbs = 45;
    protected static final int oprSmoothstep = 46;
    protected static final int oprBoxstep = 47;
    protected static final int oprMod = 48;
    protected static final int oprFloor = 49;
    protected static final int oprCeil = 50;
    protected static final int oprGamma = 51;
    protected static final int oprGain = 52;
    protected static final int oprBias = 53;
    protected static final int oprEuclide = 54;
    protected static final int oprAbsolute = 55;

    public ScalarVM(long seed) {
        this.povNoise = new PovNoise(seed);
    }

    public void compile(ScalarExprGene scalarExprGene) {
        this.codeTape = new int[16384];
        this.iOper = new int[16384];
        this.dOper = new double[16384];
        this.tapeLength = 0;
        this.compile0(scalarExprGene);
        this.codeTape[this.tapeLength] = 0;
        ++this.tapeLength;
    }

    private void compile0(ScalarExprGene scalarExprGene) {
        ExprScalarListGene exprListGene = scalarExprGene.getList();
        ExprScalarOprGene opr = exprListGene.getOpr();
        ExprScalarArgsListGene args = exprListGene.getArgs();
        List<GeneType> argsList = args.getVarOrConstOrScalarExpression();
        int argsLen = argsList.size();
        assert (argsLen > 0) : "argument list to short " + argsLen;
        if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.IF_POSITIVE)) {
            this.compileElement(argsList.get(0));
            int patchIf = this.tapeLength;
            this.codeTape[this.tapeLength++] = 20;
            this.compileElement(argsList.get(1 % argsLen));
            int patchJmp = this.tapeLength;
            this.codeTape[this.tapeLength++] = 21;
            this.iOper[patchIf] = this.tapeLength;
            this.compileElement(argsList.get(2 % argsLen));
            this.iOper[patchJmp] = this.tapeLength;
            this.codeTape[this.tapeLength++] = 1;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.ADD)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 22;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.MULT)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 23;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.SUB)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 24;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.DIV)) {
            while (argsLen > 0) {
                this.compileElement(argsList.get(--argsLen));
            }
            this.codeTape[this.tapeLength] = 25;
            this.iOper[this.tapeLength] = argsList.size();
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.NOISE)) {
            int ax = 3;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 26;
            this.iOper[this.tapeLength] = 3;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.TURBULENCE)) {
            int ax = 4;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 27;
            this.iOper[this.tapeLength] = 4;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.SNOISE)) {
            int ax = 4;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 28;
            this.iOper[this.tapeLength] = 4;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.STURBULENCE)) {
            int ax = 5;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 29;
            this.iOper[this.tapeLength] = 5;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.POW)) {
            int ax = 2;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 30;
            this.iOper[this.tapeLength] = 2;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.SQRT)) {
            int ax = 1;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 31;
            this.iOper[this.tapeLength] = 1;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.TAN)) {
            int ax = 1;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 32;
            this.iOper[this.tapeLength] = 1;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.SIN)) {
            int ax = 1;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 33;
            this.iOper[this.tapeLength] = 1;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.COS)) {
            int ax = 1;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 34;
            this.iOper[this.tapeLength] = 1;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.ATANQ)) {
            int ax = 2;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 35;
            this.iOper[this.tapeLength] = 2;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.ATAN)) {
            int ax = 1;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 36;
            this.iOper[this.tapeLength] = 1;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.LOG)) {
            int ax = 1;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 37;
            this.iOper[this.tapeLength] = 1;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.MIX)) {
            int ax = 3;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 38;
            this.iOper[this.tapeLength] = 3;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.MIXX)) {
            int ax = 5;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 39;
            this.iOper[this.tapeLength] = 5;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.STEP)) {
            int ax = 2;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 40;
            this.iOper[this.tapeLength] = 2;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.PULS)) {
            int ax = 3;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 41;
            this.iOper[this.tapeLength] = 3;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.CLAMP)) {
            int ax = 3;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 42;
            this.iOper[this.tapeLength] = 3;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.MAX)) {
            int ax = 2;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 43;
            this.iOper[this.tapeLength] = 2;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.MIN)) {
            int ax = 2;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 44;
            this.iOper[this.tapeLength] = 2;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.ABS)) {
            int ax = 1;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 45;
            this.iOper[this.tapeLength] = 1;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.SMOOTHSTEP)) {
            int ax = 3;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 46;
            this.iOper[this.tapeLength] = 3;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.BOXSTEP)) {
            int ax = 3;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 47;
            this.iOper[this.tapeLength] = 3;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.MOD)) {
            int ax = 2;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 48;
            this.iOper[this.tapeLength] = 2;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.FLOOR)) {
            int ax = 1;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 49;
            this.iOper[this.tapeLength] = 1;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.CEIL)) {
            int ax = 1;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 50;
            this.iOper[this.tapeLength] = 1;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.GAMMA)) {
            int ax = 2;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 51;
            this.iOper[this.tapeLength] = 2;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.GAIN)) {
            int ax = 2;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 52;
            this.iOper[this.tapeLength] = 2;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.BIAS)) {
            int ax = 2;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 53;
            this.iOper[this.tapeLength] = 2;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.EUCLIDE)) {
            int ax = 4;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 54;
            this.iOper[this.tapeLength] = 4;
            ++this.tapeLength;
        } else if (opr.getScalarOpr().equals((Object)ExprScalarOprBase.ABSOLUTE)) {
            int ax = 4;
            while (ax > 0) {
                this.compileElement(argsList.get(--ax % argsLen));
            }
            this.codeTape[this.tapeLength] = 55;
            this.iOper[this.tapeLength] = 4;
            ++this.tapeLength;
        } else assert (false) : "invalid operator " + String.valueOf((Object)opr.getScalarOpr());
    }

    private void compileElement(GeneType obj) {
        if (obj instanceof ExprScalarVarGene) {
            ExprScalarVarGene var = (ExprScalarVarGene)obj;
            if (var.getScalarVar().equals((Object)ExprScalarVarBase.X)) {
                this.codeTape[this.tapeLength++] = 4;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.Y)) {
                this.codeTape[this.tapeLength++] = 5;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.XI)) {
                this.codeTape[this.tapeLength++] = 6;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.YI)) {
                this.codeTape[this.tapeLength++] = 7;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.R)) {
                this.codeTape[this.tapeLength++] = 8;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.RI)) {
                this.codeTape[this.tapeLength++] = 9;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.T)) {
                this.codeTape[this.tapeLength++] = 10;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.TI)) {
                this.codeTape[this.tapeLength++] = 11;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.XP_2)) {
                this.codeTape[this.tapeLength++] = 12;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.YP_2)) {
                this.codeTape[this.tapeLength++] = 13;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.XP_3)) {
                this.codeTape[this.tapeLength++] = 14;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.YP_3)) {
                this.codeTape[this.tapeLength++] = 15;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.XCOS)) {
                this.codeTape[this.tapeLength++] = 16;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.YCOS)) {
                this.codeTape[this.tapeLength++] = 17;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.XSINH)) {
                this.codeTape[this.tapeLength++] = 18;
            } else if (var.getScalarVar().equals((Object)ExprScalarVarBase.YSINH)) {
                this.codeTape[this.tapeLength++] = 19;
            } else assert (false) : "invalid var compiling scalar expression" + String.valueOf((Object)var.getScalarVar());
        } else if (obj instanceof ExprScalarConstGene) {
            ExprScalarConstGene aConst = (ExprScalarConstGene)obj;
            this.codeTape[this.tapeLength] = 2;
            this.dOper[this.tapeLength] = aConst.getScalarConst().getValue();
            ++this.tapeLength;
        } else if (obj instanceof ScalarExprGene) {
            ScalarExprGene scalarExpressionArg = (ScalarExprGene)obj;
            this.compile0(scalarExpressionArg);
            this.codeTape[this.tapeLength++] = 3;
        } else assert (false) : "invalid object compiling scalar expression" + obj.getClass().getName();
    }

    public double execute(double x, double y, double t, double xscale, double yscale) {
        Complex cm = new Complex(x *= Math.exp(xscale), y *= Math.exp(yscale));
        Complex cm_pow2 = Complex.multiply(cm, cm);
        Complex cm_pow3 = Complex.multiply(cm, cm_pow2);
        Complex cm_cos = Complex.cos(cm);
        Complex cm_sinh = Complex.sinh(cm);
        double xi = -x;
        double yi = -y;
        double r = Math.sqrt(x * x + y * y);
        double ri = 1.0 - r;
        double ti = -t;
        double accu = 0.0;
        int dSp = 0;
        int ip = 0;
        int argLength = 0;
        while (ip < this.tapeLength) {
            switch (this.codeTape[ip]) {
                case 0: {
                    return accu;
                }
                case 1: {
                    accu = this.dStack[--dSp];
                    break;
                }
                case 2: {
                    this.dStack[dSp++] = this.dOper[ip];
                    break;
                }
                case 3: {
                    this.dStack[dSp++] = accu;
                    break;
                }
                case 4: {
                    this.dStack[dSp++] = x;
                    break;
                }
                case 5: {
                    this.dStack[dSp++] = y;
                    break;
                }
                case 6: {
                    this.dStack[dSp++] = xi;
                    break;
                }
                case 7: {
                    this.dStack[dSp++] = yi;
                    break;
                }
                case 8: {
                    this.dStack[dSp++] = r;
                    break;
                }
                case 9: {
                    this.dStack[dSp++] = ri;
                    break;
                }
                case 10: {
                    this.dStack[dSp++] = t;
                    break;
                }
                case 11: {
                    this.dStack[dSp++] = ti;
                    break;
                }
                case 12: {
                    this.dStack[dSp++] = cm_pow2.re;
                    break;
                }
                case 13: {
                    this.dStack[dSp++] = cm_pow2.im;
                    break;
                }
                case 14: {
                    this.dStack[dSp++] = cm_pow3.re;
                    break;
                }
                case 15: {
                    this.dStack[dSp++] = cm_pow3.im;
                    break;
                }
                case 16: {
                    this.dStack[dSp++] = cm_cos.re;
                    break;
                }
                case 17: {
                    this.dStack[dSp++] = cm_cos.im;
                    break;
                }
                case 18: {
                    this.dStack[dSp++] = cm_sinh.re;
                    break;
                }
                case 19: {
                    this.dStack[dSp++] = cm_sinh.im;
                    break;
                }
                case 20: {
                    accu = this.dStack[--dSp];
                    if (!(accu < 0.0)) break;
                    ip = this.iOper[ip] - 1;
                    break;
                }
                case 21: {
                    ip = this.iOper[ip] - 1;
                    break;
                }
                case 22: {
                    argLength = this.iOper[ip];
                    accu = this.dStack[--dSp];
                    while (argLength > 1) {
                        accu += this.dStack[--dSp];
                        --argLength;
                    }
                    break;
                }
                case 23: {
                    argLength = this.iOper[ip];
                    accu = this.dStack[--dSp];
                    while (argLength > 1) {
                        accu *= this.dStack[--dSp];
                        --argLength;
                    }
                    break;
                }
                case 24: {
                    argLength = this.iOper[ip];
                    accu = this.dStack[--dSp];
                    while (argLength > 1) {
                        accu -= this.dStack[--dSp];
                        --argLength;
                    }
                    break;
                }
                case 25: {
                    argLength = this.iOper[ip];
                    accu = this.dStack[--dSp];
                    while (argLength > 1) {
                        double divisor = this.dStack[--dSp];
                        try {
                            accu /= divisor;
                        }
                        catch (ArithmeticException ae) {
                            accu = Math.abs(accu) != accu ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                        }
                        --argLength;
                    }
                    break;
                }
                case 26: {
                    argLength = this.iOper[ip];
                    assert (argLength == 3) : "argument length of operator 'noise' should be 3";
                    double nx = this.dStack[--dSp];
                    double ny = this.dStack[--dSp];
                    double nz = this.dStack[--dSp];
                    accu = this.povNoise.getNoise(nx, ny, nz);
                    break;
                }
                case 27: {
                    int octaves;
                    argLength = this.iOper[ip];
                    assert (argLength == 4) : "argument length of operator 'turbulence' should be 4";
                    double nx = this.dStack[--dSp];
                    double ny = this.dStack[--dSp];
                    double nz = this.dStack[--dSp];
                    octaves = (octaves = (int)Math.log(Math.abs(1.0 + this.dStack[--dSp]))) > 7 ? 8 : octaves + 1;
                    accu = this.povNoise.getTurbulence(nx, ny, nz, octaves);
                    break;
                }
                case 28: {
                    argLength = this.iOper[ip];
                    assert (argLength == 4) : "argument length of operator 'snoise' should be 4";
                    double nx = this.dStack[--dSp];
                    double ny = this.dStack[--dSp];
                    double nz = this.dStack[--dSp];
                    double scale = this.dStack[--dSp];
                    accu = this.povNoise.getNoise(scale * nx, scale * ny, scale * nz);
                    break;
                }
                case 29: {
                    int octaves;
                    argLength = this.iOper[ip];
                    assert (argLength == 5) : "argument length of operator 'sturbulence' should be 5";
                    double nx = this.dStack[--dSp];
                    double ny = this.dStack[--dSp];
                    double nz = this.dStack[--dSp];
                    octaves = (octaves = (int)Math.log(Math.abs(1.0 + this.dStack[--dSp]))) > 7 ? 8 : octaves + 1;
                    double scale = this.dStack[--dSp];
                    accu = this.povNoise.getTurbulence(scale * nx, scale * ny, scale * nz, octaves);
                    break;
                }
                case 30: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'pow' should be 2";
                    double n1 = this.dStack[--dSp];
                    double n2 = this.dStack[--dSp];
                    accu = Math.pow(Math.abs(n1), n2);
                    break;
                }
                case 31: {
                    argLength = this.iOper[ip];
                    assert (argLength == 1) : "argument length of operator 'sqrt' should be 1";
                    double n1 = this.dStack[--dSp];
                    accu = Math.sqrt(Math.abs(n1));
                    break;
                }
                case 32: {
                    argLength = this.iOper[ip];
                    assert (argLength == 1) : "argument length of operator 'tan' should be 1";
                    double n1 = this.dStack[--dSp];
                    accu = Math.tan(n1);
                    break;
                }
                case 33: {
                    argLength = this.iOper[ip];
                    assert (argLength == 1) : "argument length of operator 'sin' should be 1";
                    double n1 = this.dStack[--dSp];
                    accu = Math.sin(n1);
                    break;
                }
                case 34: {
                    argLength = this.iOper[ip];
                    assert (argLength == 1) : "argument length of operator 'cos' should be 1";
                    double n1 = this.dStack[--dSp];
                    accu = Math.cos(n1);
                    break;
                }
                case 35: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'atanq' should be 2";
                    double n1 = this.dStack[--dSp];
                    double n2 = this.dStack[--dSp];
                    if (Math.abs(n1) < 1.0E-10 && Math.abs(n2) < 1.0E-10) {
                        accu = 0.0;
                        break;
                    }
                    accu = Math.atan2(n1, n2);
                    break;
                }
                case 36: {
                    argLength = this.iOper[ip];
                    assert (argLength == 1) : "argument length of operator 'atan' should be 1";
                    double n1 = this.dStack[--dSp];
                    accu = Math.atan(n1);
                    break;
                }
                case 37: {
                    double n1;
                    argLength = this.iOper[ip];
                    assert (argLength == 1) : "argument length of operator 'log' should be 1";
                    if ((n1 = this.dStack[--dSp]) > 1.0E-10) {
                        accu = Math.log(n1);
                        break;
                    }
                    if (n1 < -1.0E-10) {
                        accu = Math.log(-n1);
                        break;
                    }
                    accu = Double.NEGATIVE_INFINITY;
                    break;
                }
                case 38: {
                    double n3;
                    argLength = this.iOper[ip];
                    assert (argLength == 3) : "argument length of operator 'mix' should be 3";
                    double n1 = this.dStack[--dSp];
                    double n2 = this.dStack[--dSp];
                    if ((n3 = this.dStack[--dSp]) < 0.0) {
                        n3 = 0.0;
                    } else if (n3 > 1.0) {
                        n3 = 1.0;
                    }
                    accu = (1.0 - n3) * n1 + n3 * n2;
                    break;
                }
                case 39: {
                    argLength = this.iOper[ip];
                    assert (argLength == 5) : "argument length of operator 'mixx' should be 5";
                    double n1 = this.dStack[--dSp];
                    double n2 = this.dStack[--dSp];
                    double n3 = this.dStack[--dSp];
                    double n4 = this.dStack[--dSp];
                    double n5 = this.dStack[--dSp];
                    if (n4 < 0.0) {
                        n4 = 0.0;
                    } else if (n4 > 1.0) {
                        n4 = 1.0;
                    }
                    accu = (1.0 - n4) * n1 + n4 * n2;
                    if (n5 < 0.0) {
                        n5 = 0.0;
                    } else if (n5 > 1.0) {
                        n5 = 1.0;
                    }
                    accu = (1.0 - n5) * accu + n5 * n3;
                    break;
                }
                case 40: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'step' should be 2";
                    double n1 = this.dStack[--dSp];
                    double n2 = this.dStack[--dSp];
                    accu = Util.step(n1, n2);
                    break;
                }
                case 41: {
                    argLength = this.iOper[ip];
                    assert (argLength == 3) : "argument length of operator 'puls' should be 3";
                    double n1 = this.dStack[--dSp];
                    double n2 = this.dStack[--dSp];
                    double n3 = this.dStack[--dSp];
                    accu = Util.step(n1, n3) - Util.step(n2, n3);
                    break;
                }
                case 42: {
                    double n3;
                    argLength = this.iOper[ip];
                    assert (argLength == 3) : "argument length of operator 'clamp' should be 3";
                    double n1 = this.dStack[--dSp];
                    --dSp;
                    double n2 = this.dStack[dSp];
                    if (n2 > (n3 = this.dStack[--dSp])) {
                        double temp = n2;
                        n2 = n3;
                        n3 = temp;
                    }
                    if (n1 < n2) {
                        accu = n2;
                        break;
                    }
                    if (n1 > n3) {
                        accu = n3;
                        break;
                    }
                    accu = n1;
                    break;
                }
                case 43: {
                    double n2;
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'max' should be 2";
                    --dSp;
                    double n1 = this.dStack[dSp];
                    if (n1 > (n2 = this.dStack[--dSp])) {
                        accu = n1;
                        break;
                    }
                    accu = n2;
                    break;
                }
                case 44: {
                    double n2;
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'min' should be 2";
                    --dSp;
                    double n1 = this.dStack[dSp];
                    if (n1 < (n2 = this.dStack[--dSp])) {
                        accu = n1;
                        break;
                    }
                    accu = n2;
                    break;
                }
                case 45: {
                    double n1;
                    argLength = this.iOper[ip];
                    assert (argLength == 1) : "argument length of operator 'abs' should be 1";
                    if ((n1 = this.dStack[--dSp]) < 0.0) {
                        accu = -n1;
                        break;
                    }
                    accu = n1;
                    break;
                }
                case 46: {
                    double n3;
                    argLength = this.iOper[ip];
                    assert (argLength == 3) : "argument length of operator 'smoothstep' should be 3";
                    double n1 = this.dStack[--dSp];
                    double n2 = this.dStack[--dSp];
                    if ((n3 = this.dStack[--dSp]) < n1) {
                        accu = 0.0;
                        break;
                    }
                    if (n3 >= n2) {
                        accu = 1.0;
                        break;
                    }
                    if (Math.abs(n2 - n1) > 1.0E-10) {
                        n3 = (n3 - n1) / (n2 - n1);
                        accu = n3 * n3 * (3.0 - 2.0 * n3);
                        break;
                    }
                    accu = 1.0;
                    break;
                }
                case 47: {
                    argLength = this.iOper[ip];
                    assert (argLength == 3) : "argument length of operator 'boxstep' should be 3";
                    double n1 = this.dStack[--dSp];
                    double n2 = this.dStack[--dSp];
                    double n3 = this.dStack[--dSp];
                    accu = Util.clamp((n3 - n1) / (n2 - n1));
                    break;
                }
                case 48: {
                    double n2;
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'mod' should be 2";
                    double n1 = this.dStack[--dSp];
                    if (Math.abs(n2 = this.dStack[--dSp]) > 1.0E-10) {
                        int n;
                        if ((n1 -= (double)(n = (int)(n1 / n2)) * n2) < 0.0) {
                            n1 += n2;
                        }
                        accu = n1;
                        break;
                    }
                    accu = 0.0;
                    break;
                }
                case 49: {
                    argLength = this.iOper[ip];
                    assert (argLength == 1) : "argument length of operator 'floor' should be 1";
                    double n1 = this.dStack[--dSp];
                    accu = Math.floor(n1);
                    break;
                }
                case 50: {
                    argLength = this.iOper[ip];
                    assert (argLength == 1) : "argument length of operator 'ceil' should be 1";
                    double n1 = this.dStack[--dSp];
                    accu = Math.ceil(n1);
                    break;
                }
                case 51: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'gamma' should be 2";
                    double n1 = this.dStack[--dSp];
                    double n2 = this.dStack[--dSp];
                    if (Math.abs(n1) > 1.0E-10) {
                        accu = Math.pow(Math.abs(n2), 1.0 / n1);
                        break;
                    }
                    accu = Double.POSITIVE_INFINITY;
                    break;
                }
                case 52: {
                    double n2;
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'gain' should be 2";
                    double n1 = this.dStack[--dSp];
                    if ((n2 = this.dStack[--dSp]) < 0.5) {
                        accu = Util.bias(1.0 - n1, 2.0 * n2) / 2.0;
                        break;
                    }
                    accu = 1.0 - Util.bias(1.0 - n1, 2.0 - 2.0 * n2) / 2.0;
                    break;
                }
                case 53: {
                    argLength = this.iOper[ip];
                    assert (argLength == 2) : "argument length of operator 'bias' should be 2";
                    double n1 = this.dStack[--dSp];
                    double n2 = this.dStack[--dSp];
                    accu = Util.bias(n1, n2);
                    break;
                }
                case 54: {
                    argLength = this.iOper[ip];
                    assert (argLength == 4) : "argument length of operator 'euclide' should be 4";
                    double n1 = this.dStack[--dSp];
                    double n2 = this.dStack[--dSp];
                    double n3 = this.dStack[--dSp];
                    double n4 = this.dStack[--dSp];
                    n1 = n3 - n1;
                    n2 = n4 - n2;
                    accu = Math.sqrt(n1 * n1 + n2 * n2);
                    break;
                }
                case 55: {
                    argLength = this.iOper[ip];
                    assert (argLength == 4) : "argument length of operator 'absolute' should be 4";
                    double n1 = this.dStack[--dSp];
                    double n2 = this.dStack[--dSp];
                    double n3 = this.dStack[--dSp];
                    double n4 = this.dStack[--dSp];
                    accu = Math.abs(n3 - n1) + Math.abs(n4 - n2);
                    break;
                }
                default: {
                    assert (false) : "invalid code " + this.codeTape[ip] + " on tape position " + ip;
                    break;
                }
            }
            ++ip;
        }
        return accu;
    }

    public String toString() {
        StringBuffer asm = new StringBuffer();
        int ip = 0;
        while (ip < this.tapeLength) {
            asm.append(ip + "\t");
            switch (this.codeTape[ip]) {
                case 0: {
                    asm.append("stop");
                    break;
                }
                case 1: {
                    asm.append("pop");
                    break;
                }
                case 2: {
                    asm.append("pushConst  ");
                    asm.append(this.dOper[ip]);
                    break;
                }
                case 3: {
                    asm.append("pushAccu");
                    break;
                }
                case 4: {
                    asm.append("pushX");
                    break;
                }
                case 5: {
                    asm.append("pushY");
                    break;
                }
                case 6: {
                    asm.append("pushXI");
                    break;
                }
                case 7: {
                    asm.append("pushYI");
                    break;
                }
                case 8: {
                    asm.append("pushR");
                    break;
                }
                case 9: {
                    asm.append("pushRI");
                    break;
                }
                case 10: {
                    asm.append("pushT");
                    break;
                }
                case 11: {
                    asm.append("pushTI");
                    break;
                }
                case 12: {
                    asm.append("pushXp2");
                    break;
                }
                case 13: {
                    asm.append("pushYp2");
                    break;
                }
                case 14: {
                    asm.append("pushXp3");
                    break;
                }
                case 15: {
                    asm.append("pushYp3");
                    break;
                }
                case 16: {
                    asm.append("pushXcos");
                    break;
                }
                case 17: {
                    asm.append("pushYcos");
                    break;
                }
                case 18: {
                    asm.append("pushXsinh");
                    break;
                }
                case 19: {
                    asm.append("pushYsinh");
                    break;
                }
                case 20: {
                    asm.append("if\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 21: {
                    asm.append("jmp\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 22: {
                    asm.append("add\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 23: {
                    asm.append("mult\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 24: {
                    asm.append("sub\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 25: {
                    asm.append("div\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 26: {
                    asm.append("noise\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 27: {
                    asm.append("turbulence\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 28: {
                    asm.append("snoise\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 29: {
                    asm.append("sturbulence\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 30: {
                    asm.append("pow\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 31: {
                    asm.append("sqrt\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 32: {
                    asm.append("tan\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 33: {
                    asm.append("sin\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 34: {
                    asm.append("cos\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 35: {
                    asm.append("atanq\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 36: {
                    asm.append("atan\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 37: {
                    asm.append("log\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 38: {
                    asm.append("mix\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 39: {
                    asm.append("mixx\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 40: {
                    asm.append("step\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 41: {
                    asm.append("puls\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 42: {
                    asm.append("clamp\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 43: {
                    asm.append("max\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 44: {
                    asm.append("min\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 45: {
                    asm.append("abs\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 46: {
                    asm.append("smoothstep\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 47: {
                    asm.append("boxstep\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 48: {
                    asm.append("mod\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 49: {
                    asm.append("floor\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 50: {
                    asm.append("ceil\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 51: {
                    asm.append("gamma\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 52: {
                    asm.append("gain\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 53: {
                    asm.append("bias\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 54: {
                    asm.append("euclide\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                case 55: {
                    asm.append("absolute\t");
                    asm.append(this.iOper[ip]);
                    break;
                }
                default: {
                    asm.append("invalid code\t");
                    asm.append(this.iOper[ip]);
                    assert (false) : "invalid code " + this.codeTape[ip] + " on tape position " + ip;
                    break;
                }
            }
            asm.append('\n');
            ++ip;
        }
        return asm.toString();
    }
}

