/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.vm.scalar;

import java.awt.Component;
import java.awt.Dimension;
import kandid.calculation.RefinementCalculation;
import kandid.calculation.vm.scalar.Deviation;
import kandid.calculation.vm.scalar.ScalarVM;
import kandid.colorator.ColorF32;
import kandid.soup.ChromosomeType;
import kandid.soup.ScalarExprGene;
import kandid.soup.ScalarExpressionChromosome;

public class ScalarExpressionCalculation
extends RefinementCalculation {
    private ScanResults scanResults;
    private ScalarVM scalarVM;
    private double xscale = 1.0;
    private double yscale = 1.0;

    @Override
    public boolean reject(ChromosomeType chromosome) {
        this.depth = 6;
        this.xwMin = -1.0;
        this.xwMax = 1.0;
        this.ywMin = -1.0;
        this.ywMax = 1.0;
        this.chromosome = chromosome;
        ScalarExpressionChromosome scalarExpressionChromosome = (ScalarExpressionChromosome)chromosome;
        ScalarExprGene scalarExprGene = scalarExpressionChromosome.getScalarExpression();
        this.scalarVM = new ScalarVM(scalarExpressionChromosome.getNoiseSeed().getValue());
        this.xscale = scalarExpressionChromosome.getXScale().getValue();
        this.yscale = scalarExpressionChromosome.getYScale().getValue();
        try {
            this.scalarVM.compile(scalarExprGene);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        this.scanResults = new ScanResults(scalarExpressionChromosome);
        return this.scanResults.isNaN || this.scanResults.maxValue - this.scanResults.minValue < 9.0E-5;
    }

    @Override
    public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
        this.depth = 6;
        this.xwMin = -1.1;
        this.xwMax = 1.1;
        this.ywMin = -1.1;
        this.ywMax = 1.1;
        super.activateCanvas(viewComponent, canvasSize, zoomMode);
        ScalarExpressionChromosome scalarExpressionChromosome = (ScalarExpressionChromosome)this.chromosome;
        ScalarExprGene scalarExprGene = scalarExpressionChromosome.getScalarExpression();
        this.scalarVM = new ScalarVM(scalarExpressionChromosome.getNoiseSeed().getValue());
        this.scalarVM.compile(scalarExprGene);
        this.scanResults = new ScanResults((ScalarExpressionChromosome)this.chromosome);
    }

    @Override
    public void calculate(kandid.calculation.Deviation dev, boolean paintOnScreen, String doExport) {
        if (this.enterDepth()) {
            ColorF32 cout = new ColorF32();
            double x = dev == null ? 1.0 : ((Deviation)dev).x;
            double y = dev == null ? 1.0 : ((Deviation)dev).y;
            while (this.more) {
                double scalarValue = this.scalarVM.execute(this.xw * x, this.yw * y, 1.0E-10, this.xscale, this.yscale);
                this.colorator.getColor((scalarValue - this.scanResults.minValue) / this.scanResults.range, cout);
                this.setPixel(cout);
                this.nextLocation();
            }
        }
    }

    @Override
    public boolean hasWhiteBackground() {
        return false;
    }

    private class ScanResults {
        double maxValue = Double.NEGATIVE_INFINITY;
        double minValue = Double.POSITIVE_INFINITY;
        boolean isNaN = false;
        double range = 1.0E-4;

        public ScanResults(ScalarExpressionChromosome scalarExpressionChromosome) {
            long nan = Double.doubleToLongBits(Double.NaN);
            double scalarValue = ScalarExpressionCalculation.this.scalarVM.execute(0.0, 0.0, 1.0E-10, ScalarExpressionCalculation.this.xscale, ScalarExpressionCalculation.this.yscale);
            if (nan == Double.doubleToLongBits(scalarValue)) {
                this.isNaN = true;
            } else {
                this.maxValue = this.minValue = scalarValue;
            }
            double xt = ScalarExpressionCalculation.this.xwMin;
            while (xt < ScalarExpressionCalculation.this.xwMax + 1.0E-10) {
                double yt = ScalarExpressionCalculation.this.ywMin;
                while (yt < ScalarExpressionCalculation.this.ywMax + 1.0E-10) {
                    scalarValue = ScalarExpressionCalculation.this.scalarVM.execute(xt, yt, 1.0E-10, ScalarExpressionCalculation.this.xscale, ScalarExpressionCalculation.this.yscale);
                    if (nan == Double.doubleToLongBits(scalarValue)) {
                        this.isNaN = true;
                    } else {
                        if (scalarValue < this.minValue) {
                            this.minValue = scalarValue;
                        }
                        if (scalarValue > this.maxValue) {
                            this.maxValue = scalarValue;
                        }
                    }
                    yt += 0.1;
                }
                xt += 0.1;
            }
            this.range = this.maxValue - this.minValue;
            if (this.range < 1.0E-4) {
                this.range = 1.0E-4;
            }
        }
    }
}

