/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.tutorial.shape;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.util.List;
import kandid.calculation.Deviation;
import kandid.calculation.VectorCalculation;
import kandid.soup.TutorialCircleGene;
import kandid.soup.TutorialShapeChromosome;

public class TutorialShapeCalculation
extends VectorCalculation {
    private boolean ready;

    @Override
    public void calculate(Deviation dev, boolean paintOnScreen, String exportFilename) {
        TutorialShapeChromosome shapeChromosome = (TutorialShapeChromosome)this.chromosome;
        this.initTransformation(0.0);
        Color background = new Color(shapeChromosome.getColor().getRed().floatValue(), shapeChromosome.getColor().getGreen().floatValue(), shapeChromosome.getColor().getBlue().floatValue());
        this.g2d.setColor(background);
        this.g2d.fillRect(0, 0, this.canvasSize.width, this.canvasSize.height);
        List<TutorialCircleGene> allShapes = shapeChromosome.getAllShapes();
        for (TutorialCircleGene element : allShapes) {
            if (!(element instanceof TutorialCircleGene)) continue;
            TutorialCircleGene shape = element;
            Color fillcolor = new Color(shape.getColor().getRed().floatValue(), shape.getColor().getGreen().floatValue(), shape.getColor().getBlue().floatValue());
            this.g2d.setColor(fillcolor);
            float alpha = (float)shape.getTransparency().getValue().doubleValue();
            AlphaComposite ac = AlphaComposite.getInstance(3, alpha);
            this.g2d.setComposite(ac);
            this.transform(shape.getX().getValue(), shape.getY().getValue());
            int x1 = this.xp;
            int y1 = this.yp;
            this.transform(0.5 * shape.getRadius().getValue(), 0.5 * shape.getRadius().getValue());
            int r1 = this.xp;
            this.g2d.fillOval(x1 + r1, y1 + r1, r1, r1);
        }
        this.ready = true;
    }

    @Override
    public int getPercent() {
        return -1;
    }

    @Override
    public boolean getReady() {
        return this.ready;
    }

    @Override
    public boolean hasWhiteBackground() {
        return false;
    }
}

