/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.symmifs;

import kandid.calculation.IterationCalculation;
import kandid.colorator.BlackWhiteColorator;
import kandid.colorator.Colorator;
import kandid.colorator.GrayColorator;
import kandid.soup.ChromosomeType;
import kandid.soup.SymmetricIfsChromosome;
import kandid.util.Complex;

public class SymmetricIfsCalculation
extends IterationCalculation
implements Cloneable {
    int symmetry;
    int p;
    double lambda;
    double alpha;
    double beta;
    double gamma;
    double omega;

    @Override
    protected int getMaxIterations(int width, int height) {
        if (this.colorator instanceof BlackWhiteColorator) {
            return 32 * this.canvasSize.width * this.canvasSize.height;
        }
        if (this.colorator instanceof GrayColorator) {
            return 64 * this.canvasSize.width * this.canvasSize.height;
        }
        return 256 * this.canvasSize.width * this.canvasSize.height;
    }

    public void mapChromosome(ChromosomeType chromosome) {
        SymmetricIfsChromosome symmetricIfsChromosome = (SymmetricIfsChromosome)chromosome;
        this.symmetry = symmetricIfsChromosome.getSymmetry().getValue();
        this.p = -1;
        this.lambda = symmetricIfsChromosome.getLambda().getValue();
        this.alpha = symmetricIfsChromosome.getAlpha().getValue();
        this.beta = symmetricIfsChromosome.getBeta().getValue();
        this.gamma = symmetricIfsChromosome.getGamma().getValue();
        this.omega = symmetricIfsChromosome.getOmega().getValue();
    }

    @Override
    public void setChromosome(ChromosomeType chromosome, Colorator colorator) {
        super.setChromosome(chromosome, colorator);
        this.mapChromosome(chromosome);
    }

    @Override
    public boolean reject(ChromosomeType chromosome) {
        this.mapChromosome(chromosome);
        this.startIteration();
        this.findExtremeValues(500);
        return this.xmin < -1.0 || this.xmin > 1.0 || this.ymin < -1.0 || this.ymax > 1.0;
    }

    @Override
    protected void iterate() {
        if (this.p >= 0) {
            Complex term2;
            Complex z;
            Complex term1 = z = new Complex(this.xw, this.yw);
            int ix = 1;
            while (ix < this.symmetry) {
                term1 = Complex.multiply(term1, z);
                ++ix;
            }
            if (this.p >= 0) {
                Complex factor = Complex.divide(z, Complex.abs(z));
                int power = this.p * this.symmetry;
                if (power > 0) {
                    term2 = factor;
                    ix = 1;
                    while (ix < power) {
                        term2 = Complex.multiply(term2, factor);
                        ++ix;
                    }
                } else {
                    term2 = new Complex(1.0, 0.0);
                }
            } else {
                term2 = new Complex(1.0, 0.0);
            }
            Complex term3 = Complex.conj(z);
            ix = 2;
            while (ix < this.symmetry) {
                term3 = Complex.multiply(term3, Complex.conj(z));
                ++ix;
            }
            Complex term4 = Complex.multiply(this.alpha, z);
            term4 = Complex.multiply(term4, Complex.conj(z));
            Complex term5 = Complex.multiply(this.beta, term1);
            double term6 = this.omega * Complex.real(term2) * Complex.abs(z);
            Complex znew = Complex.add(this.lambda, term4);
            znew = Complex.add(znew, term5);
            znew = Complex.add(znew, term6);
            znew = Complex.multiply(znew, z);
            znew = Complex.add(znew, Complex.multiply(this.gamma, term3));
            this.xw = Complex.real(znew);
            this.yw = Complex.imag(znew);
        } else {
            double zbar = this.xw * this.xw + this.yw * this.yw;
            double zReal = this.xw;
            double zImag = this.yw;
            int ix = 0;
            while (ix < this.symmetry - 2) {
                double zR = zReal * this.xw - zImag * this.yw;
                double zI = zImag * this.xw + zReal * this.yw;
                zReal = zR;
                zImag = zI;
                ++ix;
            }
            double zPowerN = this.xw * zReal - this.yw * zImag;
            double p = this.lambda + this.alpha * zbar + this.beta * zPowerN;
            double x2 = p * this.xw + this.gamma * zReal - this.omega * this.yw;
            double y2 = p * this.yw - this.gamma * zImag + this.omega * this.xw;
            this.xw = x2;
            this.yw = y2;
        }
    }

    @Override
    public boolean hasWhiteBackground() {
        return true;
    }
}

