/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.lsys;

import javax.xml.bind.JAXBElement;
import junit.framework.TestCase;
import kandid.calculation.lsys.LsysMashine;
import kandid.soup.EntityType;
import kandid.soup.Lsys0LChromosome;
import kandid.soup.genetic.lsys.LsysGenetic;
import kandid.soup.util.SoupFactory;

public class Lsys0LCalculationTest
extends TestCase {
    static final String header = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><entity version=\"0.1.3\">    <lsys0L version=\"0.2.7\" rating=\"abort\">        <calculationName>kandid.calculation.lsys.LsysCalculation</calculationName>        <coloratorName>kandid.colorator.BlackWhiteColorator</coloratorName>        <chromosome>            <ident>Lsys_dqhq698a_dqhq6992</ident>";
    static final String footer = "        </chromosome>    </lsys0L></entity>";
    private SoupFactory soupFactory = SoupFactory.getSoupFactory();

    public Lsys0LCalculationTest(String name) {
        super(name);
    }

    private static String buildProduction(String axiom, String[] predecessor, String[] successor, int depth) {
        String ret = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><entity version=\"0.1.3\">    <lsys0L version=\"0.2.7\" rating=\"abort\">        <calculationName>kandid.calculation.lsys.LsysCalculation</calculationName>        <coloratorName>kandid.colorator.BlackWhiteColorator</coloratorName>        <chromosome>            <ident>Lsys_dqhq698a_dqhq6992</ident>            <alphabet>                <value>F-+-</value>            </alphabet>            <axiom>                <value>" + axiom + "</value>            </axiom>";
        assert (predecessor.length == successor.length);
        int ip = 0;
        while (ip < predecessor.length) {
            ret = ret + "            <production>                <predecessor>                    <value>" + predecessor[ip] + "</value>                </predecessor>                <successor>                    <value>" + successor[ip] + "</value>                </successor>            </production>";
            ++ip;
        }
        ret = ret + "            <directions>                <value>4</value>            </directions>            <baseIndex>                <value>10</value>            </baseIndex>            <depth>                <value>" + depth + "</value>            </depth>            <jitter>                <value>10</value>            </jitter>            <noiseSeed>                <value>1512</value>            </noiseSeed>        </chromosome>    </lsys0L></entity>";
        return ret;
    }

    private Lsys0LChromosome buildChromosome(String axiom, String[] predecessor, String[] successor, int depth) {
        String production = Lsys0LCalculationTest.buildProduction(axiom, predecessor, successor, depth);
        JAXBElement uo = (JAXBElement)this.soupFactory.unmarshalFromString(production);
        EntityType entity = (EntityType)uo.getValue();
        Lsys0LChromosome lsys0LChromosome = entity.getLsys0L().getChromosome();
        return lsys0LChromosome;
    }

    private String executeProduction(String axiom, String[] predecessor, String[] successor, int depth) {
        System.out.println("----\n");
        Lsys0LChromosome lsys0LChromosome = this.buildChromosome(axiom, predecessor, successor, depth);
        LsysMashine.testInitCalculation(lsys0LChromosome);
        LsysMashine.expand(lsys0LChromosome.getDepth().getValue());
        byte[] result = LsysMashine.string;
        StringBuffer ret = new StringBuffer(LsysMashine.length);
        int rx = 0;
        while (rx < LsysMashine.length) {
            ret.append((char)result[rx]);
            ++rx;
        }
        System.out.println(ret.toString());
        return ret.toString();
    }

    public void testErzeugePflanze() {
        String[] predecessor = new String[]{"F", "F"};
        String[] successor = new String[]{"-", "FF-[-F+F+F]+[+F-F-F]"};
        Lsys0LCalculationTest.assertEquals((String)"FF-[-F+F+F]+[+F-F-F]--[-FF-[-F+F+F]+[+F-F-F]+-+FF-[-F+F+F]+[+F-F-F]]+[+--FF-[-F+F+F]+[+F-F-F]-FF-[-F+F+F]+[+F-F-F]]", (String)this.executeProduction("F", predecessor, successor, 2));
    }

    public void testReject() {
        String[] predecessor = new String[]{"F"};
        String[] successor = new String[]{"FF-[-F+F+F]+[+F-F-F]"};
        Lsys0LCalculationTest.assertFalse((boolean)LsysGenetic.reject(this.buildChromosome("F", predecessor, successor, 1)));
        predecessor = new String[]{"F", "+"};
        successor = new String[]{"FF-[-F+F+F]+[+F-F-F]", "-"};
        Lsys0LCalculationTest.assertFalse((boolean)LsysGenetic.reject(this.buildChromosome("F", predecessor, successor, 1)));
        predecessor = new String[]{"F", "F"};
        successor = new String[]{"FF-[-F+F+F]+[+F-F-F]", "-"};
        Lsys0LCalculationTest.assertFalse((boolean)LsysGenetic.reject(this.buildChromosome("F", predecessor, successor, 1)));
    }
}

