/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.lca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;
import kandid.calculation.Deviation;
import kandid.calculation.PixelCalculation;
import kandid.colorator.ColorF32;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;
import kandid.soup.LcaChromosome;

public abstract class LcaCalculation
extends PixelCalculation
implements Cloneable {
    protected int totalDisplayRows;
    protected int actDisplayRow;
    protected int[] rule;
    protected int[] state;
    protected int[] nextState;
    protected int neighbors;
    protected ColorF32[] intPalette;
    protected int width;
    protected int maxStates;
    protected String initialFillMode;
    protected long initialStateSeed;

    @Override
    public void setChromosome(ChromosomeType chromosome, Colorator colorator) {
        super.setChromosome(chromosome, colorator);
        LcaChromosome lcaChromosome = (LcaChromosome)chromosome;
        this.width = lcaChromosome.getWidth().getValue();
        this.initialFillMode = lcaChromosome.getLcaInitialState().getFillMode().value();
        this.initialStateSeed = lcaChromosome.getLcaInitialState().getStateSeed().getValue();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.width);
    }

    @Override
    public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
        super.activateCanvas(viewComponent, canvasSize, zoomMode);
        this.bufAwtImg = new BufferedImage(this.width, this.width, 1);
        if (!zoomMode) {
            double xScale = (double)canvasSize.width / (double)this.width;
            double yScale = (double)canvasSize.height / (double)this.width;
            this.affineTransform.setToScale(xScale, yScale);
        }
        Graphics gr = this.bufAwtImg.getGraphics();
        gr.setColor(Color.black);
        gr.fillRect(0, 0, canvasSize.width, canvasSize.height);
        this.paint(this.intPalette);
    }

    @Override
    public void calculate(Deviation dev, boolean paintOnScreen, String doExport) {
        int maxPart = paintOnScreen ? 200 : this.totalDisplayRows;
        int px = 0;
        while (px < maxPart && !this.getReady()) {
            int sx = 0;
            while (sx < this.state.length) {
                int ruleNumber = this.getRuleNumber(sx, this.maxStates);
                try {
                    this.nextState[sx] = this.rule[ruleNumber];
                }
                catch (Exception exc) {
                    this.nextState[sx] = 0;
                }
                ++sx;
            }
            System.arraycopy(this.nextState, 0, this.state, 0, this.state.length);
            this.paint(this.intPalette);
            ++this.actDisplayRow;
            ++px;
        }
    }

    protected abstract int getRuleNumber(int var1, int var2);

    private void paint(ColorF32[] palette) {
        int sx = 0;
        while (sx < this.state.length) {
            this.setPixel(sx, this.actDisplayRow, palette[this.state[sx] % palette.length]);
            ++sx;
        }
    }

    @Override
    public int getPercent() {
        return 100 - 100 * (this.totalDisplayRows - this.actDisplayRow) / this.totalDisplayRows;
    }

    @Override
    public boolean getReady() {
        return this.aborted || this.actDisplayRow >= this.totalDisplayRows;
    }

    @Override
    public ColorF32[] getPalette() {
        return this.intPalette;
    }

    protected void setRandomFirstState() {
        Random rand = new Random();
        rand.setSeed(this.initialStateSeed);
        if (this.initialFillMode.equals("uniform random")) {
            int fx = 0;
            while (fx < this.state.length) {
                this.state[fx] = rand.nextInt(this.maxStates);
                ++fx;
            }
        } else if (this.initialFillMode.equals("random ramp")) {
            int fx = 0;
            while (fx < this.state.length) {
                this.state[fx] = rand.nextInt(this.maxStates) * (int)Math.round((double)(this.state.length - fx) / (double)this.state.length);
                int n = fx++;
                this.state[n] = this.state[n] % this.maxStates;
            }
        } else if (this.initialFillMode.equals("single point")) {
            this.clearFirstState();
            this.state[this.width / 2] = rand.nextInt(this.maxStates);
        } else if (this.initialFillMode.equals("two points")) {
            this.clearFirstState();
            this.state[this.width / 2] = rand.nextInt(this.maxStates);
            this.state[this.width / 2 + 1] = rand.nextInt(this.maxStates);
        } else if (this.initialFillMode.equals("three points")) {
            this.clearFirstState();
            this.state[this.width / 2 - 1] = rand.nextInt(this.maxStates);
            this.state[this.width / 2] = rand.nextInt(this.maxStates);
            this.state[this.width / 2 + 1] = rand.nextInt(this.maxStates);
        } else if (this.initialFillMode.equals("two points with single gap")) {
            this.clearFirstState();
            this.state[this.width / 2 - 1] = rand.nextInt(this.maxStates);
            this.state[this.width / 2 + 1] = rand.nextInt(this.maxStates);
        }
    }

    protected void clearFirstState() {
        int fx = 0;
        while (fx < this.state.length) {
            this.state[fx] = 0;
            ++fx;
        }
    }
}

