/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.domainwarping;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import kandid.calculation.Deviation;
import kandid.calculation.RefinementCalculation;
import kandid.colorator.ColorF32;
import kandid.noise.AbstractNoise;
import kandid.noise.CellNoise;
import kandid.noise.ChladniNoise;
import kandid.noise.ImageNoise;
import kandid.noise.PerlinNoise;
import kandid.soup.ChromosomeType;
import kandid.soup.DomainWarpingChromosome;
import kandid.soup.WarpingLayerGene;
import kandid.soup.WarpingTurbulenceGene;

public abstract class DomainWarpingCalculation
extends RefinementCalculation
implements Cloneable {
    private String constraint;
    protected static final String FREQUENCY_KEY = "frequency=";
    int[] frequency;
    private double mainscale;
    private double gradientgain;
    private WarpingLayer lay0;
    private WarpingLayer lay1ll;
    private WarpingLayer lay1rl;
    private WarpingLayer lay1lr;
    private WarpingLayer lay1rr;
    private static final double LOG_0_5 = Math.log(0.5);
    double scan_maxValue;
    double scan_minValue;
    double scan_range;

    protected abstract String getConstraint();

    public DomainWarpingCalculation() {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        this.frequency = nArray;
        this.lay0 = new WarpingLayer();
        this.lay1ll = new WarpingLayer();
        this.lay1rl = new WarpingLayer();
        this.lay1lr = new WarpingLayer();
        this.lay1rr = new WarpingLayer();
        this.scan_maxValue = Double.NEGATIVE_INFINITY;
        this.scan_minValue = Double.POSITIVE_INFINITY;
        this.scan_range = 9.0E-5;
        this.constraint = this.getConstraint();
        try {
            if (this.constraint.startsWith(FREQUENCY_KEY)) {
                String detail = this.constraint.substring(FREQUENCY_KEY.length());
                String[] parts = detail.split(",");
                this.frequency[0] = Integer.parseInt(parts[0]);
                this.frequency[1] = Integer.parseInt(parts[1]);
                this.frequency[2] = Integer.parseInt(parts[2]);
                this.frequency[3] = Integer.parseInt(parts[3]);
            }
        }
        catch (Exception ex) {
            System.err.println("Can not parse constraints: '" + this.constraint + "'");
            ex.printStackTrace();
        }
    }

    @Override
    public boolean reject(ChromosomeType chromosome) {
        DomainWarpingChromosome domainWarpingChromosome = (DomainWarpingChromosome)chromosome;
        this.init_params(domainWarpingChromosome);
        this.scanResults(domainWarpingChromosome);
        return this.scan_range < 0.001;
    }

    private void init_params(DomainWarpingChromosome domainWarpingChromosome) {
        this.mainscale = domainWarpingChromosome.getMainscale().getValue();
        this.gradientgain = domainWarpingChromosome.getGradientgain().getValue();
        List<WarpingLayerGene> wlg = domainWarpingChromosome.getWarpingLayer();
        int lindex = 0;
        for (WarpingLayerGene warpingLayerGene : wlg) {
            switch (lindex) {
                case 0: {
                    this.lay0.fill(warpingLayerGene);
                    break;
                }
                case 1: {
                    this.lay1ll.fill(warpingLayerGene);
                    break;
                }
                case 2: {
                    this.lay1rl.fill(warpingLayerGene);
                    break;
                }
                case 3: {
                    this.lay1lr.fill(warpingLayerGene);
                    break;
                }
                case 4: {
                    this.lay1rr.fill(warpingLayerGene);
                }
            }
            ++lindex;
        }
    }

    @Override
    public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
        this.depth = 6;
        this.xwMin = -1.0;
        this.xwMax = 1.0;
        this.ywMin = -1.0;
        this.ywMax = 1.0;
        super.activateCanvas(viewComponent, canvasSize, zoomMode);
        DomainWarpingChromosome domainWarpingChromosome = (DomainWarpingChromosome)this.chromosome;
        this.init_params(domainWarpingChromosome);
        this.scanResults(domainWarpingChromosome);
    }

    private double calc(double xwk, double ywk) {
        double val_lay0t2;
        double freqscale;
        double ampscale;
        double octaves;
        double factor;
        double val_lay1_rrt2;
        double val_lay1_rlt2;
        double val_lay1_lrt2;
        double val_lay1_llt2;
        double value_lay1_ll = 0.0;
        if (this.lay1ll.n >= 1) {
            value_lay1_ll += this.lay1ll.term1.scaleOut * this.lay1ll.term1.composer.sturbulence(this.mainscale * this.lay1ll.term1.scaleXin * xwk, this.mainscale * this.lay1ll.term1.scaleYin * ywk, this.lay1ll.term1.timeCoord, this.lay1ll.term1.octaves, this.lay1ll.term1.ampscale, this.lay1ll.term1.freqscale);
        }
        if (this.lay1ll.n >= 2 && (val_lay1_llt2 = this.lay1ll.term2.scaleOut * this.lay1ll.term2.composer.sturbulence(this.mainscale * this.lay1ll.term2.scaleXin * xwk, this.mainscale * this.lay1ll.term2.scaleYin * ywk, this.lay1ll.term2.timeCoord, this.lay1ll.term2.octaves, this.lay1ll.term2.ampscale, this.lay1ll.term2.freqscale)) < 0.0) {
            value_lay1_ll = -value_lay1_ll;
        }
        double value_lay1_lr = 0.0;
        if (this.lay1lr.n >= 1) {
            value_lay1_lr += this.lay1lr.term1.scaleOut * this.lay1lr.term1.composer.sturbulence(this.mainscale * this.lay1lr.term1.scaleXin * xwk, this.mainscale * this.lay1lr.term1.scaleYin * ywk, this.lay1lr.term1.timeCoord, this.lay1lr.term1.octaves, this.lay1lr.term1.ampscale, this.lay1lr.term1.freqscale);
        }
        if (this.lay1lr.n >= 2 && (val_lay1_lrt2 = this.lay1lr.term2.scaleOut * this.lay1lr.term2.composer.sturbulence(this.mainscale * this.lay1lr.term2.scaleXin * xwk, this.mainscale * this.lay1lr.term2.scaleYin * ywk, this.lay1lr.term2.timeCoord, this.lay1lr.term2.octaves, this.lay1lr.term2.ampscale, this.lay1lr.term2.freqscale)) < 0.0) {
            value_lay1_lr = -value_lay1_lr;
        }
        double value_lay1_rl = 0.0;
        if (this.lay1rl.n >= 1) {
            value_lay1_rl += this.lay1rl.term1.scaleOut * this.lay1rl.term1.composer.sturbulence(this.mainscale * this.lay1rl.term1.scaleXin * xwk, this.mainscale * this.lay1rl.term1.scaleYin * ywk, this.lay1rl.term1.timeCoord, this.lay1rl.term1.octaves, this.lay1rl.term1.ampscale, this.lay1rl.term1.freqscale);
        }
        if (this.lay1rl.n >= 2 && (val_lay1_rlt2 = this.lay1rl.term2.scaleOut * this.lay1rl.term2.composer.sturbulence(this.mainscale * this.lay1rl.term2.scaleXin * xwk, this.mainscale * this.lay1rl.term2.scaleYin * ywk, this.lay1rl.term2.timeCoord, this.lay1rl.term2.octaves, this.lay1rl.term2.ampscale, this.lay1rl.term2.freqscale)) < 0.0) {
            value_lay1_rl = -value_lay1_rl;
        }
        double value_lay1_rr = 0.0;
        if (this.lay1rr.n >= 1) {
            value_lay1_rr += this.lay1rr.term1.scaleOut * this.lay1rr.term1.composer.sturbulence(this.mainscale * this.lay1rr.term1.scaleXin * xwk, this.mainscale * this.lay1rr.term1.scaleYin * ywk, this.lay1rr.term1.timeCoord, this.lay1rr.term1.octaves, this.lay1rr.term1.ampscale, this.lay1rr.term1.freqscale);
        }
        if (this.lay1rr.n >= 2 && (val_lay1_rrt2 = this.lay1rr.term2.scaleOut * this.lay1rr.term2.composer.sturbulence(this.mainscale * this.lay1rr.term2.scaleXin * xwk, this.mainscale * this.lay1rr.term2.scaleYin * ywk, this.lay1rr.term2.timeCoord, this.lay1rr.term2.octaves, this.lay1rr.term2.ampscale, this.lay1rr.term2.freqscale)) < 0.0) {
            value_lay1_rr = -value_lay1_rr;
        }
        double value_lay0 = 0.0;
        if (this.lay0.n >= 1) {
            factor = this.lay0.term1.scaleOut * this.lay0.term1.composer.uturbulence(this.mainscale * this.lay0.term1.scaleXin * value_lay1_ll, this.mainscale * this.lay0.term1.scaleYin * value_lay1_lr, this.lay0.term1.timeCoord, this.lay0.term1.octaves, this.lay0.term1.ampscale, this.lay0.term1.freqscale);
            octaves = 7.0 * factor;
            ampscale = factor;
            freqscale = 1.0 / factor;
            value_lay0 += this.lay0.term1.scaleOut * this.lay0.term1.composer.uturbulence(this.mainscale * this.lay0.term1.scaleXin * value_lay1_ll, this.mainscale * this.lay0.term1.scaleYin * value_lay1_lr, this.lay0.term1.timeCoord, octaves, ampscale, freqscale);
        }
        if (this.lay0.n >= 2 && (val_lay0t2 = this.lay0.term2.scaleOut * this.lay0.term2.composer.sturbulence(this.mainscale * this.lay0.term2.scaleXin * value_lay1_rl, this.mainscale * this.lay0.term2.scaleYin * value_lay1_rr, this.lay0.term2.timeCoord, octaves = 7.0 * (factor = this.lay0.term2.scaleOut * this.lay0.term2.composer.uturbulence(this.mainscale * this.lay0.term2.scaleXin * value_lay1_rl, this.mainscale * this.lay0.term2.scaleYin * value_lay1_rr, this.lay0.term2.timeCoord, this.lay0.term2.octaves, this.lay0.term2.ampscale, this.lay0.term2.freqscale)), ampscale = factor, freqscale = 1.0 / factor)) < 0.0) {
            value_lay0 = 1.0 - value_lay0;
        }
        return DomainWarpingCalculation.gain(this.gradientgain, value_lay0);
    }

    private static double bias(double b, double x) {
        b = Math.abs(b);
        x = Math.abs(x) + 1.0E-5;
        return Math.pow(x, Math.log(b) / LOG_0_5);
    }

    private static double gain(double g, double x) {
        g = Math.abs(g);
        if ((x = Math.abs(x) + 1.0E-5) < 0.5) {
            return 0.5 * DomainWarpingCalculation.bias(1.0 - g, 2.0 * x);
        }
        return 1.0 - 0.5 * DomainWarpingCalculation.bias(1.0 - g, 2.0 - 2.0 * x);
    }

    @Override
    public void calculate(Deviation dev, boolean paintOnScreen, String exportFilename) {
        if (this.enterDepth()) {
            ColorF32 colorF32 = new ColorF32();
            if (dev != null) {
                this.lay0.term1.composer.setWeight(this.lay0.term1.composer.source1 * ((kandid.calculation.domainwarping.Deviation)dev).s1, this.lay0.term1.composer.source2 * ((kandid.calculation.domainwarping.Deviation)dev).s2, this.lay0.term1.composer.source3 * ((kandid.calculation.domainwarping.Deviation)dev).s3, this.lay0.term1.composer.source4 * ((kandid.calculation.domainwarping.Deviation)dev).s4);
            }
            while (this.more) {
                double gray = (this.calc(this.xw, this.yw) - this.scan_minValue) / this.scan_range;
                this.colorator.getColor(gray, colorF32);
                this.setPixel(colorF32);
                this.nextLocation();
            }
        }
    }

    @Override
    public boolean hasWhiteBackground() {
        return false;
    }

    public void scanResults(DomainWarpingChromosome scalarExpressionChromosome) {
        this.scan_maxValue = Double.NEGATIVE_INFINITY;
        this.scan_minValue = Double.POSITIVE_INFINITY;
        this.scan_range = 9.0E-5;
        double xt = -1.1;
        while (xt < 1.1) {
            double yt = -1.1;
            while (yt < 1.1) {
                double scan_value = this.calc(xt, yt);
                if (scan_value < this.scan_minValue) {
                    this.scan_minValue = scan_value;
                }
                if (scan_value > this.scan_maxValue) {
                    this.scan_maxValue = scan_value;
                }
                yt += 0.1;
            }
            xt += 0.1;
        }
        this.scan_range = this.scan_maxValue - this.scan_minValue;
    }

    class NoiseComposer {
        private double source1 = 0.25;
        private double source2 = 0.25;
        private double source3 = 0.25;
        private double source4 = 0.25;
        private AbstractNoise noise1;
        private AbstractNoise noise2;
        private AbstractNoise noise3;
        private AbstractNoise noise4;

        NoiseComposer() {
        }

        void setWeight(double w1, double w2, double w3, double w4) {
            double sum = w1 + w2 + w3 + w4;
            w1 /= sum;
            w2 /= sum;
            w3 /= sum;
            w4 /= sum;
            w1 *= w1;
            w2 *= w2;
            w3 *= w3;
            w4 *= w4;
            sum = w1 + w2 + w3 + w4;
            this.source1 = w1 / sum;
            this.source2 = w2 / sum;
            this.source3 = w3 / sum;
            this.source4 = w4 / sum;
        }

        private AbstractNoise factory(long seed, int n) {
            int sum = 0;
            int i = 0;
            while (i < DomainWarpingCalculation.this.frequency.length) {
                sum += DomainWarpingCalculation.this.frequency[i];
                ++i;
            }
            int[] selector = new int[sum];
            int k0 = 0;
            int k1 = 0;
            int i2 = 0;
            while (i2 < DomainWarpingCalculation.this.frequency.length) {
                int j = 0;
                while (j < DomainWarpingCalculation.this.frequency[i2]) {
                    selector[k0] = k1;
                    ++k0;
                    ++j;
                }
                ++k1;
                ++i2;
            }
            int p = (int)seed + 131 + n;
            if (p < 0) {
                p = -p;
            }
            switch (selector[p % selector.length]) {
                case 0: {
                    return new PerlinNoise(seed + (long)(3 * n));
                }
                case 1: {
                    return new CellNoise(seed + (long)(5 * n));
                }
                case 2: {
                    return new ChladniNoise(seed + (long)(7 * n));
                }
                case 3: {
                    return new ImageNoise(seed + (long)(11 * n));
                }
            }
            assert (false) : "can not create noise pattern " + p;
            return new PerlinNoise(seed);
        }

        void setSeed(long seed1, long seed2, long seed3, long seed4) {
            int i = 7;
            this.noise1 = this.factory(seed1, i);
            i = 13;
            this.noise2 = this.factory(seed2, i);
            i = 23;
            this.noise3 = this.factory(seed3, i);
            i = 41;
            this.noise4 = this.factory(seed4, i);
        }

        public double sturbulence(double x, double y, double z, double octaves, double ampscale, double freqscale) {
            double n1 = this.source1 * this.noise1.sturbulence(x, y, z, octaves, ampscale, freqscale);
            double n2 = this.source2 * this.noise2.sturbulence(y, z, x, octaves, ampscale, freqscale);
            double n3 = this.source3 * this.noise3.sturbulence(z, x, y, octaves, ampscale, freqscale);
            double n4 = this.source4 * this.noise4.sturbulence((x + z) / 2.0, (y + z) / 2.0, z * z, octaves, ampscale, freqscale);
            return (n1 + n2 + n3 + n4) / 4.0;
        }

        public double uturbulence(double x, double y, double z, double octaves, double ampscale, double freqscale) {
            double n1 = this.source1 * this.noise1.uturbulence(x, y, z, octaves, ampscale, freqscale);
            double n2 = this.source2 * this.noise2.uturbulence(y, z, x, octaves, ampscale, freqscale);
            double n3 = this.source3 * this.noise3.uturbulence(z, x, y, octaves, ampscale, freqscale);
            double n4 = this.source4 * this.noise4.uturbulence((x + z) / 2.0, (y + z) / 2.0, z * z, octaves, ampscale, freqscale);
            return (n1 + n2 + n3 + n4) / 4.0;
        }
    }

    class WarpingLayer {
        NoiseComposer compose1;
        WarpingTurbulence term1;
        NoiseComposer compose2;
        WarpingTurbulence term2;
        int n;

        WarpingLayer() {
            this.compose1 = new NoiseComposer();
            this.term1 = new WarpingTurbulence(this.compose1);
            this.compose2 = new NoiseComposer();
            this.term2 = new WarpingTurbulence(this.compose2);
            this.n = 0;
        }

        void fill(WarpingLayerGene wlg) {
            List<WarpingTurbulenceGene> tl = wlg.getTerm();
            switch (tl.size()) {
                case 1: {
                    this.term1.fill(tl.get(0));
                    this.n = 1;
                    break;
                }
                case 2: {
                    this.term1.fill(tl.get(0));
                    this.term2.fill(tl.get(1));
                    this.n = 2;
                }
            }
        }
    }

    class WarpingTurbulence {
        double timeCoord;
        double octaves;
        double ampscale;
        double freqscale;
        double scaleOut;
        double scaleXin;
        double scaleYin;
        double source1;
        double source2;
        double source3;
        double source4;
        long seed1;
        long seed2;
        long seed3;
        long seed4;
        NoiseComposer composer;

        public WarpingTurbulence(NoiseComposer composer) {
            this.composer = composer;
        }

        void fill(WarpingTurbulenceGene wpg) {
            this.timeCoord = wpg.getTimeCoord().getValue();
            this.octaves = wpg.getOctaves().getValue();
            this.ampscale = wpg.getAmpscale().getValue();
            this.freqscale = wpg.getFreqscale().getValue();
            this.scaleOut = wpg.getScaleOut().getValue();
            this.scaleXin = wpg.getScaleXin().getValue();
            this.scaleYin = wpg.getScaleYin().getValue();
            this.source1 = wpg.getSource1().getValue();
            this.source2 = wpg.getSource2().getValue();
            this.source3 = wpg.getSource3().getValue();
            this.source4 = wpg.getSource4().getValue();
            this.seed1 = wpg.getSeed1().getValue();
            this.seed2 = wpg.getSeed2().getValue();
            this.seed3 = wpg.getSeed3().getValue();
            this.seed4 = wpg.getSeed4().getValue();
            this.composer.setWeight(this.source1, this.source2, this.source3, this.source4);
            this.composer.setSeed(this.seed1, this.seed2, this.seed3, this.seed4);
        }
    }
}

