/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.bridge.povray;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import kandid.calculation.bridge.BatchJob;
import kandid.util.Debug;

public class TargaStreamReader
implements Runnable {
    private static final int rowsPerTile = 25;
    private Process childProcess;
    private BatchJob job;
    private int externalHeight;
    private int externalWidth;
    private int increment;
    private Thread engine;

    public TargaStreamReader(Process childProcess, BatchJob job) {
        this.childProcess = childProcess;
        this.job = job;
        this.externalHeight = job.canvasSize.height;
        this.externalWidth = job.canvasSize.width;
        if (job.preview) {
            this.externalHeight /= 3;
            this.externalWidth /= 3;
        }
        if (job.importedImage == null) {
            job.importedImage = new BufferedImage(job.canvasSize.width, job.canvasSize.height, 1);
        }
    }

    public void start() {
        if (this.engine == null) {
            this.engine = new Thread(this);
            this.engine.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block23: {
            try {
                InputStream dataStream = this.childProcess.getInputStream();
                int[] targaHeader = new int[18];
                int hx = 0;
                while (hx < targaHeader.length) {
                    int ch = dataStream.read();
                    if (ch >= 0) {
                        targaHeader[hx] = ch;
                        ++hx;
                        continue;
                    }
                    break block23;
                }
                int width = targaHeader[12] + 256 * targaHeader[13];
                int height = targaHeader[14] + 256 * targaHeader[15];
                int[] pixel = new int[25 * width];
                this.increment = 0;
                int row = 0;
                int rx = 0;
                block10: while (rx < height) {
                    int cx = 0;
                    while (cx < width) {
                        if (this.job.state != 3) {
                            int r;
                            int g;
                            int b = dataStream.read();
                            if (b < 0 || (g = dataStream.read()) < 0 || (r = dataStream.read()) < 0) break block10;
                            int rgbColor = (r << 16) + (g << 8) + b;
                            if (!this.job.preview) {
                                pixel[this.increment * width + cx] = rgbColor;
                            } else {
                                int rx2 = 0;
                                while (rx2 < 3) {
                                    int cx2 = 0;
                                    while (cx2 < 3) {
                                        this.job.importedImage.setRGB(cx * 3 + cx2, rx * 3 + rx2, rgbColor);
                                        ++cx2;
                                    }
                                    ++rx2;
                                }
                            }
                            ++cx;
                            continue;
                        }
                        break block23;
                    }
                    if (this.increment >= 24) {
                        if (!this.job.preview) {
                            this.job.importedImage.setRGB(0, row, width, 25, pixel, 0, width);
                        }
                        row += 25;
                        Object object = this.job.incrementReady;
                        synchronized (object) {
                            this.job.incrementReady.notify();
                        }
                        this.increment = 0;
                    } else {
                        ++this.increment;
                    }
                    ++rx;
                }
                if (!this.job.preview) {
                    this.job.importedImage.setRGB(0, row, width, this.increment, pixel, 0, width);
                }
            }
            catch (IOException exc) {
                this.job.exitCode = -3;
                Debug.stackTrace(exc);
            }
            catch (Throwable exc) {
                this.job.exitCode = -4;
                Debug.stackTrace(exc);
            }
        }
        if (this.job.state != 3) {
            this.job.state = 2;
        }
        Object object = this.job.incrementReady;
        synchronized (object) {
            this.job.incrementReady.notify();
        }
    }
}

