/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.bridge.flame;

import java.awt.Color;
import java.awt.image.BufferedImage;
import kandid.Kandid;
import kandid.calculation.bridge.FileBridge;
import kandid.calculation.bridge.PixelBridgeCalculation;
import kandid.calculation.bridge.flame.FlameJob;
import kandid.util.Debug;

public class FlameCalculation
extends PixelBridgeCalculation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculateView() {
        FlameCalculation flameCalculation = this;
        synchronized (flameCalculation) {
            if (!this.aborted && this.runCount < 2) {
                FlameJob flameJob = null;
                try {
                    BufferedImage image;
                    ++this.runCount;
                    flameJob = new FlameJob();
                    flameJob.createJob(this.chromosome, this.canvasSize, this.runCount == 1, null, "png");
                    this.bbridge = new FileBridge(flameJob);
                    this.bbridge.execute();
                    this.bbridge.waitFor();
                    if (flameJob.state == 2 && (image = this.bbridge.getImage()) != null) {
                        this.bufAwtImg.getGraphics().drawImage(image, 0, 0, Color.BLACK, Kandid.getFrame());
                    }
                    this.bbridge.cleanUp();
                }
                catch (Exception exc) {
                    if (flameJob != null) {
                        System.err.println(flameJob.imageFileName);
                    }
                    Debug.stackTrace(exc);
                }
                this.ready = this.runCount >= 2;
            }
            this.bbridge = null;
        }
    }

    @Override
    public void calculateExport(String exportFilename) {
        FlameJob flameJob = new FlameJob();
        flameJob.createJob(this.chromosome, this.canvasSize, false, exportFilename, "png");
        this.bbridge = new FileBridge(flameJob);
        this.bbridge.execute();
        this.bbridge.waitFor();
        this.bbridge = null;
        this.ready = true;
    }
}

