/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.bridge;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import junit.framework.TestCase;
import kandid.calculation.bridge.StreamBridge;
import kandid.calculation.bridge.povray.PovJob;
import kandid.soup.ChromosomeType;
import kandid.soup.PopulationType;
import kandid.soup.test.SoupFactoryTest;
import kandid.soup.util.SoupFactory;
import kandid.util.Debug;

public class StreamBridgeTest
extends TestCase {
    private static final int height = 25;
    private static final int width = 25;
    SoupFactory soupFactory;
    PopulationType population;
    ChromosomeType aChromosome;
    Dimension dim = new Dimension(25, 25);

    public StreamBridgeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.soupFactory = SoupFactory.getSoupFactory();
        this.population = SoupFactoryTest.createRandomPopulation(this.soupFactory, "PovIsoSurface", "PovTextureCalculation", "kandid.colorator.RGBColorator");
        this.aChromosome = this.soupFactory.getChromosome(this.population, 0);
        this.dim = new Dimension(25, 25);
    }

    public void testExecute() {
        PovJob povJob = new PovJob();
        povJob.createJob(this.aChromosome, this.dim, false, null, "png");
        StreamBridge streamBridge = new StreamBridge(povJob);
        streamBridge.execute();
        BufferedImage image = new BufferedImage(25, 25, 1);
        boolean ready = false;
        while (!(ready = streamBridge.recieve(image.getGraphics()))) {
        }
        StreamBridgeTest.assertNotNull((Object)image);
        StreamBridgeTest.assertEquals((int)25, (int)image.getHeight());
        StreamBridgeTest.assertEquals((int)25, (int)image.getWidth());
        StreamBridgeTest.assertEquals((int)2, (int)povJob.state);
        streamBridge.waitFor();
        streamBridge.cleanUp();
    }

    public void testDestroy() {
        PovJob povJob = new PovJob();
        povJob.createJob(this.aChromosome, this.dim, false, null, "png");
        StreamBridge streamBridge = new StreamBridge(povJob);
        streamBridge.execute();
        streamBridge.destroy();
        StreamBridgeTest.assertEquals((int)3, (int)povJob.state);
        BufferedImage image = null;
        try {
            image = streamBridge.getImage();
        }
        catch (IOException exc) {
            Debug.stackTrace(exc);
            StreamBridgeTest.fail();
        }
        StreamBridgeTest.assertNull((Object)image);
    }

    public void testErrorMessage() {
        PovJob povJob = new PovJob();
        povJob.createJob(this.aChromosome, this.dim, false, null, "png");
        povJob.script = povJob.script.replace('<', '!');
        StreamBridge streamBridge = new StreamBridge(povJob);
        streamBridge.execute();
        streamBridge.waitFor();
        StreamBridgeTest.assertTrue((povJob.errorMessage.length() >= 0 ? 1 : 0) != 0);
        StreamBridgeTest.assertTrue((povJob.errorMessage.toString().indexOf("Fatal error in parser:") > 0 ? 1 : 0) != 0);
    }
}

