/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.bridge;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import kandid.calculation.bridge.BatchJob;
import kandid.calculation.bridge.Bridge;
import kandid.calculation.bridge.BridgeBase;

public class FileBridge
extends BridgeBase
implements Bridge {
    public FileBridge(BatchJob batchJob) {
        super(batchJob);
    }

    @Override
    public BufferedImage getImage() throws IOException {
        File imgFile;
        BufferedImage importedImage = null;
        if (this.batchJob.state == 2 && (imgFile = new File(this.batchJob.imageFileName)).exists()) {
            if (this.batchJob.preview) {
                BufferedImage unscaledImage = ImageIO.read(imgFile);
                importedImage = new BufferedImage(this.batchJob.canvasSize.width, this.batchJob.canvasSize.height, 1);
                Graphics2D g2d = importedImage.createGraphics();
                g2d.drawImage(unscaledImage, this.scale, null);
            } else {
                importedImage = ImageIO.read(imgFile);
            }
        }
        return importedImage;
    }

    @Override
    public void cleanUp() {
        if (!this.batchJob.doExport) {
            new File(this.batchJob.scriptFileName).delete();
            new File(this.batchJob.imageFileName).delete();
        }
    }

    @Override
    public boolean recieve(Graphics graphics) {
        return true;
    }
}

