/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.affineifs;

import kandid.calculation.affineifs.AffineIfsCalculation;
import kandid.soup.AffineIfsChromosome;
import kandid.soup.AffineIfsSymmChromosome;

public class AffineIfsSymmCalculation
extends AffineIfsCalculation
implements Cloneable {
    int symmetry;
    boolean Dn;

    @Override
    protected void prepareMatcher(AffineIfsChromosome ifsChromosome) {
        super.prepareMatcher(ifsChromosome);
        this.symmetry = ((AffineIfsSymmChromosome)ifsChromosome).getSymmetry().getValue();
        this.Dn = ((AffineIfsSymmChromosome)ifsChromosome).getDn().isValue();
    }

    @Override
    protected void iterate() {
        super.iterate();
        if (this.symmetry > 0) {
            double angel = Math.PI * 2 * (double)this.rand.nextInt(this.symmetry) / (double)this.symmetry;
            double cosinus = Math.cos(angel);
            double sinus = Math.sin(angel);
            double x2 = cosinus * this.xw - sinus * this.yw;
            double y2 = sinus * this.xw + cosinus * this.yw;
            this.xw = x2;
            this.yw = this.Dn && this.rand.nextBoolean() ? -y2 : y2;
        }
    }

    @Override
    public boolean hasWhiteBackground() {
        return true;
    }
}

