/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import kandid.calculation.Calculation;

public abstract class VectorCalculation
extends Calculation {
    public Graphics2D g2d;
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    protected double xfactor;
    protected double yfactor;
    public int xp;
    public int yp;

    public void activateCanvas(Component viewComponent, Dimension canvasSize, Graphics2D g2d, boolean zoomMode) {
        super.activateCanvas(viewComponent, canvasSize, zoomMode);
        this.viewComponent = viewComponent;
        this.g2d = g2d;
        this.ymin = 0.0;
        this.xmin = 0.0;
        this.ymax = 1.0;
        this.xmax = 1.0;
        this.xfactor = canvasSize.width;
        this.yfactor = canvasSize.height;
        this.yp = 0;
        this.xp = 0;
    }

    public void initTransformation(double borderFactor) {
        double xBorder = borderFactor * (this.xmax - this.xmin);
        double yBorder = borderFactor * (this.ymax - this.ymin);
        this.xmax += xBorder;
        this.xmin -= xBorder;
        this.ymax += yBorder;
        this.ymin -= yBorder;
        double diffX = this.xmax - this.xmin;
        double diffY = this.ymax - this.ymin;
        if (diffX > 0.0) {
            this.xfactor = (double)this.canvasSize.width / diffX;
        }
        if (diffY > 0.0) {
            this.yfactor = (double)this.canvasSize.height / diffY;
        }
    }

    public void transform(double xw, double yw) {
        this.xp = (int)((xw - this.xmin) * this.xfactor);
        this.yp = (int)((yw - this.ymin) * this.yfactor);
    }
}

